/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.time;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.util.TimePeriod;
import com.espertech.esper.codegen.base.CodegenBlock;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMethodNode;
import com.espertech.esper.codegen.base.CodegenMethodScope;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprForge;
import com.espertech.esper.epl.expression.core.ExprForgeComplexityEnum;
import com.espertech.esper.epl.expression.core.ExprNodeUtilityCore;
import com.espertech.esper.epl.expression.time.ExprTimePeriod;
import com.espertech.esper.epl.expression.time.ExprTimePeriodAdder;
import com.espertech.esper.epl.expression.time.ExprTimePeriodEvalDeltaConst;
import com.espertech.esper.epl.expression.time.ExprTimePeriodEvalDeltaConstGivenCalAdd;
import com.espertech.esper.epl.expression.time.ExprTimePeriodEvalDeltaConstGivenDelta;
import com.espertech.esper.epl.expression.time.ExprTimePeriodEvalDeltaNonConst;
import com.espertech.esper.epl.expression.time.ExprTimePeriodEvalDeltaNonConstCalAdd;
import com.espertech.esper.epl.expression.time.ExprTimePeriodEvalDeltaNonConstMsec;
import com.espertech.esper.epl.expression.time.ExprTimePeriodImpl;
import com.espertech.esper.epl.expression.time.TimeAbacus;
import com.espertech.esper.util.SimpleNumberCoercerFactory;
import java.math.BigDecimal;
import java.math.BigInteger;

public class ExprTimePeriodForge
implements ExprForge {
    private final ExprTimePeriodImpl parent;
    private final boolean hasVariable;
    private final ExprTimePeriodAdder.TimePeriodAdder[] adders;
    private ExprEvaluator[] evaluators;

    public ExprTimePeriodForge(ExprTimePeriodImpl parent, boolean hasVariable, ExprTimePeriodAdder.TimePeriodAdder[] adders) {
        this.parent = parent;
        this.hasVariable = hasVariable;
        this.adders = adders;
    }

    public ExprTimePeriodEvalDeltaConst constEvaluator(ExprEvaluatorContext context) {
        if (this.evaluators == null) {
            this.evaluators = ExprNodeUtilityCore.getEvaluatorsNoCompile(this.parent.getChildNodes());
        }
        if (!this.parent.isHasMonth() && !this.parent.isHasYear()) {
            double seconds = this.evaluateAsSeconds(null, true, context);
            long msec = this.parent.getTimeAbacus().deltaForSecondsDouble(seconds);
            return new ExprTimePeriodEvalDeltaConstGivenDelta(msec);
        }
        int[] values = new int[this.adders.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = ((Number)this.evaluators[i].evaluate(null, true, context)).intValue();
        }
        return new ExprTimePeriodEvalDeltaConstGivenCalAdd(this.adders, values, this.parent.getTimeZone(), this.parent.getTimeAbacus());
    }

    public ExprTimePeriodEvalDeltaNonConst nonconstEvaluator() {
        if (!this.parent.isHasMonth() && !this.parent.isHasYear()) {
            return new ExprTimePeriodEvalDeltaNonConstMsec(this);
        }
        return new ExprTimePeriodEvalDeltaNonConstCalAdd(this.parent.getTimeZone(), this);
    }

    public TimeAbacus getTimeAbacus() {
        return this.parent.getTimeAbacus();
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return new ExprEvaluator(){

            @Override
            public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
                throw new IllegalStateException("Time-Period expression must be evaluated via any of " + ExprTimePeriod.class.getSimpleName() + " interface methods");
            }
        };
    }

    @Override
    public CodegenExpression evaluateCodegen(Class requiredType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        throw new IllegalStateException("Time period evaluator does not have a code representation");
    }

    @Override
    public ExprForgeComplexityEnum getComplexity() {
        return ExprForgeComplexityEnum.NOT_APPLICABLE;
    }

    @Override
    public Class getEvaluationType() {
        return Double.class;
    }

    public boolean isHasVariable() {
        return this.hasVariable;
    }

    protected ExprTimePeriodAdder.TimePeriodAdder[] getAdders() {
        return this.adders;
    }

    @Override
    public ExprTimePeriodImpl getForgeRenderable() {
        return this.parent;
    }

    public ExprEvaluator[] getEvaluators() {
        if (this.evaluators == null) {
            this.evaluators = ExprNodeUtilityCore.getEvaluatorsNoCompile(this.parent.getChildNodes());
        }
        return this.evaluators;
    }

    public double evaluateAsSeconds(EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
        if (this.evaluators == null) {
            this.evaluators = ExprNodeUtilityCore.getEvaluatorsNoCompile(this.parent.getChildNodes());
        }
        double seconds = 0.0;
        for (int i = 0; i < this.adders.length; ++i) {
            Double result = this.eval(this.evaluators[i], eventsPerStream, newData, context);
            if (result == null) {
                throw ExprTimePeriodForge.makeTimePeriodParamNullException(ExprNodeUtilityCore.toExpressionStringMinPrecedenceSafe(this.parent));
            }
            seconds += this.adders[i].compute(result);
        }
        return seconds;
    }

    public CodegenExpression evaluateAsSecondsCodegen(CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenMethodNode methodNode = codegenMethodScope.makeChild(Double.TYPE, ExprTimePeriodForge.class, codegenClassScope);
        CodegenBlock block = methodNode.getBlock().declareVar(Double.TYPE, "seconds", CodegenExpressionBuilder.constant(0)).declareVarNoInit(Double.class, "result");
        for (int i = 0; i < this.parent.getChildNodes().length; ++i) {
            ExprForge forge = this.parent.getChildNodes()[i].getForge();
            Class evaluationType = forge.getEvaluationType();
            block.assignRef("result", SimpleNumberCoercerFactory.SimpleNumberCoercerDouble.codegenDoubleMayNullBoxedIncludeBig(forge.evaluateCodegen(evaluationType, methodNode, exprSymbol, codegenClassScope), evaluationType, methodNode, codegenClassScope));
            block.ifRefNull("result").blockThrow(CodegenExpressionBuilder.staticMethod(ExprTimePeriodForge.class, "makeTimePeriodParamNullException", CodegenExpressionBuilder.constant(ExprNodeUtilityCore.toExpressionStringMinPrecedenceSafe(this.parent))));
            block.assignRef("seconds", CodegenExpressionBuilder.op(CodegenExpressionBuilder.ref("seconds"), "+", this.adders[i].computeCodegen(CodegenExpressionBuilder.ref("result"))));
        }
        block.methodReturn(CodegenExpressionBuilder.ref("seconds"));
        return CodegenExpressionBuilder.localMethod(methodNode, new CodegenExpression[0]);
    }

    private Double eval(ExprEvaluator expr, EventBean[] events, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Object value = expr.evaluate(events, isNewData, exprEvaluatorContext);
        if (value == null) {
            return null;
        }
        if (value instanceof BigDecimal) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof BigInteger) {
            return ((Number)value).doubleValue();
        }
        return ((Number)value).doubleValue();
    }

    public TimePeriod evaluateGetTimePeriod(EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
        if (this.evaluators == null) {
            this.evaluators = ExprNodeUtilityCore.getEvaluatorsNoCompile(this.parent.getChildNodes());
        }
        int exprCtr = 0;
        Integer year = null;
        if (this.parent.isHasYear()) {
            year = this.getInt(this.evaluators[exprCtr++].evaluate(eventsPerStream, newData, context));
        }
        Integer month = null;
        if (this.parent.isHasMonth()) {
            month = this.getInt(this.evaluators[exprCtr++].evaluate(eventsPerStream, newData, context));
        }
        Integer week = null;
        if (this.parent.isHasWeek()) {
            week = this.getInt(this.evaluators[exprCtr++].evaluate(eventsPerStream, newData, context));
        }
        Integer day = null;
        if (this.parent.isHasDay()) {
            day = this.getInt(this.evaluators[exprCtr++].evaluate(eventsPerStream, newData, context));
        }
        Integer hours = null;
        if (this.parent.isHasHour()) {
            hours = this.getInt(this.evaluators[exprCtr++].evaluate(eventsPerStream, newData, context));
        }
        Integer minutes = null;
        if (this.parent.isHasMinute()) {
            minutes = this.getInt(this.evaluators[exprCtr++].evaluate(eventsPerStream, newData, context));
        }
        Integer seconds = null;
        if (this.parent.isHasSecond()) {
            seconds = this.getInt(this.evaluators[exprCtr++].evaluate(eventsPerStream, newData, context));
        }
        Integer milliseconds = null;
        if (this.parent.isHasMillisecond()) {
            milliseconds = this.getInt(this.evaluators[exprCtr++].evaluate(eventsPerStream, newData, context));
        }
        Integer microseconds = null;
        if (this.parent.isHasMicrosecond()) {
            microseconds = this.getInt(this.evaluators[exprCtr].evaluate(eventsPerStream, newData, context));
        }
        return new TimePeriod(year, month, week, day, hours, minutes, seconds, milliseconds, microseconds);
    }

    public CodegenExpression evaluateGetTimePeriodCodegen(CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenMethodNode methodNode = codegenMethodScope.makeChild(TimePeriod.class, ExprTimePeriodForge.class, codegenClassScope);
        CodegenBlock block = methodNode.getBlock();
        int counter = 0;
        counter += this.evaluateGetTimePeriodCodegenField(block, "year", this.parent.isHasYear(), counter, methodNode, exprSymbol, codegenClassScope);
        counter += this.evaluateGetTimePeriodCodegenField(block, "month", this.parent.isHasMonth(), counter, methodNode, exprSymbol, codegenClassScope);
        counter += this.evaluateGetTimePeriodCodegenField(block, "week", this.parent.isHasWeek(), counter, methodNode, exprSymbol, codegenClassScope);
        counter += this.evaluateGetTimePeriodCodegenField(block, "day", this.parent.isHasDay(), counter, methodNode, exprSymbol, codegenClassScope);
        counter += this.evaluateGetTimePeriodCodegenField(block, "hours", this.parent.isHasHour(), counter, methodNode, exprSymbol, codegenClassScope);
        counter += this.evaluateGetTimePeriodCodegenField(block, "minutes", this.parent.isHasMinute(), counter, methodNode, exprSymbol, codegenClassScope);
        counter += this.evaluateGetTimePeriodCodegenField(block, "seconds", this.parent.isHasSecond(), counter, methodNode, exprSymbol, codegenClassScope);
        counter += this.evaluateGetTimePeriodCodegenField(block, "milliseconds", this.parent.isHasMillisecond(), counter, methodNode, exprSymbol, codegenClassScope);
        this.evaluateGetTimePeriodCodegenField(block, "microseconds", this.parent.isHasMicrosecond(), counter, methodNode, exprSymbol, codegenClassScope);
        block.methodReturn(CodegenExpressionBuilder.newInstance(TimePeriod.class, CodegenExpressionBuilder.ref("year"), CodegenExpressionBuilder.ref("month"), CodegenExpressionBuilder.ref("week"), CodegenExpressionBuilder.ref("day"), CodegenExpressionBuilder.ref("hours"), CodegenExpressionBuilder.ref("minutes"), CodegenExpressionBuilder.ref("seconds"), CodegenExpressionBuilder.ref("milliseconds"), CodegenExpressionBuilder.ref("microseconds")));
        return CodegenExpressionBuilder.localMethod(methodNode, new CodegenExpression[0]);
    }

    public static EPException makeTimePeriodParamNullException(String expressionText) {
        return new EPException("Failed to evaluate time period, received a null value for '" + expressionText + "'");
    }

    private int evaluateGetTimePeriodCodegenField(CodegenBlock block, String variable, boolean present, int counter, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        if (!present) {
            block.declareVar(Integer.class, variable, CodegenExpressionBuilder.constantNull());
            return 0;
        }
        ExprForge forge = this.parent.getChildNodes()[counter].getForge();
        Class evaluationType = forge.getEvaluationType();
        block.declareVar(Integer.class, variable, SimpleNumberCoercerFactory.SimpleNumberCoercerInt.coerceCodegenMayNull(forge.evaluateCodegen(evaluationType, codegenMethodScope, exprSymbol, codegenClassScope), forge.getEvaluationType(), codegenMethodScope, codegenClassScope));
        return 1;
    }

    private Integer getInt(Object evaluated) {
        if (evaluated == null) {
            return null;
        }
        return ((Number)evaluated).intValue();
    }
}

