/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.time;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.codegen.base.CodegenBlock;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMember;
import com.espertech.esper.codegen.base.CodegenMethodNode;
import com.espertech.esper.codegen.base.CodegenMethodScope;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.time.ExprTimePeriodAdder;
import com.espertech.esper.epl.expression.time.ExprTimePeriodEvalDeltaNonConst;
import com.espertech.esper.epl.expression.time.ExprTimePeriodEvalDeltaResult;
import com.espertech.esper.epl.expression.time.ExprTimePeriodForge;
import com.espertech.esper.epl.expression.time.ExprTimePeriodUtil;
import com.espertech.esper.schedule.TimeProvider;
import java.util.Calendar;
import java.util.TimeZone;

public class ExprTimePeriodEvalDeltaNonConstCalAdd
implements ExprTimePeriodEvalDeltaNonConst {
    private final Calendar cal;
    private final ExprTimePeriodForge forge;
    private final int indexMicroseconds;

    public ExprTimePeriodEvalDeltaNonConstCalAdd(TimeZone timeZone, ExprTimePeriodForge forge) {
        this.forge = forge;
        this.cal = Calendar.getInstance(timeZone);
        this.indexMicroseconds = ExprTimePeriodUtil.findIndexMicroseconds(forge.getAdders());
    }

    @Override
    public synchronized long deltaAdd(long currentTime, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        return this.addSubtract(currentTime, 1, eventsPerStream, isNewData, context);
    }

    @Override
    public CodegenExpression deltaAddCodegen(CodegenExpression reference, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return this.addSubtractCodegen(reference, CodegenExpressionBuilder.constant(1), codegenMethodScope, exprSymbol, codegenClassScope);
    }

    @Override
    public synchronized long deltaSubtract(long currentTime, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        return this.addSubtract(currentTime, -1, eventsPerStream, isNewData, context);
    }

    @Override
    public synchronized long deltaUseEngineTime(EventBean[] eventsPerStream, ExprEvaluatorContext exprEvaluatorContext, TimeProvider timeProvider) {
        long currentTime = timeProvider.getTime();
        return this.addSubtract(currentTime, 1, eventsPerStream, true, exprEvaluatorContext);
    }

    @Override
    public synchronized ExprTimePeriodEvalDeltaResult deltaAddWReference(long current, long reference, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        long last;
        if (reference > current) {
            while (reference > current) {
                reference -= this.deltaSubtract(reference, eventsPerStream, isNewData, context);
            }
        }
        long next = reference;
        while ((next += this.deltaAdd(last = next, eventsPerStream, isNewData, context)) <= current) {
        }
        return new ExprTimePeriodEvalDeltaResult(next - current, last);
    }

    private long addSubtract(long currentTime, int factor, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
        long remainder = this.forge.getTimeAbacus().calendarSet(currentTime, this.cal);
        ExprTimePeriodAdder.TimePeriodAdder[] adders = this.forge.getAdders();
        ExprEvaluator[] evaluators = this.forge.getEvaluators();
        int usec = 0;
        for (int i = 0; i < adders.length; ++i) {
            int value = ((Number)evaluators[i].evaluate(eventsPerStream, newData, context)).intValue();
            if (i == this.indexMicroseconds) {
                usec = value;
                continue;
            }
            adders[i].add(this.cal, factor * value);
        }
        long result = this.forge.getTimeAbacus().calendarGet(this.cal, remainder);
        if (this.indexMicroseconds != -1) {
            result += (long)(factor * usec);
        }
        return result - currentTime;
    }

    private CodegenExpression addSubtractCodegen(CodegenExpression reference, CodegenExpression constant, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenMember calMember = codegenClassScope.makeAddMember(Calendar.class, this.cal);
        CodegenMethodNode methodNode = codegenMethodScope.makeChild(Long.TYPE, ExprTimePeriodEvalDeltaNonConstCalAdd.class, codegenClassScope);
        methodNode.addParam(Long.TYPE, "currentTime");
        methodNode.addParam(Integer.TYPE, "factor");
        CodegenBlock block = methodNode.getBlock().declareVarNoInit(Long.TYPE, "result").synchronizedOn(CodegenExpressionBuilder.member(calMember.getMemberId())).declareVar(Long.TYPE, "remainder", this.forge.getTimeAbacus().calendarSetCodegen(CodegenExpressionBuilder.ref("currentTime"), CodegenExpressionBuilder.member(calMember.getMemberId()), methodNode, codegenClassScope)).declareVar(Integer.TYPE, "usec", CodegenExpressionBuilder.constant(0));
        for (int i = 0; i < this.forge.getAdders().length; ++i) {
            String refname = "r" + i;
            block.declareVar(Integer.TYPE, refname, this.forge.getForgeRenderable().getChildNodes()[i].getForge().evaluateCodegen(Integer.TYPE, methodNode, exprSymbol, codegenClassScope));
            if (i == this.indexMicroseconds) {
                block.assignRef("usec", (CodegenExpression)CodegenExpressionBuilder.ref(refname));
                continue;
            }
            block.expression(this.forge.getAdders()[i].addCodegen(CodegenExpressionBuilder.member(calMember.getMemberId()), CodegenExpressionBuilder.op(CodegenExpressionBuilder.ref("factor"), "*", CodegenExpressionBuilder.ref(refname))));
        }
        block.assignRef("result", this.forge.getTimeAbacus().calendarGetCodegen(CodegenExpressionBuilder.member(calMember.getMemberId()), CodegenExpressionBuilder.ref("remainder"), codegenClassScope));
        if (this.indexMicroseconds != -1) {
            block.assignRef("result", CodegenExpressionBuilder.op(CodegenExpressionBuilder.ref("result"), "+", CodegenExpressionBuilder.op(CodegenExpressionBuilder.ref("factor"), "*", CodegenExpressionBuilder.ref("usec"))));
        }
        block.blockEnd().methodReturn(CodegenExpressionBuilder.op(CodegenExpressionBuilder.ref("result"), "-", CodegenExpressionBuilder.ref("currentTime")));
        return CodegenExpressionBuilder.localMethod(methodNode, reference, constant);
    }
}

