/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.time;

import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import java.util.Calendar;

public class ExprTimePeriodAdder {
    private static CodegenExpression computeCodegenTimesMultiplier(CodegenExpression doubleValue, double multiplier) {
        return CodegenExpressionBuilder.op(doubleValue, "*", CodegenExpressionBuilder.constant(multiplier));
    }

    private static CodegenExpression addCodegenCalendar(CodegenExpression cal, CodegenExpression value, int unit) {
        return CodegenExpressionBuilder.exprDotMethod(cal, "add", CodegenExpressionBuilder.constant(unit), value);
    }

    public static class TimePeriodAdderUSec
    implements TimePeriodAdder {
        @Override
        public double compute(Double value) {
            return value / 1000000.0;
        }

        @Override
        public void add(Calendar cal, int value) {
        }

        @Override
        public boolean isMicroseconds() {
            return true;
        }

        @Override
        public CodegenExpression computeCodegen(CodegenExpression doubleValue) {
            return CodegenExpressionBuilder.op(doubleValue, "/", CodegenExpressionBuilder.constant(1000000.0));
        }

        @Override
        public CodegenExpression addCodegen(CodegenExpression cal, CodegenExpression value) {
            return CodegenExpressionBuilder.noop();
        }
    }

    public static class TimePeriodAdderMSec
    implements TimePeriodAdder {
        @Override
        public double compute(Double value) {
            return value / 1000.0;
        }

        @Override
        public void add(Calendar cal, int value) {
            cal.add(14, value);
        }

        @Override
        public boolean isMicroseconds() {
            return false;
        }

        @Override
        public CodegenExpression computeCodegen(CodegenExpression doubleValue) {
            return CodegenExpressionBuilder.op(doubleValue, "/", CodegenExpressionBuilder.constant(1000.0));
        }

        @Override
        public CodegenExpression addCodegen(CodegenExpression cal, CodegenExpression value) {
            return ExprTimePeriodAdder.addCodegenCalendar(cal, value, 14);
        }
    }

    public static class TimePeriodAdderSecond
    implements TimePeriodAdder {
        @Override
        public double compute(Double value) {
            return value;
        }

        @Override
        public void add(Calendar cal, int value) {
            cal.add(13, value);
        }

        @Override
        public boolean isMicroseconds() {
            return false;
        }

        @Override
        public CodegenExpression computeCodegen(CodegenExpression doubleValue) {
            return doubleValue;
        }

        @Override
        public CodegenExpression addCodegen(CodegenExpression cal, CodegenExpression value) {
            return ExprTimePeriodAdder.addCodegenCalendar(cal, value, 13);
        }
    }

    public static class TimePeriodAdderMinute
    implements TimePeriodAdder {
        private static final double MULTIPLIER = 60.0;

        @Override
        public double compute(Double value) {
            return value * 60.0;
        }

        @Override
        public void add(Calendar cal, int value) {
            cal.add(12, value);
        }

        @Override
        public boolean isMicroseconds() {
            return false;
        }

        @Override
        public CodegenExpression computeCodegen(CodegenExpression doubleValue) {
            return ExprTimePeriodAdder.computeCodegenTimesMultiplier(doubleValue, 60.0);
        }

        @Override
        public CodegenExpression addCodegen(CodegenExpression cal, CodegenExpression value) {
            return ExprTimePeriodAdder.addCodegenCalendar(cal, value, 12);
        }
    }

    public static class TimePeriodAdderHour
    implements TimePeriodAdder {
        private static final double MULTIPLIER = 3600.0;

        @Override
        public double compute(Double value) {
            return value * 3600.0;
        }

        @Override
        public void add(Calendar cal, int value) {
            cal.add(11, value);
        }

        @Override
        public boolean isMicroseconds() {
            return false;
        }

        @Override
        public CodegenExpression computeCodegen(CodegenExpression doubleValue) {
            return ExprTimePeriodAdder.computeCodegenTimesMultiplier(doubleValue, 3600.0);
        }

        @Override
        public CodegenExpression addCodegen(CodegenExpression cal, CodegenExpression value) {
            return ExprTimePeriodAdder.addCodegenCalendar(cal, value, 11);
        }
    }

    public static class TimePeriodAdderDay
    implements TimePeriodAdder {
        private static final double MULTIPLIER = 86400.0;

        @Override
        public double compute(Double value) {
            return value * 86400.0;
        }

        @Override
        public void add(Calendar cal, int value) {
            cal.add(5, value);
        }

        @Override
        public boolean isMicroseconds() {
            return false;
        }

        @Override
        public CodegenExpression computeCodegen(CodegenExpression doubleValue) {
            return ExprTimePeriodAdder.computeCodegenTimesMultiplier(doubleValue, 86400.0);
        }

        @Override
        public CodegenExpression addCodegen(CodegenExpression cal, CodegenExpression value) {
            return ExprTimePeriodAdder.addCodegenCalendar(cal, value, 5);
        }
    }

    public static class TimePeriodAdderWeek
    implements TimePeriodAdder {
        private static final double MULTIPLIER = 604800.0;

        @Override
        public double compute(Double value) {
            return value * 604800.0;
        }

        @Override
        public void add(Calendar cal, int value) {
            cal.add(3, value);
        }

        @Override
        public boolean isMicroseconds() {
            return false;
        }

        @Override
        public CodegenExpression computeCodegen(CodegenExpression doubleValue) {
            return ExprTimePeriodAdder.computeCodegenTimesMultiplier(doubleValue, 604800.0);
        }

        @Override
        public CodegenExpression addCodegen(CodegenExpression cal, CodegenExpression value) {
            return ExprTimePeriodAdder.addCodegenCalendar(cal, value, 3);
        }
    }

    public static class TimePeriodAdderMonth
    implements TimePeriodAdder {
        private static final double MULTIPLIER = 2592000.0;

        @Override
        public double compute(Double value) {
            return value * 2592000.0;
        }

        @Override
        public void add(Calendar cal, int value) {
            cal.add(2, value);
        }

        @Override
        public CodegenExpression addCodegen(CodegenExpression cal, CodegenExpression value) {
            return ExprTimePeriodAdder.addCodegenCalendar(cal, value, 2);
        }

        @Override
        public boolean isMicroseconds() {
            return false;
        }

        @Override
        public CodegenExpression computeCodegen(CodegenExpression doubleValue) {
            return ExprTimePeriodAdder.computeCodegenTimesMultiplier(doubleValue, 2592000.0);
        }
    }

    public static class TimePeriodAdderYear
    implements TimePeriodAdder {
        private static final double MULTIPLIER = 3.1536E7;

        @Override
        public double compute(Double value) {
            return value * 3.1536E7;
        }

        @Override
        public void add(Calendar cal, int value) {
            cal.add(1, value);
        }

        @Override
        public boolean isMicroseconds() {
            return false;
        }

        @Override
        public CodegenExpression computeCodegen(CodegenExpression doubleValue) {
            return ExprTimePeriodAdder.computeCodegenTimesMultiplier(doubleValue, 3.1536E7);
        }

        @Override
        public CodegenExpression addCodegen(CodegenExpression cal, CodegenExpression value) {
            return ExprTimePeriodAdder.addCodegenCalendar(cal, value, 1);
        }
    }

    public static interface TimePeriodAdder {
        public double compute(Double var1);

        public void add(Calendar var1, int var2);

        public boolean isMicroseconds();

        public CodegenExpression computeCodegen(CodegenExpression var1);

        public CodegenExpression addCodegen(CodegenExpression var1, CodegenExpression var2);
    }
}

