/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.subquery;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprIdentNode;
import com.espertech.esper.epl.expression.core.ExprIdentNodeEvaluator;
import com.espertech.esper.epl.expression.subquery.ExprSubselectRowNode;
import com.espertech.esper.epl.expression.subquery.SubselectEvalStrategyRow;
import com.espertech.esper.event.EventBeanUtility;
import com.espertech.esper.event.EventPropertyGetterSPI;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubselectEvalStrategyRowUnfilteredSelected
implements SubselectEvalStrategyRow {
    private static final Logger log = LoggerFactory.getLogger(SubselectEvalStrategyRowUnfilteredSelected.class);

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean newData, Collection<EventBean> matchingEvents, ExprEvaluatorContext exprEvaluatorContext, ExprSubselectRowNode parent) {
        if (matchingEvents.size() > 1) {
            log.warn(parent.getMultirowMessage());
            return null;
        }
        EventBean[] events = EventBeanUtility.allocatePerStreamShift(eventsPerStream);
        events[0] = EventBeanUtility.getNonemptyFirstEvent(matchingEvents);
        Object result = parent.selectClauseEvaluator.length == 1 ? parent.selectClauseEvaluator[0].evaluate(events, true, exprEvaluatorContext) : parent.evaluateRow(events, true, exprEvaluatorContext);
        return result;
    }

    @Override
    public Collection<EventBean> evaluateGetCollEvents(EventBean[] eventsPerStream, boolean newData, Collection<EventBean> matchingEvents, ExprEvaluatorContext context, ExprSubselectRowNode parent) {
        if (matchingEvents.size() == 0) {
            return Collections.emptyList();
        }
        if (parent.subselectMultirowType == null) {
            ArrayDeque<EventBean> events = new ArrayDeque<EventBean>(matchingEvents.size());
            ExprIdentNodeEvaluator eval = ((ExprIdentNode)parent.selectClause[0]).getExprEvaluatorIdent();
            EventPropertyGetterSPI getter = eval.getGetter();
            for (EventBean subselectEvent : matchingEvents) {
                Object fragment = getter.getFragment(subselectEvent);
                if (fragment == null) continue;
                events.add((EventBean)fragment);
            }
            return events;
        }
        ArrayDeque<EventBean> events = new ArrayDeque<EventBean>(matchingEvents.size());
        EventBean[] eventsPerStreamEval = EventBeanUtility.allocatePerStreamShift(eventsPerStream);
        Iterator<EventBean> iterator = matchingEvents.iterator();
        while (iterator.hasNext()) {
            EventBean subselectEvent;
            eventsPerStreamEval[0] = subselectEvent = iterator.next();
            Map<String, Object> row = parent.evaluateRow(eventsPerStreamEval, true, context);
            EventBean event = parent.subselectMultirowType.getEventAdapterService().adapterForTypedMap(row, parent.subselectMultirowType.getEventType());
            events.add(event);
        }
        return events;
    }

    @Override
    public Collection evaluateGetCollScalar(EventBean[] eventsPerStream, boolean isNewData, Collection<EventBean> matchingEvents, ExprEvaluatorContext context, ExprSubselectRowNode parent) {
        ArrayList<Object> result = new ArrayList<Object>();
        EventBean[] events = EventBeanUtility.allocatePerStreamShift(eventsPerStream);
        Iterator<EventBean> iterator = matchingEvents.iterator();
        while (iterator.hasNext()) {
            EventBean subselectEvent;
            events[0] = subselectEvent = iterator.next();
            result.add(parent.selectClauseEvaluator[0].evaluate(events, isNewData, context));
        }
        return result;
    }

    @Override
    public Object[] typableEvaluate(EventBean[] eventsPerStream, boolean isNewData, Collection<EventBean> matchingEvents, ExprEvaluatorContext exprEvaluatorContext, ExprSubselectRowNode parent) {
        EventBean[] events = EventBeanUtility.allocatePerStreamShift(eventsPerStream);
        events[0] = EventBeanUtility.getNonemptyFirstEvent(matchingEvents);
        Object[] results = new Object[parent.selectClauseEvaluator.length];
        for (int i = 0; i < results.length; ++i) {
            results[i] = parent.selectClauseEvaluator[i].evaluate(events, isNewData, exprEvaluatorContext);
        }
        return results;
    }

    @Override
    public Object[][] typableEvaluateMultirow(EventBean[] eventsPerStream, boolean isNewData, Collection<EventBean> matchingEvents, ExprEvaluatorContext exprEvaluatorContext, ExprSubselectRowNode parent) {
        Object[][] rows = new Object[matchingEvents.size()][];
        int index = -1;
        EventBean[] events = EventBeanUtility.allocatePerStreamShift(eventsPerStream);
        for (EventBean matchingEvent : matchingEvents) {
            ++index;
            events[0] = matchingEvent;
            Object[] results = new Object[parent.selectClauseEvaluator.length];
            for (int i = 0; i < results.length; ++i) {
                results[i] = parent.selectClauseEvaluator[i].evaluate(events, isNewData, exprEvaluatorContext);
            }
            rows[index] = results;
        }
        return rows;
    }

    @Override
    public EventBean evaluateGetEventBean(EventBean[] eventsPerStream, boolean newData, Collection<EventBean> matchingEvents, ExprEvaluatorContext context, ExprSubselectRowNode parent) {
        EventBean[] events = EventBeanUtility.allocatePerStreamShift(eventsPerStream);
        events[0] = EventBeanUtility.getNonemptyFirstEvent(matchingEvents);
        Map<String, Object> row = parent.evaluateRow(events, true, context);
        return parent.subselectMultirowType.getEventAdapterService().adapterForTypedMap(row, parent.subselectMultirowType.getEventType());
    }
}

