/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.prior;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMethodScope;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.epl.expression.codegen.CodegenLegoEvaluateSelf;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprForge;
import com.espertech.esper.epl.expression.core.ExprForgeComplexityEnum;
import com.espertech.esper.epl.expression.core.ExprIdentNode;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeBase;
import com.espertech.esper.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.epl.expression.core.ExprStreamUnderlyingNode;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.prior.ExprPriorEvalStrategy;
import com.espertech.esper.util.JavaClassHelper;
import java.io.StringWriter;

public class ExprPriorNode
extends ExprNodeBase
implements ExprEvaluator,
ExprForge {
    private Class resultType;
    private int streamNumber;
    private int constantIndexNumber;
    private transient ExprPriorEvalStrategy priorStrategy;
    private transient ExprEvaluator innerEvaluator;
    private static final long serialVersionUID = -2115346817501589366L;

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    public int getStreamNumber() {
        return this.streamNumber;
    }

    public int getConstantIndexNumber() {
        return this.constantIndexNumber;
    }

    public void setPriorStrategy(ExprPriorEvalStrategy priorStrategy) {
        this.priorStrategy = priorStrategy;
    }

    public ExprEvaluator getInnerEvaluator() {
        return this.innerEvaluator;
    }

    @Override
    public ExprForge getForge() {
        return this;
    }

    @Override
    public Class getEvaluationType() {
        return this.resultType;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        if (this.getChildNodes().length != 2) {
            throw new ExprValidationException("Prior node must have 2 parameters");
        }
        if (!this.getChildNodes()[0].isConstantResult()) {
            throw new ExprValidationException("Prior function requires a constant-value integer-typed index expression as the first parameter");
        }
        ExprNode constantNode = this.getChildNodes()[0];
        Class constantNodeType = constantNode.getForge().getEvaluationType();
        if (constantNodeType != Integer.class && constantNodeType != Integer.TYPE) {
            throw new ExprValidationException("Prior function requires an integer index parameter");
        }
        Object value = constantNode.getForge().getExprEvaluator().evaluate(null, false, validationContext.getExprEvaluatorContext());
        this.constantIndexNumber = ((Number)value).intValue();
        ExprForge innerForge = this.getChildNodes()[1].getForge();
        this.innerEvaluator = innerForge.getExprEvaluator();
        if (this.getChildNodes()[1] instanceof ExprIdentNode) {
            ExprIdentNode identNode = (ExprIdentNode)this.getChildNodes()[1];
            this.streamNumber = identNode.getStreamId();
            this.resultType = JavaClassHelper.getBoxedType(innerForge.getEvaluationType());
        } else if (this.getChildNodes()[1] instanceof ExprStreamUnderlyingNode) {
            ExprStreamUnderlyingNode streamNode = (ExprStreamUnderlyingNode)this.getChildNodes()[1];
            this.streamNumber = streamNode.getStreamId();
            this.resultType = JavaClassHelper.getBoxedType(innerForge.getEvaluationType());
        } else {
            throw new ExprValidationException("Previous function requires an event property as parameter");
        }
        if (validationContext.getViewResourceDelegate() == null) {
            throw new ExprValidationException("Prior function cannot be used in this context");
        }
        validationContext.getViewResourceDelegate().addPriorNodeRequest(this);
        return null;
    }

    @Override
    public boolean isConstantResult() {
        return false;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        return this.priorStrategy.evaluate(eventsPerStream, isNewData, exprEvaluatorContext, this.streamNumber, this.innerEvaluator, this.constantIndexNumber);
    }

    @Override
    public CodegenExpression evaluateCodegen(Class requiredType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return CodegenLegoEvaluateSelf.evaluateSelfPlainWithCast(requiredType, this, this.getEvaluationType(), codegenMethodScope, exprSymbol, codegenClassScope);
    }

    @Override
    public ExprForgeComplexityEnum getComplexity() {
        return ExprForgeComplexityEnum.SELF;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        writer.append("prior(");
        this.getChildNodes()[0].toEPL(writer, ExprPrecedenceEnum.MINIMUM);
        writer.append(',');
        this.getChildNodes()[1].toEPL(writer, ExprPrecedenceEnum.MINIMUM);
        writer.append(')');
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }

    @Override
    public ExprNode getForgeRenderable() {
        return this;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        return node instanceof ExprPriorNode;
    }
}

