/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.prev;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMethodScope;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.epl.expression.codegen.CodegenLegoEvaluateSelf;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.epl.expression.core.ExprConstantNodeImpl;
import com.espertech.esper.epl.expression.core.ExprEnumerationEval;
import com.espertech.esper.epl.expression.core.ExprEnumerationForge;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprForge;
import com.espertech.esper.epl.expression.core.ExprForgeComplexityEnum;
import com.espertech.esper.epl.expression.core.ExprIdentNode;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeBase;
import com.espertech.esper.epl.expression.core.ExprNodeUtilityCore;
import com.espertech.esper.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.epl.expression.core.ExprStreamUnderlyingNode;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.prev.ExprPreviousEvalStrategy;
import com.espertech.esper.epl.expression.prev.ExprPreviousNodePreviousType;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.util.JavaClassHelper;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Locale;

public class ExprPreviousNode
extends ExprNodeBase
implements ExprEvaluator,
ExprEnumerationForge,
ExprEnumerationEval,
ExprForge {
    private static final long serialVersionUID = 0L;
    private final ExprPreviousNodePreviousType previousType;
    private Class resultType;
    private int streamNumber;
    private Integer constantIndexNumber;
    private boolean isConstantIndex;
    private transient EventType enumerationMethodType;
    private transient ExprPreviousEvalStrategy evaluator;

    public ExprPreviousNode(ExprPreviousNodePreviousType previousType) {
        this.previousType = previousType;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    public void setEvaluator(ExprPreviousEvalStrategy evaluator) {
        this.evaluator = evaluator;
    }

    public int getStreamNumber() {
        return this.streamNumber;
    }

    public Integer getConstantIndexNumber() {
        return this.constantIndexNumber;
    }

    public boolean isConstantIndex() {
        return this.isConstantIndex;
    }

    public Class getResultType() {
        return this.resultType;
    }

    @Override
    public ExprForge getForge() {
        return this;
    }

    @Override
    public ExprEnumerationEval getExprEvaluatorEnumeration() {
        return this;
    }

    @Override
    public Class getEvaluationType() {
        return this.getResultType();
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        if (this.getChildNodes().length > 2 || this.getChildNodes().length == 0) {
            throw new ExprValidationException("Previous node must have 1 or 2 parameters");
        }
        if (this.getChildNodes().length == 1) {
            if (this.previousType == ExprPreviousNodePreviousType.PREV) {
                this.addChildNodeToFront(new ExprConstantNodeImpl(1));
            } else {
                this.addChildNodeToFront(new ExprConstantNodeImpl(0));
            }
        }
        if (ExprNodeUtilityCore.isConstantValueExpr(this.getChildNodes()[1])) {
            ExprNode first = this.getChildNodes()[0];
            ExprNode second = this.getChildNodes()[1];
            this.setChildNodes(second, first);
        }
        if (this.getChildNodes()[0].isConstantResult()) {
            ExprNode constantNode = this.getChildNodes()[0];
            Object value = constantNode.getForge().getExprEvaluator().evaluate(null, false, validationContext.getExprEvaluatorContext());
            if (!(value instanceof Number)) {
                throw new ExprValidationException("Previous function requires an integer index parameter or expression");
            }
            Number valueNumber = (Number)value;
            if (JavaClassHelper.isFloatingPointNumber(valueNumber)) {
                throw new ExprValidationException("Previous function requires an integer index parameter or expression");
            }
            this.constantIndexNumber = valueNumber.intValue();
            this.isConstantIndex = true;
        }
        if (this.getChildNodes()[1] instanceof ExprIdentNode) {
            ExprIdentNode identNode = (ExprIdentNode)this.getChildNodes()[1];
            this.streamNumber = identNode.getStreamId();
            this.resultType = JavaClassHelper.getBoxedType(this.getChildNodes()[1].getForge().getEvaluationType());
        } else if (this.getChildNodes()[1] instanceof ExprStreamUnderlyingNode) {
            ExprStreamUnderlyingNode streamNode = (ExprStreamUnderlyingNode)this.getChildNodes()[1];
            this.streamNumber = streamNode.getStreamId();
            this.resultType = JavaClassHelper.getBoxedType(this.getChildNodes()[1].getForge().getEvaluationType());
            this.enumerationMethodType = validationContext.getStreamTypeService().getEventTypes()[streamNode.getStreamId()];
        } else {
            throw new ExprValidationException("Previous function requires an event property as parameter");
        }
        if (this.previousType == ExprPreviousNodePreviousType.PREVCOUNT) {
            this.resultType = Long.class;
        }
        if (this.previousType == ExprPreviousNodePreviousType.PREVWINDOW) {
            this.resultType = JavaClassHelper.getArrayType(this.resultType);
        }
        if (validationContext.getViewResourceDelegate() == null) {
            throw new ExprValidationException("Previous function cannot be used in this context");
        }
        validationContext.getViewResourceDelegate().addPreviousRequest(this);
        return null;
    }

    public ExprPreviousNodePreviousType getPreviousType() {
        return this.previousType;
    }

    @Override
    public boolean isConstantResult() {
        return false;
    }

    @Override
    public Collection<EventBean> evaluateGetROCollectionEvents(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        if (!isNewData) {
            return null;
        }
        return this.evaluator.evaluateGetCollEvents(eventsPerStream, context);
    }

    @Override
    public CodegenExpression evaluateGetROCollectionEventsCodegen(CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return CodegenLegoEvaluateSelf.evaluateSelfGetROCollectionEvents(this, codegenMethodScope, exprSymbol, codegenClassScope);
    }

    @Override
    public EventBean evaluateGetEventBean(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        if (!isNewData) {
            return null;
        }
        return this.evaluator.evaluateGetEventBean(eventsPerStream, context);
    }

    @Override
    public CodegenExpression evaluateGetEventBeanCodegen(CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return CodegenLegoEvaluateSelf.evaluateSelfGetEventBean(this, codegenMethodScope, exprSymbol, codegenClassScope);
    }

    @Override
    public Collection evaluateGetROCollectionScalar(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        if (!isNewData) {
            return null;
        }
        return this.evaluator.evaluateGetCollScalar(eventsPerStream, context);
    }

    @Override
    public CodegenExpression evaluateGetROCollectionScalarCodegen(CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return CodegenLegoEvaluateSelf.evaluateSelfGetROCollectionScalar(this, codegenMethodScope, exprSymbol, codegenClassScope);
    }

    @Override
    public EventType getEventTypeCollection(EventAdapterService eventAdapterService, int statementId) throws ExprValidationException {
        if (this.previousType == ExprPreviousNodePreviousType.PREV || this.previousType == ExprPreviousNodePreviousType.PREVTAIL) {
            return null;
        }
        return this.enumerationMethodType;
    }

    @Override
    public EventType getEventTypeSingle(EventAdapterService eventAdapterService, int statementId) throws ExprValidationException {
        if (this.previousType == ExprPreviousNodePreviousType.PREV || this.previousType == ExprPreviousNodePreviousType.PREVTAIL) {
            return this.enumerationMethodType;
        }
        return null;
    }

    @Override
    public Class getComponentTypeCollection() throws ExprValidationException {
        if (this.resultType.isArray()) {
            return this.resultType.getComponentType();
        }
        return this.resultType;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        if (!isNewData) {
            return null;
        }
        return this.evaluator.evaluate(eventsPerStream, exprEvaluatorContext);
    }

    @Override
    public CodegenExpression evaluateCodegen(Class requiredType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return CodegenLegoEvaluateSelf.evaluateSelfPlainWithCast(requiredType, this, this.getEvaluationType(), codegenMethodScope, exprSymbol, codegenClassScope);
    }

    @Override
    public ExprForgeComplexityEnum getComplexity() {
        return ExprForgeComplexityEnum.SELF;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        writer.append(this.previousType.toString().toLowerCase(Locale.ENGLISH));
        writer.append("(");
        if (this.previousType == ExprPreviousNodePreviousType.PREVCOUNT || this.previousType == ExprPreviousNodePreviousType.PREVWINDOW) {
            this.getChildNodes()[1].toEPL(writer, ExprPrecedenceEnum.MINIMUM);
        } else {
            this.getChildNodes()[0].toEPL(writer, ExprPrecedenceEnum.MINIMUM);
            if (this.getChildNodes().length > 1) {
                writer.append(",");
                this.getChildNodes()[1].toEPL(writer, ExprPrecedenceEnum.MINIMUM);
            }
        }
        writer.append(')');
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }

    @Override
    public ExprNode getForgeRenderable() {
        return this;
    }

    public int hashCode() {
        return this.previousType != null ? this.previousType.hashCode() : 0;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        if (node == null || this.getClass() != node.getClass()) {
            return false;
        }
        ExprPreviousNode that = (ExprPreviousNode)node;
        return this.previousType == that.previousType;
    }
}

