/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.ops;

import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprForge;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeBase;
import com.espertech.esper.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.ops.ExprRelationalOpNode;
import com.espertech.esper.epl.expression.ops.ExprRelationalOpNodeForge;
import com.espertech.esper.type.RelationalOpEnum;
import com.espertech.esper.util.JavaClassHelper;
import java.io.StringWriter;

public class ExprRelationalOpNodeImpl
extends ExprNodeBase
implements ExprRelationalOpNode {
    private static final long serialVersionUID = -6170161542681634598L;
    private final RelationalOpEnum relationalOpEnum;
    private transient ExprRelationalOpNodeForge forge;

    public ExprRelationalOpNodeImpl(RelationalOpEnum relationalOpEnum) {
        this.relationalOpEnum = relationalOpEnum;
    }

    public ExprEvaluator getExprEvaluator() {
        ExprRelationalOpNodeImpl.checkValidated(this.forge);
        return this.forge.getExprEvaluator();
    }

    @Override
    public ExprForge getForge() {
        ExprRelationalOpNodeImpl.checkValidated(this.forge);
        return this.forge;
    }

    @Override
    public boolean isConstantResult() {
        return false;
    }

    @Override
    public RelationalOpEnum getRelationalOpEnum() {
        return this.relationalOpEnum;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        if (this.getChildNodes().length != 2) {
            throw new IllegalStateException("Relational op node does not have exactly 2 parameters");
        }
        Class typeOne = JavaClassHelper.getBoxedType(this.getChildNodes()[0].getForge().getEvaluationType());
        Class typeTwo = JavaClassHelper.getBoxedType(this.getChildNodes()[1].getForge().getEvaluationType());
        if (typeOne != String.class || typeTwo != String.class) {
            if (!JavaClassHelper.isNumeric(typeOne)) {
                throw new ExprValidationException("Implicit conversion from datatype '" + (typeOne == null ? "null" : typeOne.getSimpleName()) + "' to numeric is not allowed");
            }
            if (!JavaClassHelper.isNumeric(typeTwo)) {
                throw new ExprValidationException("Implicit conversion from datatype '" + (typeTwo == null ? "null" : typeTwo.getSimpleName()) + "' to numeric is not allowed");
            }
        }
        Class compareType = JavaClassHelper.getCompareToCoercionType(typeOne, typeTwo);
        RelationalOpEnum.Computer computer = this.relationalOpEnum.getComputer(compareType, typeOne, typeTwo);
        this.forge = new ExprRelationalOpNodeForge(this, computer);
        return null;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        this.getChildNodes()[0].toEPL(writer, this.getPrecedence());
        writer.append(this.relationalOpEnum.getExpressionText());
        this.getChildNodes()[1].toEPL(writer, this.getPrecedence());
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.RELATIONAL_BETWEEN_IN;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        if (!(node instanceof ExprRelationalOpNodeImpl)) {
            return false;
        }
        ExprRelationalOpNodeImpl other = (ExprRelationalOpNodeImpl)node;
        return other.relationalOpEnum == this.relationalOpEnum;
    }
}

