/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.ops;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.codegen.base.CodegenBlock;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMethodNode;
import com.espertech.esper.codegen.base.CodegenMethodScope;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.ops.ExprMathNodeForge;

public class ExprMathNodeForgeEval
implements ExprEvaluator {
    private final ExprMathNodeForge forge;
    private final ExprEvaluator evaluatorLeft;
    private final ExprEvaluator evaluatorRight;

    public ExprMathNodeForgeEval(ExprMathNodeForge forge, ExprEvaluator evaluatorLeft, ExprEvaluator evaluatorRight) {
        this.forge = forge;
        this.evaluatorLeft = evaluatorLeft;
        this.evaluatorRight = evaluatorRight;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Object left = this.evaluatorLeft.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        if (left == null) {
            return null;
        }
        Object right = this.evaluatorRight.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        if (right == null) {
            return null;
        }
        Number result = this.forge.getArithTypeEnumComputer().compute((Number)left, (Number)right);
        return result;
    }

    public static CodegenMethodNode codegen(ExprMathNodeForge forge, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope, ExprNode lhs, ExprNode rhs) {
        CodegenMethodNode methodNode = codegenMethodScope.makeChild(forge.getEvaluationType(), ExprMathNodeForgeEval.class, codegenClassScope);
        Class lhsType = lhs.getForge().getEvaluationType();
        Class rhsType = rhs.getForge().getEvaluationType();
        CodegenBlock block = methodNode.getBlock().declareVar(lhsType, "left", lhs.getForge().evaluateCodegen(lhsType, methodNode, exprSymbol, codegenClassScope));
        if (!lhsType.isPrimitive()) {
            block.ifRefNullReturnNull("left");
        }
        block.declareVar(rhsType, "right", rhs.getForge().evaluateCodegen(rhsType, methodNode, exprSymbol, codegenClassScope));
        if (!rhsType.isPrimitive()) {
            block.ifRefNullReturnNull("right");
        }
        block.methodReturn(forge.getArithTypeEnumComputer().codegen(methodNode, codegenClassScope, CodegenExpressionBuilder.ref("left"), CodegenExpressionBuilder.ref("right"), lhsType, rhsType));
        return methodNode;
    }
}

