/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.ops;

import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprForge;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeBase;
import com.espertech.esper.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.ops.ExprInNode;
import com.espertech.esper.epl.expression.ops.ExprInNodeForge;
import com.espertech.esper.util.CoercionException;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.SimpleNumberCoercer;
import com.espertech.esper.util.SimpleNumberCoercerFactory;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class ExprInNodeImpl
extends ExprNodeBase
implements ExprInNode {
    private static final long serialVersionUID = -601723009914169907L;
    private final boolean isNotIn;
    private transient ExprInNodeForge forge;

    public ExprInNodeImpl(boolean isNotIn) {
        this.isNotIn = isNotIn;
    }

    public ExprEvaluator getExprEvaluator() {
        ExprInNodeImpl.checkValidated(this.forge);
        return this.forge.getExprEvaluator();
    }

    @Override
    public ExprForge getForge() {
        return this.forge;
    }

    @Override
    public boolean isNotIn() {
        return this.isNotIn;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        this.validateWithoutContext();
        return null;
    }

    @Override
    public void validateWithoutContext() throws ExprValidationException {
        Class coercionType;
        if (this.getChildNodes().length < 2) {
            throw new ExprValidationException("The IN operator requires at least 2 child expressions");
        }
        Class typeOne = JavaClassHelper.getBoxedType(this.getChildNodes()[0].getForge().getEvaluationType());
        if (typeOne.isArray() || JavaClassHelper.isImplementsInterface(typeOne, Collection.class) || JavaClassHelper.isImplementsInterface(typeOne, Map.class)) {
            throw new ExprValidationException("Collection or array comparison is not allowed for the IN, ANY, SOME or ALL keywords");
        }
        ArrayList<Class> comparedTypes = new ArrayList<Class>();
        comparedTypes.add(typeOne);
        boolean hasCollectionOrArray = false;
        for (int i = 0; i < this.getChildNodes().length - 1; ++i) {
            Class propType = this.getChildNodes()[i + 1].getForge().getEvaluationType();
            if (propType == null) continue;
            if (propType.isArray()) {
                hasCollectionOrArray = true;
                if (propType.getComponentType() == Object.class) continue;
                comparedTypes.add(propType.getComponentType());
                continue;
            }
            if (JavaClassHelper.isImplementsInterface(propType, Collection.class)) {
                hasCollectionOrArray = true;
                continue;
            }
            if (JavaClassHelper.isImplementsInterface(propType, Map.class)) {
                hasCollectionOrArray = true;
                continue;
            }
            comparedTypes.add(propType);
        }
        try {
            coercionType = JavaClassHelper.getCommonCoercionType(comparedTypes.toArray(new Class[comparedTypes.size()]));
        }
        catch (CoercionException ex) {
            throw new ExprValidationException("Implicit conversion not allowed: " + ex.getMessage());
        }
        boolean mustCoerce = false;
        SimpleNumberCoercer coercer = null;
        if (JavaClassHelper.isNumeric(coercionType)) {
            for (Class compareType : comparedTypes) {
                if (coercionType == JavaClassHelper.getBoxedType(compareType)) continue;
                mustCoerce = true;
            }
            if (mustCoerce) {
                coercer = SimpleNumberCoercerFactory.getCoercer(null, JavaClassHelper.getBoxedType(coercionType));
            }
        }
        this.forge = new ExprInNodeForge(this, mustCoerce, coercer, coercionType, hasCollectionOrArray);
    }

    @Override
    public boolean isConstantResult() {
        return false;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        if (!(node instanceof ExprInNodeImpl)) {
            return false;
        }
        ExprInNodeImpl other = (ExprInNodeImpl)node;
        return other.isNotIn == this.isNotIn;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        String delimiter = "";
        Iterator<ExprNode> it = Arrays.asList(this.getChildNodes()).iterator();
        it.next().toEPL(writer, this.getPrecedence());
        if (this.isNotIn) {
            writer.append(" not in (");
        } else {
            writer.append(" in (");
        }
        do {
            ExprNode inSetValueExpr = it.next();
            writer.append(delimiter);
            inSetValueExpr.toEPL(writer, this.getPrecedence());
            delimiter = ",";
        } while (it.hasNext());
        writer.append(')');
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.RELATIONAL_BETWEEN_IN;
    }
}

