/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.ops;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.codegen.base.CodegenBlock;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMethodNode;
import com.espertech.esper.codegen.base.CodegenMethodScope;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.epl.expression.core.ExprEnumerationEval;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprForge;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.ops.ExprArrayNodeForge;
import java.lang.reflect.Array;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;

public class ExprArrayNodeForgeEval
implements ExprEvaluator,
ExprEnumerationEval {
    private final ExprArrayNodeForge forge;
    private final ExprEvaluator[] evaluators;

    public ExprArrayNodeForgeEval(ExprArrayNodeForge forge, ExprEvaluator[] evaluators) {
        this.forge = forge;
        this.evaluators = evaluators;
    }

    public ExprEnumerationEval getExprEvaluatorEnumeration() {
        return this;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Object array = Array.newInstance(this.forge.getArrayReturnType(), this.evaluators.length);
        int index = 0;
        for (ExprEvaluator child : this.evaluators) {
            Object result = child.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (result != null) {
                if (this.forge.isMustCoerce()) {
                    Number boxed = (Number)result;
                    Number coercedResult = this.forge.getCoercer().coerceBoxed(boxed);
                    Array.set(array, index, coercedResult);
                } else {
                    Array.set(array, index, result);
                }
            }
            ++index;
        }
        return array;
    }

    public static CodegenExpression codegen(ExprArrayNodeForge forge, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenMethodNode methodNode = codegenMethodScope.makeChild(forge.getEvaluationType(), ExprArrayNodeForgeEval.class, codegenClassScope);
        CodegenBlock block = methodNode.getBlock().declareVar(forge.getEvaluationType(), "array", CodegenExpressionBuilder.newArrayByLength(forge.getArrayReturnType(), CodegenExpressionBuilder.constant(forge.getForgeRenderable().getChildNodes().length)));
        for (int i = 0; i < forge.getForgeRenderable().getChildNodes().length; ++i) {
            ExprForge child = forge.getForgeRenderable().getChildNodes()[i].getForge();
            Class childType = child.getEvaluationType();
            String refname = "r" + i;
            block.declareVar(childType, refname, child.evaluateCodegen(childType, methodNode, exprSymbol, codegenClassScope));
            if (child.getEvaluationType().isPrimitive()) {
                if (!forge.isMustCoerce()) {
                    block.assignArrayElement("array", CodegenExpressionBuilder.constant(i), (CodegenExpression)CodegenExpressionBuilder.ref(refname));
                    continue;
                }
                block.assignArrayElement("array", CodegenExpressionBuilder.constant(i), forge.getCoercer().coerceCodegen(CodegenExpressionBuilder.ref(refname), child.getEvaluationType()));
                continue;
            }
            CodegenBlock ifNotNull = block.ifCondition(CodegenExpressionBuilder.notEqualsNull(CodegenExpressionBuilder.ref(refname)));
            if (!forge.isMustCoerce()) {
                ifNotNull.assignArrayElement("array", CodegenExpressionBuilder.constant(i), (CodegenExpression)CodegenExpressionBuilder.ref(refname));
                continue;
            }
            ifNotNull.assignArrayElement("array", CodegenExpressionBuilder.constant(i), forge.getCoercer().coerceCodegen(CodegenExpressionBuilder.ref(refname), child.getEvaluationType()));
        }
        block.methodReturn(CodegenExpressionBuilder.ref("array"));
        return CodegenExpressionBuilder.localMethod(methodNode, new CodegenExpression[0]);
    }

    @Override
    public Collection<EventBean> evaluateGetROCollectionEvents(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        return null;
    }

    @Override
    public Collection evaluateGetROCollectionScalar(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        if (this.forge.getForgeRenderable().getChildNodes().length == 0) {
            return Collections.emptyList();
        }
        ArrayDeque<Object> resultList = new ArrayDeque<Object>(this.evaluators.length);
        for (ExprEvaluator child : this.evaluators) {
            Object result = child.evaluate(eventsPerStream, isNewData, context);
            if (result == null) continue;
            if (this.forge.isMustCoerce()) {
                Number boxed = (Number)result;
                Number coercedResult = this.forge.getCoercer().coerceBoxed(boxed);
                resultList.add(coercedResult);
                continue;
            }
            resultList.add(result);
        }
        return resultList;
    }

    public static CodegenExpression codegenEvaluateGetROCollectionScalar(ExprArrayNodeForge forge, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        ExprNode[] children = forge.getForgeRenderable().getChildNodes();
        if (children.length == 0) {
            return CodegenExpressionBuilder.staticMethod(Collections.class, "emptyList", new CodegenExpression[0]);
        }
        CodegenMethodNode methodNode = codegenMethodScope.makeChild(Collection.class, ExprArrayNodeForgeEval.class, codegenClassScope);
        CodegenBlock block = methodNode.getBlock().declareVar(ArrayDeque.class, "resultList", CodegenExpressionBuilder.newInstance(ArrayDeque.class, CodegenExpressionBuilder.constant(children.length)));
        int count = -1;
        for (ExprNode child : children) {
            String refname = "r" + ++count;
            ExprForge childForge = child.getForge();
            Class returnType = childForge.getEvaluationType();
            if (returnType == null) continue;
            block.declareVar(returnType, refname, childForge.evaluateCodegen(returnType, methodNode, exprSymbol, codegenClassScope));
            CodegenExpression nonNullTest = returnType.isPrimitive() ? CodegenExpressionBuilder.constantTrue() : CodegenExpressionBuilder.notEqualsNull(CodegenExpressionBuilder.ref(refname));
            CodegenBlock blockIfNotNull = block.ifCondition(nonNullTest);
            CodegenExpression added = CodegenExpressionBuilder.ref(refname);
            if (forge.isMustCoerce()) {
                added = forge.getCoercer().coerceCodegen(CodegenExpressionBuilder.ref(refname), childForge.getEvaluationType());
            }
            blockIfNotNull.expression(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("resultList"), "add", added));
        }
        block.methodReturn(CodegenExpressionBuilder.ref("resultList"));
        return CodegenExpressionBuilder.localMethod(methodNode, new CodegenExpression[0]);
    }

    @Override
    public EventBean evaluateGetEventBean(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        return null;
    }
}

