/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.ops;

import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.expression.core.ExprEnumerationEval;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprForge;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeBase;
import com.espertech.esper.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.ops.ExprArrayNodeForge;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.util.CoercionException;
import com.espertech.esper.util.CollectionUtil;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.SimpleNumberCoercer;
import com.espertech.esper.util.SimpleNumberCoercerFactory;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.util.LinkedList;

public class ExprArrayNode
extends ExprNodeBase {
    private static final long serialVersionUID = 5533223915923867651L;
    private transient ExprArrayNodeForge forge;

    public ExprEvaluator getExprEvaluator() {
        ExprArrayNode.checkValidated(this.forge);
        return this.forge.getExprEvaluator();
    }

    @Override
    public boolean isConstantResult() {
        ExprArrayNode.checkValidated(this.forge);
        return this.forge.getConstantResult() != null;
    }

    @Override
    public ExprForge getForge() {
        ExprArrayNode.checkValidated(this.forge);
        return this.forge;
    }

    public ExprEnumerationEval getExprEvaluatorEnumeration() {
        ExprArrayNode.checkValidated(this.forge);
        return this.forge.getExprEvaluatorEnumeration();
    }

    public Class getComponentTypeCollection() throws ExprValidationException {
        ExprArrayNode.checkValidated(this.forge);
        return this.forge.getArrayReturnType();
    }

    public EventType getEventTypeCollection(EventAdapterService eventAdapterService, int statementId) throws ExprValidationException {
        return null;
    }

    public EventType getEventTypeSingle(EventAdapterService eventAdapterService, int statementId) throws ExprValidationException {
        return null;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        int length = this.getChildNodes().length;
        if (this.getChildNodes().length == 0) {
            this.forge = new ExprArrayNodeForge(this, Object.class, CollectionUtil.OBJECTARRAY_EMPTY);
            return null;
        }
        LinkedList<Class> comparedTypes = new LinkedList<Class>();
        for (int i = 0; i < length; ++i) {
            comparedTypes.add(this.getChildNodes()[i].getForge().getEvaluationType());
        }
        Class arrayReturnType = null;
        boolean mustCoerce = false;
        SimpleNumberCoercer coercer = null;
        try {
            arrayReturnType = JavaClassHelper.getCommonCoercionType(comparedTypes.toArray(new Class[comparedTypes.size()]));
            if (JavaClassHelper.isNumeric(arrayReturnType)) {
                mustCoerce = false;
                for (Class comparedType : comparedTypes) {
                    if (comparedType == arrayReturnType) continue;
                    mustCoerce = true;
                }
                if (mustCoerce) {
                    coercer = SimpleNumberCoercerFactory.getCoercer(null, arrayReturnType);
                }
            }
        }
        catch (CoercionException coercionException) {
            // empty catch block
        }
        if (arrayReturnType == null) {
            arrayReturnType = Object.class;
        }
        Object[] results = new Object[length];
        int index = 0;
        for (ExprNode child : this.getChildNodes()) {
            if (!child.isConstantResult()) {
                results = null;
                break;
            }
            results[index] = this.getChildNodes()[index].getForge().getExprEvaluator().evaluate(null, false, validationContext.getExprEvaluatorContext());
            ++index;
        }
        Object constantResult = null;
        if (results != null) {
            constantResult = Array.newInstance(arrayReturnType, length);
            for (int i = 0; i < length; ++i) {
                if (mustCoerce) {
                    Number boxed = (Number)results[i];
                    if (boxed == null) continue;
                    Number coercedResult = coercer.coerceBoxed(boxed);
                    Array.set(constantResult, i, coercedResult);
                    continue;
                }
                Array.set(constantResult, i, results[i]);
            }
        }
        this.forge = new ExprArrayNodeForge(this, arrayReturnType, mustCoerce, coercer, constantResult);
        return null;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        String delimiter = "";
        writer.append("{");
        for (ExprNode expr : this.getChildNodes()) {
            writer.append(delimiter);
            expr.toEPL(writer, ExprPrecedenceEnum.MINIMUM);
            delimiter = ",";
        }
        writer.append('}');
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        return node instanceof ExprArrayNode;
    }
}

