/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.methodagg;

import com.espertech.esper.epl.agg.service.common.AggregationMethodFactory;
import com.espertech.esper.epl.expression.baseagg.ExprAggregateNode;
import com.espertech.esper.epl.expression.baseagg.ExprAggregateNodeBase;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeUtilityCore;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.time.ExprTimePeriod;
import com.espertech.esper.epl.expression.time.ExprTimestampNode;
import com.espertech.esper.epl.util.ExprNodeUtilityRich;
import com.espertech.esper.util.JavaClassHelper;

public class ExprRateAggNode
extends ExprAggregateNodeBase {
    private static final long serialVersionUID = -1616393720555472129L;

    public ExprRateAggNode(boolean distinct) {
        super(distinct);
    }

    @Override
    public AggregationMethodFactory validateAggregationChild(ExprValidationContext validationContext) throws ExprValidationException {
        if (this.positionalParams.length == 0) {
            throw new ExprValidationException("The rate aggregation function minimally requires a numeric constant or expression as a parameter.");
        }
        ExprNode first = this.positionalParams[0];
        if (first.isConstantResult()) {
            long intervalTime;
            String message = "The rate aggregation function requires a numeric constant or time period as the first parameter in the constant-value notation";
            if (first instanceof ExprTimePeriod) {
                double secInterval = ((ExprTimePeriod)first).evaluateAsSeconds(null, true, validationContext.getExprEvaluatorContext());
                intervalTime = validationContext.getEngineImportService().getTimeAbacus().deltaForSecondsDouble(secInterval);
            } else if (ExprNodeUtilityCore.isConstantValueExpr(first)) {
                if (!JavaClassHelper.isNumeric(first.getForge().getEvaluationType())) {
                    throw new ExprValidationException(message);
                }
                Number num = (Number)first.getForge().getExprEvaluator().evaluate(null, true, validationContext.getExprEvaluatorContext());
                intervalTime = validationContext.getEngineImportService().getTimeAbacus().deltaForSecondsNumber(num);
            } else {
                throw new ExprValidationException(message);
            }
            this.positionalParams = this.optionalFilter == null ? ExprNodeUtilityCore.EMPTY_EXPR_ARRAY : new ExprNode[]{this.optionalFilter};
            return validationContext.getEngineImportService().getAggregationFactoryFactory().makeRate(validationContext.getStatementExtensionSvcContext(), this, true, intervalTime, validationContext.getTimeProvider(), validationContext.getEngineImportService().getTimeAbacus());
        }
        String message = "The rate aggregation function requires a property or expression returning a non-constant long-type value as the first parameter in the timestamp-property notation";
        Class boxedParamOne = JavaClassHelper.getBoxedType(first.getForge().getEvaluationType());
        if (boxedParamOne != Long.class) {
            throw new ExprValidationException(message);
        }
        if (first.isConstantResult()) {
            throw new ExprValidationException(message);
        }
        if (first instanceof ExprTimestampNode) {
            throw new ExprValidationException("The rate aggregation function does not allow the current engine timestamp as a parameter");
        }
        if (this.positionalParams.length > 1 && !JavaClassHelper.isNumeric(this.positionalParams[1].getForge().getEvaluationType())) {
            throw new ExprValidationException("The rate aggregation function accepts an expression returning a numeric value to accumulate as an optional second parameter");
        }
        boolean hasDataWindows = ExprNodeUtilityRich.hasRemoveStreamForAggregations(first, validationContext.getStreamTypeService(), validationContext.isResettingAggregations());
        if (!hasDataWindows) {
            throw new ExprValidationException("The rate aggregation function in the timestamp-property notation requires data windows");
        }
        if (this.optionalFilter != null) {
            this.positionalParams = ExprNodeUtilityCore.addExpression(this.positionalParams, this.optionalFilter);
        }
        return validationContext.getEngineImportService().getAggregationFactoryFactory().makeRate(validationContext.getStatementExtensionSvcContext(), this, false, -1L, validationContext.getTimeProvider(), validationContext.getEngineImportService().getTimeAbacus());
    }

    @Override
    public String getAggregationFunctionName() {
        return "rate";
    }

    @Override
    public final boolean equalsNodeAggregateMethodOnly(ExprAggregateNode node) {
        return node instanceof ExprRateAggNode;
    }

    @Override
    protected boolean isFilterExpressionAsLastParameter() {
        return false;
    }
}

