/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.funcs;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMember;
import com.espertech.esper.codegen.base.CodegenMethodNode;
import com.espertech.esper.codegen.base.CodegenMethodScope;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprForge;
import com.espertech.esper.epl.expression.core.ExprNamedParameterNode;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeBase;
import com.espertech.esper.epl.expression.core.ExprNodeUtilityCore;
import com.espertech.esper.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.funcs.ExprCastNodeDateDesc;
import com.espertech.esper.epl.expression.funcs.ExprCastNodeForge;
import com.espertech.esper.epl.util.ExprNodeUtilityRich;
import com.espertech.esper.pattern.observer.TimerScheduleISO8601Parser;
import com.espertech.esper.schedule.ScheduleParameterException;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.SimpleTypeCaster;
import com.espertech.esper.util.SimpleTypeCasterAnyType;
import com.espertech.esper.util.SimpleTypeCasterFactory;
import com.espertech.esper.util.SimpleTypeParser;
import com.espertech.esper.util.SimpleTypeParserFactory;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class ExprCastNode
extends ExprNodeBase {
    private static final long serialVersionUID = 7448449031028156455L;
    private final String classIdentifier;
    private transient ExprCastNodeForge forge;

    public ExprCastNode(String classIdentifier) {
        this.classIdentifier = classIdentifier;
    }

    public ExprEvaluator getExprEvaluator() {
        ExprCastNode.checkValidated(this.forge);
        return this.forge.getExprEvaluator();
    }

    @Override
    public ExprForge getForge() {
        ExprCastNode.checkValidated(this.forge);
        return this.forge;
    }

    public String getClassIdentifier() {
        return this.classIdentifier;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        void var8_54;
        void var6_19;
        void var8_49;
        SimpleTypeCaster caster;
        boolean numeric;
        if (this.getChildNodes().length == 0 || this.getChildNodes().length > 2) {
            throw new ExprValidationException("Cast function node must have one or two child expressions");
        }
        Class fromType = this.getChildNodes()[0].getForge().getEvaluationType();
        Map<String, ExprNamedParameterNode> namedParams = ExprNodeUtilityRich.getNamedExpressionsHandleDups(Arrays.asList(this.getChildNodes()));
        ExprNodeUtilityRich.validateNamed(namedParams, new String[]{"dateformat"});
        ExprNamedParameterNode dateFormatParameter = namedParams.get("dateformat");
        if (dateFormatParameter != null) {
            ExprNodeUtilityRich.validateNamedExpectType(dateFormatParameter, new Class[]{String.class, DateFormat.class, DateTimeFormatter.class});
        }
        Class clazz = JavaClassHelper.getBoxedType(JavaClassHelper.getPrimitiveClassForName(this.classIdentifier.trim()));
        Object var8_20 = null;
        if (dateFormatParameter != null) {
            ExprCastNodeDateDesc desc;
            void var6_7;
            if (fromType != String.class) {
                throw new ExprValidationException("Use of the '" + dateFormatParameter.getParameterName() + "' named parameter requires a string-type input");
            }
            if (clazz == null) {
                try {
                    Class clazz2 = JavaClassHelper.getClassForName(this.classIdentifier.trim(), validationContext.getEngineImportService().getClassForNameProvider());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            numeric = false;
            caster = null;
            if (var6_7 == Date.class || this.classIdentifier.trim().toLowerCase(Locale.ENGLISH).equals("date")) {
                Class<Date> clazz3 = Date.class;
                desc = this.validateDateFormat(dateFormatParameter, validationContext, false);
                if (desc.isIso8601Format()) {
                    StringToDateWStaticISOFormatComputer stringToDateWStaticISOFormatComputer = new StringToDateWStaticISOFormatComputer();
                } else if (desc.getDateFormat() != null) {
                    StringToDateWStaticFormatComputer stringToDateWStaticFormatComputer = new StringToDateWStaticFormatComputer(desc.getStaticDateFormatString(), desc.getDateFormat());
                } else {
                    StringToDateWDynamicFormatComputerForge stringToDateWDynamicFormatComputerForge = new StringToDateWDynamicFormatComputerForge(desc.getDynamicDateFormat());
                }
            } else if (var6_7 == Calendar.class || this.classIdentifier.trim().toLowerCase(Locale.ENGLISH).equals("calendar")) {
                Class<Calendar> clazz4 = Calendar.class;
                desc = this.validateDateFormat(dateFormatParameter, validationContext, false);
                if (desc.isIso8601Format()) {
                    StringToCalendarWStaticISOFormatComputer stringToCalendarWStaticISOFormatComputer = new StringToCalendarWStaticISOFormatComputer();
                } else if (desc.getDateFormat() != null) {
                    StringToCalendarWStaticFormatComputer stringToCalendarWStaticFormatComputer = new StringToCalendarWStaticFormatComputer(desc.getStaticDateFormatString(), desc.getDateFormat(), validationContext.getEngineImportService().getTimeZone());
                } else {
                    StringToCalendarWDynamicFormatComputer stringToCalendarWDynamicFormatComputer = new StringToCalendarWDynamicFormatComputer(desc.getDynamicDateFormat(), validationContext.getEngineImportService().getTimeZone());
                }
            } else if (var6_7 == Long.class) {
                Class<Long> clazz5 = Long.class;
                desc = this.validateDateFormat(dateFormatParameter, validationContext, false);
                if (desc.isIso8601Format()) {
                    StringToLongWStaticISOFormatComputer stringToLongWStaticISOFormatComputer = new StringToLongWStaticISOFormatComputer();
                } else if (desc.getDateFormat() != null) {
                    StringToLongWStaticFormatComputer stringToLongWStaticFormatComputer = new StringToLongWStaticFormatComputer(desc.getStaticDateFormatString(), desc.getDateFormat());
                } else {
                    StringToLongWDynamicFormatComputerForge stringToLongWDynamicFormatComputerForge = new StringToLongWDynamicFormatComputerForge(desc.getDynamicDateFormat());
                }
            } else if (var6_7 == LocalDateTime.class || this.classIdentifier.trim().toLowerCase(Locale.ENGLISH).equals("localdatetime")) {
                Class<LocalDateTime> clazz6 = LocalDateTime.class;
                desc = this.validateDateFormat(dateFormatParameter, validationContext, true);
                if (desc.isIso8601Format()) {
                    StringToLocalDateTimeWStaticFormatComputer stringToLocalDateTimeWStaticFormatComputer = new StringToLocalDateTimeWStaticFormatComputer(DateTimeFormatter.ISO_DATE_TIME);
                } else if (desc.getDateTimeFormatter() != null) {
                    StringToLocalDateTimeWStaticFormatComputer stringToLocalDateTimeWStaticFormatComputer = new StringToLocalDateTimeWStaticFormatComputer(desc.getDateTimeFormatter());
                } else {
                    StringToLocalDateTimeWDynamicFormatComputerForge stringToLocalDateTimeWDynamicFormatComputerForge = new StringToLocalDateTimeWDynamicFormatComputerForge(desc.getDynamicDateFormat());
                }
            } else if (var6_7 == LocalDate.class || this.classIdentifier.trim().toLowerCase(Locale.ENGLISH).equals("localdate")) {
                Class<LocalDate> clazz7 = LocalDate.class;
                desc = this.validateDateFormat(dateFormatParameter, validationContext, true);
                if (desc.isIso8601Format()) {
                    StringToLocalDateWStaticFormatComputer stringToLocalDateWStaticFormatComputer = new StringToLocalDateWStaticFormatComputer(DateTimeFormatter.ISO_DATE);
                } else if (desc.getDateTimeFormatter() != null) {
                    StringToLocalDateWStaticFormatComputer stringToLocalDateWStaticFormatComputer = new StringToLocalDateWStaticFormatComputer(desc.getDateTimeFormatter());
                } else {
                    StringToLocalDateWDynamicFormatComputerForge stringToLocalDateWDynamicFormatComputerForge = new StringToLocalDateWDynamicFormatComputerForge(desc.getDynamicDateFormat());
                }
            } else if (var6_7 == LocalTime.class || this.classIdentifier.trim().toLowerCase(Locale.ENGLISH).equals("localtime")) {
                Class<LocalTime> clazz8 = LocalTime.class;
                desc = this.validateDateFormat(dateFormatParameter, validationContext, true);
                if (desc.isIso8601Format()) {
                    StringToLocalTimeWStaticFormatComputer stringToLocalTimeWStaticFormatComputer = new StringToLocalTimeWStaticFormatComputer(DateTimeFormatter.ISO_TIME);
                } else if (desc.getDateTimeFormatter() != null) {
                    StringToLocalTimeWStaticFormatComputer stringToLocalTimeWStaticFormatComputer = new StringToLocalTimeWStaticFormatComputer(desc.getDateTimeFormatter());
                } else {
                    StringToLocalTimeWDynamicFormatComputerForge stringToLocalTimeWDynamicFormatComputerForge = new StringToLocalTimeWDynamicFormatComputerForge(desc.getDynamicDateFormat());
                }
            } else {
                if (var6_7 != ZonedDateTime.class && !this.classIdentifier.trim().toLowerCase(Locale.ENGLISH).equals("zoneddatetime")) throw new ExprValidationException("Use of the '" + dateFormatParameter.getParameterName() + "' named parameter requires a target type of calendar, date, long, localdatetime, localdate, localtime or zoneddatetime");
                Class<ZonedDateTime> clazz9 = ZonedDateTime.class;
                desc = this.validateDateFormat(dateFormatParameter, validationContext, true);
                if (desc.isIso8601Format()) {
                    StringToZonedDateTimeWStaticFormatComputer stringToZonedDateTimeWStaticFormatComputer = new StringToZonedDateTimeWStaticFormatComputer(DateTimeFormatter.ISO_ZONED_DATE_TIME);
                } else if (desc.getDateTimeFormatter() != null) {
                    StringToZonedDateTimeWStaticFormatComputer stringToZonedDateTimeWStaticFormatComputer = new StringToZonedDateTimeWStaticFormatComputer(desc.getDateTimeFormatter());
                } else {
                    StringToZonedDateTimeWDynamicFormatComputerForge stringToZonedDateTimeWDynamicFormatComputerForge = new StringToZonedDateTimeWDynamicFormatComputerForge(desc.getDynamicDateFormat());
                }
            }
        } else if (clazz != null) {
            Class clazz10 = JavaClassHelper.getBoxedType(clazz);
            caster = SimpleTypeCasterFactory.getCaster(fromType, clazz10);
            numeric = caster.isNumericCast();
        } else if (this.classIdentifier.trim().toLowerCase(Locale.ENGLISH).equals("BigInteger".toLowerCase(Locale.ENGLISH))) {
            Class<BigInteger> clazz11 = BigInteger.class;
            caster = SimpleTypeCasterFactory.getCaster(fromType, clazz11);
            numeric = true;
        } else if (this.classIdentifier.trim().toLowerCase(Locale.ENGLISH).equals("BigDecimal".toLowerCase(Locale.ENGLISH))) {
            Class<BigDecimal> clazz12 = BigDecimal.class;
            caster = SimpleTypeCasterFactory.getCaster(fromType, clazz12);
            numeric = true;
        } else {
            Class clazz13;
            try {
                clazz13 = JavaClassHelper.getClassForName(this.classIdentifier.trim(), validationContext.getEngineImportService().getClassForNameProvider());
            }
            catch (ClassNotFoundException e) {
                throw new ExprValidationException("Class as listed in cast function by name '" + this.classIdentifier + "' cannot be loaded", e);
            }
            numeric = JavaClassHelper.isNumeric(clazz13);
            caster = numeric ? SimpleTypeCasterFactory.getCaster(fromType, clazz13) : new SimpleTypeCasterAnyType(clazz13);
        }
        if (var8_49 == null) {
            if (var6_19 == String.class) {
                StringXFormComputer stringXFormComputer = new StringXFormComputer();
            } else if (fromType == String.class && var6_19 != Character.class) {
                SimpleTypeParser parser = SimpleTypeParserFactory.getParser(JavaClassHelper.getBoxedType((Class)var6_19));
                StringParserComputer stringParserComputer = new StringParserComputer(parser);
            } else if (numeric) {
                NumberCasterComputer numberCasterComputer = new NumberCasterComputer(caster);
            } else {
                NonnumericCasterComputer nonnumericCasterComputer = new NonnumericCasterComputer(caster);
            }
        }
        Object theConstant = null;
        boolean isConstant = false;
        if (this.getChildNodes()[0].isConstantResult() && (isConstant = var8_54.isConstantForConstInput())) {
            Object in = this.getChildNodes()[0].getForge().getExprEvaluator().evaluate(null, true, validationContext.getExprEvaluatorContext());
            theConstant = in == null ? null : var8_54.getEvaluatorComputer().compute(in, null, true, validationContext.getExprEvaluatorContext());
        }
        this.forge = new ExprCastNodeForge(this, (CasterParserComputerForge)var8_54, (Class)var6_19, isConstant, theConstant);
        return null;
    }

    @Override
    public boolean isConstantResult() {
        ExprCastNode.checkValidated(this.forge);
        return this.forge.isConstant();
    }

    public Class getTargetType() {
        ExprCastNode.checkValidated(this.forge);
        return this.forge.getEvaluationType();
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        writer.append("cast(");
        this.getChildNodes()[0].toEPL(writer, ExprPrecedenceEnum.MINIMUM);
        writer.append(",");
        writer.append(this.classIdentifier);
        for (int i = 1; i < this.getChildNodes().length; ++i) {
            writer.write(",");
            this.getChildNodes()[i].toEPL(writer, ExprPrecedenceEnum.MINIMUM);
        }
        writer.append(')');
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        if (!(node instanceof ExprCastNode)) {
            return false;
        }
        ExprCastNode other = (ExprCastNode)node;
        return other.classIdentifier.equals(this.classIdentifier);
    }

    public static EPException handleParseException(String formatString, String date, Exception ex) {
        return new EPException("Exception parsing date '" + date + "' format '" + formatString + "': " + ex.getMessage(), ex);
    }

    public static EPException handleParseISOException(String date, ScheduleParameterException ex) {
        return new EPException("Exception parsing iso8601 date '" + date + "': " + ex.getMessage(), ex);
    }

    private ExprCastNodeDateDesc validateDateFormat(ExprNamedParameterNode dateFormatParameter, ExprValidationContext validationContext, boolean java8Formatter) throws ExprValidationException {
        String staticFormatString = null;
        DateFormat dateFormat = null;
        ExprForge dynamicDateFormat = null;
        boolean iso8601Format = false;
        DateTimeFormatter dateTimeFormatter = null;
        ExprNode formatExpr = dateFormatParameter.getChildNodes()[0];
        ExprForge formatForge = formatExpr.getForge();
        Class formatReturnType = formatExpr.getForge().getEvaluationType();
        if (formatReturnType == String.class) {
            if (!formatExpr.isConstantResult()) {
                dynamicDateFormat = formatForge;
            } else {
                staticFormatString = (String)formatForge.getExprEvaluator().evaluate(null, true, validationContext.getExprEvaluatorContext());
                if (staticFormatString.toLowerCase(Locale.ENGLISH).trim().equals("iso")) {
                    iso8601Format = true;
                } else if (!java8Formatter) {
                    try {
                        dateFormat = new SimpleDateFormat(staticFormatString);
                    }
                    catch (RuntimeException ex) {
                        throw new ExprValidationException("Invalid date format '" + staticFormatString + "' (as obtained from new SimpleDateFormat): " + ex.getMessage(), ex);
                    }
                } else {
                    try {
                        dateTimeFormatter = DateTimeFormatter.ofPattern(staticFormatString);
                    }
                    catch (RuntimeException ex) {
                        throw new ExprValidationException("Invalid date format '" + staticFormatString + "' (as obtained from DateTimeFormatter.ofPattern): " + ex.getMessage(), ex);
                    }
                }
            }
        } else {
            Object dateFormatObject = ExprNodeUtilityCore.evaluateValidationTimeNoStreams(formatForge.getExprEvaluator(), validationContext.getExprEvaluatorContext(), "date format");
            if (!java8Formatter) {
                if (!(dateFormatObject instanceof DateFormat)) {
                    throw this.getFailedExpected(DateFormat.class, dateFormatObject);
                }
                dateFormat = (DateFormat)dateFormatObject;
            } else {
                if (!(dateFormatObject instanceof DateTimeFormatter)) {
                    throw this.getFailedExpected(DateTimeFormatter.class, dateFormatObject);
                }
                dateTimeFormatter = (DateTimeFormatter)dateFormatObject;
            }
        }
        return new ExprCastNodeDateDesc(iso8601Format, dynamicDateFormat, staticFormatString, dateFormat, dateTimeFormatter);
    }

    public static SimpleDateFormat stringToSimpleDateFormatSafe(Object format) {
        if (format == null) {
            throw new EPException("Null date format returned by 'dateformat' expression");
        }
        try {
            return new SimpleDateFormat(format.toString());
        }
        catch (RuntimeException ex) {
            throw new EPException("Invalid date format '" + format.toString() + "': " + ex.getMessage(), ex);
        }
    }

    public static DateTimeFormatter stringToDateTimeFormatterSafe(Object format) {
        if (format == null) {
            throw new EPException("Null date format returned by 'dateformat' expression");
        }
        try {
            return DateTimeFormatter.ofPattern(format.toString());
        }
        catch (RuntimeException ex) {
            throw new EPException("Invalid date format '" + format.toString() + "': " + ex.getMessage(), ex);
        }
    }

    private ExprValidationException getFailedExpected(Class expected, Object received) {
        return new ExprValidationException("Invalid format, expected string-format or " + expected.getSimpleName() + " but received " + JavaClassHelper.getClassNameFullyQualPretty(received.getClass()));
    }

    public static class StringToCalendarWDynamicFormatComputerEval
    extends StringToDateLongWDynamicFormatEval {
        private final TimeZone timeZone;

        public StringToCalendarWDynamicFormatComputerEval(ExprEvaluator dateFormatEval, TimeZone timeZone) {
            super(dateFormatEval);
            this.timeZone = timeZone;
        }

        @Override
        public Calendar compute(Object input, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
            Object format = this.dateFormatEval.evaluate(eventsPerStream, newData, exprEvaluatorContext);
            SimpleDateFormat dateFormat = ExprCastNode.stringToSimpleDateFormatSafe(format);
            return StringToCalendarWStaticFormatComputer.stringToCalendarWStaticFormatParse(format.toString(), dateFormat, input, this.timeZone);
        }

        public static CodegenExpression codegen(CodegenExpression input, ExprForge dateFormatForge, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope, TimeZone timeZone) {
            CodegenMember timezone = codegenClassScope.makeAddMember(TimeZone.class, timeZone);
            CodegenMethodNode method = codegenMethodScope.makeChild(Calendar.class, StringToCalendarWDynamicFormatComputerEval.class, codegenClassScope).addParam(Object.class, "input");
            method.getBlock().declareVar(Object.class, "format", dateFormatForge.evaluateCodegen(Object.class, method, exprSymbol, codegenClassScope)).declareVar(SimpleDateFormat.class, "dateFormat", CodegenExpressionBuilder.staticMethod(ExprCastNode.class, "stringToSimpleDateFormatSafe", CodegenExpressionBuilder.ref("format"))).methodReturn(CodegenExpressionBuilder.staticMethod(StringToCalendarWStaticFormatComputer.class, "stringToCalendarWStaticFormatParse", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("format"), "toString", new CodegenExpression[0]), CodegenExpressionBuilder.ref("dateFormat"), CodegenExpressionBuilder.ref("input"), CodegenExpressionBuilder.member(timezone.getMemberId())));
            return CodegenExpressionBuilder.localMethod(method, input);
        }
    }

    public static class StringToCalendarWDynamicFormatComputer
    extends StringToDateLongWDynamicFormatForge {
        private final TimeZone timeZone;

        public StringToCalendarWDynamicFormatComputer(ExprForge dateFormatForge, TimeZone timeZone) {
            super(dateFormatForge);
            this.timeZone = timeZone;
        }

        @Override
        public CasterParserComputer getEvaluatorComputer() {
            return new StringToCalendarWDynamicFormatComputerEval(this.dateFormatForge.getExprEvaluator(), this.timeZone);
        }

        @Override
        public CodegenExpression codegenPremade(Class evaluationType, CodegenExpression input, Class inputType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return StringToCalendarWDynamicFormatComputerEval.codegen(input, this.dateFormatForge, codegenMethodScope, exprSymbol, codegenClassScope, this.timeZone);
        }
    }

    public static class StringToLongWDynamicFormatComputerEval
    extends StringToDateLongWDynamicFormatEval {
        public StringToLongWDynamicFormatComputerEval(ExprEvaluator dateFormatEval) {
            super(dateFormatEval);
        }

        @Override
        public Long compute(Object input, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
            Object format = this.dateFormatEval.evaluate(eventsPerStream, newData, exprEvaluatorContext);
            SimpleDateFormat dateFormat = ExprCastNode.stringToSimpleDateFormatSafe(format);
            return StringToLongWStaticFormatComputer.stringToLongWStaticFormatParseSafe(format.toString(), dateFormat, input);
        }

        public static CodegenExpression codegen(CodegenExpression input, ExprForge formatForge, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            CodegenMethodNode method = codegenMethodScope.makeChild(Long.class, StringToLongWDynamicFormatComputerEval.class, codegenClassScope).addParam(Object.class, "input");
            method.getBlock().declareVar(Object.class, "format", formatForge.evaluateCodegen(Object.class, method, exprSymbol, codegenClassScope)).declareVar(SimpleDateFormat.class, "dateFormat", CodegenExpressionBuilder.staticMethod(ExprCastNode.class, "stringToSimpleDateFormatSafe", CodegenExpressionBuilder.ref("format"))).methodReturn(CodegenExpressionBuilder.staticMethod(StringToLongWStaticFormatComputer.class, "stringToLongWStaticFormatParseSafe", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("format"), "toString", new CodegenExpression[0]), CodegenExpressionBuilder.ref("dateFormat"), CodegenExpressionBuilder.ref("input")));
            return CodegenExpressionBuilder.localMethod(method, input);
        }
    }

    public static class StringToLongWDynamicFormatComputerForge
    extends StringToDateLongWDynamicFormatForge {
        public StringToLongWDynamicFormatComputerForge(ExprForge dateFormatForge) {
            super(dateFormatForge);
        }

        @Override
        public CasterParserComputer getEvaluatorComputer() {
            return new StringToLongWDynamicFormatComputerEval(this.dateFormatForge.getExprEvaluator());
        }

        @Override
        public CodegenExpression codegenPremade(Class evaluationType, CodegenExpression input, Class inputType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return StringToLongWDynamicFormatComputerEval.codegen(input, this.dateFormatForge, codegenMethodScope, exprSymbol, codegenClassScope);
        }
    }

    public static class StringToDateWDynamicFormatComputerEval
    extends StringToDateLongWDynamicFormatEval {
        public StringToDateWDynamicFormatComputerEval(ExprEvaluator dateFormatEval) {
            super(dateFormatEval);
        }

        @Override
        public Date compute(Object input, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
            Object format = this.dateFormatEval.evaluate(eventsPerStream, newData, exprEvaluatorContext);
            SimpleDateFormat dateFormat = ExprCastNode.stringToSimpleDateFormatSafe(format);
            return StringToDateWStaticFormatComputer.stringToDateWStaticFormatParseSafe(format.toString(), dateFormat, input);
        }

        public static CodegenExpression codegen(CodegenExpression input, ExprForge formatExpr, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            CodegenMethodNode method = codegenMethodScope.makeChild(Date.class, StringToDateWDynamicFormatComputerEval.class, codegenClassScope).addParam(Object.class, "input");
            method.getBlock().declareVar(Object.class, "format", formatExpr.evaluateCodegen(Object.class, method, exprSymbol, codegenClassScope)).declareVar(SimpleDateFormat.class, "dateFormat", CodegenExpressionBuilder.staticMethod(ExprCastNode.class, "stringToSimpleDateFormatSafe", CodegenExpressionBuilder.ref("format"))).methodReturn(CodegenExpressionBuilder.staticMethod(StringToDateWStaticFormatComputer.class, "stringToDateWStaticFormatParseSafe", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("format"), "toString", new CodegenExpression[0]), CodegenExpressionBuilder.ref("dateFormat"), CodegenExpressionBuilder.ref("input")));
            return CodegenExpressionBuilder.localMethod(method, input);
        }
    }

    public static class StringToDateWDynamicFormatComputerForge
    extends StringToDateLongWDynamicFormatForge {
        public StringToDateWDynamicFormatComputerForge(ExprForge dateFormatForge) {
            super(dateFormatForge);
        }

        @Override
        public CasterParserComputer getEvaluatorComputer() {
            return new StringToDateWDynamicFormatComputerEval(this.dateFormatForge.getExprEvaluator());
        }

        @Override
        public CodegenExpression codegenPremade(Class evaluationType, CodegenExpression input, Class inputType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return StringToDateWDynamicFormatComputerEval.codegen(input, this.dateFormatForge, codegenMethodScope, exprSymbol, codegenClassScope);
        }
    }

    public static class StringToCalendarWStaticISOFormatComputer
    implements CasterParserComputerForge,
    CasterParserComputer {
        public static Calendar stringToCalendarWStaticISOParse(String input) {
            try {
                return TimerScheduleISO8601Parser.parseDate(input);
            }
            catch (ScheduleParameterException ex) {
                throw ExprCastNode.handleParseISOException(input, ex);
            }
        }

        @Override
        public Object compute(Object input, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
            return StringToCalendarWStaticISOFormatComputer.stringToCalendarWStaticISOParse(input.toString());
        }

        @Override
        public boolean isConstantForConstInput() {
            return true;
        }

        @Override
        public CodegenExpression codegenPremade(Class evaluationType, CodegenExpression input, Class inputType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return CodegenExpressionBuilder.staticMethod(StringToCalendarWStaticISOFormatComputer.class, "stringToCalendarWStaticISOParse", input);
        }

        @Override
        public CasterParserComputer getEvaluatorComputer() {
            return this;
        }
    }

    public static class StringToCalendarWStaticFormatComputer
    extends StringToDateLongWStaticFormat {
        private final TimeZone timeZone;

        public StringToCalendarWStaticFormatComputer(String dateFormatString, DateFormat dateFormat, TimeZone timeZone) {
            super(dateFormatString, dateFormat);
            this.timeZone = timeZone;
        }

        @Override
        public Object compute(Object input, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
            return StringToCalendarWStaticFormatComputer.stringToCalendarWStaticFormatParse(this.dateFormatString, (DateFormat)this.formats.get(), input, this.timeZone);
        }

        public static Calendar stringToCalendarWStaticFormatParse(String formatString, DateFormat format, Object input, TimeZone timeZone) {
            try {
                Calendar cal = Calendar.getInstance(timeZone);
                Date date = format.parse(input.toString());
                cal.setTime(date);
                return cal;
            }
            catch (ParseException ex) {
                throw ExprCastNode.handleParseException(formatString, input.toString(), ex);
            }
        }

        @Override
        public CodegenExpression codegenPremade(Class evaluationType, CodegenExpression input, Class inputType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            CodegenMember tz = codegenClassScope.makeAddMember(TimeZone.class, this.timeZone);
            return CodegenExpressionBuilder.staticMethod(StringToCalendarWStaticFormatComputer.class, "stringToCalendarWStaticFormatParse", this.codegenAddFormatString(codegenClassScope), this.codegenAddFormat(codegenClassScope), input, CodegenExpressionBuilder.member(tz.getMemberId()));
        }
    }

    public static class StringToLongWStaticISOFormatComputer
    implements CasterParserComputerForge,
    CasterParserComputer {
        public static long stringToLongWStaticISOParse(String input) {
            try {
                return TimerScheduleISO8601Parser.parseDate(input).getTimeInMillis();
            }
            catch (ScheduleParameterException ex) {
                throw ExprCastNode.handleParseISOException(input, ex);
            }
        }

        @Override
        public Object compute(Object input, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
            return StringToLongWStaticISOFormatComputer.stringToLongWStaticISOParse(input.toString());
        }

        @Override
        public boolean isConstantForConstInput() {
            return true;
        }

        @Override
        public CodegenExpression codegenPremade(Class evaluationType, CodegenExpression input, Class inputType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return CodegenExpressionBuilder.staticMethod(StringToLongWStaticISOFormatComputer.class, "stringToLongWStaticISOParse", input);
        }

        @Override
        public CasterParserComputer getEvaluatorComputer() {
            return this;
        }
    }

    public static class StringToLongWStaticFormatComputer
    extends StringToDateLongWStaticFormat {
        public StringToLongWStaticFormatComputer(String dateFormatString, DateFormat dateFormat) {
            super(dateFormatString, dateFormat);
        }

        @Override
        public Object compute(Object input, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
            return StringToLongWStaticFormatComputer.stringToLongWStaticFormatParseSafe(this.dateFormatString, (DateFormat)this.formats.get(), input);
        }

        public static long stringToLongWStaticFormatParseSafe(String dateFormatString, DateFormat format, Object input) {
            try {
                return format.parse(input.toString()).getTime();
            }
            catch (ParseException e) {
                throw ExprCastNode.handleParseException(dateFormatString, input.toString(), e);
            }
        }

        @Override
        public CodegenExpression codegenPremade(Class evaluationType, CodegenExpression input, Class inputType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return CodegenExpressionBuilder.staticMethod(StringToLongWStaticFormatComputer.class, "stringToLongWStaticFormatParseSafe", this.codegenAddFormatString(codegenClassScope), this.codegenAddFormat(codegenClassScope), input);
        }
    }

    public static class StringToDateWStaticISOFormatComputer
    implements CasterParserComputerForge,
    CasterParserComputer {
        public static Date stringToDateWStaticISOParse(String input) {
            try {
                return TimerScheduleISO8601Parser.parseDate(input).getTime();
            }
            catch (ScheduleParameterException e) {
                throw ExprCastNode.handleParseISOException(input, e);
            }
        }

        @Override
        public Object compute(Object input, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
            return StringToDateWStaticISOFormatComputer.stringToDateWStaticISOParse(input.toString());
        }

        @Override
        public boolean isConstantForConstInput() {
            return true;
        }

        @Override
        public CodegenExpression codegenPremade(Class evaluationType, CodegenExpression input, Class inputType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return CodegenExpressionBuilder.staticMethod(StringToDateWStaticISOFormatComputer.class, "stringToDateWStaticISOParse", input);
        }

        @Override
        public CasterParserComputer getEvaluatorComputer() {
            return this;
        }
    }

    public static class StringToZonedDateTimeWDynamicFormatComputerEval
    extends StringToJava8WDynamicFormatComputerEval {
        public StringToZonedDateTimeWDynamicFormatComputerEval(ExprEvaluator dateFormatEval) {
            super(dateFormatEval);
        }

        @Override
        public ZonedDateTime compute(Object input, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
            Object format = this.dateFormatEval.evaluate(eventsPerStream, newData, exprEvaluatorContext);
            DateTimeFormatter formatter = ExprCastNode.stringToDateTimeFormatterSafe(format);
            return StringToZonedDateTimeWStaticFormatComputer.stringZonedDateTimeWStaticFormatParse(input.toString(), formatter);
        }

        public static CodegenExpression codegen(CodegenExpression input, ExprForge dateFormatForge, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            CodegenMethodNode methodNode = codegenMethodScope.makeChild(ZonedDateTime.class, StringToZonedDateTimeWDynamicFormatComputerEval.class, codegenClassScope).addParam(String.class, "input");
            methodNode.getBlock().declareVar(DateTimeFormatter.class, "formatter", CodegenExpressionBuilder.staticMethod(ExprCastNode.class, "stringToDateTimeFormatterSafe", dateFormatForge.evaluateCodegen(Object.class, methodNode, exprSymbol, codegenClassScope))).methodReturn(CodegenExpressionBuilder.staticMethod(StringToZonedDateTimeWStaticFormatComputer.class, "stringZonedDateTimeWStaticFormatParse", CodegenExpressionBuilder.ref("input"), CodegenExpressionBuilder.ref("formatter")));
            return CodegenExpressionBuilder.localMethod(methodNode, input);
        }
    }

    public static class StringToZonedDateTimeWDynamicFormatComputerForge
    extends StringToJava8WDynamicFormatComputerForge {
        public StringToZonedDateTimeWDynamicFormatComputerForge(ExprForge dateFormatForge) {
            super(dateFormatForge);
        }

        @Override
        public CasterParserComputer getEvaluatorComputer() {
            return new StringToZonedDateTimeWDynamicFormatComputerEval(this.dateFormatForge.getExprEvaluator());
        }

        @Override
        public CodegenExpression codegenPremade(Class evaluationType, CodegenExpression input, Class inputType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return StringToZonedDateTimeWDynamicFormatComputerEval.codegen(input, this.dateFormatForge, codegenMethodScope, exprSymbol, codegenClassScope);
        }
    }

    public static class StringToLocalTimeWDynamicFormatComputerEval
    extends StringToJava8WDynamicFormatComputerEval {
        public StringToLocalTimeWDynamicFormatComputerEval(ExprEvaluator dateFormatEval) {
            super(dateFormatEval);
        }

        @Override
        public LocalTime compute(Object input, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
            Object format = this.dateFormatEval.evaluate(eventsPerStream, newData, exprEvaluatorContext);
            DateTimeFormatter formatter = ExprCastNode.stringToDateTimeFormatterSafe(format);
            return StringToLocalTimeWStaticFormatComputer.stringToLocalTimeWStaticFormatParse(input.toString(), formatter);
        }

        public static CodegenExpression codegen(CodegenExpression input, ExprForge dateFormatForge, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            CodegenMethodNode methodNode = codegenMethodScope.makeChild(LocalTime.class, StringToLocalTimeWDynamicFormatComputerForge.class, codegenClassScope).addParam(String.class, "input");
            methodNode.getBlock().declareVar(DateTimeFormatter.class, "formatter", CodegenExpressionBuilder.staticMethod(ExprCastNode.class, "stringToDateTimeFormatterSafe", dateFormatForge.evaluateCodegen(Object.class, methodNode, exprSymbol, codegenClassScope))).methodReturn(CodegenExpressionBuilder.staticMethod(StringToLocalTimeWStaticFormatComputer.class, "stringToLocalTimeWStaticFormatParse", CodegenExpressionBuilder.ref("input"), CodegenExpressionBuilder.ref("formatter")));
            return CodegenExpressionBuilder.localMethod(methodNode, input);
        }
    }

    public static class StringToLocalTimeWDynamicFormatComputerForge
    extends StringToJava8WDynamicFormatComputerForge {
        public StringToLocalTimeWDynamicFormatComputerForge(ExprForge dateFormatForge) {
            super(dateFormatForge);
        }

        @Override
        public CasterParserComputer getEvaluatorComputer() {
            return new StringToLocalTimeWDynamicFormatComputerEval(this.dateFormatForge.getExprEvaluator());
        }

        @Override
        public CodegenExpression codegenPremade(Class evaluationType, CodegenExpression input, Class inputType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return StringToLocalTimeWDynamicFormatComputerEval.codegen(input, this.dateFormatForge, codegenMethodScope, exprSymbol, codegenClassScope);
        }
    }

    public static class StringToLocalDateWDynamicFormatComputerEval
    extends StringToJava8WDynamicFormatComputerEval {
        public StringToLocalDateWDynamicFormatComputerEval(ExprEvaluator dateFormatEval) {
            super(dateFormatEval);
        }

        @Override
        public LocalDate compute(Object input, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
            Object format = this.dateFormatEval.evaluate(eventsPerStream, newData, exprEvaluatorContext);
            DateTimeFormatter formatter = ExprCastNode.stringToDateTimeFormatterSafe(format);
            return StringToLocalDateWStaticFormatComputer.stringToLocalDateWStaticFormatParse(input.toString(), formatter);
        }

        public static CodegenExpression codegen(CodegenExpression input, ExprForge dateFormatForge, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            CodegenMethodNode method = codegenMethodScope.makeChild(LocalDate.class, StringToLocalDateWDynamicFormatComputerEval.class, codegenClassScope).addParam(String.class, "input");
            method.getBlock().declareVar(DateTimeFormatter.class, "formatter", CodegenExpressionBuilder.staticMethod(ExprCastNode.class, "stringToDateTimeFormatterSafe", dateFormatForge.evaluateCodegen(Object.class, method, exprSymbol, codegenClassScope))).methodReturn(CodegenExpressionBuilder.staticMethod(StringToLocalDateWStaticFormatComputer.class, "stringToLocalDateWStaticFormatParse", CodegenExpressionBuilder.ref("input"), CodegenExpressionBuilder.ref("formatter")));
            return CodegenExpressionBuilder.localMethod(method, input);
        }
    }

    public static class StringToLocalDateWDynamicFormatComputerForge
    extends StringToJava8WDynamicFormatComputerForge {
        public StringToLocalDateWDynamicFormatComputerForge(ExprForge dateFormatForge) {
            super(dateFormatForge);
        }

        @Override
        public CasterParserComputer getEvaluatorComputer() {
            return new StringToLocalDateWDynamicFormatComputerEval(this.dateFormatForge.getExprEvaluator());
        }

        @Override
        public CodegenExpression codegenPremade(Class evaluationType, CodegenExpression input, Class inputType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return StringToLocalDateWDynamicFormatComputerEval.codegen(input, this.dateFormatForge, codegenMethodScope, exprSymbol, codegenClassScope);
        }
    }

    public static class StringToLocalDateTimeWDynamicFormatComputerEval
    extends StringToJava8WDynamicFormatComputerEval {
        public StringToLocalDateTimeWDynamicFormatComputerEval(ExprEvaluator dateFormatEval) {
            super(dateFormatEval);
        }

        @Override
        public Object compute(Object input, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
            Object format = this.dateFormatEval.evaluate(eventsPerStream, newData, exprEvaluatorContext);
            DateTimeFormatter formatter = ExprCastNode.stringToDateTimeFormatterSafe(format);
            return StringToLocalDateTimeWStaticFormatComputer.stringToLocalDateTimeWStaticFormatParse(input.toString(), formatter);
        }

        public static CodegenExpression codegen(CodegenExpression input, ExprForge dateFormatForge, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            CodegenMethodNode method = codegenMethodScope.makeChild(LocalDateTime.class, StringToLocalDateTimeWDynamicFormatComputerEval.class, codegenClassScope).addParam(String.class, "input");
            method.getBlock().declareVar(DateTimeFormatter.class, "formatter", CodegenExpressionBuilder.staticMethod(ExprCastNode.class, "stringToDateTimeFormatterSafe", dateFormatForge.evaluateCodegen(Object.class, method, exprSymbol, codegenClassScope))).methodReturn(CodegenExpressionBuilder.staticMethod(StringToLocalDateTimeWStaticFormatComputer.class, "stringToLocalDateTimeWStaticFormatParse", CodegenExpressionBuilder.ref("input"), CodegenExpressionBuilder.ref("formatter")));
            return CodegenExpressionBuilder.localMethod(method, input);
        }
    }

    public static class StringToLocalDateTimeWDynamicFormatComputerForge
    extends StringToJava8WDynamicFormatComputerForge {
        public StringToLocalDateTimeWDynamicFormatComputerForge(ExprForge dateFormatForge) {
            super(dateFormatForge);
        }

        @Override
        public CasterParserComputer getEvaluatorComputer() {
            return new StringToLocalDateTimeWDynamicFormatComputerEval(this.dateFormatForge.getExprEvaluator());
        }

        @Override
        public CodegenExpression codegenPremade(Class evaluationType, CodegenExpression input, Class inputType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return StringToLocalDateTimeWDynamicFormatComputerEval.codegen(input, this.dateFormatForge, codegenMethodScope, exprSymbol, codegenClassScope);
        }
    }

    public static abstract class StringToJava8WDynamicFormatComputerEval
    implements CasterParserComputer {
        protected final ExprEvaluator dateFormatEval;

        public StringToJava8WDynamicFormatComputerEval(ExprEvaluator dateFormatEval) {
            this.dateFormatEval = dateFormatEval;
        }
    }

    public static abstract class StringToJava8WDynamicFormatComputerForge
    implements CasterParserComputerForge {
        protected final ExprForge dateFormatForge;

        public StringToJava8WDynamicFormatComputerForge(ExprForge dateFormatForge) {
            this.dateFormatForge = dateFormatForge;
        }

        @Override
        public boolean isConstantForConstInput() {
            return false;
        }
    }

    public static class StringToZonedDateTimeWStaticFormatComputer
    extends StringToJava8WStaticFormatComputer {
        public StringToZonedDateTimeWStaticFormatComputer(DateTimeFormatter formatter) {
            super(formatter);
        }

        public static ZonedDateTime stringZonedDateTimeWStaticFormatParse(String input, DateTimeFormatter formatter) {
            try {
                return ZonedDateTime.parse(input, formatter);
            }
            catch (DateTimeParseException e) {
                throw ExprCastNode.handleParseException(formatter.toString(), input, e);
            }
        }

        @Override
        public Object parse(String input) {
            return StringToZonedDateTimeWStaticFormatComputer.stringZonedDateTimeWStaticFormatParse(input, this.formatter);
        }

        @Override
        public CodegenExpression codegenPremade(Class evaluationType, CodegenExpression input, Class inputType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return CodegenExpressionBuilder.staticMethod(StringToZonedDateTimeWStaticFormatComputer.class, "stringZonedDateTimeWStaticFormatParse", input, this.codegenFormatter(codegenClassScope));
        }
    }

    public static class StringToLocalTimeWStaticFormatComputer
    extends StringToJava8WStaticFormatComputer {
        public StringToLocalTimeWStaticFormatComputer(DateTimeFormatter formatter) {
            super(formatter);
        }

        public static LocalTime stringToLocalTimeWStaticFormatParse(String input, DateTimeFormatter formatter) {
            try {
                return LocalTime.parse(input, formatter);
            }
            catch (DateTimeParseException e) {
                throw ExprCastNode.handleParseException(formatter.toString(), input, e);
            }
        }

        @Override
        public Object parse(String input) {
            return StringToLocalTimeWStaticFormatComputer.stringToLocalTimeWStaticFormatParse(input, this.formatter);
        }

        @Override
        public CodegenExpression codegenPremade(Class evaluationType, CodegenExpression input, Class inputType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return CodegenExpressionBuilder.staticMethod(StringToLocalTimeWStaticFormatComputer.class, "stringToLocalTimeWStaticFormatParse", input, this.codegenFormatter(codegenClassScope));
        }
    }

    public static class StringToLocalDateWStaticFormatComputer
    extends StringToJava8WStaticFormatComputer {
        public StringToLocalDateWStaticFormatComputer(DateTimeFormatter formatter) {
            super(formatter);
        }

        public static LocalDate stringToLocalDateWStaticFormatParse(String input, DateTimeFormatter formatter) {
            try {
                return LocalDate.parse(input, formatter);
            }
            catch (DateTimeParseException e) {
                throw ExprCastNode.handleParseException(formatter.toString(), input, e);
            }
        }

        @Override
        public Object parse(String input) {
            return StringToLocalDateWStaticFormatComputer.stringToLocalDateWStaticFormatParse(input, this.formatter);
        }

        @Override
        public CodegenExpression codegenPremade(Class evaluationType, CodegenExpression input, Class inputType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return CodegenExpressionBuilder.staticMethod(StringToLocalDateWStaticFormatComputer.class, "stringToLocalDateWStaticFormatParse", input, this.codegenFormatter(codegenClassScope));
        }
    }

    public static class StringToLocalDateTimeWStaticFormatComputer
    extends StringToJava8WStaticFormatComputer {
        public StringToLocalDateTimeWStaticFormatComputer(DateTimeFormatter formatter) {
            super(formatter);
        }

        public static LocalDateTime stringToLocalDateTimeWStaticFormatParse(String input, DateTimeFormatter formatter) {
            try {
                return LocalDateTime.parse(input, formatter);
            }
            catch (DateTimeParseException e) {
                throw ExprCastNode.handleParseException(formatter.toString(), input, e);
            }
        }

        @Override
        public Object parse(String input) {
            return StringToLocalDateTimeWStaticFormatComputer.stringToLocalDateTimeWStaticFormatParse(input, this.formatter);
        }

        @Override
        public CodegenExpression codegenPremade(Class evaluationType, CodegenExpression input, Class inputType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return CodegenExpressionBuilder.staticMethod(StringToLocalDateTimeWStaticFormatComputer.class, "stringToLocalDateTimeWStaticFormatParse", input, this.codegenFormatter(codegenClassScope));
        }
    }

    public static abstract class StringToJava8WStaticFormatComputer
    implements CasterParserComputerForge,
    CasterParserComputer {
        protected final DateTimeFormatter formatter;

        public StringToJava8WStaticFormatComputer(DateTimeFormatter formatter) {
            this.formatter = formatter;
        }

        @Override
        public boolean isConstantForConstInput() {
            return true;
        }

        public abstract Object parse(String var1);

        @Override
        public Object compute(Object input, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
            return this.parse(input.toString());
        }

        protected CodegenExpression codegenFormatter(CodegenClassScope codegenClassScope) {
            return CodegenExpressionBuilder.member(codegenClassScope.makeAddMember(DateTimeFormatter.class, this.formatter).getMemberId());
        }

        @Override
        public CasterParserComputer getEvaluatorComputer() {
            return this;
        }
    }

    public static class StringToDateWStaticFormatComputer
    extends StringToDateLongWStaticFormat {
        public StringToDateWStaticFormatComputer(String dateFormatString, DateFormat dateFormat) {
            super(dateFormatString, dateFormat);
        }

        @Override
        public Object compute(Object input, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
            return StringToDateWStaticFormatComputer.stringToDateWStaticFormatParseSafe(this.dateFormatString, (DateFormat)this.formats.get(), input);
        }

        public static Date stringToDateWStaticFormatParseSafe(String formatString, DateFormat format, Object input) {
            try {
                return format.parse(input.toString());
            }
            catch (ParseException e) {
                throw ExprCastNode.handleParseException(formatString, input.toString(), e);
            }
        }

        @Override
        public CodegenExpression codegenPremade(Class evaluationType, CodegenExpression input, Class inputType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return CodegenExpressionBuilder.staticMethod(StringToDateWStaticFormatComputer.class, "stringToDateWStaticFormatParseSafe", this.codegenAddFormatString(codegenClassScope), this.codegenAddFormat(codegenClassScope), input);
        }
    }

    public static abstract class StringToDateLongWDynamicFormatEval
    implements CasterParserComputer {
        protected final ExprEvaluator dateFormatEval;

        public StringToDateLongWDynamicFormatEval(ExprEvaluator dateFormatEval) {
            this.dateFormatEval = dateFormatEval;
        }
    }

    public static abstract class StringToDateLongWDynamicFormatForge
    implements CasterParserComputerForge {
        protected final ExprForge dateFormatForge;

        protected StringToDateLongWDynamicFormatForge(ExprForge dateFormatForge) {
            this.dateFormatForge = dateFormatForge;
        }

        @Override
        public boolean isConstantForConstInput() {
            return false;
        }
    }

    public static abstract class StringToDateLongWStaticFormat
    implements CasterParserComputerForge,
    CasterParserComputer {
        protected final String dateFormatString;
        protected final DateFormat dateFormat;
        protected final ThreadLocal<DateFormat> formats = new ThreadLocal<DateFormat>(){

            @Override
            protected synchronized DateFormat initialValue() {
                return (DateFormat)dateFormat.clone();
            }
        };

        protected StringToDateLongWStaticFormat(String dateFormatString, DateFormat dateFormat) {
            this.dateFormatString = dateFormatString;
            this.dateFormat = dateFormat;
        }

        @Override
        public CasterParserComputer getEvaluatorComputer() {
            return this;
        }

        @Override
        public boolean isConstantForConstInput() {
            return true;
        }

        protected CodegenExpression codegenAddFormat(CodegenClassScope codegenClassScope) {
            return CodegenExpressionBuilder.member(codegenClassScope.makeAddMember(DateFormat.class, this.dateFormat).getMemberId());
        }

        protected CodegenExpression codegenAddFormatString(CodegenClassScope codegenClassScope) {
            return CodegenExpressionBuilder.member(codegenClassScope.makeAddMember(String.class, this.dateFormatString).getMemberId());
        }
    }

    public static class NonnumericCasterComputer
    implements CasterParserComputerForge,
    CasterParserComputer {
        private final SimpleTypeCaster caster;

        public NonnumericCasterComputer(SimpleTypeCaster numericTypeCaster) {
            this.caster = numericTypeCaster;
        }

        @Override
        public Object compute(Object input, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
            return this.caster.cast(input);
        }

        @Override
        public boolean isConstantForConstInput() {
            return true;
        }

        @Override
        public CodegenExpression codegenPremade(Class evaluationType, CodegenExpression input, Class inputType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return this.caster.codegen(input, inputType, codegenMethodScope, codegenClassScope);
        }

        @Override
        public CasterParserComputer getEvaluatorComputer() {
            return this;
        }
    }

    public static class StringParserComputer
    implements CasterParserComputer,
    CasterParserComputerForge {
        private final SimpleTypeParser parser;

        public StringParserComputer(SimpleTypeParser parser) {
            this.parser = parser;
        }

        @Override
        public Object compute(Object input, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
            return this.parser.parse(input.toString());
        }

        @Override
        public boolean isConstantForConstInput() {
            return true;
        }

        @Override
        public CodegenExpression codegenPremade(Class evaluationType, CodegenExpression input, Class inputType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return this.parser.codegen(input);
        }

        @Override
        public CasterParserComputer getEvaluatorComputer() {
            return this;
        }
    }

    public static class NumberCasterComputer
    implements CasterParserComputerForge,
    CasterParserComputer {
        private final SimpleTypeCaster numericTypeCaster;

        public NumberCasterComputer(SimpleTypeCaster numericTypeCaster) {
            this.numericTypeCaster = numericTypeCaster;
        }

        @Override
        public Object compute(Object input, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
            if (input instanceof Number) {
                return this.numericTypeCaster.cast(input);
            }
            return null;
        }

        @Override
        public boolean isConstantForConstInput() {
            return true;
        }

        @Override
        public CodegenExpression codegenPremade(Class evaluationType, CodegenExpression input, Class inputType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            if (inputType.isPrimitive() || JavaClassHelper.isSubclassOrImplementsInterface(inputType, Number.class)) {
                return this.numericTypeCaster.codegen(input, inputType, codegenMethodScope, codegenClassScope);
            }
            CodegenMethodNode methodNode = codegenMethodScope.makeChild(evaluationType, NumberCasterComputer.class, codegenClassScope).addParam(inputType, "input");
            methodNode.getBlock().ifInstanceOf("input", Number.class).blockReturn(this.numericTypeCaster.codegen(CodegenExpressionBuilder.ref("input"), inputType, methodNode, codegenClassScope)).methodReturn(CodegenExpressionBuilder.constantNull());
            return CodegenExpressionBuilder.localMethod(methodNode, input);
        }

        @Override
        public CasterParserComputer getEvaluatorComputer() {
            return this;
        }
    }

    public static class StringXFormComputer
    implements CasterParserComputerForge,
    CasterParserComputer {
        @Override
        public Object compute(Object input, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
            return input.toString();
        }

        @Override
        public boolean isConstantForConstInput() {
            return true;
        }

        @Override
        public CodegenExpression codegenPremade(Class evaluationType, CodegenExpression input, Class inputType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return CodegenExpressionBuilder.exprDotMethod(input, "toString", new CodegenExpression[0]);
        }

        @Override
        public CasterParserComputer getEvaluatorComputer() {
            return this;
        }
    }

    public static interface CasterParserComputer {
        public Object compute(Object var1, EventBean[] var2, boolean var3, ExprEvaluatorContext var4);
    }

    public static interface CasterParserComputerForge {
        public boolean isConstantForConstInput();

        public CodegenExpression codegenPremade(Class var1, CodegenExpression var2, Class var3, CodegenMethodScope var4, ExprForgeCodegenSymbol var5, CodegenClassScope var6);

        public CasterParserComputer getEvaluatorComputer();
    }
}

