/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.codegen.base.CodegenBlock;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMethodNode;
import com.espertech.esper.codegen.base.CodegenMethodScope;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.codegen.model.expression.CodegenExpressionRef;
import com.espertech.esper.codegen.model.expression.CodegenExpressionRelational;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.type.RelationalOpEnum;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.SimpleNumberBigDecimalCoercer;
import com.espertech.esper.util.SimpleNumberBigIntegerCoercer;
import java.math.BigDecimal;
import java.math.BigInteger;

public enum MinMaxTypeEnum {
    MAX("max"),
    MIN("min");

    private String expressionText;

    private MinMaxTypeEnum(String expressionText) {
        this.expressionText = expressionText;
    }

    public String getExpressionText() {
        return this.expressionText;
    }

    private static CodegenExpression codegenMinMax(boolean min, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope, ExprNode[] nodes, Class returnType) {
        Class r0Type = nodes[0].getForge().getEvaluationType();
        Class r1Type = nodes[1].getForge().getEvaluationType();
        if (r0Type == null || r1Type == null) {
            return CodegenExpressionBuilder.constantNull();
        }
        CodegenMethodNode methodNode = codegenMethodScope.makeChild(returnType, MaxComputerDoubleCoerce.class, codegenClassScope);
        CodegenBlock block = methodNode.getBlock();
        block.declareVar(r0Type, "r0", nodes[0].getForge().evaluateCodegen(r0Type, methodNode, exprSymbol, codegenClassScope));
        if (!r0Type.isPrimitive()) {
            block.ifRefNullReturnNull("r0");
        }
        block.declareVar(r1Type, "r1", nodes[1].getForge().evaluateCodegen(r1Type, methodNode, exprSymbol, codegenClassScope));
        if (!r1Type.isPrimitive()) {
            block.ifRefNullReturnNull("r1");
        }
        block.declareVarNoInit(returnType, "result");
        block.ifCondition(MinMaxTypeEnum.codegenCompareRelop(returnType, min ? RelationalOpEnum.LT : RelationalOpEnum.GT, CodegenExpressionBuilder.ref("r0"), r0Type, CodegenExpressionBuilder.ref("r1"), r1Type)).assignRef("result", JavaClassHelper.coerceNumberToBoxedCodegen(CodegenExpressionBuilder.ref("r0"), r0Type, returnType)).ifElse().assignRef("result", JavaClassHelper.coerceNumberToBoxedCodegen(CodegenExpressionBuilder.ref("r1"), r1Type, returnType)).blockEnd();
        for (int i = 2; i < nodes.length; ++i) {
            Class nodeType = nodes[i].getForge().getEvaluationType();
            String refname = "r" + i;
            block.declareVar(nodeType, refname, nodes[i].getForge().evaluateCodegen(nodeType, methodNode, exprSymbol, codegenClassScope));
            if (!nodeType.isPrimitive()) {
                block.ifRefNullReturnNull(refname);
            }
            block.ifCondition(CodegenExpressionBuilder.not(MinMaxTypeEnum.codegenCompareRelop(returnType, min ? RelationalOpEnum.LT : RelationalOpEnum.GT, CodegenExpressionBuilder.ref("result"), returnType, CodegenExpressionBuilder.ref(refname), r1Type))).assignRef("result", JavaClassHelper.coerceNumberToBoxedCodegen(CodegenExpressionBuilder.ref(refname), nodeType, returnType)).blockEnd();
        }
        block.methodReturn(CodegenExpressionBuilder.ref("result"));
        return CodegenExpressionBuilder.localMethod(methodNode, new CodegenExpression[0]);
    }

    private static CodegenExpression codegenCompareRelop(Class resultType, RelationalOpEnum op, CodegenExpressionRef lhs, Class lhsType, CodegenExpression rhs, Class rhsType) {
        return CodegenExpressionBuilder.op(lhs, op.getExpressionText(), rhs);
    }

    private static CodegenExpression codegenCompareCompareTo(CodegenExpression lhs, CodegenExpression rhs, boolean max) {
        return CodegenExpressionBuilder.relational(CodegenExpressionBuilder.exprDotMethod(lhs, "compareTo", rhs), max ? CodegenExpressionRelational.CodegenRelational.GT : CodegenExpressionRelational.CodegenRelational.LT, CodegenExpressionBuilder.constant(0));
    }

    public static class ComputerBigDecCoerce
    implements Computer {
        private final ExprEvaluator[] childNodes;
        private final SimpleNumberBigDecimalCoercer[] convertors;
        private final boolean isMax;

        public ComputerBigDecCoerce(ExprEvaluator[] childNodes, SimpleNumberBigDecimalCoercer[] convertors, boolean isMax) {
            this.childNodes = childNodes;
            this.convertors = convertors;
            this.isMax = isMax;
        }

        @Override
        public Number execute(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
            Number valueChildOne = (Number)this.childNodes[0].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            Number valueChildTwo = (Number)this.childNodes[1].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (valueChildOne == null || valueChildTwo == null) {
                return null;
            }
            BigDecimal bigDecOne = this.convertors[0].coerceBoxedBigDec(valueChildOne);
            BigDecimal bigDecTwo = this.convertors[1].coerceBoxedBigDec(valueChildTwo);
            BigDecimal result = this.isMax && bigDecOne.compareTo(bigDecTwo) > 0 || !this.isMax && bigDecOne.compareTo(bigDecTwo) < 0 ? bigDecOne : bigDecTwo;
            for (int i = 2; i < this.childNodes.length; ++i) {
                Number valueChild = (Number)this.childNodes[i].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
                if (valueChild == null) {
                    return null;
                }
                BigDecimal bigDec = this.convertors[i].coerceBoxedBigDec(valueChild);
                if ((!this.isMax || result.compareTo(bigDec) >= 0) && (this.isMax || result.compareTo(bigDec) <= 0)) continue;
                result = bigDec;
            }
            return result;
        }

        public static CodegenExpression codegen(boolean max, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope, ExprNode[] nodes, SimpleNumberBigDecimalCoercer[] convertors) {
            Class r0Type = nodes[0].getForge().getEvaluationType();
            Class r1Type = nodes[1].getForge().getEvaluationType();
            if (r0Type == null || r1Type == null) {
                return CodegenExpressionBuilder.constantNull();
            }
            CodegenMethodNode methodNode = codegenMethodScope.makeChild(BigDecimal.class, ComputerBigDecCoerce.class, codegenClassScope);
            CodegenBlock block = methodNode.getBlock();
            block.declareVar(r0Type, "r0", nodes[0].getForge().evaluateCodegen(r0Type, methodNode, exprSymbol, codegenClassScope));
            if (!r0Type.isPrimitive()) {
                block.ifRefNullReturnNull("r0");
            }
            block.declareVar(r1Type, "r1", nodes[1].getForge().evaluateCodegen(r1Type, methodNode, exprSymbol, codegenClassScope));
            if (!r1Type.isPrimitive()) {
                block.ifRefNullReturnNull("r1");
            }
            block.declareVar(BigDecimal.class, "bi0", convertors[0].coerceBoxedBigDecCodegen(CodegenExpressionBuilder.ref("r0"), r0Type));
            block.declareVar(BigDecimal.class, "bi1", convertors[1].coerceBoxedBigDecCodegen(CodegenExpressionBuilder.ref("r1"), r1Type));
            block.declareVarNoInit(BigDecimal.class, "result");
            block.ifCondition(MinMaxTypeEnum.codegenCompareCompareTo(CodegenExpressionBuilder.ref("bi0"), CodegenExpressionBuilder.ref("bi1"), max)).assignRef("result", (CodegenExpression)CodegenExpressionBuilder.ref("bi0")).ifElse().assignRef("result", (CodegenExpression)CodegenExpressionBuilder.ref("bi1")).blockEnd();
            for (int i = 2; i < nodes.length; ++i) {
                Class nodeType = nodes[i].getForge().getEvaluationType();
                String refnameNumber = "r" + i;
                block.declareVar(nodeType, refnameNumber, nodes[i].getForge().evaluateCodegen(nodeType, methodNode, exprSymbol, codegenClassScope));
                if (!nodeType.isPrimitive()) {
                    block.ifRefNullReturnNull(refnameNumber);
                }
                String refnameBigint = "bi" + i;
                block.declareVar(BigDecimal.class, refnameBigint, convertors[i].coerceBoxedBigDecCodegen(CodegenExpressionBuilder.ref(refnameNumber), nodeType));
                block.ifCondition(CodegenExpressionBuilder.not(MinMaxTypeEnum.codegenCompareCompareTo(CodegenExpressionBuilder.ref("result"), CodegenExpressionBuilder.ref(refnameBigint), max))).assignRef("result", (CodegenExpression)CodegenExpressionBuilder.ref(refnameBigint)).blockEnd();
            }
            block.methodReturn(CodegenExpressionBuilder.ref("result"));
            return CodegenExpressionBuilder.localMethod(methodNode, new CodegenExpression[0]);
        }
    }

    public static class ComputerBigIntCoerce
    implements Computer {
        private final ExprEvaluator[] childNodes;
        private final SimpleNumberBigIntegerCoercer[] convertors;
        private final boolean isMax;

        public ComputerBigIntCoerce(ExprEvaluator[] childNodes, SimpleNumberBigIntegerCoercer[] convertors, boolean isMax) {
            this.childNodes = childNodes;
            this.convertors = convertors;
            this.isMax = isMax;
        }

        @Override
        public Number execute(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
            Number valueChildOne = (Number)this.childNodes[0].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            Number valueChildTwo = (Number)this.childNodes[1].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (valueChildOne == null || valueChildTwo == null) {
                return null;
            }
            BigInteger bigIntOne = this.convertors[0].coerceBoxedBigInt(valueChildOne);
            BigInteger bigIntTwo = this.convertors[1].coerceBoxedBigInt(valueChildTwo);
            BigInteger result = this.isMax && bigIntOne.compareTo(bigIntTwo) > 0 || !this.isMax && bigIntOne.compareTo(bigIntTwo) < 0 ? bigIntOne : bigIntTwo;
            for (int i = 2; i < this.childNodes.length; ++i) {
                Number valueChild = (Number)this.childNodes[i].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
                if (valueChild == null) {
                    return null;
                }
                BigInteger bigInt = this.convertors[i].coerceBoxedBigInt(valueChild);
                if ((!this.isMax || result.compareTo(bigInt) >= 0) && (this.isMax || result.compareTo(bigInt) <= 0)) continue;
                result = bigInt;
            }
            return result;
        }

        public static CodegenExpression codegen(boolean max, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope, ExprNode[] nodes, SimpleNumberBigIntegerCoercer[] convertors) {
            Class r0Type = nodes[0].getForge().getEvaluationType();
            Class r1Type = nodes[1].getForge().getEvaluationType();
            if (r0Type == null || r1Type == null) {
                return CodegenExpressionBuilder.constantNull();
            }
            CodegenMethodNode methodNode = codegenMethodScope.makeChild(BigInteger.class, ComputerBigIntCoerce.class, codegenClassScope);
            CodegenBlock block = methodNode.getBlock();
            block.declareVar(r0Type, "r0", nodes[0].getForge().evaluateCodegen(r0Type, methodNode, exprSymbol, codegenClassScope));
            if (!r0Type.isPrimitive()) {
                block.ifRefNullReturnNull("r0");
            }
            block.declareVar(r1Type, "r1", nodes[1].getForge().evaluateCodegen(r1Type, methodNode, exprSymbol, codegenClassScope));
            if (!r1Type.isPrimitive()) {
                block.ifRefNullReturnNull("r1");
            }
            block.declareVar(BigInteger.class, "bi0", convertors[0].coerceBoxedBigIntCodegen(CodegenExpressionBuilder.ref("r0"), r0Type));
            block.declareVar(BigInteger.class, "bi1", convertors[1].coerceBoxedBigIntCodegen(CodegenExpressionBuilder.ref("r1"), r1Type));
            block.declareVarNoInit(BigInteger.class, "result");
            block.ifCondition(MinMaxTypeEnum.codegenCompareCompareTo(CodegenExpressionBuilder.ref("bi0"), CodegenExpressionBuilder.ref("bi1"), max)).assignRef("result", (CodegenExpression)CodegenExpressionBuilder.ref("bi0")).ifElse().assignRef("result", (CodegenExpression)CodegenExpressionBuilder.ref("bi1")).blockEnd();
            for (int i = 2; i < nodes.length; ++i) {
                Class nodeType = nodes[i].getForge().getEvaluationType();
                String refnameNumber = "r" + i;
                block.declareVar(nodeType, refnameNumber, nodes[i].getForge().evaluateCodegen(nodeType, methodNode, exprSymbol, codegenClassScope));
                if (!nodeType.isPrimitive()) {
                    block.ifRefNullReturnNull(refnameNumber);
                }
                String refnameBigint = "bi" + i;
                block.declareVar(BigInteger.class, refnameBigint, convertors[i].coerceBoxedBigIntCodegen(CodegenExpressionBuilder.ref(refnameNumber), nodeType));
                block.ifCondition(CodegenExpressionBuilder.not(MinMaxTypeEnum.codegenCompareCompareTo(CodegenExpressionBuilder.ref("result"), CodegenExpressionBuilder.ref(refnameBigint), max))).assignRef("result", (CodegenExpression)CodegenExpressionBuilder.ref(refnameBigint)).blockEnd();
            }
            block.methodReturn(CodegenExpressionBuilder.ref("result"));
            return CodegenExpressionBuilder.localMethod(methodNode, new CodegenExpression[0]);
        }
    }

    public static class MaxComputerDoubleCoerce
    implements Computer {
        private final ExprEvaluator[] childNodes;

        public MaxComputerDoubleCoerce(ExprEvaluator[] childNodes) {
            this.childNodes = childNodes;
        }

        @Override
        public Number execute(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
            Number valueChildOne = (Number)this.childNodes[0].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            Number valueChildTwo = (Number)this.childNodes[1].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (valueChildOne == null || valueChildTwo == null) {
                return null;
            }
            Number result = valueChildOne.doubleValue() > valueChildTwo.doubleValue() ? (Number)valueChildOne : (Number)valueChildTwo;
            for (int i = 2; i < this.childNodes.length; ++i) {
                Number valueChild = (Number)this.childNodes[i].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
                if (valueChild == null) {
                    return null;
                }
                if (!(valueChild.doubleValue() > result.doubleValue())) continue;
                result = valueChild;
            }
            return result;
        }

        public static CodegenExpression codegen(CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope, ExprNode[] nodes, Class returnType) {
            return MinMaxTypeEnum.codegenMinMax(false, codegenMethodScope, exprSymbol, codegenClassScope, nodes, returnType);
        }
    }

    public static class MinComputerDoubleCoerce
    implements Computer {
        private final ExprEvaluator[] childNodes;

        public MinComputerDoubleCoerce(ExprEvaluator[] childNodes) {
            this.childNodes = childNodes;
        }

        @Override
        public Number execute(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
            Number valueChildOne = (Number)this.childNodes[0].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            Number valueChildTwo = (Number)this.childNodes[1].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (valueChildOne == null || valueChildTwo == null) {
                return null;
            }
            Number result = valueChildOne.doubleValue() > valueChildTwo.doubleValue() ? (Number)valueChildTwo : (Number)valueChildOne;
            for (int i = 2; i < this.childNodes.length; ++i) {
                Number valueChild = (Number)this.childNodes[i].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
                if (valueChild == null) {
                    return null;
                }
                if (!(valueChild.doubleValue() < result.doubleValue())) continue;
                result = valueChild;
            }
            return result;
        }

        public static CodegenExpression codegen(CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope, ExprNode[] nodes, Class returnType) {
            return MinMaxTypeEnum.codegenMinMax(true, codegenMethodScope, exprSymbol, codegenClassScope, nodes, returnType);
        }
    }

    public static interface Computer {
        public Number execute(EventBean[] var1, boolean var2, ExprEvaluatorContext var3);
    }
}

