/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.codegen.base.CodegenBlock;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMethodNode;
import com.espertech.esper.codegen.base.CodegenMethodScope;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprForge;
import com.espertech.esper.epl.expression.core.ExprForgeComplexityEnum;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeBase;
import com.espertech.esper.epl.expression.core.ExprNodeRenderable;
import com.espertech.esper.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.type.FrequencyParameter;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.SimpleNumberCoercerFactory;
import java.io.StringWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExprNumberSetFrequency
extends ExprNodeBase
implements ExprForge,
ExprEvaluator {
    private static final Logger log = LoggerFactory.getLogger(ExprNumberSetFrequency.class);
    private transient ExprEvaluator evaluator;
    private static final long serialVersionUID = -5389069399403078192L;

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    @Override
    public Class getEvaluationType() {
        return FrequencyParameter.class;
    }

    @Override
    public ExprForge getForge() {
        return this;
    }

    @Override
    public ExprNodeRenderable getForgeRenderable() {
        return this;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        writer.append("*/");
        this.getChildNodes()[0].toEPL(writer, ExprPrecedenceEnum.MINIMUM);
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.MINIMUM;
    }

    @Override
    public boolean isConstantResult() {
        return this.getChildNodes()[0].isConstantResult();
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        return node instanceof ExprNumberSetFrequency;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        ExprForge forge = this.getChildNodes()[0].getForge();
        if (!JavaClassHelper.isNumericNonFP(forge.getEvaluationType())) {
            throw new ExprValidationException("Frequency operator requires an integer-type parameter");
        }
        this.evaluator = forge.getExprEvaluator();
        return null;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Object value = this.evaluator.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        if (value == null) {
            return ExprNumberSetFrequency.handleNumberSetFreqNullValue();
        }
        int intValue = ((Number)value).intValue();
        return new FrequencyParameter(intValue);
    }

    @Override
    public CodegenExpression evaluateCodegen(Class requiredType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        ExprForge forge = this.getChildNodes()[0].getForge();
        Class evaluationType = forge.getEvaluationType();
        CodegenMethodNode methodNode = codegenMethodScope.makeChild(FrequencyParameter.class, ExprNumberSetFrequency.class, codegenClassScope);
        CodegenBlock block = methodNode.getBlock().declareVar(evaluationType, "value", forge.evaluateCodegen(requiredType, methodNode, exprSymbol, codegenClassScope));
        if (!evaluationType.isPrimitive()) {
            block.ifRefNull("value").blockReturn(CodegenExpressionBuilder.staticMethod(ExprNumberSetFrequency.class, "handleNumberSetFreqNullValue", new CodegenExpression[0]));
        }
        block.methodReturn(CodegenExpressionBuilder.newInstance(FrequencyParameter.class, SimpleNumberCoercerFactory.SimpleNumberCoercerInt.codegenInt(CodegenExpressionBuilder.ref("value"), evaluationType)));
        return CodegenExpressionBuilder.localMethod(methodNode, new CodegenExpression[0]);
    }

    @Override
    public ExprForgeComplexityEnum getComplexity() {
        return this.isConstantResult() ? ExprForgeComplexityEnum.NONE : ExprForgeComplexityEnum.INTER;
    }

    public static FrequencyParameter handleNumberSetFreqNullValue() {
        log.warn("Null value returned for frequency parameter");
        return new FrequencyParameter(Integer.MAX_VALUE);
    }
}

