/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.codegen.base.CodegenBlock;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMethodNode;
import com.espertech.esper.codegen.base.CodegenMethodScope;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprForge;
import com.espertech.esper.epl.expression.core.ExprForgeComplexityEnum;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeBase;
import com.espertech.esper.epl.expression.core.ExprNodeRenderable;
import com.espertech.esper.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.type.CronOperatorEnum;
import com.espertech.esper.type.CronParameter;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.SimpleNumberCoercerFactory;
import java.io.StringWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExprNumberSetCronParam
extends ExprNodeBase
implements ExprForge,
ExprEvaluator {
    private static final Logger log = LoggerFactory.getLogger(ExprNumberSetCronParam.class);
    public static final String METHOD_HANDLENUMBERSETCRONPARAMNULLVALUE = "handleNumberSetCronParamNullValue";
    private final CronOperatorEnum cronOperator;
    private transient ExprEvaluator evaluator;
    private static final long serialVersionUID = -1315999998249935318L;

    public ExprNumberSetCronParam(CronOperatorEnum cronOperator) {
        this.cronOperator = cronOperator;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    public CronOperatorEnum getCronOperator() {
        return this.cronOperator;
    }

    @Override
    public ExprForge getForge() {
        return this;
    }

    @Override
    public ExprNodeRenderable getForgeRenderable() {
        return this;
    }

    @Override
    public Class getEvaluationType() {
        return CronParameter.class;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        if (this.getChildNodes().length != 0) {
            this.getChildNodes()[0].toEPL(writer, this.getPrecedence());
            writer.append(" ");
        }
        writer.append(this.cronOperator.getSyntax());
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }

    @Override
    public boolean isConstantResult() {
        if (this.getChildNodes().length == 0) {
            return true;
        }
        return this.getChildNodes()[0].isConstantResult();
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        if (!(node instanceof ExprNumberSetCronParam)) {
            return false;
        }
        ExprNumberSetCronParam other = (ExprNumberSetCronParam)node;
        return other.cronOperator.equals((Object)this.cronOperator);
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        if (this.getChildNodes().length == 0) {
            return null;
        }
        ExprForge forge = this.getChildNodes()[0].getForge();
        if (!JavaClassHelper.isNumericNonFP(forge.getEvaluationType())) {
            throw new ExprValidationException("Frequency operator requires an integer-type parameter");
        }
        this.evaluator = forge.getExprEvaluator();
        return null;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        if (this.getChildNodes().length == 0) {
            return new CronParameter(this.cronOperator, null);
        }
        Object value = this.evaluator.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        if (value == null) {
            ExprNumberSetCronParam.handleNumberSetCronParamNullValue();
            return new CronParameter(this.cronOperator, null);
        }
        int intValue = ((Number)value).intValue();
        return new CronParameter(this.cronOperator, intValue);
    }

    @Override
    public CodegenExpression evaluateCodegen(Class requiredType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenExpression enumValue = CodegenExpressionBuilder.enumValue(CronOperatorEnum.class, this.cronOperator.name());
        CodegenExpression defaultValue = CodegenExpressionBuilder.newInstance(CronParameter.class, enumValue, CodegenExpressionBuilder.constantNull());
        if (this.getChildNodes().length == 0) {
            return defaultValue;
        }
        ExprForge forge = this.getChildNodes()[0].getForge();
        Class evaluationType = forge.getEvaluationType();
        CodegenMethodNode methodNode = codegenMethodScope.makeChild(CronParameter.class, ExprNumberSetCronParam.class, codegenClassScope);
        CodegenBlock block = methodNode.getBlock().declareVar(evaluationType, "value", forge.evaluateCodegen(requiredType, methodNode, exprSymbol, codegenClassScope));
        if (!evaluationType.isPrimitive()) {
            block.ifRefNull("value").staticMethod(ExprNumberSetCronParam.class, METHOD_HANDLENUMBERSETCRONPARAMNULLVALUE, new CodegenExpression[0]).blockReturn(defaultValue);
        }
        block.methodReturn(CodegenExpressionBuilder.newInstance(CronParameter.class, enumValue, SimpleNumberCoercerFactory.SimpleNumberCoercerInt.codegenInt(CodegenExpressionBuilder.ref("value"), evaluationType)));
        return CodegenExpressionBuilder.localMethod(methodNode, new CodegenExpression[0]);
    }

    @Override
    public ExprForgeComplexityEnum getComplexity() {
        return this.isConstantResult() ? ExprForgeComplexityEnum.NONE : ExprForgeComplexityEnum.INTER;
    }

    public static void handleNumberSetCronParamNullValue() {
        log.warn("Null value returned for cron parameter");
    }
}

