/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMember;
import com.espertech.esper.codegen.base.CodegenMethodNode;
import com.espertech.esper.codegen.base.CodegenMethodScope;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprForge;
import com.espertech.esper.epl.expression.core.ExprForgeComplexityEnum;
import com.espertech.esper.epl.expression.core.ExprNodeRenderable;
import com.espertech.esper.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.epl.table.mgmt.TableMetadata;
import com.espertech.esper.epl.table.mgmt.TableMetadataInternalEventToPublic;
import java.io.StringWriter;

public class ExprNodeUtilUnderlyingEvaluatorTable
implements ExprEvaluator,
ExprForge {
    private final int streamNum;
    private final Class resultType;
    private final TableMetadata tableMetadata;

    public ExprNodeUtilUnderlyingEvaluatorTable(int streamNum, Class resultType, TableMetadata tableMetadata) {
        this.streamNum = streamNum;
        this.resultType = resultType;
        this.tableMetadata = tableMetadata;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    @Override
    public Class getEvaluationType() {
        return this.resultType;
    }

    @Override
    public ExprForgeComplexityEnum getComplexity() {
        return ExprForgeComplexityEnum.SINGLE;
    }

    @Override
    public ExprNodeRenderable getForgeRenderable() {
        return new ExprNodeRenderable(){

            @Override
            public void toEPL(StringWriter writer, ExprPrecedenceEnum parentPrecedence) {
                writer.append(this.getClass().getSimpleName());
            }
        };
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        if (eventsPerStream == null) {
            return null;
        }
        EventBean event = eventsPerStream[this.streamNum];
        if (event == null) {
            return null;
        }
        return this.tableMetadata.getEventToPublic().convertToUnd(event, eventsPerStream, isNewData, context);
    }

    @Override
    public CodegenExpression evaluateCodegen(Class requiredType, CodegenMethodScope parent, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenMember eventToPublic = codegenClassScope.makeAddMember(TableMetadataInternalEventToPublic.class, this.tableMetadata.getEventToPublic());
        CodegenMethodNode method = parent.makeChild(Object[].class, ExprNodeUtilUnderlyingEvaluatorTable.class, codegenClassScope);
        method.getBlock().ifRefNullReturnNull(exprSymbol.getAddEPS(method)).declareVar(EventBean.class, "event", CodegenExpressionBuilder.arrayAtIndex(exprSymbol.getAddEPS(method), CodegenExpressionBuilder.constant(this.streamNum))).ifRefNullReturnNull("event").methodReturn(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.member(eventToPublic.getMemberId()), "convertToUnd", CodegenExpressionBuilder.ref("event"), exprSymbol.getAddEPS(method), exprSymbol.getAddIsNewData(method), exprSymbol.getAddExprEvalCtx(method)));
        return CodegenExpressionBuilder.localMethod(method, new CodegenExpression[0]);
    }
}

