/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.core;

import com.espertech.esper.client.EventType;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.client.annotation.Audit;
import com.espertech.esper.client.annotation.AuditEnum;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMethodScope;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.core.streamtype.PropertyResolutionDescriptor;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprFilterSpecLookupable;
import com.espertech.esper.epl.expression.core.ExprForge;
import com.espertech.esper.epl.expression.core.ExprForgeComplexityEnum;
import com.espertech.esper.epl.expression.core.ExprIdentNode;
import com.espertech.esper.epl.expression.core.ExprIdentNodeEvaluator;
import com.espertech.esper.epl.expression.core.ExprIdentNodeEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprIdentNodeEvaluatorImpl;
import com.espertech.esper.epl.expression.core.ExprIdentNodeEvaluatorLogging;
import com.espertech.esper.epl.expression.core.ExprIdentNodeUtil;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeBase;
import com.espertech.esper.epl.expression.core.ExprNodeRenderable;
import com.espertech.esper.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.table.ExprTableIdentNode;
import com.espertech.esper.epl.parse.ASTUtil;
import com.espertech.esper.event.EventPropertyGetterSPI;
import com.espertech.esper.event.EventTypeSPI;
import com.espertech.esper.event.property.PropertyParser;
import com.espertech.esper.util.JavaClassHelper;
import java.io.StringWriter;

public class ExprIdentNodeImpl
extends ExprNodeBase
implements ExprIdentNode,
ExprNode,
ExprForge {
    private static final long serialVersionUID = 5882493771230745244L;
    private final String unresolvedPropertyName;
    private String streamOrPropertyName;
    private String resolvedStreamName;
    private String resolvedPropertyName;
    private transient ExprIdentNodeEvaluator evaluator;

    public ExprIdentNodeImpl(String unresolvedPropertyName) {
        if (unresolvedPropertyName == null) {
            throw new IllegalArgumentException("Property name is null");
        }
        this.unresolvedPropertyName = unresolvedPropertyName;
        this.streamOrPropertyName = null;
    }

    public ExprIdentNodeImpl(String unresolvedPropertyName, String streamOrPropertyName) {
        if (unresolvedPropertyName == null) {
            throw new IllegalArgumentException("Property name is null");
        }
        if (streamOrPropertyName == null) {
            throw new IllegalArgumentException("Stream (or property name) name is null");
        }
        this.unresolvedPropertyName = unresolvedPropertyName;
        this.streamOrPropertyName = streamOrPropertyName;
    }

    public ExprIdentNodeImpl(EventType eventType, String propertyName, int streamNumber) {
        this.unresolvedPropertyName = propertyName;
        this.resolvedPropertyName = propertyName;
        EventPropertyGetterSPI propertyGetter = ((EventTypeSPI)eventType).getGetterSPI(propertyName);
        if (propertyGetter == null) {
            throw new IllegalArgumentException("Ident-node constructor could not locate property " + propertyName);
        }
        Class propertyType = eventType.getPropertyType(propertyName);
        this.evaluator = new ExprIdentNodeEvaluatorImpl(streamNumber, propertyGetter, JavaClassHelper.getBoxedType(propertyType), this, eventType, true);
    }

    @Override
    public ExprForge getForge() {
        if (this.resolvedPropertyName == null) {
            throw ExprIdentNodeImpl.checkValidatedException();
        }
        return this;
    }

    @Override
    public ExprNodeRenderable getForgeRenderable() {
        return this;
    }

    @Override
    public Class getEvaluationType() {
        return this.evaluator.getEvaluationType();
    }

    @Override
    public CodegenExpression evaluateCodegen(Class requiredType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return this.evaluator.codegen(requiredType, codegenMethodScope, exprSymbol, codegenClassScope);
    }

    @Override
    public ExprForgeComplexityEnum getComplexity() {
        return ExprForgeComplexityEnum.SINGLE;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this.evaluator;
    }

    @Override
    public String getUnresolvedPropertyName() {
        return this.unresolvedPropertyName;
    }

    @Override
    public String getStreamOrPropertyName() {
        return this.streamOrPropertyName;
    }

    @Override
    public void setStreamOrPropertyName(String streamOrPropertyName) {
        this.streamOrPropertyName = streamOrPropertyName;
    }

    @Override
    public String getFullUnresolvedName() {
        if (this.streamOrPropertyName == null) {
            return this.unresolvedPropertyName;
        }
        return this.streamOrPropertyName + "." + this.unresolvedPropertyName;
    }

    @Override
    public boolean getFilterLookupEligible() {
        return this.evaluator.getStreamNum() == 0 && !this.evaluator.isContextEvaluated();
    }

    @Override
    public ExprFilterSpecLookupable getFilterLookupable() {
        return new ExprFilterSpecLookupable(this.resolvedPropertyName, this.evaluator.getGetter(), this.evaluator.getEvaluationType(), false);
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        EventPropertyGetterSPI propertyGetter;
        ExprTableIdentNode tableIdentNode;
        if (validationContext.getStreamTypeService().hasTableTypes() && (tableIdentNode = validationContext.getTableService().getTableIdentNode(validationContext.getStreamTypeService(), this.unresolvedPropertyName, this.streamOrPropertyName)) != null) {
            return tableIdentNode;
        }
        String unescapedPropertyName = PropertyParser.unescapeBacktickForProperty(this.unresolvedPropertyName);
        Pair<PropertyResolutionDescriptor, String> propertyInfoPair = ExprIdentNodeUtil.getTypeFromStream(validationContext.getStreamTypeService(), unescapedPropertyName, this.streamOrPropertyName, false);
        this.resolvedStreamName = propertyInfoPair.getSecond();
        int streamNum = propertyInfoPair.getFirst().getStreamNum();
        Class propertyType = JavaClassHelper.getBoxedType(propertyInfoPair.getFirst().getPropertyType());
        this.resolvedPropertyName = propertyInfoPair.getFirst().getPropertyName();
        EventType eventType = propertyInfoPair.getFirst().getStreamEventType();
        try {
            propertyGetter = ((EventTypeSPI)eventType).getGetterSPI(this.resolvedPropertyName);
        }
        catch (PropertyAccessException ex) {
            throw new ExprValidationException("Property '" + this.unresolvedPropertyName + "' is not valid: " + ex.getMessage(), ex);
        }
        if (propertyGetter == null) {
            throw new ExprValidationException("Property getter returned was invalid for property '" + this.unresolvedPropertyName + "'");
        }
        Audit audit = AuditEnum.PROPERTY.getAudit(validationContext.getAnnotations());
        this.evaluator = audit != null ? new ExprIdentNodeEvaluatorLogging(streamNum, propertyGetter, propertyType, this, eventType, validationContext.getStreamTypeService().isOptionalStreams(), this.resolvedPropertyName, validationContext.getStatementName(), validationContext.getStreamTypeService().getEngineURIQualifier()) : new ExprIdentNodeEvaluatorImpl(streamNum, propertyGetter, propertyType, this, eventType, validationContext.getStreamTypeService().isOptionalStreams());
        if (validationContext.getContextDescriptor() != null && !validationContext.isFilterExpression()) {
            EventType fromType = validationContext.getStreamTypeService().getEventTypes()[streamNum];
            String contextPropertyName = validationContext.getContextDescriptor().getContextPropertyRegistry().getPartitionContextPropertyName(fromType, this.resolvedPropertyName);
            if (contextPropertyName != null) {
                EventTypeSPI contextType = (EventTypeSPI)validationContext.getContextDescriptor().getContextPropertyRegistry().getContextEventType();
                Class type = JavaClassHelper.getBoxedType(contextType.getPropertyType(contextPropertyName));
                this.evaluator = new ExprIdentNodeEvaluatorContext(streamNum, type, contextType.getGetterSPI(contextPropertyName));
            }
        }
        return null;
    }

    @Override
    public boolean isConstantResult() {
        return false;
    }

    @Override
    public int getStreamId() {
        if (this.evaluator == null) {
            throw new IllegalStateException("Identifier expression has not been validated");
        }
        return this.evaluator.getStreamNum();
    }

    @Override
    public Integer getStreamReferencedIfAny() {
        return this.getStreamId();
    }

    @Override
    public String getRootPropertyNameIfAny() {
        return this.getResolvedPropertyNameRoot();
    }

    public Class getType() {
        if (this.evaluator == null) {
            throw new IllegalStateException("Identifier expression has not been validated");
        }
        return this.evaluator.getEvaluationType();
    }

    @Override
    public String getResolvedStreamName() {
        if (this.resolvedStreamName == null) {
            throw new IllegalStateException("Identifier node has not been validated");
        }
        return this.resolvedStreamName;
    }

    @Override
    public String getResolvedPropertyName() {
        if (this.resolvedPropertyName == null) {
            throw new IllegalStateException("Identifier node has not been validated");
        }
        return this.resolvedPropertyName;
    }

    @Override
    public String getResolvedPropertyNameRoot() {
        if (this.resolvedPropertyName == null) {
            throw new IllegalStateException("Identifier node has not been validated");
        }
        if (this.resolvedPropertyName.indexOf(91) != -1) {
            return this.resolvedPropertyName.substring(0, this.resolvedPropertyName.indexOf(91));
        }
        if (this.resolvedPropertyName.indexOf(40) != -1) {
            return this.resolvedPropertyName.substring(0, this.resolvedPropertyName.indexOf(40));
        }
        if (this.resolvedPropertyName.indexOf(46) != -1) {
            return this.resolvedPropertyName.substring(0, this.resolvedPropertyName.indexOf(46));
        }
        return this.resolvedPropertyName;
    }

    public String toString() {
        return "unresolvedPropertyName=" + this.unresolvedPropertyName + " streamOrPropertyName=" + this.streamOrPropertyName + " resolvedPropertyName=" + this.resolvedPropertyName;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        ExprIdentNodeImpl.toPrecedenceFreeEPL(writer, this.streamOrPropertyName, this.unresolvedPropertyName);
    }

    public static void toPrecedenceFreeEPL(StringWriter writer, String streamOrPropertyName, String unresolvedPropertyName) {
        if (streamOrPropertyName != null) {
            writer.append(ASTUtil.unescapeDot(streamOrPropertyName)).append('.');
        }
        writer.append(ASTUtil.unescapeDot(PropertyParser.unescapeBacktickForProperty(unresolvedPropertyName)));
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        if (!(node instanceof ExprIdentNode)) {
            return false;
        }
        ExprIdentNode other = (ExprIdentNode)node;
        if (ignoreStreamPrefix && this.resolvedPropertyName != null && other.getResolvedPropertyName() != null && this.resolvedPropertyName.equals(other.getResolvedPropertyName())) {
            return true;
        }
        if (this.streamOrPropertyName != null ? !this.streamOrPropertyName.equals(other.getStreamOrPropertyName()) : other.getStreamOrPropertyName() != null) {
            return false;
        }
        return !(this.unresolvedPropertyName != null ? !this.unresolvedPropertyName.equals(other.getUnresolvedPropertyName()) : other.getUnresolvedPropertyName() != null);
    }

    @Override
    public ExprIdentNodeEvaluator getExprEvaluatorIdent() {
        return this.evaluator;
    }
}

