/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.codegen.base.CodegenBlock;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMethodNode;
import com.espertech.esper.codegen.base.CodegenMethodScope;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.codegen.model.expression.CodegenExpressionRef;
import com.espertech.esper.epl.expression.codegen.CodegenLegoCast;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.epl.expression.core.ExprContextPropertyNode;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprForge;
import com.espertech.esper.epl.expression.core.ExprForgeComplexityEnum;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeBase;
import com.espertech.esper.epl.expression.core.ExprNodeRenderable;
import com.espertech.esper.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.event.EventPropertyGetterSPI;
import com.espertech.esper.event.EventTypeSPI;
import com.espertech.esper.util.JavaClassHelper;
import java.io.StringWriter;
import java.util.Arrays;

public class ExprContextPropertyNodeImpl
extends ExprNodeBase
implements ExprContextPropertyNode,
ExprEvaluator,
ExprForge {
    private static final long serialVersionUID = 2816977190089087618L;
    private final String propertyName;
    private Class returnType;
    private transient EventPropertyGetterSPI getter;

    public ExprContextPropertyNodeImpl(String propertyName) {
        this.propertyName = propertyName;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public Class getEvaluationType() {
        return this.returnType;
    }

    @Override
    public ExprForge getForge() {
        return this;
    }

    @Override
    public ExprNodeRenderable getForgeRenderable() {
        return this;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        if (validationContext.getContextDescriptor() == null) {
            throw new ExprValidationException("Context property '" + this.propertyName + "' cannot be used in the expression as provided");
        }
        EventTypeSPI eventType = (EventTypeSPI)validationContext.getContextDescriptor().getContextPropertyRegistry().getContextEventType();
        if (eventType == null) {
            throw new ExprValidationException("Context property '" + this.propertyName + "' cannot be used in the expression as provided");
        }
        this.getter = eventType.getGetterSPI(this.propertyName);
        if (this.getter == null) {
            throw new ExprValidationException("Context property '" + this.propertyName + "' is not a known property, known properties are " + Arrays.toString(eventType.getPropertyNames()));
        }
        this.returnType = JavaClassHelper.getBoxedType(eventType.getPropertyType(this.propertyName));
        return null;
    }

    @Override
    public boolean isConstantResult() {
        return false;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        EventBean props = context.getContextProperties();
        Object result = props != null ? this.getter.get(props) : null;
        return result;
    }

    @Override
    public CodegenExpression evaluateCodegen(Class requiredType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenMethodNode methodNode = codegenMethodScope.makeChild(this.getEvaluationType(), ExprContextPropertyNodeImpl.class, codegenClassScope);
        CodegenExpressionRef refExprEvalCtx = exprSymbol.getAddExprEvalCtx(methodNode);
        CodegenBlock block = methodNode.getBlock().declareVar(EventBean.class, "props", CodegenExpressionBuilder.exprDotMethod(refExprEvalCtx, "getContextProperties", new CodegenExpression[0])).ifRefNullReturnNull("props");
        block.methodReturn(CodegenLegoCast.castSafeFromObjectType(this.returnType, this.getter.eventBeanGetCodegen(CodegenExpressionBuilder.ref("props"), methodNode, codegenClassScope)));
        return CodegenExpressionBuilder.localMethod(methodNode, new CodegenExpression[0]);
    }

    @Override
    public ExprForgeComplexityEnum getComplexity() {
        return ExprForgeComplexityEnum.SINGLE;
    }

    @Override
    public Class getType() {
        return this.returnType;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        writer.append(this.propertyName);
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }

    @Override
    public EventPropertyGetter getGetter() {
        return this.getter;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        if (this == node) {
            return true;
        }
        if (node == null || this.getClass() != node.getClass()) {
            return false;
        }
        ExprContextPropertyNodeImpl that = (ExprContextPropertyNodeImpl)node;
        return this.propertyName.equals(that.propertyName);
    }
}

