/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMember;
import com.espertech.esper.codegen.base.CodegenMethodScope;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.epl.expression.core.ExprConstantNode;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprForge;
import com.espertech.esper.epl.expression.core.ExprForgeComplexityEnum;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeBase;
import com.espertech.esper.epl.expression.core.ExprNodeRenderable;
import com.espertech.esper.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.util.JavaClassHelper;
import java.io.StringWriter;

public class ExprConstantNodeImpl
extends ExprNodeBase
implements ExprConstantNode,
ExprEvaluator,
ExprForge {
    private Object value;
    private final Class clazz;
    private static final long serialVersionUID = 3154169410675962539L;

    public ExprConstantNodeImpl(Object value) {
        this.value = value;
        this.clazz = value == null ? null : JavaClassHelper.getPrimitiveType(value.getClass());
    }

    @Override
    public boolean isConstantValue() {
        return true;
    }

    public ExprConstantNodeImpl(Object value, Class valueType) {
        this.value = value;
        this.clazz = value == null ? valueType : JavaClassHelper.getPrimitiveType(value.getClass());
    }

    public ExprConstantNodeImpl(Class clazz) {
        this.clazz = JavaClassHelper.getBoxedType(clazz);
        this.value = null;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    @Override
    public Class getEvaluationType() {
        return this.clazz;
    }

    @Override
    public ExprForge getForge() {
        return this;
    }

    @Override
    public ExprNodeRenderable getForgeRenderable() {
        return this;
    }

    @Override
    public CodegenExpression evaluateCodegen(Class requiredType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        if (this.value == null) {
            return CodegenExpressionBuilder.constantNull();
        }
        if (this.value.getClass().isEnum()) {
            return CodegenExpressionBuilder.enumValue(this.value.getClass(), this.value.toString());
        }
        if (!JavaClassHelper.isJavaBuiltinDataType(this.value.getClass())) {
            CodegenMember constant = codegenClassScope.makeAddMember(this.value.getClass(), this.value);
            return CodegenExpressionBuilder.member(constant.getMemberId());
        }
        return CodegenExpressionBuilder.constant(this.value);
    }

    @Override
    public ExprForgeComplexityEnum getComplexity() {
        return ExprForgeComplexityEnum.NONE;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        return null;
    }

    @Override
    public boolean isConstantResult() {
        return true;
    }

    @Override
    public Object getConstantValue(ExprEvaluatorContext context) {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public Class getConstantType() {
        return this.clazz;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        return this.value;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        if (this.value instanceof String) {
            writer.append("\"" + this.value + '\"');
        } else if (this.value == null) {
            writer.append("null");
        } else {
            writer.append(this.value.toString());
        }
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        if (!(node instanceof ExprConstantNodeImpl)) {
            return false;
        }
        ExprConstantNodeImpl other = (ExprConstantNodeImpl)node;
        if (other.value == null && this.value != null) {
            return false;
        }
        if (other.value != null && this.value == null) {
            return false;
        }
        if (other.value == null && this.value == null) {
            return true;
        }
        return other.value.equals(this.value);
    }
}

