/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.baseagg;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMethodScope;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.core.service.StatementType;
import com.espertech.esper.epl.agg.service.common.AggregationMethodFactory;
import com.espertech.esper.epl.agg.service.common.AggregationResultFuture;
import com.espertech.esper.epl.expression.baseagg.ExprAggregateLocalGroupByDesc;
import com.espertech.esper.epl.expression.baseagg.ExprAggregateNode;
import com.espertech.esper.epl.expression.baseagg.ExprAggregateNodeParamDesc;
import com.espertech.esper.epl.expression.baseagg.ExprAggregateNodeUtil;
import com.espertech.esper.epl.expression.baseagg.ExprAggregationPlugInNodeMarker;
import com.espertech.esper.epl.expression.codegen.CodegenLegoEvaluateSelf;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprForge;
import com.espertech.esper.epl.expression.core.ExprForgeComplexityEnum;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeBase;
import com.espertech.esper.epl.expression.core.ExprNodeUtilityCore;
import com.espertech.esper.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.util.ExprNodeUtilityRich;
import com.espertech.esper.util.JavaClassHelper;
import java.io.StringWriter;

public abstract class ExprAggregateNodeBase
extends ExprNodeBase
implements ExprEvaluator,
ExprAggregateNode,
ExprForge {
    private static final long serialVersionUID = 4859196214837888423L;
    protected transient AggregationResultFuture aggregationResultFuture;
    protected int column;
    private transient AggregationMethodFactory aggregationMethodFactory;
    protected ExprAggregateLocalGroupByDesc optionalAggregateLocalGroupByDesc;
    protected ExprNode optionalFilter;
    protected ExprNode[] positionalParams;
    protected boolean isDistinct;

    public abstract String getAggregationFunctionName();

    protected abstract boolean isFilterExpressionAsLastParameter();

    protected abstract boolean equalsNodeAggregateMethodOnly(ExprAggregateNode var1);

    protected abstract AggregationMethodFactory validateAggregationChild(ExprValidationContext var1) throws ExprValidationException;

    protected ExprAggregateNodeBase(boolean distinct) {
        this.isDistinct = distinct;
    }

    @Override
    public ExprNode[] getPositionalParams() {
        return this.positionalParams;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    @Override
    public boolean isConstantResult() {
        return false;
    }

    @Override
    public ExprNode getForgeRenderable() {
        return this;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        this.validatePositionals();
        this.aggregationMethodFactory = this.validateAggregationChild(validationContext);
        if (validationContext.getExprEvaluatorContext().getStatementType() == StatementType.CREATE_TABLE && (this.optionalAggregateLocalGroupByDesc != null || this.optionalFilter != null)) {
            throw new ExprValidationException("The 'group_by' and 'filter' parameter is not allowed in create-table statements");
        }
        return null;
    }

    @Override
    public void validatePositionals() throws ExprValidationException {
        ExprAggregateNodeParamDesc paramDesc = ExprAggregateNodeUtil.getValidatePositionalParams(this.getChildNodes(), !(this instanceof ExprAggregationPlugInNodeMarker));
        this.optionalAggregateLocalGroupByDesc = paramDesc.getOptLocalGroupBy();
        this.optionalFilter = paramDesc.getOptionalFilter();
        if (this.optionalAggregateLocalGroupByDesc != null) {
            ExprNodeUtilityRich.validateNoSpecialsGroupByExpressions(this.optionalAggregateLocalGroupByDesc.getPartitionExpressions());
        }
        if (this.optionalFilter != null) {
            ExprNodeUtilityRich.validateNoSpecialsGroupByExpressions(new ExprNode[]{this.optionalFilter});
        }
        if (this.optionalFilter != null && this.isFilterExpressionAsLastParameter()) {
            if (paramDesc.getPositionalParams().length > 1) {
                throw new ExprValidationException("Only a single filter expression can be provided");
            }
            this.positionalParams = ExprNodeUtilityCore.addExpression(paramDesc.getPositionalParams(), this.optionalFilter);
        } else {
            this.positionalParams = paramDesc.getPositionalParams();
        }
    }

    @Override
    public AggregationMethodFactory getFactory() {
        if (this.aggregationMethodFactory == null) {
            throw new IllegalStateException("Aggregation method has not been set");
        }
        return this.aggregationMethodFactory;
    }

    @Override
    public void setAggregationResultFuture(AggregationResultFuture aggregationResultFuture, int column) {
        this.aggregationResultFuture = aggregationResultFuture;
        this.column = column;
    }

    @Override
    public final Object evaluate(EventBean[] events, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        return this.aggregationResultFuture.getValue(this.column, exprEvaluatorContext.getAgentInstanceId(), events, isNewData, exprEvaluatorContext);
    }

    @Override
    public CodegenExpression evaluateCodegen(Class requiredType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return CodegenLegoEvaluateSelf.evaluateSelfPlainWithCast(requiredType, this, this.getEvaluationType(), codegenMethodScope, exprSymbol, codegenClassScope);
    }

    @Override
    public ExprForgeComplexityEnum getComplexity() {
        return ExprForgeComplexityEnum.SELF;
    }

    @Override
    public Class getEvaluationType() {
        if (this.aggregationMethodFactory == null) {
            throw new IllegalStateException("Aggregation method has not been set");
        }
        return this.aggregationMethodFactory.getResultType();
    }

    @Override
    public ExprForge getForge() {
        return this;
    }

    @Override
    public boolean isDistinct() {
        return this.isDistinct;
    }

    @Override
    public final boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        if (!(node instanceof ExprAggregateNode)) {
            return false;
        }
        ExprAggregateNode other = (ExprAggregateNode)node;
        if (other.isDistinct() != this.isDistinct) {
            return false;
        }
        return this.equalsNodeAggregateMethodOnly(other);
    }

    protected final Class validateNumericChildAllowFilter(boolean hasFilter) throws ExprValidationException {
        Class childType;
        if (this.positionalParams.length == 0 || this.positionalParams.length > 2) {
            throw this.makeExceptionExpectedParamNum(1, 2);
        }
        ExprNode child = this.positionalParams[0];
        if (hasFilter) {
            this.validateFilter(this.positionalParams[1].getForge());
        }
        if (!JavaClassHelper.isNumeric(childType = child.getForge().getEvaluationType())) {
            throw new ExprValidationException("Implicit conversion from datatype '" + (childType == null ? "null" : childType.getSimpleName()) + "' to numeric is not allowed for aggregation function '" + this.getAggregationFunctionName() + "'");
        }
        return childType;
    }

    protected ExprValidationException makeExceptionExpectedParamNum(int lower, int upper) {
        String message = "The '" + this.getAggregationFunctionName() + "' function expects ";
        message = lower == 0 && upper == 0 ? message + "no parameters" : (lower == upper ? message + lower + " parameters" : message + "at least " + lower + " and up to " + upper + " parameters");
        return new ExprValidationException(message);
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        writer.append(this.getAggregationFunctionName());
        writer.append('(');
        if (this.isDistinct) {
            writer.append("distinct ");
        }
        if (this.getChildNodes().length > 0) {
            this.getChildNodes()[0].toEPL(writer, this.getPrecedence());
            String delimiter = ",";
            for (int i = 1; i < this.getChildNodes().length; ++i) {
                writer.write(delimiter);
                delimiter = ",";
                this.getChildNodes()[i].toEPL(writer, this.getPrecedence());
            }
        } else if (this.isExprTextWildcardWhenNoParams()) {
            writer.append('*');
        }
        writer.append(')');
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.MINIMUM;
    }

    public void validateFilter(ExprForge filterEvaluator) throws ExprValidationException {
        if (JavaClassHelper.getBoxedType(filterEvaluator.getEvaluationType()) != Boolean.class) {
            throw new ExprValidationException("Invalid filter expression parameter to the aggregation function '" + this.getAggregationFunctionName() + "' is expected to return a boolean value but returns " + JavaClassHelper.getClassNameFullyQualPretty(filterEvaluator.getEvaluationType()));
        }
    }

    @Override
    public ExprAggregateLocalGroupByDesc getOptionalLocalGroupBy() {
        return this.optionalAggregateLocalGroupByDesc;
    }

    @Override
    public ExprNode getOptionalFilter() {
        return this.optionalFilter;
    }

    protected boolean isExprTextWildcardWhenNoParams() {
        return true;
    }
}

