/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.accessagg;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMethodScope;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.core.service.StatementType;
import com.espertech.esper.epl.agg.access.AggregationAccessorForge;
import com.espertech.esper.epl.agg.access.AggregationAccessorMinMaxByNonTable;
import com.espertech.esper.epl.agg.access.AggregationAccessorMinMaxByTable;
import com.espertech.esper.epl.agg.access.AggregationAccessorSortedNonTable;
import com.espertech.esper.epl.agg.access.AggregationAccessorSortedTable;
import com.espertech.esper.epl.agg.access.AggregationAgentDefault;
import com.espertech.esper.epl.agg.access.AggregationAgentForge;
import com.espertech.esper.epl.agg.service.common.AggregationMethodFactory;
import com.espertech.esper.epl.agg.service.common.AggregationStateKeyWStream;
import com.espertech.esper.epl.agg.service.common.AggregationStateTypeWStream;
import com.espertech.esper.epl.expression.accessagg.ExprAggAggregationAgentFactory;
import com.espertech.esper.epl.expression.accessagg.ExprAggMultiFunctionLinearAccessNode;
import com.espertech.esper.epl.expression.accessagg.ExprAggMultiFunctionSortedMinMaxByNodeFactory;
import com.espertech.esper.epl.expression.accessagg.ExprAggMultiFunctionUtil;
import com.espertech.esper.epl.expression.accessagg.ExprAggregateAccessMultiValueNode;
import com.espertech.esper.epl.expression.accessagg.SortedAggregationStateFactoryFactory;
import com.espertech.esper.epl.expression.baseagg.ExprAggregateNode;
import com.espertech.esper.epl.expression.baseagg.ExprAggregateNodeBase;
import com.espertech.esper.epl.expression.codegen.CodegenLegoEvaluateSelf;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.epl.expression.core.ExprEnumerationEval;
import com.espertech.esper.epl.expression.core.ExprEnumerationForge;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprForge;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeUtilityCore;
import com.espertech.esper.epl.expression.core.ExprOrderedExpr;
import com.espertech.esper.epl.expression.core.ExprStreamUnderlyingNode;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.core.ExprWildcard;
import com.espertech.esper.epl.table.mgmt.TableMetadata;
import com.espertech.esper.epl.table.mgmt.TableMetadataColumnAggregation;
import com.espertech.esper.epl.util.ExprNodeUtilityRich;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.util.JavaClassHelper;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Set;

public class ExprAggMultiFunctionSortedMinMaxByNode
extends ExprAggregateNodeBase
implements ExprEnumerationForge,
ExprEnumerationEval,
ExprAggregateAccessMultiValueNode {
    private static final long serialVersionUID = -8407756454712340265L;
    private final boolean max;
    private final boolean ever;
    private final boolean sortedwin;
    private transient EventType containedType;

    public ExprAggMultiFunctionSortedMinMaxByNode(boolean max, boolean ever, boolean sortedwin) {
        super(false);
        this.max = max;
        this.ever = ever;
        this.sortedwin = sortedwin;
    }

    @Override
    public AggregationMethodFactory validateAggregationParamsWBinding(ExprValidationContext validationContext, TableMetadataColumnAggregation tableAccessColumn) throws ExprValidationException {
        return this.validateAggregationInternal(validationContext, tableAccessColumn);
    }

    @Override
    public AggregationMethodFactory validateAggregationChild(ExprValidationContext validationContext) throws ExprValidationException {
        return this.validateAggregationInternal(validationContext, null);
    }

    @Override
    public ExprEnumerationEval getExprEvaluatorEnumeration() {
        return this;
    }

    private AggregationMethodFactory validateAggregationInternal(ExprValidationContext validationContext, TableMetadataColumnAggregation optionalBinding) throws ExprValidationException {
        ExprAggMultiFunctionSortedMinMaxByNodeFactory factory = optionalBinding != null ? this.handleTableAccess(optionalBinding) : (validationContext.getExprEvaluatorContext().getStatementType() == StatementType.CREATE_TABLE ? this.handleCreateTable(validationContext) : (validationContext.getIntoTableName() != null ? this.handleIntoTable(validationContext) : this.handleNonTable(validationContext)));
        this.containedType = factory.getContainedEventType();
        return factory;
    }

    private ExprAggMultiFunctionSortedMinMaxByNodeFactory handleNonTable(ExprValidationContext validationContext) throws ExprValidationException {
        AggregationAccessorForge accessor;
        Class componentType;
        if (this.positionalParams.length == 0) {
            throw new ExprValidationException("Missing the sort criteria expression");
        }
        Set<Integer> streams = ExprNodeUtilityRich.getIdentStreamNumbers(this.positionalParams[0]);
        if (streams.size() > 1 || streams.isEmpty()) {
            throw new ExprValidationException(this.getErrorPrefix() + " requires that any parameter expressions evaluate properties of the same stream");
        }
        int streamNum = streams.iterator().next();
        if (!this.ever && ExprAggMultiFunctionLinearAccessNode.getIstreamOnly(validationContext.getStreamTypeService(), streamNum) && this.sortedwin) {
            throw new ExprValidationException(this.getErrorPrefix() + " requires that a data window is declared for the stream");
        }
        this.containedType = validationContext.getStreamTypeService().getEventTypes()[streamNum];
        Class accessorResultType = componentType = this.containedType.getUnderlyingType();
        TableMetadata tableMetadata = validationContext.getTableService().getTableMetadataFromEventType(this.containedType);
        if (!this.sortedwin) {
            accessor = tableMetadata != null ? new AggregationAccessorMinMaxByTable(this.max, tableMetadata) : new AggregationAccessorMinMaxByNonTable(this.max);
        } else {
            accessor = tableMetadata != null ? new AggregationAccessorSortedTable(this.max, componentType, tableMetadata) : new AggregationAccessorSortedNonTable(this.max, componentType);
            accessorResultType = JavaClassHelper.getArrayType(accessorResultType);
        }
        Pair<ExprNode[], boolean[]> criteriaExpressions = this.getCriteriaExpressions();
        AggregationStateTypeWStream type = this.ever ? (this.max ? AggregationStateTypeWStream.MAXEVER : AggregationStateTypeWStream.MINEVER) : AggregationStateTypeWStream.SORTED;
        AggregationStateKeyWStream stateKey = new AggregationStateKeyWStream(streamNum, this.containedType, type, criteriaExpressions.getFirst(), this.optionalFilter);
        ExprForge optionalFilterForge = this.optionalFilter == null ? null : this.optionalFilter.getForge();
        boolean join = validationContext.getStreamTypeService().getEventTypes().length > 1;
        SortedAggregationStateFactoryFactory stateFactoryFactory = new SortedAggregationStateFactoryFactory(validationContext.getEngineImportService(), validationContext.getStatementExtensionSvcContext(), criteriaExpressions.getFirst(), criteriaExpressions.getSecond(), this.ever, streamNum, this, optionalFilterForge, join);
        return new ExprAggMultiFunctionSortedMinMaxByNodeFactory(this, accessor, accessorResultType, this.containedType, stateKey, stateFactoryFactory, AggregationAgentDefault.INSTANCE);
    }

    private ExprAggMultiFunctionSortedMinMaxByNodeFactory handleIntoTable(ExprValidationContext validationContext) throws ExprValidationException {
        AggregationAccessorForge accessor;
        Class componentType;
        int streamNum;
        if (this.positionalParams.length == 0 || this.positionalParams.length == 1 && this.positionalParams[0] instanceof ExprWildcard) {
            ExprAggMultiFunctionUtil.validateWildcardStreamNumbers(validationContext.getStreamTypeService(), this.getAggregationFunctionName());
            streamNum = 0;
        } else if (this.positionalParams.length == 1 && this.positionalParams[0] instanceof ExprStreamUnderlyingNode) {
            streamNum = ExprAggMultiFunctionUtil.validateStreamWildcardGetStreamNum(this.positionalParams[0]);
        } else {
            if (this.positionalParams.length > 0) {
                throw new ExprValidationException("When specifying into-table a sort expression cannot be provided");
            }
            streamNum = 0;
        }
        EventType containedType = validationContext.getStreamTypeService().getEventTypes()[streamNum];
        Class accessorResultType = componentType = containedType.getUnderlyingType();
        if (!this.sortedwin) {
            accessor = new AggregationAccessorMinMaxByNonTable(this.max);
        } else {
            accessor = new AggregationAccessorSortedNonTable(this.max, componentType);
            accessorResultType = JavaClassHelper.getArrayType(accessorResultType);
        }
        AggregationAgentForge agent = ExprAggAggregationAgentFactory.make(streamNum, this.optionalFilter, validationContext.getEngineImportService(), validationContext.getStreamTypeService().isOnDemandStreams(), validationContext.getStatementName());
        return new ExprAggMultiFunctionSortedMinMaxByNodeFactory(this, accessor, accessorResultType, containedType, null, null, agent);
    }

    private ExprAggMultiFunctionSortedMinMaxByNodeFactory handleCreateTable(ExprValidationContext validationContext) throws ExprValidationException {
        AggregationAccessorForge accessor;
        if (this.positionalParams.length == 0) {
            throw new ExprValidationException("Missing the sort criteria expression");
        }
        String message = "For tables columns, the aggregation function requires the 'sorted(*)' declaration";
        if (!this.sortedwin && !this.ever) {
            throw new ExprValidationException(message);
        }
        if (validationContext.getStreamTypeService().getStreamNames().length == 0) {
            throw new ExprValidationException("'Sorted' requires that the event type is provided");
        }
        EventType containedType = validationContext.getStreamTypeService().getEventTypes()[0];
        Class componentType = containedType.getUnderlyingType();
        Pair<ExprNode[], boolean[]> criteriaExpressions = this.getCriteriaExpressions();
        Class accessorResultType = componentType;
        if (!this.sortedwin) {
            accessor = new AggregationAccessorMinMaxByNonTable(this.max);
        } else {
            accessor = new AggregationAccessorSortedNonTable(this.max, componentType);
            accessorResultType = JavaClassHelper.getArrayType(accessorResultType);
        }
        boolean join = validationContext.getStreamTypeService().getEventTypes().length > 1;
        SortedAggregationStateFactoryFactory stateFactoryFactory = new SortedAggregationStateFactoryFactory(validationContext.getEngineImportService(), validationContext.getStatementExtensionSvcContext(), criteriaExpressions.getFirst(), criteriaExpressions.getSecond(), this.ever, 0, this, null, join);
        return new ExprAggMultiFunctionSortedMinMaxByNodeFactory(this, accessor, accessorResultType, containedType, null, stateFactoryFactory, null);
    }

    private Pair<ExprNode[], boolean[]> getCriteriaExpressions() {
        ExprNode[] criteriaExpressions = new ExprNode[this.positionalParams.length];
        boolean[] sortDescending = new boolean[this.positionalParams.length];
        for (int i = 0; i < this.positionalParams.length; ++i) {
            ExprNode parameter;
            criteriaExpressions[i] = parameter = this.positionalParams[i];
            if (!(parameter instanceof ExprOrderedExpr)) continue;
            ExprOrderedExpr ordered = (ExprOrderedExpr)parameter;
            sortDescending[i] = ordered.isDescending();
            if (ordered.isDescending()) continue;
            criteriaExpressions[i] = ordered.getChildNodes()[0];
        }
        return new Pair<ExprNode[], boolean[]>(criteriaExpressions, sortDescending);
    }

    private ExprAggMultiFunctionSortedMinMaxByNodeFactory handleTableAccess(TableMetadataColumnAggregation tableAccess) {
        AggregationAccessorForge accessor;
        Class componentType;
        ExprAggMultiFunctionSortedMinMaxByNodeFactory factory = (ExprAggMultiFunctionSortedMinMaxByNodeFactory)tableAccess.getFactory();
        Class accessorResultType = componentType = factory.getContainedEventType().getUnderlyingType();
        if (!this.sortedwin) {
            accessor = new AggregationAccessorMinMaxByNonTable(this.max);
        } else {
            accessor = new AggregationAccessorSortedNonTable(this.max, componentType);
            accessorResultType = JavaClassHelper.getArrayType(accessorResultType);
        }
        return new ExprAggMultiFunctionSortedMinMaxByNodeFactory(this, accessor, accessorResultType, factory.getContainedEventType(), null, null, null);
    }

    @Override
    public String getAggregationFunctionName() {
        if (this.sortedwin) {
            return "sorted";
        }
        if (this.ever) {
            return this.max ? "maxbyever" : "minbyever";
        }
        return this.max ? "maxby" : "minby";
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        writer.append(this.getAggregationFunctionName());
        ExprNodeUtilityCore.toExpressionStringParams(writer, this.positionalParams);
    }

    @Override
    public Collection<EventBean> evaluateGetROCollectionEvents(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        return this.aggregationResultFuture.getCollectionOfEvents(this.column, eventsPerStream, isNewData, context);
    }

    @Override
    public CodegenExpression evaluateGetROCollectionEventsCodegen(CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return CodegenLegoEvaluateSelf.evaluateSelfGetROCollectionEvents(this, codegenMethodScope, exprSymbol, codegenClassScope);
    }

    @Override
    public Collection evaluateGetROCollectionScalar(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        return null;
    }

    @Override
    public CodegenExpression evaluateGetROCollectionScalarCodegen(CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.constantNull();
    }

    @Override
    public EventType getEventTypeCollection(EventAdapterService eventAdapterService, int statementId) {
        if (!this.sortedwin) {
            return null;
        }
        return this.containedType;
    }

    @Override
    public Class getComponentTypeCollection() throws ExprValidationException {
        return null;
    }

    @Override
    public EventType getEventTypeSingle(EventAdapterService eventAdapterService, int statementId) throws ExprValidationException {
        if (this.sortedwin) {
            return null;
        }
        return this.containedType;
    }

    @Override
    public EventBean evaluateGetEventBean(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        return this.aggregationResultFuture.getEventBean(this.column, eventsPerStream, isNewData, context);
    }

    @Override
    public CodegenExpression evaluateGetEventBeanCodegen(CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return CodegenLegoEvaluateSelf.evaluateSelfGetEventBean(this, codegenMethodScope, exprSymbol, codegenClassScope);
    }

    public boolean isMax() {
        return this.max;
    }

    @Override
    protected boolean isFilterExpressionAsLastParameter() {
        return false;
    }

    @Override
    protected boolean equalsNodeAggregateMethodOnly(ExprAggregateNode node) {
        if (!(node instanceof ExprAggMultiFunctionSortedMinMaxByNode)) {
            return false;
        }
        ExprAggMultiFunctionSortedMinMaxByNode other = (ExprAggMultiFunctionSortedMinMaxByNode)node;
        return this.max == other.max && this.containedType == other.containedType && this.sortedwin == other.sortedwin && this.ever == other.ever;
    }

    private String getErrorPrefix() {
        return "The '" + this.getAggregationFunctionName() + "' aggregation function";
    }
}

