/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.datetime.reformatop;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMember;
import com.espertech.esper.codegen.base.CodegenMethodNode;
import com.espertech.esper.codegen.base.CodegenMethodScope;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.epl.datetime.eval.DatetimeLongCoercerLocalDateTime;
import com.espertech.esper.epl.datetime.eval.DatetimeLongCoercerZonedDateTime;
import com.espertech.esper.epl.datetime.eval.DatetimeMethodEnum;
import com.espertech.esper.epl.datetime.reformatop.ReformatForge;
import com.espertech.esper.epl.datetime.reformatop.ReformatOp;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.dot.ExprDotNodeFilterAnalyzerInput;
import com.espertech.esper.epl.expression.time.TimeAbacus;
import com.espertech.esper.epl.join.plan.FilterExprAnalyzerAffector;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;

public class ReformatToCalendarForge
implements ReformatForge,
ReformatOp {
    private final TimeZone timeZone;
    private final TimeAbacus timeAbacus;

    public ReformatToCalendarForge(TimeZone timeZone, TimeAbacus timeAbacus) {
        this.timeZone = timeZone;
        this.timeAbacus = timeAbacus;
    }

    @Override
    public ReformatOp getOp() {
        return this;
    }

    @Override
    public Object evaluate(Long ts, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
        Calendar cal = Calendar.getInstance(this.timeZone);
        this.timeAbacus.calendarSet(ts, cal);
        return cal;
    }

    @Override
    public CodegenExpression codegenLong(CodegenExpression inner, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenMember tz = codegenClassScope.makeAddMember(TimeZone.class, this.timeZone);
        CodegenMethodNode methodNode = codegenMethodScope.makeChild(Calendar.class, ReformatToCalendarForge.class, codegenClassScope).addParam(Long.TYPE, "ts");
        methodNode.getBlock().declareVar(Calendar.class, "cal", CodegenExpressionBuilder.staticMethod(Calendar.class, "getInstance", CodegenExpressionBuilder.member(tz.getMemberId()))).expression(this.timeAbacus.calendarSetCodegen(CodegenExpressionBuilder.ref("ts"), CodegenExpressionBuilder.ref("cal"), methodNode, codegenClassScope)).methodReturn(CodegenExpressionBuilder.ref("cal"));
        return CodegenExpressionBuilder.localMethod(methodNode, inner);
    }

    @Override
    public Object evaluate(Date d, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
        Calendar cal = Calendar.getInstance(this.timeZone);
        cal.setTimeInMillis(d.getTime());
        return cal;
    }

    @Override
    public CodegenExpression codegenDate(CodegenExpression inner, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenMember tz = codegenClassScope.makeAddMember(TimeZone.class, this.timeZone);
        CodegenMethodNode method = codegenMethodScope.makeChild(Calendar.class, ReformatToCalendarForge.class, codegenClassScope).addParam(Date.class, "d").getBlock().declareVar(Calendar.class, "cal", CodegenExpressionBuilder.staticMethod(Calendar.class, "getInstance", CodegenExpressionBuilder.member(tz.getMemberId()))).exprDotMethod(CodegenExpressionBuilder.ref("cal"), "setTimeInMillis", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("d"), "getTime", new CodegenExpression[0])).methodReturn(CodegenExpressionBuilder.ref("cal"));
        return CodegenExpressionBuilder.localMethodBuild(method).pass(inner).call();
    }

    @Override
    public Object evaluate(Calendar cal, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
        return cal;
    }

    @Override
    public CodegenExpression codegenCal(CodegenExpression inner, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return inner;
    }

    @Override
    public Object evaluate(LocalDateTime ldt, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
        Calendar cal = GregorianCalendar.getInstance(this.timeZone);
        cal.setTimeInMillis(DatetimeLongCoercerLocalDateTime.coerceLDTToMilliWTimezone(ldt, this.timeZone));
        return cal;
    }

    @Override
    public CodegenExpression codegenLDT(CodegenExpression inner, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenMember tz = codegenClassScope.makeAddMember(TimeZone.class, this.timeZone);
        CodegenMethodNode method = codegenMethodScope.makeChild(Calendar.class, ReformatToCalendarForge.class, codegenClassScope).addParam(LocalDateTime.class, "ldt").getBlock().declareVar(Calendar.class, "cal", CodegenExpressionBuilder.staticMethod(Calendar.class, "getInstance", CodegenExpressionBuilder.member(tz.getMemberId()))).exprDotMethod(CodegenExpressionBuilder.ref("cal"), "setTimeInMillis", CodegenExpressionBuilder.staticMethod(DatetimeLongCoercerLocalDateTime.class, "coerceLDTToMilliWTimezone", CodegenExpressionBuilder.ref("ldt"), CodegenExpressionBuilder.member(tz.getMemberId()))).methodReturn(CodegenExpressionBuilder.ref("cal"));
        return CodegenExpressionBuilder.localMethodBuild(method).pass(inner).call();
    }

    @Override
    public Object evaluate(ZonedDateTime zdt, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
        Calendar cal = GregorianCalendar.getInstance(this.timeZone);
        cal.setTimeInMillis(DatetimeLongCoercerZonedDateTime.coerceZDTToMillis(zdt));
        return cal;
    }

    @Override
    public CodegenExpression codegenZDT(CodegenExpression inner, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenMember tz = codegenClassScope.makeAddMember(TimeZone.class, this.timeZone);
        CodegenMethodNode method = codegenMethodScope.makeChild(Calendar.class, ReformatToCalendarForge.class, codegenClassScope).addParam(ZonedDateTime.class, "zdt").getBlock().declareVar(Calendar.class, "cal", CodegenExpressionBuilder.staticMethod(Calendar.class, "getInstance", CodegenExpressionBuilder.member(tz.getMemberId()))).exprDotMethod(CodegenExpressionBuilder.ref("cal"), "setTimeInMillis", CodegenExpressionBuilder.staticMethod(DatetimeLongCoercerZonedDateTime.class, "coerceZDTToMillis", CodegenExpressionBuilder.ref("zdt"))).methodReturn(CodegenExpressionBuilder.ref("cal"));
        return CodegenExpressionBuilder.localMethodBuild(method).pass(inner).call();
    }

    @Override
    public Class getReturnType() {
        return Calendar.class;
    }

    @Override
    public FilterExprAnalyzerAffector getFilterDesc(EventType[] typesPerStream, DatetimeMethodEnum currentMethod, List<ExprNode> currentParameters, ExprDotNodeFilterAnalyzerInput inputDesc) {
        return null;
    }
}

