/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.datetime.reformatop;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.codegen.base.CodegenBlock;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMember;
import com.espertech.esper.codegen.base.CodegenMethodNode;
import com.espertech.esper.codegen.base.CodegenMethodScope;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.codegen.model.expression.CodegenExpressionRef;
import com.espertech.esper.codegen.model.expression.CodegenExpressionRelational;
import com.espertech.esper.epl.datetime.eval.DatetimeLongCoercer;
import com.espertech.esper.epl.datetime.eval.DatetimeLongCoercerLocalDateTime;
import com.espertech.esper.epl.datetime.eval.DatetimeLongCoercerZonedDateTime;
import com.espertech.esper.epl.datetime.reformatop.ReformatBetweenNonConstantParamsForge;
import com.espertech.esper.epl.datetime.reformatop.ReformatOp;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprForge;
import com.espertech.esper.epl.expression.core.ExprNode;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class ReformatBetweenNonConstantParamsForgeOp
implements ReformatOp {
    private final ReformatBetweenNonConstantParamsForge forge;
    private final ExprEvaluator startEval;
    private final ExprEvaluator endEval;
    private final ExprEvaluator evalIncludeLow;
    private final ExprEvaluator evalIncludeHigh;

    public ReformatBetweenNonConstantParamsForgeOp(ReformatBetweenNonConstantParamsForge forge, ExprEvaluator startEval, ExprEvaluator endEval, ExprEvaluator evalIncludeLow, ExprEvaluator evalIncludeHigh) {
        this.forge = forge;
        this.startEval = startEval;
        this.endEval = endEval;
        this.evalIncludeLow = evalIncludeLow;
        this.evalIncludeHigh = evalIncludeHigh;
    }

    @Override
    public Object evaluate(Long ts, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
        if (ts == null) {
            return null;
        }
        return this.evaluateInternal(ts, eventsPerStream, newData, exprEvaluatorContext);
    }

    public static CodegenExpression codegenLong(ReformatBetweenNonConstantParamsForge forge, CodegenExpression inner, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return ReformatBetweenNonConstantParamsForgeOp.codegenLongInternal(forge, inner, codegenMethodScope, exprSymbol, codegenClassScope);
    }

    @Override
    public Object evaluate(Date d, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
        if (d == null) {
            return null;
        }
        return this.evaluateInternal(d.getTime(), eventsPerStream, newData, exprEvaluatorContext);
    }

    public static CodegenExpression codegenDate(ReformatBetweenNonConstantParamsForge forge, CodegenExpression inner, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenMethodNode methodNode = codegenMethodScope.makeChild(Boolean.class, ReformatBetweenNonConstantParamsForgeOp.class, codegenClassScope).addParam(Date.class, "d");
        methodNode.getBlock().ifRefNullReturnNull("d").methodReturn(ReformatBetweenNonConstantParamsForgeOp.codegenLongInternal(forge, CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("d"), "getTime", new CodegenExpression[0]), methodNode, exprSymbol, codegenClassScope));
        return CodegenExpressionBuilder.localMethod(methodNode, inner);
    }

    @Override
    public Object evaluate(Calendar cal, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
        if (cal == null) {
            return null;
        }
        return this.evaluateInternal(cal.getTimeInMillis(), eventsPerStream, newData, exprEvaluatorContext);
    }

    public static CodegenExpression codegenCal(ReformatBetweenNonConstantParamsForge forge, CodegenExpression inner, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenMethodNode methodNode = codegenMethodScope.makeChild(Boolean.class, ReformatBetweenNonConstantParamsForgeOp.class, codegenClassScope).addParam(Calendar.class, "cal");
        methodNode.getBlock().ifRefNullReturnNull("cal").methodReturn(ReformatBetweenNonConstantParamsForgeOp.codegenLongInternal(forge, CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("cal"), "getTimeInMillis", new CodegenExpression[0]), methodNode, exprSymbol, codegenClassScope));
        return CodegenExpressionBuilder.localMethod(methodNode, inner);
    }

    @Override
    public Object evaluate(LocalDateTime ldt, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
        return this.evaluateInternal(DatetimeLongCoercerLocalDateTime.coerceLDTToMilliWTimezone(ldt, this.forge.timeZone), eventsPerStream, newData, exprEvaluatorContext);
    }

    public static CodegenExpression codegenLDT(ReformatBetweenNonConstantParamsForge forge, CodegenExpression inner, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenMember tz = codegenClassScope.makeAddMember(TimeZone.class, forge.timeZone);
        return ReformatBetweenNonConstantParamsForgeOp.codegenLongInternal(forge, CodegenExpressionBuilder.staticMethod(DatetimeLongCoercerLocalDateTime.class, "coerceLDTToMilliWTimezone", inner, CodegenExpressionBuilder.member(tz.getMemberId())), codegenMethodScope, exprSymbol, codegenClassScope);
    }

    @Override
    public Object evaluate(ZonedDateTime zdt, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
        return this.evaluateInternal(DatetimeLongCoercerZonedDateTime.coerceZDTToMillis(zdt), eventsPerStream, newData, exprEvaluatorContext);
    }

    public static CodegenExpression codegenZDT(ReformatBetweenNonConstantParamsForge forge, CodegenExpression inner, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return ReformatBetweenNonConstantParamsForgeOp.codegenLongInternal(forge, CodegenExpressionBuilder.staticMethod(DatetimeLongCoercerZonedDateTime.class, "coerceZDTToMillis", inner), codegenMethodScope, exprSymbol, codegenClassScope);
    }

    public Object evaluateInternal(long ts, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
        boolean includeHighEndpoint;
        boolean includeLowEndpoint;
        Object firstObj = this.startEval.evaluate(eventsPerStream, newData, exprEvaluatorContext);
        if (firstObj == null) {
            return null;
        }
        Object secondObj = this.endEval.evaluate(eventsPerStream, newData, exprEvaluatorContext);
        if (secondObj == null) {
            return null;
        }
        long first = this.forge.startCoercer.coerce(firstObj);
        long second = this.forge.secondCoercer.coerce(secondObj);
        if (this.forge.includeBoth) {
            if (first <= second) {
                return first <= ts && ts <= second;
            }
            return second <= ts && ts <= first;
        }
        if (this.forge.includeLow != null) {
            includeLowEndpoint = this.forge.includeLow;
        } else {
            Object value = this.evalIncludeLow.evaluate(eventsPerStream, newData, exprEvaluatorContext);
            if (value == null) {
                return null;
            }
            includeLowEndpoint = (Boolean)value;
        }
        if (this.forge.includeHigh != null) {
            includeHighEndpoint = this.forge.includeHigh;
        } else {
            Object value = this.evalIncludeHigh.evaluate(eventsPerStream, newData, exprEvaluatorContext);
            if (value == null) {
                return null;
            }
            includeHighEndpoint = (Boolean)value;
        }
        return ReformatBetweenNonConstantParamsForgeOp.compareTimestamps(first, ts, second, includeLowEndpoint, includeHighEndpoint);
    }

    public static boolean compareTimestamps(long first, long ts, long second, boolean includeLowEndpoint, boolean includeHighEndpoint) {
        if (includeLowEndpoint ? ts < first : ts <= first) {
            return false;
        }
        return !(includeHighEndpoint ? ts > second : ts >= second);
    }

    private static CodegenExpression codegenLongInternal(ReformatBetweenNonConstantParamsForge forge, CodegenExpression inner, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenMethodNode methodNode = codegenMethodScope.makeChild(Boolean.class, ReformatBetweenNonConstantParamsForgeOp.class, codegenClassScope).addParam(Long.TYPE, "ts");
        CodegenBlock block = methodNode.getBlock();
        ReformatBetweenNonConstantParamsForgeOp.codegenLongCoercion(block, "first", forge.start, forge.startCoercer, methodNode, exprSymbol, codegenClassScope);
        ReformatBetweenNonConstantParamsForgeOp.codegenLongCoercion(block, "second", forge.end, forge.secondCoercer, methodNode, exprSymbol, codegenClassScope);
        CodegenExpressionRef first = CodegenExpressionBuilder.ref("first");
        CodegenExpressionRef second = CodegenExpressionBuilder.ref("second");
        CodegenExpressionRef ts = CodegenExpressionBuilder.ref("ts");
        if (forge.includeBoth) {
            block.ifCondition(CodegenExpressionBuilder.relational(first, CodegenExpressionRelational.CodegenRelational.LE, second)).blockReturn(CodegenExpressionBuilder.and(CodegenExpressionBuilder.relational(first, CodegenExpressionRelational.CodegenRelational.LE, ts), CodegenExpressionBuilder.relational(ts, CodegenExpressionRelational.CodegenRelational.LE, second), new CodegenExpression[0])).methodReturn(CodegenExpressionBuilder.and(CodegenExpressionBuilder.relational(second, CodegenExpressionRelational.CodegenRelational.LE, ts), CodegenExpressionBuilder.relational(ts, CodegenExpressionRelational.CodegenRelational.LE, first), new CodegenExpression[0]));
        } else if (forge.includeLow != null && forge.includeHigh != null) {
            block.ifCondition(CodegenExpressionBuilder.relational(ts, forge.includeLow != false ? CodegenExpressionRelational.CodegenRelational.LT : CodegenExpressionRelational.CodegenRelational.LE, first)).blockReturn(CodegenExpressionBuilder.constantFalse()).ifCondition(CodegenExpressionBuilder.relational(ts, forge.includeHigh != false ? CodegenExpressionRelational.CodegenRelational.GT : CodegenExpressionRelational.CodegenRelational.GE, second)).blockReturn(CodegenExpressionBuilder.constantFalse()).methodReturn(CodegenExpressionBuilder.constantTrue());
        } else {
            ReformatBetweenNonConstantParamsForgeOp.codegenBooleanEval(block, "includeLowEndpoint", forge.includeLow, forge.forgeIncludeLow, methodNode, exprSymbol, codegenClassScope);
            ReformatBetweenNonConstantParamsForgeOp.codegenBooleanEval(block, "includeLowHighpoint", forge.includeHigh, forge.forgeIncludeHigh, methodNode, exprSymbol, codegenClassScope);
            block.methodReturn(CodegenExpressionBuilder.staticMethod(ReformatBetweenNonConstantParamsForgeOp.class, "compareTimestamps", first, ts, second, CodegenExpressionBuilder.ref("includeLowEndpoint"), CodegenExpressionBuilder.ref("includeLowHighpoint")));
        }
        return CodegenExpressionBuilder.localMethod(methodNode, inner);
    }

    private static void codegenBooleanEval(CodegenBlock block, String variable, Boolean preset, ExprForge forge, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        if (preset != null) {
            block.declareVar(Boolean.TYPE, variable, CodegenExpressionBuilder.constant(preset));
            return;
        }
        if (forge.getEvaluationType() == Boolean.TYPE) {
            block.declareVar(Boolean.TYPE, variable, forge.evaluateCodegen(Boolean.TYPE, codegenMethodScope, exprSymbol, codegenClassScope));
            return;
        }
        String refname = variable + "Obj";
        block.declareVar(Boolean.class, refname, forge.evaluateCodegen(Boolean.class, codegenMethodScope, exprSymbol, codegenClassScope)).ifRefNullReturnNull(refname).declareVar(Boolean.TYPE, variable, (CodegenExpression)CodegenExpressionBuilder.ref(refname));
    }

    private static void codegenLongCoercion(CodegenBlock block, String variable, ExprNode assignment, DatetimeLongCoercer coercer, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        Class evaluationType = assignment.getForge().getEvaluationType();
        if (evaluationType == Long.TYPE) {
            block.declareVar(Long.TYPE, variable, assignment.getForge().evaluateCodegen(Long.TYPE, codegenMethodScope, exprSymbol, codegenClassScope));
            return;
        }
        String refname = variable + "Obj";
        block.declareVar(evaluationType, refname, assignment.getForge().evaluateCodegen(evaluationType, codegenMethodScope, exprSymbol, codegenClassScope));
        if (!evaluationType.isPrimitive()) {
            block.ifRefNullReturnNull(refname);
        }
        block.declareVar(Long.TYPE, variable, coercer.codegen(CodegenExpressionBuilder.ref(refname), evaluationType, codegenClassScope));
    }
}

