/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.datetime.interval;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.codegen.base.CodegenBlock;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMethodNode;
import com.espertech.esper.codegen.base.CodegenMethodScope;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.codegen.model.expression.CodegenExpressionRelational;
import com.espertech.esper.epl.datetime.eval.DatetimeMethodEnum;
import com.espertech.esper.epl.datetime.interval.ExprOptionalConstantForge;
import com.espertech.esper.epl.datetime.interval.IntervalComputerConstantBase;
import com.espertech.esper.epl.datetime.interval.IntervalComputerEval;
import com.espertech.esper.epl.datetime.interval.IntervalComputerForge;
import com.espertech.esper.epl.datetime.interval.IntervalDeltaExprEvaluator;
import com.espertech.esper.epl.datetime.interval.IntervalDeltaExprForge;
import com.espertech.esper.epl.datetime.interval.IntervalForgeCodegenNames;
import com.espertech.esper.epl.datetime.interval.IntervalStartEndParameterPairForge;
import com.espertech.esper.epl.datetime.interval.deltaexpr.IntervalDeltaExprMSecConstForge;
import com.espertech.esper.epl.datetime.interval.deltaexpr.IntervalDeltaExprTimePeriodConstForge;
import com.espertech.esper.epl.datetime.interval.deltaexpr.IntervalDeltaExprTimePeriodNonConstForge;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.epl.expression.core.ExprConstantNode;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprForge;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeUtilityCore;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.time.ExprTimePeriod;
import com.espertech.esper.epl.expression.time.ExprTimePeriodEvalDeltaConst;
import com.espertech.esper.epl.expression.time.ExprTimePeriodEvalDeltaNonConst;
import com.espertech.esper.epl.expression.time.TimeAbacus;
import com.espertech.esper.util.SimpleNumberCoercerFactory;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntervalComputerForgeFactory {
    public static IntervalComputerForge make(DatetimeMethodEnum method, List<ExprNode> expressions, TimeAbacus timeAbacus) throws ExprValidationException {
        ExprOptionalConstantForge[] parameters = IntervalComputerForgeFactory.getParameters(expressions, timeAbacus);
        if (method == DatetimeMethodEnum.BEFORE) {
            if (parameters.length == 0) {
                return new IntervalComputerBeforeNoParamForge();
            }
            IntervalStartEndParameterPairForge pair = IntervalStartEndParameterPairForge.fromParamsWithLongMaxEnd(parameters);
            if (pair.isConstant()) {
                return new IntervalComputerConstantBefore(pair);
            }
            return new IntervalComputerBeforeWithDeltaExprForge(pair);
        }
        if (method == DatetimeMethodEnum.AFTER) {
            if (parameters.length == 0) {
                return new IntervalComputerAfterNoParam();
            }
            IntervalStartEndParameterPairForge pair = IntervalStartEndParameterPairForge.fromParamsWithLongMaxEnd(parameters);
            if (pair.isConstant()) {
                return new IntervalComputerConstantAfter(pair);
            }
            return new IntervalComputerAfterWithDeltaExprForge(pair);
        }
        if (method == DatetimeMethodEnum.COINCIDES) {
            if (parameters.length == 0) {
                return new IntervalComputerCoincidesNoParam();
            }
            IntervalStartEndParameterPairForge pair = IntervalStartEndParameterPairForge.fromParamsWithSameEnd(parameters);
            if (pair.isConstant()) {
                return new IntervalComputerConstantCoincides(pair);
            }
            return new IntervalComputerCoincidesWithDeltaExprForge(pair);
        }
        if (method == DatetimeMethodEnum.DURING || method == DatetimeMethodEnum.INCLUDES) {
            if (parameters.length == 0) {
                if (method == DatetimeMethodEnum.DURING) {
                    return new IntervalComputerDuringNoParam();
                }
                return new IntervalComputerIncludesNoParam();
            }
            IntervalStartEndParameterPairForge pair = IntervalStartEndParameterPairForge.fromParamsWithSameEnd(parameters);
            if (parameters.length == 1) {
                return new IntervalComputerDuringAndIncludesThresholdForge(method == DatetimeMethodEnum.DURING, pair.getStart().getForge());
            }
            if (parameters.length == 2) {
                return new IntervalComputerDuringAndIncludesMinMax(method == DatetimeMethodEnum.DURING, pair.getStart().getForge(), pair.getEnd().getForge());
            }
            return new IntervalComputerDuringMinMaxStartEndForge(method == DatetimeMethodEnum.DURING, IntervalComputerForgeFactory.getEvaluators(expressions, timeAbacus));
        }
        if (method == DatetimeMethodEnum.FINISHES) {
            if (parameters.length == 0) {
                return new IntervalComputerFinishesNoParam();
            }
            IntervalComputerForgeFactory.validateConstantThreshold("finishes", parameters[0]);
            return new IntervalComputerFinishesThresholdForge(parameters[0].getForge());
        }
        if (method == DatetimeMethodEnum.FINISHEDBY) {
            if (parameters.length == 0) {
                return new IntervalComputerFinishedByNoParam();
            }
            IntervalComputerForgeFactory.validateConstantThreshold("finishedby", parameters[0]);
            return new IntervalComputerFinishedByThresholdForge(parameters[0].getForge());
        }
        if (method == DatetimeMethodEnum.MEETS) {
            if (parameters.length == 0) {
                return new IntervalComputerMeetsNoParam();
            }
            IntervalComputerForgeFactory.validateConstantThreshold("meets", parameters[0]);
            return new IntervalComputerMeetsThresholdForge(parameters[0].getForge());
        }
        if (method == DatetimeMethodEnum.METBY) {
            if (parameters.length == 0) {
                return new IntervalComputerMetByNoParam();
            }
            IntervalComputerForgeFactory.validateConstantThreshold("metBy", parameters[0]);
            return new IntervalComputerMetByThresholdForge(parameters[0].getForge());
        }
        if (method == DatetimeMethodEnum.OVERLAPS || method == DatetimeMethodEnum.OVERLAPPEDBY) {
            if (parameters.length == 0) {
                if (method == DatetimeMethodEnum.OVERLAPS) {
                    return new IntervalComputerOverlapsNoParam();
                }
                return new IntervalComputerOverlappedByNoParam();
            }
            if (parameters.length == 1) {
                return new IntervalComputerOverlapsAndByThreshold(method == DatetimeMethodEnum.OVERLAPS, parameters[0].getForge());
            }
            return new IntervalComputerOverlapsAndByMinMaxForge(method == DatetimeMethodEnum.OVERLAPS, parameters[0].getForge(), parameters[1].getForge());
        }
        if (method == DatetimeMethodEnum.STARTS) {
            if (parameters.length == 0) {
                return new IntervalComputerStartsNoParam();
            }
            IntervalComputerForgeFactory.validateConstantThreshold("starts", parameters[0]);
            return new IntervalComputerStartsThresholdForge(parameters[0].getForge());
        }
        if (method == DatetimeMethodEnum.STARTEDBY) {
            if (parameters.length == 0) {
                return new IntervalComputerStartedByNoParam();
            }
            IntervalComputerForgeFactory.validateConstantThreshold("startedBy", parameters[0]);
            return new IntervalComputerStartedByThresholdForge(parameters[0].getForge());
        }
        throw new IllegalArgumentException("Unknown datetime method '" + (Object)((Object)method) + "'");
    }

    private static void validateConstantThreshold(String method, ExprOptionalConstantForge param) throws ExprValidationException {
        if (param.getOptionalConstant() != null && param.getOptionalConstant() < 0L) {
            throw new ExprValidationException("The " + method + " date-time method does not allow negative threshold value");
        }
    }

    private static ExprOptionalConstantForge[] getParameters(List<ExprNode> expressions, TimeAbacus timeAbacus) {
        ExprOptionalConstantForge[] parameters = new ExprOptionalConstantForge[expressions.size() - 1];
        for (int i = 1; i < expressions.size(); ++i) {
            parameters[i - 1] = IntervalComputerForgeFactory.getExprOrConstant(expressions.get(i), timeAbacus);
        }
        return parameters;
    }

    private static IntervalDeltaExprForge[] getEvaluators(List<ExprNode> expressions, TimeAbacus timeAbacus) {
        IntervalDeltaExprForge[] parameters = new IntervalDeltaExprForge[expressions.size() - 1];
        for (int i = 1; i < expressions.size(); ++i) {
            parameters[i - 1] = IntervalComputerForgeFactory.getExprOrConstant(expressions.get(i), timeAbacus).getForge();
        }
        return parameters;
    }

    private static ExprOptionalConstantForge getExprOrConstant(ExprNode exprNode, TimeAbacus timeAbacus) {
        if (exprNode instanceof ExprTimePeriod) {
            ExprTimePeriod timePeriod = (ExprTimePeriod)exprNode;
            if (!timePeriod.isHasMonth() && !timePeriod.isHasYear()) {
                if (exprNode.isConstantResult()) {
                    double sec = timePeriod.evaluateAsSeconds(null, true, null);
                    long l = timeAbacus.deltaForSecondsDouble(sec);
                    return new ExprOptionalConstantForge(new IntervalDeltaExprMSecConstForge(l), l);
                }
                return new ExprOptionalConstantForge(new IntervalDeltaExprTimePeriodNonConstForge(timePeriod, timeAbacus), null);
            }
            if (exprNode.isConstantResult()) {
                ExprTimePeriodEvalDeltaConst timerPeriodConst = timePeriod.constEvaluator(null);
                return new ExprOptionalConstantForge(new IntervalDeltaExprTimePeriodConstForge(timerPeriodConst), null);
            }
            final ExprTimePeriodEvalDeltaNonConst timerPeriodNonConst = timePeriod.nonconstEvaluator();
            IntervalDeltaExprForge forge = new IntervalDeltaExprForge(){

                @Override
                public IntervalDeltaExprEvaluator makeEvaluator() {
                    return new IntervalDeltaExprEvaluator(){

                        @Override
                        public long evaluate(long reference, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
                            return timerPeriodNonConst.deltaAdd(reference, eventsPerStream, isNewData, context);
                        }
                    };
                }

                @Override
                public CodegenExpression codegen(CodegenExpression reference, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
                    return timerPeriodNonConst.deltaAddCodegen(reference, codegenMethodScope, exprSymbol, codegenClassScope);
                }
            };
            return new ExprOptionalConstantForge(forge, null);
        }
        if (ExprNodeUtilityCore.isConstantValueExpr(exprNode)) {
            ExprConstantNode constantNode = (ExprConstantNode)exprNode;
            long l = ((Number)constantNode.getConstantValue(null)).longValue();
            return new ExprOptionalConstantForge(new IntervalDeltaExprMSecConstForge(l), l);
        }
        final ExprForge forge = exprNode.getForge();
        IntervalDeltaExprForge eval = new IntervalDeltaExprForge(){

            @Override
            public IntervalDeltaExprEvaluator makeEvaluator() {
                final ExprEvaluator evaluator = forge.getExprEvaluator();
                return new IntervalDeltaExprEvaluator(){

                    @Override
                    public long evaluate(long reference, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
                        return ((Number)evaluator.evaluate(eventsPerStream, isNewData, context)).longValue();
                    }
                };
            }

            @Override
            public CodegenExpression codegen(CodegenExpression reference, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
                return SimpleNumberCoercerFactory.SimpleNumberCoercerLong.codegenLong(forge.evaluateCodegen(forge.getEvaluationType(), codegenMethodScope, exprSymbol, codegenClassScope), forge.getEvaluationType());
            }
        };
        return new ExprOptionalConstantForge(eval, null);
    }

    public static class IntervalComputerStartedByThresholdEval
    implements IntervalComputerEval {
        private static final Logger log = LoggerFactory.getLogger(IntervalComputerStartedByThresholdForge.class);
        public static final String METHOD_LOGWARNINGINTERVALSTARTEDBYTHRESHOLD = "logWarningIntervalStartedByThreshold";
        private final IntervalDeltaExprEvaluator thresholdExpr;

        public IntervalComputerStartedByThresholdEval(IntervalDeltaExprEvaluator thresholdExpr) {
            this.thresholdExpr = thresholdExpr;
        }

        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            long threshold = this.thresholdExpr.evaluate(Math.min(leftStart, rightStart), eventsPerStream, newData, context);
            if (threshold < 0L) {
                IntervalComputerStartedByThresholdEval.logWarningIntervalStartedByThreshold();
                return null;
            }
            long delta = Math.abs(leftStart - rightStart);
            return delta <= threshold && leftEnd > rightEnd;
        }

        public static void logWarningIntervalStartedByThreshold() {
            log.warn("The 'started-by' date-time method does not allow negative threshold");
        }

        public static CodegenExpression codegen(IntervalComputerStartedByThresholdForge forge, CodegenExpression leftStart, CodegenExpression leftEnd, CodegenExpression rightStart, CodegenExpression rightEnd, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            CodegenMethodNode methodNode = codegenMethodScope.makeChild(Boolean.class, IntervalComputerStartedByThresholdEval.class, codegenClassScope).addParam(IntervalForgeCodegenNames.PARAMS);
            methodNode.getBlock().declareVar(Long.TYPE, "threshold", forge.thresholdExpr.codegen(CodegenExpressionBuilder.staticMethod(Math.class, "min", IntervalForgeCodegenNames.REF_LEFTSTART, IntervalForgeCodegenNames.REF_RIGHTSTART), methodNode, exprSymbol, codegenClassScope)).ifCondition(CodegenExpressionBuilder.relational(CodegenExpressionBuilder.ref("threshold"), CodegenExpressionRelational.CodegenRelational.LT, CodegenExpressionBuilder.constant(0))).staticMethod(IntervalComputerStartedByThresholdEval.class, METHOD_LOGWARNINGINTERVALSTARTEDBYTHRESHOLD, new CodegenExpression[0]).blockReturn(CodegenExpressionBuilder.constantNull()).declareVar(Long.TYPE, "delta", CodegenExpressionBuilder.staticMethod(Math.class, "abs", CodegenExpressionBuilder.op(IntervalForgeCodegenNames.REF_LEFTSTART, "-", IntervalForgeCodegenNames.REF_RIGHTSTART))).methodReturn(CodegenExpressionBuilder.and(CodegenExpressionBuilder.relational(CodegenExpressionBuilder.ref("delta"), CodegenExpressionRelational.CodegenRelational.LE, CodegenExpressionBuilder.ref("threshold")), CodegenExpressionBuilder.relational(IntervalForgeCodegenNames.REF_LEFTEND, CodegenExpressionRelational.CodegenRelational.GT, IntervalForgeCodegenNames.REF_RIGHTEND), new CodegenExpression[0]));
            return CodegenExpressionBuilder.localMethod(methodNode, leftStart, leftEnd, rightStart, rightEnd);
        }
    }

    public static class IntervalComputerStartedByThresholdForge
    implements IntervalComputerForge {
        private final IntervalDeltaExprForge thresholdExpr;

        public IntervalComputerStartedByThresholdForge(IntervalDeltaExprForge thresholdExpr) {
            this.thresholdExpr = thresholdExpr;
        }

        @Override
        public IntervalComputerEval makeComputerEval() {
            return new IntervalComputerStartedByThresholdEval(this.thresholdExpr.makeEvaluator());
        }

        @Override
        public CodegenExpression codegen(CodegenExpression leftStart, CodegenExpression leftEnd, CodegenExpression rightStart, CodegenExpression rightEnd, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return IntervalComputerStartedByThresholdEval.codegen(this, leftStart, leftEnd, rightStart, rightEnd, codegenMethodScope, exprSymbol, codegenClassScope);
        }
    }

    public static class IntervalComputerStartedByNoParam
    implements IntervalComputerForge,
    IntervalComputerEval {
        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            return leftStart == rightStart && leftEnd > rightEnd;
        }

        @Override
        public IntervalComputerEval makeComputerEval() {
            return this;
        }

        @Override
        public CodegenExpression codegen(CodegenExpression leftStart, CodegenExpression leftEnd, CodegenExpression rightStart, CodegenExpression rightEnd, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return CodegenExpressionBuilder.and(CodegenExpressionBuilder.equalsIdentity(leftStart, rightStart), CodegenExpressionBuilder.relational(leftEnd, CodegenExpressionRelational.CodegenRelational.GT, rightEnd), new CodegenExpression[0]);
        }
    }

    public static class IntervalComputerStartsThresholdEval
    implements IntervalComputerEval {
        private static final Logger log = LoggerFactory.getLogger(IntervalComputerStartsThresholdEval.class);
        public static final String METHOD_LOGWARNINGINTERVALSTARTSTHRESHOLD = "logWarningIntervalStartsThreshold";
        private final IntervalDeltaExprEvaluator thresholdExpr;

        public IntervalComputerStartsThresholdEval(IntervalDeltaExprEvaluator thresholdExpr) {
            this.thresholdExpr = thresholdExpr;
        }

        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            long threshold = this.thresholdExpr.evaluate(Math.min(leftStart, rightStart), eventsPerStream, newData, context);
            if (threshold < 0L) {
                IntervalComputerStartsThresholdEval.logWarningIntervalStartsThreshold();
                return null;
            }
            long delta = Math.abs(leftStart - rightStart);
            return delta <= threshold && leftEnd < rightEnd;
        }

        public static void logWarningIntervalStartsThreshold() {
            log.warn("The 'starts' date-time method does not allow negative threshold");
        }

        public static CodegenExpression codegen(IntervalComputerStartsThresholdForge forge, CodegenExpression leftStart, CodegenExpression leftEnd, CodegenExpression rightStart, CodegenExpression rightEnd, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            CodegenMethodNode methodNode = codegenMethodScope.makeChild(Boolean.class, IntervalComputerStartsThresholdEval.class, codegenClassScope).addParam(IntervalForgeCodegenNames.PARAMS);
            methodNode.getBlock().declareVar(Long.TYPE, "threshold", forge.thresholdExpr.codegen(CodegenExpressionBuilder.staticMethod(Math.class, "min", IntervalForgeCodegenNames.REF_LEFTSTART, IntervalForgeCodegenNames.REF_RIGHTSTART), methodNode, exprSymbol, codegenClassScope)).ifCondition(CodegenExpressionBuilder.relational(CodegenExpressionBuilder.ref("threshold"), CodegenExpressionRelational.CodegenRelational.LT, CodegenExpressionBuilder.constant(0))).staticMethod(IntervalComputerStartsThresholdEval.class, METHOD_LOGWARNINGINTERVALSTARTSTHRESHOLD, new CodegenExpression[0]).blockReturn(CodegenExpressionBuilder.constantNull()).declareVar(Long.TYPE, "delta", CodegenExpressionBuilder.staticMethod(Math.class, "abs", CodegenExpressionBuilder.op(IntervalForgeCodegenNames.REF_LEFTSTART, "-", IntervalForgeCodegenNames.REF_RIGHTSTART))).methodReturn(CodegenExpressionBuilder.and(CodegenExpressionBuilder.relational(CodegenExpressionBuilder.ref("delta"), CodegenExpressionRelational.CodegenRelational.LE, CodegenExpressionBuilder.ref("threshold")), CodegenExpressionBuilder.relational(IntervalForgeCodegenNames.REF_LEFTEND, CodegenExpressionRelational.CodegenRelational.LT, IntervalForgeCodegenNames.REF_RIGHTEND), new CodegenExpression[0]));
            return CodegenExpressionBuilder.localMethod(methodNode, leftStart, leftEnd, rightStart, rightEnd);
        }
    }

    public static class IntervalComputerStartsThresholdForge
    implements IntervalComputerForge {
        private final IntervalDeltaExprForge thresholdExpr;

        public IntervalComputerStartsThresholdForge(IntervalDeltaExprForge thresholdExpr) {
            this.thresholdExpr = thresholdExpr;
        }

        @Override
        public IntervalComputerEval makeComputerEval() {
            return new IntervalComputerStartsThresholdEval(this.thresholdExpr.makeEvaluator());
        }

        @Override
        public CodegenExpression codegen(CodegenExpression leftStart, CodegenExpression leftEnd, CodegenExpression rightStart, CodegenExpression rightEnd, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return IntervalComputerStartsThresholdEval.codegen(this, leftStart, leftEnd, rightStart, rightEnd, codegenMethodScope, exprSymbol, codegenClassScope);
        }
    }

    public static class IntervalComputerStartsNoParam
    implements IntervalComputerForge,
    IntervalComputerEval {
        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            return leftStart == rightStart && leftEnd < rightEnd;
        }

        @Override
        public IntervalComputerEval makeComputerEval() {
            return this;
        }

        @Override
        public CodegenExpression codegen(CodegenExpression leftStart, CodegenExpression leftEnd, CodegenExpression rightStart, CodegenExpression rightEnd, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return CodegenExpressionBuilder.and(CodegenExpressionBuilder.equalsIdentity(leftStart, rightStart), CodegenExpressionBuilder.relational(leftEnd, CodegenExpressionRelational.CodegenRelational.LT, rightEnd), new CodegenExpression[0]);
        }
    }

    public static class IntervalComputerOverlappedByNoParam
    implements IntervalComputerForge,
    IntervalComputerEval {
        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            return rightStart < leftStart && leftStart < rightEnd && rightEnd < leftEnd;
        }

        @Override
        public IntervalComputerEval makeComputerEval() {
            return this;
        }

        @Override
        public CodegenExpression codegen(CodegenExpression leftStart, CodegenExpression leftEnd, CodegenExpression rightStart, CodegenExpression rightEnd, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return CodegenExpressionBuilder.and(CodegenExpressionBuilder.relational(rightStart, CodegenExpressionRelational.CodegenRelational.LT, leftStart), CodegenExpressionBuilder.relational(leftStart, CodegenExpressionRelational.CodegenRelational.LT, rightEnd), CodegenExpressionBuilder.relational(rightEnd, CodegenExpressionRelational.CodegenRelational.LT, leftEnd));
        }
    }

    public static class IntervalComputerOverlapsAndByMinMaxEval
    implements IntervalComputerEval {
        private final boolean overlaps;
        private final IntervalDeltaExprEvaluator minEval;
        private final IntervalDeltaExprEvaluator maxEval;

        public IntervalComputerOverlapsAndByMinMaxEval(boolean overlaps, IntervalDeltaExprEvaluator minEval, IntervalDeltaExprEvaluator maxEval) {
            this.overlaps = overlaps;
            this.minEval = minEval;
            this.maxEval = maxEval;
        }

        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            if (this.overlaps) {
                long minThreshold = this.minEval.evaluate(leftStart, eventsPerStream, newData, context);
                long maxThreshold = this.maxEval.evaluate(leftEnd, eventsPerStream, newData, context);
                return IntervalComputerOverlapsAndByThresholdEval.computeIntervalOverlaps(leftStart, leftEnd, rightStart, rightEnd, minThreshold, maxThreshold);
            }
            long minThreshold = this.minEval.evaluate(rightStart, eventsPerStream, newData, context);
            long maxThreshold = this.maxEval.evaluate(rightEnd, eventsPerStream, newData, context);
            return IntervalComputerOverlapsAndByThresholdEval.computeIntervalOverlaps(rightStart, rightEnd, leftStart, leftEnd, minThreshold, maxThreshold);
        }

        public static CodegenExpression codegen(IntervalComputerOverlapsAndByMinMaxForge forge, CodegenExpression leftStart, CodegenExpression leftEnd, CodegenExpression rightStart, CodegenExpression rightEnd, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            CodegenMethodNode methodNode = codegenMethodScope.makeChild(Boolean.TYPE, IntervalComputerOverlapsAndByMinMaxEval.class, codegenClassScope).addParam(IntervalForgeCodegenNames.PARAMS);
            CodegenBlock block = methodNode.getBlock().declareVar(Long.TYPE, "minThreshold", forge.minEval.codegen(forge.overlaps ? IntervalForgeCodegenNames.REF_LEFTSTART : IntervalForgeCodegenNames.REF_RIGHTSTART, methodNode, exprSymbol, codegenClassScope)).declareVar(Long.TYPE, "maxThreshold", forge.maxEval.codegen(forge.overlaps ? IntervalForgeCodegenNames.REF_LEFTEND : IntervalForgeCodegenNames.REF_RIGHTEND, methodNode, exprSymbol, codegenClassScope));
            if (forge.overlaps) {
                block.methodReturn(CodegenExpressionBuilder.staticMethod(IntervalComputerOverlapsAndByThresholdEval.class, "computeIntervalOverlaps", IntervalForgeCodegenNames.REF_LEFTSTART, IntervalForgeCodegenNames.REF_LEFTEND, IntervalForgeCodegenNames.REF_RIGHTSTART, IntervalForgeCodegenNames.REF_RIGHTEND, CodegenExpressionBuilder.ref("minThreshold"), CodegenExpressionBuilder.ref("maxThreshold")));
            } else {
                block.methodReturn(CodegenExpressionBuilder.staticMethod(IntervalComputerOverlapsAndByThresholdEval.class, "computeIntervalOverlaps", IntervalForgeCodegenNames.REF_RIGHTSTART, IntervalForgeCodegenNames.REF_RIGHTEND, IntervalForgeCodegenNames.REF_LEFTSTART, IntervalForgeCodegenNames.REF_LEFTEND, CodegenExpressionBuilder.ref("minThreshold"), CodegenExpressionBuilder.ref("maxThreshold")));
            }
            return CodegenExpressionBuilder.localMethod(methodNode, leftStart, leftEnd, rightStart, rightEnd);
        }
    }

    public static class IntervalComputerOverlapsAndByMinMaxForge
    implements IntervalComputerForge {
        private final boolean overlaps;
        private final IntervalDeltaExprForge minEval;
        private final IntervalDeltaExprForge maxEval;

        public IntervalComputerOverlapsAndByMinMaxForge(boolean overlaps, IntervalDeltaExprForge minEval, IntervalDeltaExprForge maxEval) {
            this.overlaps = overlaps;
            this.minEval = minEval;
            this.maxEval = maxEval;
        }

        @Override
        public IntervalComputerEval makeComputerEval() {
            return new IntervalComputerOverlapsAndByMinMaxEval(this.overlaps, this.minEval.makeEvaluator(), this.maxEval.makeEvaluator());
        }

        @Override
        public CodegenExpression codegen(CodegenExpression leftStart, CodegenExpression leftEnd, CodegenExpression rightStart, CodegenExpression rightEnd, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return IntervalComputerOverlapsAndByMinMaxEval.codegen(this, leftStart, leftEnd, rightStart, rightEnd, codegenMethodScope, exprSymbol, codegenClassScope);
        }
    }

    public static class IntervalComputerOverlapsAndByThresholdEval
    implements IntervalComputerEval {
        private final boolean overlaps;
        private final IntervalDeltaExprEvaluator thresholdExpr;

        public IntervalComputerOverlapsAndByThresholdEval(boolean overlaps, IntervalDeltaExprEvaluator thresholdExpr) {
            this.overlaps = overlaps;
            this.thresholdExpr = thresholdExpr;
        }

        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            if (this.overlaps) {
                long threshold = this.thresholdExpr.evaluate(leftStart, eventsPerStream, newData, context);
                return IntervalComputerOverlapsAndByThresholdEval.computeIntervalOverlaps(leftStart, leftEnd, rightStart, rightEnd, 0L, threshold);
            }
            long threshold = this.thresholdExpr.evaluate(rightStart, eventsPerStream, newData, context);
            return IntervalComputerOverlapsAndByThresholdEval.computeIntervalOverlaps(rightStart, rightEnd, leftStart, leftEnd, 0L, threshold);
        }

        public static CodegenExpression codegen(IntervalComputerOverlapsAndByThreshold forge, CodegenExpression leftStart, CodegenExpression leftEnd, CodegenExpression rightStart, CodegenExpression rightEnd, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            CodegenMethodNode methodNode = codegenMethodScope.makeChild(Boolean.TYPE, IntervalComputerOverlapsAndByThresholdEval.class, codegenClassScope).addParam(IntervalForgeCodegenNames.PARAMS);
            CodegenBlock block = methodNode.getBlock().declareVar(Long.TYPE, "threshold", forge.thresholdExpr.codegen(forge.overlaps ? IntervalForgeCodegenNames.REF_LEFTSTART : IntervalForgeCodegenNames.REF_RIGHTSTART, methodNode, exprSymbol, codegenClassScope));
            if (forge.overlaps) {
                block.methodReturn(CodegenExpressionBuilder.staticMethod(IntervalComputerOverlapsAndByThresholdEval.class, "computeIntervalOverlaps", IntervalForgeCodegenNames.REF_LEFTSTART, IntervalForgeCodegenNames.REF_LEFTEND, IntervalForgeCodegenNames.REF_RIGHTSTART, IntervalForgeCodegenNames.REF_RIGHTEND, CodegenExpressionBuilder.constant(0), CodegenExpressionBuilder.ref("threshold")));
            } else {
                block.methodReturn(CodegenExpressionBuilder.staticMethod(IntervalComputerOverlapsAndByThresholdEval.class, "computeIntervalOverlaps", IntervalForgeCodegenNames.REF_RIGHTSTART, IntervalForgeCodegenNames.REF_RIGHTEND, IntervalForgeCodegenNames.REF_LEFTSTART, IntervalForgeCodegenNames.REF_LEFTEND, CodegenExpressionBuilder.constant(0), CodegenExpressionBuilder.ref("threshold")));
            }
            return CodegenExpressionBuilder.localMethod(methodNode, leftStart, leftEnd, rightStart, rightEnd);
        }

        public static boolean computeIntervalOverlaps(long left, long leftEnd, long right, long rightEnd, long min, long max) {
            boolean match;
            boolean bl = match = left < right && right < leftEnd && leftEnd < rightEnd;
            if (!match) {
                return false;
            }
            long delta = leftEnd - right;
            return min <= delta && delta <= max;
        }
    }

    public static class IntervalComputerOverlapsAndByThreshold
    implements IntervalComputerForge {
        private final boolean overlaps;
        private final IntervalDeltaExprForge thresholdExpr;

        public IntervalComputerOverlapsAndByThreshold(boolean overlaps, IntervalDeltaExprForge thresholdExpr) {
            this.overlaps = overlaps;
            this.thresholdExpr = thresholdExpr;
        }

        @Override
        public IntervalComputerEval makeComputerEval() {
            return new IntervalComputerOverlapsAndByThresholdEval(this.overlaps, this.thresholdExpr.makeEvaluator());
        }

        @Override
        public CodegenExpression codegen(CodegenExpression leftStart, CodegenExpression leftEnd, CodegenExpression rightStart, CodegenExpression rightEnd, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return IntervalComputerOverlapsAndByThresholdEval.codegen(this, leftStart, leftEnd, rightStart, rightEnd, codegenMethodScope, exprSymbol, codegenClassScope);
        }
    }

    public static class IntervalComputerOverlapsNoParam
    implements IntervalComputerForge,
    IntervalComputerEval {
        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            return leftStart < rightStart && rightStart < leftEnd && leftEnd < rightEnd;
        }

        @Override
        public IntervalComputerEval makeComputerEval() {
            return this;
        }

        @Override
        public CodegenExpression codegen(CodegenExpression leftStart, CodegenExpression leftEnd, CodegenExpression rightStart, CodegenExpression rightEnd, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return CodegenExpressionBuilder.and(CodegenExpressionBuilder.relational(leftStart, CodegenExpressionRelational.CodegenRelational.LT, rightStart), CodegenExpressionBuilder.relational(rightStart, CodegenExpressionRelational.CodegenRelational.LT, leftEnd), CodegenExpressionBuilder.relational(leftEnd, CodegenExpressionRelational.CodegenRelational.LT, rightEnd));
        }
    }

    public static class IntervalComputerMetByThresholdEval
    implements IntervalComputerEval {
        private static final Logger log = LoggerFactory.getLogger(IntervalComputerMetByThresholdForge.class);
        public static final String METHOD_LOGWARNINGINTERVALMETBYTHRESHOLD = "logWarningIntervalMetByThreshold";
        private final IntervalDeltaExprEvaluator thresholdExpr;

        public IntervalComputerMetByThresholdEval(IntervalDeltaExprEvaluator thresholdExpr) {
            this.thresholdExpr = thresholdExpr;
        }

        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            long threshold = this.thresholdExpr.evaluate(Math.min(leftStart, rightEnd), eventsPerStream, newData, context);
            if (threshold < 0L) {
                IntervalComputerMetByThresholdEval.logWarningIntervalMetByThreshold();
                return null;
            }
            long delta = Math.abs(leftStart - rightEnd);
            return delta <= threshold;
        }

        public static void logWarningIntervalMetByThreshold() {
            log.warn("The 'met-by' date-time method does not allow negative threshold");
        }

        public static CodegenExpression codegen(IntervalComputerMetByThresholdForge forge, CodegenExpression leftStart, CodegenExpression leftEnd, CodegenExpression rightStart, CodegenExpression rightEnd, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            CodegenMethodNode methodNode = codegenMethodScope.makeChild(Boolean.class, IntervalComputerMetByThresholdEval.class, codegenClassScope).addParam(IntervalForgeCodegenNames.PARAMS);
            methodNode.getBlock().declareVar(Long.TYPE, "threshold", forge.thresholdExpr.codegen(CodegenExpressionBuilder.staticMethod(Math.class, "min", IntervalForgeCodegenNames.REF_LEFTSTART, IntervalForgeCodegenNames.REF_RIGHTEND), methodNode, exprSymbol, codegenClassScope)).ifCondition(CodegenExpressionBuilder.relational(CodegenExpressionBuilder.ref("threshold"), CodegenExpressionRelational.CodegenRelational.LT, CodegenExpressionBuilder.constant(0))).staticMethod(IntervalComputerMetByThresholdEval.class, METHOD_LOGWARNINGINTERVALMETBYTHRESHOLD, new CodegenExpression[0]).blockReturn(CodegenExpressionBuilder.constantNull()).declareVar(Long.TYPE, "delta", CodegenExpressionBuilder.staticMethod(Math.class, "abs", CodegenExpressionBuilder.op(IntervalForgeCodegenNames.REF_LEFTSTART, "-", IntervalForgeCodegenNames.REF_RIGHTEND))).methodReturn(CodegenExpressionBuilder.relational(CodegenExpressionBuilder.ref("delta"), CodegenExpressionRelational.CodegenRelational.LE, CodegenExpressionBuilder.ref("threshold")));
            return CodegenExpressionBuilder.localMethod(methodNode, leftStart, leftEnd, rightStart, rightEnd);
        }
    }

    public static class IntervalComputerMetByThresholdForge
    implements IntervalComputerForge {
        private final IntervalDeltaExprForge thresholdExpr;

        public IntervalComputerMetByThresholdForge(IntervalDeltaExprForge thresholdExpr) {
            this.thresholdExpr = thresholdExpr;
        }

        @Override
        public IntervalComputerEval makeComputerEval() {
            return new IntervalComputerMetByThresholdEval(this.thresholdExpr.makeEvaluator());
        }

        @Override
        public CodegenExpression codegen(CodegenExpression leftStart, CodegenExpression leftEnd, CodegenExpression rightStart, CodegenExpression rightEnd, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return IntervalComputerMetByThresholdEval.codegen(this, leftStart, leftEnd, rightStart, rightEnd, codegenMethodScope, exprSymbol, codegenClassScope);
        }
    }

    public static class IntervalComputerMetByNoParam
    implements IntervalComputerForge,
    IntervalComputerEval {
        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            return rightEnd == leftStart;
        }

        @Override
        public IntervalComputerEval makeComputerEval() {
            return this;
        }

        @Override
        public CodegenExpression codegen(CodegenExpression leftStart, CodegenExpression leftEnd, CodegenExpression rightStart, CodegenExpression rightEnd, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return CodegenExpressionBuilder.equalsIdentity(rightEnd, leftStart);
        }
    }

    public static class IntervalComputerMeetsThresholdEval
    implements IntervalComputerEval {
        private static final Logger log = LoggerFactory.getLogger(IntervalComputerMeetsThresholdForge.class);
        public static final String METHOD_LOGWARNINGINTERVALMEETSTHRESHOLD = "logWarningIntervalMeetsThreshold";
        private final IntervalDeltaExprEvaluator thresholdExpr;

        public IntervalComputerMeetsThresholdEval(IntervalDeltaExprEvaluator thresholdExpr) {
            this.thresholdExpr = thresholdExpr;
        }

        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            long threshold = this.thresholdExpr.evaluate(Math.min(leftEnd, rightStart), eventsPerStream, newData, context);
            if (threshold < 0L) {
                IntervalComputerMeetsThresholdEval.logWarningIntervalMeetsThreshold();
                return null;
            }
            long delta = Math.abs(rightStart - leftEnd);
            return delta <= threshold;
        }

        public static void logWarningIntervalMeetsThreshold() {
            log.warn("The 'meets' date-time method does not allow negative threshold");
        }

        public static CodegenExpression codegen(IntervalComputerMeetsThresholdForge forge, CodegenExpression leftStart, CodegenExpression leftEnd, CodegenExpression rightStart, CodegenExpression rightEnd, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            CodegenMethodNode methodNode = codegenMethodScope.makeChild(Boolean.class, IntervalComputerMeetsThresholdEval.class, codegenClassScope).addParam(IntervalForgeCodegenNames.PARAMS);
            methodNode.getBlock().declareVar(Long.TYPE, "threshold", forge.thresholdExpr.codegen(CodegenExpressionBuilder.staticMethod(Math.class, "min", IntervalForgeCodegenNames.REF_LEFTEND, IntervalForgeCodegenNames.REF_RIGHTSTART), methodNode, exprSymbol, codegenClassScope)).ifCondition(CodegenExpressionBuilder.relational(CodegenExpressionBuilder.ref("threshold"), CodegenExpressionRelational.CodegenRelational.LT, CodegenExpressionBuilder.constant(0))).staticMethod(IntervalComputerMeetsThresholdEval.class, METHOD_LOGWARNINGINTERVALMEETSTHRESHOLD, new CodegenExpression[0]).blockReturn(CodegenExpressionBuilder.constantNull()).declareVar(Long.TYPE, "delta", CodegenExpressionBuilder.staticMethod(Math.class, "abs", CodegenExpressionBuilder.op(IntervalForgeCodegenNames.REF_RIGHTSTART, "-", IntervalForgeCodegenNames.REF_LEFTEND))).methodReturn(CodegenExpressionBuilder.relational(CodegenExpressionBuilder.ref("delta"), CodegenExpressionRelational.CodegenRelational.LE, CodegenExpressionBuilder.ref("threshold")));
            return CodegenExpressionBuilder.localMethod(methodNode, leftStart, leftEnd, rightStart, rightEnd);
        }
    }

    public static class IntervalComputerMeetsThresholdForge
    implements IntervalComputerForge {
        private final IntervalDeltaExprForge thresholdExpr;

        public IntervalComputerMeetsThresholdForge(IntervalDeltaExprForge thresholdExpr) {
            this.thresholdExpr = thresholdExpr;
        }

        @Override
        public IntervalComputerEval makeComputerEval() {
            return new IntervalComputerMeetsThresholdEval(this.thresholdExpr.makeEvaluator());
        }

        @Override
        public CodegenExpression codegen(CodegenExpression leftStart, CodegenExpression leftEnd, CodegenExpression rightStart, CodegenExpression rightEnd, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return IntervalComputerMeetsThresholdEval.codegen(this, leftStart, leftEnd, rightStart, rightEnd, codegenMethodScope, exprSymbol, codegenClassScope);
        }
    }

    public static class IntervalComputerMeetsNoParam
    implements IntervalComputerForge,
    IntervalComputerEval {
        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            return leftEnd == rightStart;
        }

        @Override
        public IntervalComputerEval makeComputerEval() {
            return this;
        }

        @Override
        public CodegenExpression codegen(CodegenExpression leftStart, CodegenExpression leftEnd, CodegenExpression rightStart, CodegenExpression rightEnd, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return CodegenExpressionBuilder.equalsIdentity(leftEnd, rightStart);
        }
    }

    public static class IntervalComputerFinishedByThresholdEval
    implements IntervalComputerEval {
        private static final Logger log = LoggerFactory.getLogger(IntervalComputerFinishedByThresholdForge.class);
        public static final String METHOD_LOGWARNINGINTERVALFINISHEDBYTHRESHOLD = "logWarningIntervalFinishedByThreshold";
        private final IntervalDeltaExprEvaluator thresholdExpr;

        public IntervalComputerFinishedByThresholdEval(IntervalDeltaExprEvaluator thresholdExpr) {
            this.thresholdExpr = thresholdExpr;
        }

        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            long threshold = this.thresholdExpr.evaluate(Math.min(rightEnd, leftEnd), eventsPerStream, newData, context);
            if (threshold < 0L) {
                IntervalComputerFinishedByThresholdEval.logWarningIntervalFinishedByThreshold();
                return null;
            }
            if (leftStart >= rightStart) {
                return false;
            }
            long delta = Math.abs(leftEnd - rightEnd);
            return delta <= threshold;
        }

        public static void logWarningIntervalFinishedByThreshold() {
            log.warn("The 'finishes' date-time method does not allow negative threshold");
        }

        public static CodegenExpression codegen(IntervalComputerFinishedByThresholdForge forge, CodegenExpression leftStart, CodegenExpression leftEnd, CodegenExpression rightStart, CodegenExpression rightEnd, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            CodegenMethodNode methodNode = codegenMethodScope.makeChild(Boolean.class, IntervalComputerFinishedByThresholdEval.class, codegenClassScope).addParam(IntervalForgeCodegenNames.PARAMS);
            methodNode.getBlock().declareVar(Long.TYPE, "threshold", forge.thresholdExpr.codegen(CodegenExpressionBuilder.staticMethod(Math.class, "min", IntervalForgeCodegenNames.REF_RIGHTEND, IntervalForgeCodegenNames.REF_LEFTEND), methodNode, exprSymbol, codegenClassScope)).ifCondition(CodegenExpressionBuilder.relational(CodegenExpressionBuilder.ref("threshold"), CodegenExpressionRelational.CodegenRelational.LT, CodegenExpressionBuilder.constant(0))).staticMethod(IntervalComputerFinishedByThresholdEval.class, METHOD_LOGWARNINGINTERVALFINISHEDBYTHRESHOLD, new CodegenExpression[0]).blockReturn(CodegenExpressionBuilder.constantNull()).ifConditionReturnConst(CodegenExpressionBuilder.relational(IntervalForgeCodegenNames.REF_LEFTSTART, CodegenExpressionRelational.CodegenRelational.GE, IntervalForgeCodegenNames.REF_RIGHTSTART), false).declareVar(Long.TYPE, "delta", CodegenExpressionBuilder.staticMethod(Math.class, "abs", CodegenExpressionBuilder.op(IntervalForgeCodegenNames.REF_LEFTEND, "-", IntervalForgeCodegenNames.REF_RIGHTEND))).methodReturn(CodegenExpressionBuilder.relational(CodegenExpressionBuilder.ref("delta"), CodegenExpressionRelational.CodegenRelational.LE, CodegenExpressionBuilder.ref("threshold")));
            return CodegenExpressionBuilder.localMethod(methodNode, leftStart, leftEnd, rightStart, rightEnd);
        }
    }

    public static class IntervalComputerFinishedByThresholdForge
    implements IntervalComputerForge {
        private final IntervalDeltaExprForge thresholdExpr;

        public IntervalComputerFinishedByThresholdForge(IntervalDeltaExprForge thresholdExpr) {
            this.thresholdExpr = thresholdExpr;
        }

        @Override
        public IntervalComputerEval makeComputerEval() {
            return new IntervalComputerFinishedByThresholdEval(this.thresholdExpr.makeEvaluator());
        }

        @Override
        public CodegenExpression codegen(CodegenExpression leftStart, CodegenExpression leftEnd, CodegenExpression rightStart, CodegenExpression rightEnd, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return IntervalComputerFinishedByThresholdEval.codegen(this, leftStart, leftEnd, rightStart, rightEnd, codegenMethodScope, exprSymbol, codegenClassScope);
        }
    }

    public static class IntervalComputerFinishedByNoParam
    implements IntervalComputerForge,
    IntervalComputerEval {
        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            return leftStart < rightStart && leftEnd == rightEnd;
        }

        @Override
        public IntervalComputerEval makeComputerEval() {
            return this;
        }

        @Override
        public CodegenExpression codegen(CodegenExpression leftStart, CodegenExpression leftEnd, CodegenExpression rightStart, CodegenExpression rightEnd, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return CodegenExpressionBuilder.and(CodegenExpressionBuilder.relational(leftStart, CodegenExpressionRelational.CodegenRelational.LT, rightStart), CodegenExpressionBuilder.equalsIdentity(leftEnd, rightEnd), new CodegenExpression[0]);
        }
    }

    public static class IntervalComputerFinishesThresholdEval
    implements IntervalComputerEval {
        private static final Logger log = LoggerFactory.getLogger(IntervalComputerFinishesThresholdForge.class);
        public static final String METHOD_LOGWARNINGINTERVALFINISHTHRESHOLD = "logWarningIntervalFinishThreshold";
        private final IntervalDeltaExprEvaluator thresholdExpr;

        public IntervalComputerFinishesThresholdEval(IntervalDeltaExprEvaluator thresholdExpr) {
            this.thresholdExpr = thresholdExpr;
        }

        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            long threshold = this.thresholdExpr.evaluate(Math.min(leftEnd, rightEnd), eventsPerStream, newData, context);
            if (threshold < 0L) {
                IntervalComputerFinishesThresholdEval.logWarningIntervalFinishThreshold();
                return null;
            }
            if (rightStart >= leftStart) {
                return false;
            }
            long delta = Math.abs(leftEnd - rightEnd);
            return delta <= threshold;
        }

        public static void logWarningIntervalFinishThreshold() {
            log.warn("The 'finishes' date-time method does not allow negative threshold");
        }

        public static CodegenExpression codegen(IntervalComputerFinishesThresholdForge forge, CodegenExpression leftStart, CodegenExpression leftEnd, CodegenExpression rightStart, CodegenExpression rightEnd, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            CodegenMethodNode methodNode = codegenMethodScope.makeChild(Boolean.class, IntervalComputerFinishesThresholdEval.class, codegenClassScope).addParam(IntervalForgeCodegenNames.PARAMS);
            methodNode.getBlock().declareVar(Long.TYPE, "threshold", forge.thresholdExpr.codegen(CodegenExpressionBuilder.staticMethod(Math.class, "min", IntervalForgeCodegenNames.REF_LEFTEND, IntervalForgeCodegenNames.REF_RIGHTEND), methodNode, exprSymbol, codegenClassScope)).ifCondition(CodegenExpressionBuilder.relational(CodegenExpressionBuilder.ref("threshold"), CodegenExpressionRelational.CodegenRelational.LT, CodegenExpressionBuilder.constant(0))).staticMethod(IntervalComputerFinishesThresholdEval.class, METHOD_LOGWARNINGINTERVALFINISHTHRESHOLD, new CodegenExpression[0]).blockReturn(CodegenExpressionBuilder.constantNull()).ifConditionReturnConst(CodegenExpressionBuilder.relational(IntervalForgeCodegenNames.REF_RIGHTSTART, CodegenExpressionRelational.CodegenRelational.GE, IntervalForgeCodegenNames.REF_LEFTSTART), false).declareVar(Long.TYPE, "delta", CodegenExpressionBuilder.staticMethod(Math.class, "abs", CodegenExpressionBuilder.op(IntervalForgeCodegenNames.REF_LEFTEND, "-", IntervalForgeCodegenNames.REF_RIGHTEND))).methodReturn(CodegenExpressionBuilder.relational(CodegenExpressionBuilder.ref("delta"), CodegenExpressionRelational.CodegenRelational.LE, CodegenExpressionBuilder.ref("threshold")));
            return CodegenExpressionBuilder.localMethod(methodNode, leftStart, leftEnd, rightStart, rightEnd);
        }
    }

    public static class IntervalComputerFinishesThresholdForge
    implements IntervalComputerForge {
        private static final Logger log = LoggerFactory.getLogger(IntervalComputerFinishesThresholdForge.class);
        private final IntervalDeltaExprForge thresholdExpr;

        public IntervalComputerFinishesThresholdForge(IntervalDeltaExprForge thresholdExpr) {
            this.thresholdExpr = thresholdExpr;
        }

        @Override
        public IntervalComputerEval makeComputerEval() {
            return new IntervalComputerFinishesThresholdEval(this.thresholdExpr.makeEvaluator());
        }

        @Override
        public CodegenExpression codegen(CodegenExpression leftStart, CodegenExpression leftEnd, CodegenExpression rightStart, CodegenExpression rightEnd, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return IntervalComputerFinishesThresholdEval.codegen(this, leftStart, leftEnd, rightStart, rightEnd, codegenMethodScope, exprSymbol, codegenClassScope);
        }
    }

    public static class IntervalComputerFinishesNoParam
    implements IntervalComputerForge,
    IntervalComputerEval {
        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            return rightStart < leftStart && leftEnd == rightEnd;
        }

        @Override
        public IntervalComputerEval makeComputerEval() {
            return this;
        }

        @Override
        public CodegenExpression codegen(CodegenExpression leftStart, CodegenExpression leftEnd, CodegenExpression rightStart, CodegenExpression rightEnd, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return CodegenExpressionBuilder.and(CodegenExpressionBuilder.relational(rightStart, CodegenExpressionRelational.CodegenRelational.LT, leftStart), CodegenExpressionBuilder.equalsIdentity(leftEnd, rightEnd), new CodegenExpression[0]);
        }
    }

    public static class IntervalComputerDuringMinMaxStartEndEval
    implements IntervalComputerEval {
        private final boolean during;
        private final IntervalDeltaExprEvaluator minStartEval;
        private final IntervalDeltaExprEvaluator maxStartEval;
        private final IntervalDeltaExprEvaluator minEndEval;
        private final IntervalDeltaExprEvaluator maxEndEval;

        public IntervalComputerDuringMinMaxStartEndEval(boolean during, IntervalDeltaExprEvaluator minStartEval, IntervalDeltaExprEvaluator maxStartEval, IntervalDeltaExprEvaluator minEndEval, IntervalDeltaExprEvaluator maxEndEval) {
            this.during = during;
            this.minStartEval = minStartEval;
            this.maxStartEval = maxStartEval;
            this.minEndEval = minEndEval;
            this.maxEndEval = maxEndEval;
        }

        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            long minStart = this.minStartEval.evaluate(rightStart, eventsPerStream, newData, context);
            long maxStart = this.maxStartEval.evaluate(rightStart, eventsPerStream, newData, context);
            long minEnd = this.minEndEval.evaluate(rightEnd, eventsPerStream, newData, context);
            long maxEnd = this.maxEndEval.evaluate(rightEnd, eventsPerStream, newData, context);
            if (this.during) {
                return IntervalComputerDuringAndIncludesMinMaxEval.computeIntervalDuring(leftStart, leftEnd, rightStart, rightEnd, minStart, maxStart, minEnd, maxEnd);
            }
            return IntervalComputerDuringAndIncludesMinMaxEval.computeIntervalIncludes(leftStart, leftEnd, rightStart, rightEnd, minStart, maxStart, minEnd, maxEnd);
        }

        public static CodegenExpression codegen(IntervalComputerDuringMinMaxStartEndForge forge, CodegenExpression leftStart, CodegenExpression leftEnd, CodegenExpression rightStart, CodegenExpression rightEnd, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            CodegenMethodNode methodNode = codegenMethodScope.makeChild(Boolean.TYPE, IntervalComputerDuringMinMaxStartEndEval.class, codegenClassScope).addParam(IntervalForgeCodegenNames.PARAMS);
            CodegenBlock block = methodNode.getBlock().declareVar(Long.TYPE, "minStart", forge.minStartEval.codegen(IntervalForgeCodegenNames.REF_RIGHTSTART, methodNode, exprSymbol, codegenClassScope)).declareVar(Long.TYPE, "maxStart", forge.maxStartEval.codegen(IntervalForgeCodegenNames.REF_RIGHTSTART, methodNode, exprSymbol, codegenClassScope)).declareVar(Long.TYPE, "minEnd", forge.minEndEval.codegen(IntervalForgeCodegenNames.REF_RIGHTEND, methodNode, exprSymbol, codegenClassScope)).declareVar(Long.TYPE, "maxEnd", forge.maxEndEval.codegen(IntervalForgeCodegenNames.REF_RIGHTEND, methodNode, exprSymbol, codegenClassScope));
            block.methodReturn(CodegenExpressionBuilder.staticMethod(IntervalComputerDuringAndIncludesMinMaxEval.class, forge.during ? "computeIntervalDuring" : "computeIntervalIncludes", IntervalForgeCodegenNames.REF_LEFTSTART, IntervalForgeCodegenNames.REF_LEFTEND, IntervalForgeCodegenNames.REF_RIGHTSTART, IntervalForgeCodegenNames.REF_RIGHTEND, CodegenExpressionBuilder.ref("minStart"), CodegenExpressionBuilder.ref("maxStart"), CodegenExpressionBuilder.ref("minEnd"), CodegenExpressionBuilder.ref("maxEnd")));
            return CodegenExpressionBuilder.localMethod(methodNode, leftStart, leftEnd, rightStart, rightEnd);
        }
    }

    public static class IntervalComputerDuringMinMaxStartEndForge
    implements IntervalComputerForge {
        private final boolean during;
        private final IntervalDeltaExprForge minStartEval;
        private final IntervalDeltaExprForge maxStartEval;
        private final IntervalDeltaExprForge minEndEval;
        private final IntervalDeltaExprForge maxEndEval;

        public IntervalComputerDuringMinMaxStartEndForge(boolean during, IntervalDeltaExprForge[] parameters) {
            this.during = during;
            this.minStartEval = parameters[0];
            this.maxStartEval = parameters[1];
            this.minEndEval = parameters[2];
            this.maxEndEval = parameters[3];
        }

        @Override
        public IntervalComputerEval makeComputerEval() {
            return new IntervalComputerDuringMinMaxStartEndEval(this.during, this.minStartEval.makeEvaluator(), this.maxStartEval.makeEvaluator(), this.minEndEval.makeEvaluator(), this.maxEndEval.makeEvaluator());
        }

        @Override
        public CodegenExpression codegen(CodegenExpression leftStart, CodegenExpression leftEnd, CodegenExpression rightStart, CodegenExpression rightEnd, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return IntervalComputerDuringMinMaxStartEndEval.codegen(this, leftStart, leftEnd, rightStart, rightEnd, codegenMethodScope, exprSymbol, codegenClassScope);
        }
    }

    public static class IntervalComputerDuringAndIncludesMinMaxEval
    implements IntervalComputerEval {
        private final boolean during;
        private final IntervalDeltaExprEvaluator minEval;
        private final IntervalDeltaExprEvaluator maxEval;

        public IntervalComputerDuringAndIncludesMinMaxEval(boolean during, IntervalDeltaExprEvaluator minEval, IntervalDeltaExprEvaluator maxEval) {
            this.during = during;
            this.minEval = minEval;
            this.maxEval = maxEval;
        }

        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            long min = this.minEval.evaluate(leftStart, eventsPerStream, newData, context);
            long max = this.maxEval.evaluate(rightEnd, eventsPerStream, newData, context);
            if (this.during) {
                return IntervalComputerDuringAndIncludesMinMaxEval.computeIntervalDuring(leftStart, leftEnd, rightStart, rightEnd, min, max, min, max);
            }
            return IntervalComputerDuringAndIncludesMinMaxEval.computeIntervalIncludes(leftStart, leftEnd, rightStart, rightEnd, min, max, min, max);
        }

        public static CodegenExpression codegen(IntervalComputerDuringAndIncludesMinMax forge, CodegenExpression leftStart, CodegenExpression leftEnd, CodegenExpression rightStart, CodegenExpression rightEnd, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            CodegenMethodNode methodNode = codegenMethodScope.makeChild(Boolean.TYPE, IntervalComputerDuringAndIncludesMinMaxEval.class, codegenClassScope).addParam(IntervalForgeCodegenNames.PARAMS);
            CodegenBlock block = methodNode.getBlock().declareVar(Long.TYPE, "min", forge.minEval.codegen(IntervalForgeCodegenNames.REF_LEFTSTART, methodNode, exprSymbol, codegenClassScope)).declareVar(Long.TYPE, "max", forge.maxEval.codegen(IntervalForgeCodegenNames.REF_RIGHTEND, methodNode, exprSymbol, codegenClassScope));
            block.methodReturn(CodegenExpressionBuilder.staticMethod(IntervalComputerDuringAndIncludesMinMaxEval.class, forge.during ? "computeIntervalDuring" : "computeIntervalIncludes", IntervalForgeCodegenNames.REF_LEFTSTART, IntervalForgeCodegenNames.REF_LEFTEND, IntervalForgeCodegenNames.REF_RIGHTSTART, IntervalForgeCodegenNames.REF_RIGHTEND, CodegenExpressionBuilder.ref("min"), CodegenExpressionBuilder.ref("max"), CodegenExpressionBuilder.ref("min"), CodegenExpressionBuilder.ref("max")));
            return CodegenExpressionBuilder.localMethod(methodNode, leftStart, leftEnd, rightStart, rightEnd);
        }

        public static boolean computeIntervalDuring(long left, long leftEnd, long right, long rightEnd, long startMin, long startMax, long endMin, long endMax) {
            long deltaStart;
            if (startMin <= 0L) {
                startMin = 1L;
            }
            if ((deltaStart = left - right) < startMin || deltaStart > startMax) {
                return false;
            }
            long deltaEnd = rightEnd - leftEnd;
            return deltaEnd >= endMin && deltaEnd <= endMax;
        }

        public static boolean computeIntervalIncludes(long left, long leftEnd, long right, long rightEnd, long startMin, long startMax, long endMin, long endMax) {
            long deltaStart;
            if (startMin <= 0L) {
                startMin = 1L;
            }
            if ((deltaStart = right - left) < startMin || deltaStart > startMax) {
                return false;
            }
            long deltaEnd = leftEnd - rightEnd;
            return deltaEnd >= endMin && deltaEnd <= endMax;
        }
    }

    public static class IntervalComputerDuringAndIncludesMinMax
    implements IntervalComputerForge {
        private final boolean during;
        private final IntervalDeltaExprForge minEval;
        private final IntervalDeltaExprForge maxEval;

        public IntervalComputerDuringAndIncludesMinMax(boolean during, IntervalDeltaExprForge minEval, IntervalDeltaExprForge maxEval) {
            this.during = during;
            this.minEval = minEval;
            this.maxEval = maxEval;
        }

        @Override
        public IntervalComputerEval makeComputerEval() {
            return new IntervalComputerDuringAndIncludesMinMaxEval(this.during, this.minEval.makeEvaluator(), this.maxEval.makeEvaluator());
        }

        @Override
        public CodegenExpression codegen(CodegenExpression leftStart, CodegenExpression leftEnd, CodegenExpression rightStart, CodegenExpression rightEnd, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return IntervalComputerDuringAndIncludesMinMaxEval.codegen(this, leftStart, leftEnd, rightStart, rightEnd, codegenMethodScope, exprSymbol, codegenClassScope);
        }
    }

    public static class IntervalComputerDuringAndIncludesThresholdEval
    implements IntervalComputerEval {
        private final boolean during;
        private final IntervalDeltaExprEvaluator threshold;

        public IntervalComputerDuringAndIncludesThresholdEval(boolean during, IntervalDeltaExprEvaluator threshold) {
            this.during = during;
            this.threshold = threshold;
        }

        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            long thresholdValue = this.threshold.evaluate(leftStart, eventsPerStream, newData, context);
            if (this.during) {
                long deltaStart = leftStart - rightStart;
                if (deltaStart <= 0L || deltaStart > thresholdValue) {
                    return false;
                }
                long deltaEnd = rightEnd - leftEnd;
                return deltaEnd > 0L && deltaEnd <= thresholdValue;
            }
            long deltaStart = rightStart - leftStart;
            if (deltaStart <= 0L || deltaStart > thresholdValue) {
                return false;
            }
            long deltaEnd = leftEnd - rightEnd;
            return deltaEnd > 0L && deltaEnd <= thresholdValue;
        }

        public static CodegenExpression codegen(IntervalComputerDuringAndIncludesThresholdForge forge, CodegenExpression leftStart, CodegenExpression leftEnd, CodegenExpression rightStart, CodegenExpression rightEnd, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            CodegenMethodNode methodNode = codegenMethodScope.makeChild(Boolean.TYPE, IntervalComputerDuringAndIncludesThresholdEval.class, codegenClassScope).addParam(IntervalForgeCodegenNames.PARAMS);
            CodegenBlock block = methodNode.getBlock().declareVar(Long.TYPE, "thresholdValue", forge.threshold.codegen(IntervalForgeCodegenNames.REF_LEFTSTART, methodNode, exprSymbol, codegenClassScope));
            if (forge.during) {
                block.declareVar(Long.TYPE, "deltaStart", CodegenExpressionBuilder.op(IntervalForgeCodegenNames.REF_LEFTSTART, "-", IntervalForgeCodegenNames.REF_RIGHTSTART)).ifConditionReturnConst(CodegenExpressionBuilder.or(CodegenExpressionBuilder.relational(CodegenExpressionBuilder.ref("deltaStart"), CodegenExpressionRelational.CodegenRelational.LE, CodegenExpressionBuilder.constant(0)), CodegenExpressionBuilder.relational(CodegenExpressionBuilder.ref("deltaStart"), CodegenExpressionRelational.CodegenRelational.GT, CodegenExpressionBuilder.ref("thresholdValue")), new CodegenExpression[0]), false).declareVar(Long.TYPE, "deltaEnd", CodegenExpressionBuilder.op(IntervalForgeCodegenNames.REF_RIGHTEND, "-", IntervalForgeCodegenNames.REF_LEFTEND)).methodReturn(CodegenExpressionBuilder.not(CodegenExpressionBuilder.or(CodegenExpressionBuilder.relational(CodegenExpressionBuilder.ref("deltaEnd"), CodegenExpressionRelational.CodegenRelational.LE, CodegenExpressionBuilder.constant(0)), CodegenExpressionBuilder.relational(CodegenExpressionBuilder.ref("deltaEnd"), CodegenExpressionRelational.CodegenRelational.GT, CodegenExpressionBuilder.ref("thresholdValue")), new CodegenExpression[0])));
            } else {
                block.declareVar(Long.TYPE, "deltaStart", CodegenExpressionBuilder.op(IntervalForgeCodegenNames.REF_RIGHTSTART, "-", IntervalForgeCodegenNames.REF_LEFTSTART)).ifConditionReturnConst(CodegenExpressionBuilder.or(CodegenExpressionBuilder.relational(CodegenExpressionBuilder.ref("deltaStart"), CodegenExpressionRelational.CodegenRelational.LE, CodegenExpressionBuilder.constant(0)), CodegenExpressionBuilder.relational(CodegenExpressionBuilder.ref("deltaStart"), CodegenExpressionRelational.CodegenRelational.GT, CodegenExpressionBuilder.ref("thresholdValue")), new CodegenExpression[0]), false).declareVar(Long.TYPE, "deltaEnd", CodegenExpressionBuilder.op(IntervalForgeCodegenNames.REF_LEFTEND, "-", IntervalForgeCodegenNames.REF_RIGHTEND)).methodReturn(CodegenExpressionBuilder.not(CodegenExpressionBuilder.or(CodegenExpressionBuilder.relational(CodegenExpressionBuilder.ref("deltaEnd"), CodegenExpressionRelational.CodegenRelational.LE, CodegenExpressionBuilder.constant(0)), CodegenExpressionBuilder.relational(CodegenExpressionBuilder.ref("deltaEnd"), CodegenExpressionRelational.CodegenRelational.GT, CodegenExpressionBuilder.ref("thresholdValue")), new CodegenExpression[0])));
            }
            return CodegenExpressionBuilder.localMethod(methodNode, leftStart, leftEnd, rightStart, rightEnd);
        }
    }

    public static class IntervalComputerDuringAndIncludesThresholdForge
    implements IntervalComputerForge {
        private final boolean during;
        private final IntervalDeltaExprForge threshold;

        public IntervalComputerDuringAndIncludesThresholdForge(boolean during, IntervalDeltaExprForge threshold) {
            this.during = during;
            this.threshold = threshold;
        }

        @Override
        public IntervalComputerEval makeComputerEval() {
            return new IntervalComputerDuringAndIncludesThresholdEval(this.during, this.threshold.makeEvaluator());
        }

        @Override
        public CodegenExpression codegen(CodegenExpression leftStart, CodegenExpression leftEnd, CodegenExpression rightStart, CodegenExpression rightEnd, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return IntervalComputerDuringAndIncludesThresholdEval.codegen(this, leftStart, leftEnd, rightStart, rightEnd, codegenMethodScope, exprSymbol, codegenClassScope);
        }
    }

    public static class IntervalComputerIncludesNoParam
    implements IntervalComputerForge,
    IntervalComputerEval {
        @Override
        public IntervalComputerEval makeComputerEval() {
            return this;
        }

        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            return leftStart < rightStart && rightEnd < leftEnd;
        }

        @Override
        public CodegenExpression codegen(CodegenExpression leftStart, CodegenExpression leftEnd, CodegenExpression rightStart, CodegenExpression rightEnd, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return CodegenExpressionBuilder.and(CodegenExpressionBuilder.relational(leftStart, CodegenExpressionRelational.CodegenRelational.LT, rightStart), CodegenExpressionBuilder.relational(rightEnd, CodegenExpressionRelational.CodegenRelational.LT, leftEnd), new CodegenExpression[0]);
        }
    }

    public static class IntervalComputerDuringNoParam
    implements IntervalComputerForge,
    IntervalComputerEval {
        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            return rightStart < leftStart && leftEnd < rightEnd;
        }

        @Override
        public IntervalComputerEval makeComputerEval() {
            return this;
        }

        @Override
        public CodegenExpression codegen(CodegenExpression leftStart, CodegenExpression leftEnd, CodegenExpression rightStart, CodegenExpression rightEnd, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return CodegenExpressionBuilder.and(CodegenExpressionBuilder.relational(rightStart, CodegenExpressionRelational.CodegenRelational.LT, leftStart), CodegenExpressionBuilder.relational(leftEnd, CodegenExpressionRelational.CodegenRelational.LT, rightEnd), new CodegenExpression[0]);
        }
    }

    public static class IntervalComputerCoincidesNoParam
    implements IntervalComputerForge,
    IntervalComputerEval {
        @Override
        public IntervalComputerEval makeComputerEval() {
            return this;
        }

        @Override
        public CodegenExpression codegen(CodegenExpression leftStart, CodegenExpression leftEnd, CodegenExpression rightStart, CodegenExpression rightEnd, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return CodegenExpressionBuilder.and(CodegenExpressionBuilder.equalsIdentity(leftStart, rightStart), CodegenExpressionBuilder.equalsIdentity(leftEnd, rightEnd), new CodegenExpression[0]);
        }

        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            return leftStart == rightStart && leftEnd == rightEnd;
        }
    }

    public static class IntervalComputerCoincidesWithDeltaExprEval
    implements IntervalComputerEval {
        private static final Logger log = LoggerFactory.getLogger(IntervalComputerCoincidesWithDeltaExprForge.class);
        public static final String METHOD_WARNCOINCIDESTARTENDLESSZERO = "warnCoincideStartEndLessZero";
        private final IntervalDeltaExprEvaluator start;
        private final IntervalDeltaExprEvaluator finish;

        public IntervalComputerCoincidesWithDeltaExprEval(IntervalDeltaExprEvaluator start, IntervalDeltaExprEvaluator finish) {
            this.start = start;
            this.finish = finish;
        }

        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            long startValue = this.start.evaluate(Math.min(leftStart, rightStart), eventsPerStream, newData, context);
            long endValue = this.finish.evaluate(Math.min(leftEnd, rightEnd), eventsPerStream, newData, context);
            if (startValue < 0L || endValue < 0L) {
                log.warn("The coincides date-time method does not allow negative start and end values");
                return null;
            }
            return IntervalComputerConstantCoincides.computeIntervalCoincides(leftStart, leftEnd, rightStart, rightEnd, startValue, endValue);
        }

        public static CodegenExpression codegen(IntervalComputerCoincidesWithDeltaExprForge forge, CodegenExpression leftStart, CodegenExpression leftEnd, CodegenExpression rightStart, CodegenExpression rightEnd, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            CodegenMethodNode methodNode = codegenMethodScope.makeChild(Boolean.class, IntervalComputerCoincidesWithDeltaExprEval.class, codegenClassScope).addParam(IntervalForgeCodegenNames.PARAMS);
            CodegenBlock block = methodNode.getBlock().declareVar(Long.TYPE, "startValue", forge.start.codegen(CodegenExpressionBuilder.staticMethod(Math.class, "min", IntervalForgeCodegenNames.REF_LEFTSTART, IntervalForgeCodegenNames.REF_RIGHTSTART), methodNode, exprSymbol, codegenClassScope)).declareVar(Long.TYPE, "endValue", forge.finish.codegen(CodegenExpressionBuilder.staticMethod(Math.class, "min", IntervalForgeCodegenNames.REF_LEFTEND, IntervalForgeCodegenNames.REF_RIGHTEND), methodNode, exprSymbol, codegenClassScope));
            block.ifCondition(CodegenExpressionBuilder.or(CodegenExpressionBuilder.relational(CodegenExpressionBuilder.ref("startValue"), CodegenExpressionRelational.CodegenRelational.LT, CodegenExpressionBuilder.constant(0)), CodegenExpressionBuilder.relational(CodegenExpressionBuilder.ref("endValue"), CodegenExpressionRelational.CodegenRelational.LT, CodegenExpressionBuilder.constant(0)), new CodegenExpression[0])).staticMethod(IntervalComputerCoincidesWithDeltaExprEval.class, METHOD_WARNCOINCIDESTARTENDLESSZERO, new CodegenExpression[0]).blockReturn(CodegenExpressionBuilder.constantNull());
            block.methodReturn(CodegenExpressionBuilder.staticMethod(IntervalComputerConstantCoincides.class, "computeIntervalCoincides", IntervalForgeCodegenNames.REF_LEFTSTART, IntervalForgeCodegenNames.REF_LEFTEND, IntervalForgeCodegenNames.REF_RIGHTSTART, IntervalForgeCodegenNames.REF_RIGHTEND, CodegenExpressionBuilder.ref("startValue"), CodegenExpressionBuilder.ref("endValue")));
            return CodegenExpressionBuilder.localMethod(methodNode, leftStart, leftEnd, rightStart, rightEnd);
        }

        public static void warnCoincideStartEndLessZero() {
            log.warn("The coincides date-time method does not allow negative start and end values");
        }
    }

    public static class IntervalComputerCoincidesWithDeltaExprForge
    implements IntervalComputerForge {
        private final IntervalDeltaExprForge start;
        private final IntervalDeltaExprForge finish;

        public IntervalComputerCoincidesWithDeltaExprForge(IntervalStartEndParameterPairForge pair) {
            this.start = pair.getStart().getForge();
            this.finish = pair.getEnd().getForge();
        }

        @Override
        public IntervalComputerEval makeComputerEval() {
            return new IntervalComputerCoincidesWithDeltaExprEval(this.start.makeEvaluator(), this.finish.makeEvaluator());
        }

        @Override
        public CodegenExpression codegen(CodegenExpression leftStart, CodegenExpression leftEnd, CodegenExpression rightStart, CodegenExpression rightEnd, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return IntervalComputerCoincidesWithDeltaExprEval.codegen(this, leftStart, leftEnd, rightStart, rightEnd, codegenMethodScope, exprSymbol, codegenClassScope);
        }
    }

    public static class IntervalComputerConstantCoincides
    implements IntervalComputerForge,
    IntervalComputerEval {
        protected final long start;
        protected final long end;

        public IntervalComputerConstantCoincides(IntervalStartEndParameterPairForge pair) throws ExprValidationException {
            this.start = pair.getStart().getOptionalConstant();
            this.end = pair.getEnd().getOptionalConstant();
            if (this.start < 0L || this.end < 0L) {
                throw new ExprValidationException("The coincides date-time method does not allow negative start and end values");
            }
        }

        @Override
        public IntervalComputerEval makeComputerEval() {
            return this;
        }

        @Override
        public CodegenExpression codegen(CodegenExpression leftStart, CodegenExpression leftEnd, CodegenExpression rightStart, CodegenExpression rightEnd, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return CodegenExpressionBuilder.staticMethod(IntervalComputerConstantCoincides.class, "computeIntervalCoincides", leftStart, leftEnd, rightStart, rightEnd, CodegenExpressionBuilder.constant(this.start), CodegenExpressionBuilder.constant(this.end));
        }

        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            return IntervalComputerConstantCoincides.computeIntervalCoincides(leftStart, leftEnd, rightStart, rightEnd, this.start, this.end);
        }

        public static boolean computeIntervalCoincides(long left, long leftEnd, long right, long rightEnd, long startThreshold, long endThreshold) {
            return Math.abs(left - right) <= startThreshold && Math.abs(leftEnd - rightEnd) <= endThreshold;
        }
    }

    public static class IntervalComputerBeforeNoParamForge
    implements IntervalComputerForge,
    IntervalComputerEval {
        @Override
        public IntervalComputerEval makeComputerEval() {
            return this;
        }

        @Override
        public CodegenExpression codegen(CodegenExpression leftStart, CodegenExpression leftEnd, CodegenExpression rightStart, CodegenExpression rightEnd, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return CodegenExpressionBuilder.relational(leftEnd, CodegenExpressionRelational.CodegenRelational.LT, rightStart);
        }

        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            return leftEnd < rightStart;
        }
    }

    public static class IntervalComputerBeforeWithDeltaExprEval
    implements IntervalComputerEval {
        private final IntervalDeltaExprEvaluator start;
        private final IntervalDeltaExprEvaluator finish;

        public IntervalComputerBeforeWithDeltaExprEval(IntervalDeltaExprEvaluator start, IntervalDeltaExprEvaluator finish) {
            this.start = start;
            this.finish = finish;
        }

        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            long rangeEndDelta;
            long rangeStartDelta = this.start.evaluate(leftEnd, eventsPerStream, newData, context);
            if (rangeStartDelta > (rangeEndDelta = this.finish.evaluate(leftEnd, eventsPerStream, newData, context))) {
                return IntervalComputerConstantBefore.computeIntervalBefore(leftEnd, rightStart, rangeEndDelta, rangeStartDelta);
            }
            return IntervalComputerConstantBefore.computeIntervalBefore(leftEnd, rightStart, rangeStartDelta, rangeEndDelta);
        }

        public static CodegenExpression codegen(IntervalComputerBeforeWithDeltaExprForge forge, CodegenExpression leftStart, CodegenExpression leftEnd, CodegenExpression rightStart, CodegenExpression rightEnd, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            CodegenMethodNode methodNode = codegenMethodScope.makeChild(Boolean.TYPE, IntervalComputerBeforeWithDeltaExprEval.class, codegenClassScope).addParam(IntervalForgeCodegenNames.PARAMS);
            CodegenBlock block = methodNode.getBlock().declareVar(Long.TYPE, "rangeStartDelta", forge.start.codegen(IntervalForgeCodegenNames.REF_LEFTEND, methodNode, exprSymbol, codegenClassScope)).declareVar(Long.TYPE, "rangeEndDelta", forge.finish.codegen(IntervalForgeCodegenNames.REF_LEFTEND, methodNode, exprSymbol, codegenClassScope));
            block.ifCondition(CodegenExpressionBuilder.relational(CodegenExpressionBuilder.ref("rangeStartDelta"), CodegenExpressionRelational.CodegenRelational.GT, CodegenExpressionBuilder.ref("rangeEndDelta"))).blockReturn(CodegenExpressionBuilder.staticMethod(IntervalComputerConstantBefore.class, "computeIntervalBefore", IntervalForgeCodegenNames.REF_LEFTEND, IntervalForgeCodegenNames.REF_RIGHTSTART, CodegenExpressionBuilder.ref("rangeEndDelta"), CodegenExpressionBuilder.ref("rangeStartDelta")));
            block.methodReturn(CodegenExpressionBuilder.staticMethod(IntervalComputerConstantBefore.class, "computeIntervalBefore", IntervalForgeCodegenNames.REF_LEFTEND, IntervalForgeCodegenNames.REF_RIGHTSTART, CodegenExpressionBuilder.ref("rangeStartDelta"), CodegenExpressionBuilder.ref("rangeEndDelta")));
            return CodegenExpressionBuilder.localMethod(methodNode, leftStart, leftEnd, rightStart, rightEnd);
        }
    }

    public static class IntervalComputerBeforeWithDeltaExprForge
    implements IntervalComputerForge {
        protected final IntervalDeltaExprForge start;
        protected final IntervalDeltaExprForge finish;

        public IntervalComputerBeforeWithDeltaExprForge(IntervalStartEndParameterPairForge pair) {
            this.start = pair.getStart().getForge();
            this.finish = pair.getEnd().getForge();
        }

        @Override
        public IntervalComputerEval makeComputerEval() {
            return new IntervalComputerBeforeWithDeltaExprEval(this.start.makeEvaluator(), this.finish.makeEvaluator());
        }

        @Override
        public CodegenExpression codegen(CodegenExpression leftStart, CodegenExpression leftEnd, CodegenExpression rightStart, CodegenExpression rightEnd, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return IntervalComputerBeforeWithDeltaExprEval.codegen(this, leftStart, leftEnd, rightStart, rightEnd, codegenMethodScope, exprSymbol, codegenClassScope);
        }
    }

    public static class IntervalComputerConstantBefore
    extends IntervalComputerConstantBase
    implements IntervalComputerForge,
    IntervalComputerEval {
        public IntervalComputerConstantBefore(IntervalStartEndParameterPairForge pair) {
            super(pair, true);
        }

        @Override
        public IntervalComputerEval makeComputerEval() {
            return this;
        }

        @Override
        public CodegenExpression codegen(CodegenExpression leftStart, CodegenExpression leftEnd, CodegenExpression rightStart, CodegenExpression rightEnd, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return CodegenExpressionBuilder.staticMethod(IntervalComputerConstantBefore.class, "computeIntervalBefore", leftEnd, rightStart, CodegenExpressionBuilder.constant(this.start), CodegenExpressionBuilder.constant(this.end));
        }

        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            return IntervalComputerConstantBefore.computeIntervalBefore(leftEnd, rightStart, this.start, this.end);
        }

        public static boolean computeIntervalBefore(long leftEnd, long right, long start, long end) {
            long delta = right - leftEnd;
            return start <= delta && delta <= end;
        }
    }

    public static class IntervalComputerAfterNoParam
    implements IntervalComputerForge,
    IntervalComputerEval {
        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            return leftStart > rightEnd;
        }

        @Override
        public IntervalComputerEval makeComputerEval() {
            return this;
        }

        @Override
        public CodegenExpression codegen(CodegenExpression leftStart, CodegenExpression leftEnd, CodegenExpression rightStart, CodegenExpression rightEnd, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return CodegenExpressionBuilder.relational(leftStart, CodegenExpressionRelational.CodegenRelational.GT, rightEnd);
        }
    }

    public static class IntervalComputerAfterWithDeltaExprEval
    implements IntervalComputerEval {
        private final IntervalDeltaExprEvaluator start;
        private final IntervalDeltaExprEvaluator finish;

        public IntervalComputerAfterWithDeltaExprEval(IntervalDeltaExprEvaluator start, IntervalDeltaExprEvaluator finish) {
            this.start = start;
            this.finish = finish;
        }

        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            long rangeEndDelta;
            long rangeStartDelta = this.start.evaluate(rightStart, eventsPerStream, newData, context);
            if (rangeStartDelta > (rangeEndDelta = this.finish.evaluate(rightStart, eventsPerStream, newData, context))) {
                return IntervalComputerConstantAfter.computeIntervalAfter(leftStart, rightEnd, rangeEndDelta, rangeStartDelta);
            }
            return IntervalComputerConstantAfter.computeIntervalAfter(leftStart, rightEnd, rangeStartDelta, rangeEndDelta);
        }

        public static CodegenExpression codegen(IntervalComputerAfterWithDeltaExprForge forge, CodegenExpression leftStart, CodegenExpression leftEnd, CodegenExpression rightStart, CodegenExpression rightEnd, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            CodegenMethodNode methodNode = codegenMethodScope.makeChild(Boolean.TYPE, IntervalComputerAfterWithDeltaExprEval.class, codegenClassScope).addParam(IntervalForgeCodegenNames.PARAMS);
            CodegenBlock block = methodNode.getBlock().declareVar(Long.TYPE, "rangeStartDelta", forge.start.codegen(IntervalForgeCodegenNames.REF_RIGHTSTART, methodNode, exprSymbol, codegenClassScope)).declareVar(Long.TYPE, "rangeEndDelta", forge.finish.codegen(IntervalForgeCodegenNames.REF_RIGHTSTART, methodNode, exprSymbol, codegenClassScope));
            block.ifCondition(CodegenExpressionBuilder.relational(CodegenExpressionBuilder.ref("rangeStartDelta"), CodegenExpressionRelational.CodegenRelational.GT, CodegenExpressionBuilder.ref("rangeEndDelta"))).blockReturn(CodegenExpressionBuilder.staticMethod(IntervalComputerConstantAfter.class, "computeIntervalAfter", IntervalForgeCodegenNames.REF_LEFTSTART, IntervalForgeCodegenNames.REF_RIGHTEND, CodegenExpressionBuilder.ref("rangeEndDelta"), CodegenExpressionBuilder.ref("rangeStartDelta")));
            block.methodReturn(CodegenExpressionBuilder.staticMethod(IntervalComputerConstantAfter.class, "computeIntervalAfter", IntervalForgeCodegenNames.REF_LEFTSTART, IntervalForgeCodegenNames.REF_RIGHTEND, CodegenExpressionBuilder.ref("rangeStartDelta"), CodegenExpressionBuilder.ref("rangeEndDelta")));
            return CodegenExpressionBuilder.localMethod(methodNode, leftStart, leftEnd, rightStart, rightEnd);
        }
    }

    public static class IntervalComputerAfterWithDeltaExprForge
    implements IntervalComputerForge {
        private final IntervalDeltaExprForge start;
        private final IntervalDeltaExprForge finish;

        public IntervalComputerAfterWithDeltaExprForge(IntervalStartEndParameterPairForge pair) {
            this.start = pair.getStart().getForge();
            this.finish = pair.getEnd().getForge();
        }

        @Override
        public IntervalComputerEval makeComputerEval() {
            return new IntervalComputerAfterWithDeltaExprEval(this.start.makeEvaluator(), this.finish.makeEvaluator());
        }

        @Override
        public CodegenExpression codegen(CodegenExpression leftStart, CodegenExpression leftEnd, CodegenExpression rightStart, CodegenExpression rightEnd, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return IntervalComputerAfterWithDeltaExprEval.codegen(this, leftStart, leftEnd, rightStart, rightEnd, codegenMethodScope, exprSymbol, codegenClassScope);
        }
    }

    public static class IntervalComputerConstantAfter
    extends IntervalComputerConstantBase
    implements IntervalComputerForge,
    IntervalComputerEval {
        public IntervalComputerConstantAfter(IntervalStartEndParameterPairForge pair) {
            super(pair, true);
        }

        @Override
        public IntervalComputerEval makeComputerEval() {
            return this;
        }

        @Override
        public CodegenExpression codegen(CodegenExpression leftStart, CodegenExpression leftEnd, CodegenExpression rightStart, CodegenExpression rightEnd, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return CodegenExpressionBuilder.staticMethod(IntervalComputerConstantAfter.class, "computeIntervalAfter", leftStart, rightEnd, CodegenExpressionBuilder.constant(this.start), CodegenExpressionBuilder.constant(this.end));
        }

        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            return IntervalComputerConstantAfter.computeIntervalAfter(leftStart, rightEnd, this.start, this.end);
        }

        public static boolean computeIntervalAfter(long leftStart, long rightEnd, long start, long end) {
            long delta = leftStart - rightEnd;
            return start <= delta && delta <= end;
        }
    }
}

