/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.datetime.eval;

import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.datetime.eval.DatetimeMethodEnum;
import com.espertech.esper.epl.expression.core.ExprIdentNode;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeUtilityCore;
import com.espertech.esper.epl.join.plan.FilterExprAnalyzerAffector;
import com.espertech.esper.epl.join.plan.QueryGraph;
import com.espertech.esper.epl.lookup.AdvancedIndexConfigContextPartition;
import com.espertech.esper.type.RelationalOpEnum;
import java.util.List;

public class FilterExprAnalyzerDTIntervalAffector
implements FilterExprAnalyzerAffector {
    private final DatetimeMethodEnum currentMethod;
    private final EventType[] typesPerStream;
    private final int targetStreamNum;
    private final String targetStartProp;
    private final String targetEndProp;
    private final Integer parameterStreamNum;
    private final String parameterStartProp;
    private final String parameterEndProp;

    public FilterExprAnalyzerDTIntervalAffector(DatetimeMethodEnum currentMethod, EventType[] typesPerStream, int targetStreamNum, String targetStartProp, String targetEndProp, Integer parameterStreamNum, String parameterStartProp, String parameterEndProp) {
        this.currentMethod = currentMethod;
        this.typesPerStream = typesPerStream;
        this.targetStreamNum = targetStreamNum;
        this.targetStartProp = targetStartProp;
        this.targetEndProp = targetEndProp;
        this.parameterStreamNum = parameterStreamNum;
        this.parameterStartProp = parameterStartProp;
        this.parameterEndProp = parameterEndProp;
    }

    public ExprNode[] getIndexExpressions() {
        return null;
    }

    public List<Pair<ExprNode, int[]>> getKeyExpressions() {
        return null;
    }

    public AdvancedIndexConfigContextPartition getOptionalIndexSpec() {
        return null;
    }

    public String getOptionalIndexName() {
        return null;
    }

    @Override
    public void apply(QueryGraph queryGraph) {
        if (this.targetStreamNum == this.parameterStreamNum) {
            return;
        }
        ExprIdentNode targetStartExpr = ExprNodeUtilityCore.getExprIdentNode(this.typesPerStream, this.targetStreamNum, this.targetStartProp);
        ExprIdentNode targetEndExpr = ExprNodeUtilityCore.getExprIdentNode(this.typesPerStream, this.targetStreamNum, this.targetEndProp);
        ExprIdentNode parameterStartExpr = ExprNodeUtilityCore.getExprIdentNode(this.typesPerStream, this.parameterStreamNum, this.parameterStartProp);
        ExprIdentNode parameterEndExpr = ExprNodeUtilityCore.getExprIdentNode(this.typesPerStream, this.parameterStreamNum, this.parameterEndProp);
        if (targetStartExpr.getForge().getEvaluationType() != parameterStartExpr.getForge().getEvaluationType()) {
            return;
        }
        if (this.currentMethod == DatetimeMethodEnum.BEFORE) {
            queryGraph.addRelationalOpStrict(this.targetStreamNum, targetEndExpr, this.parameterStreamNum, parameterStartExpr, RelationalOpEnum.LT);
        } else if (this.currentMethod == DatetimeMethodEnum.AFTER) {
            queryGraph.addRelationalOpStrict(this.targetStreamNum, targetStartExpr, this.parameterStreamNum, parameterEndExpr, RelationalOpEnum.GT);
        } else if (this.currentMethod == DatetimeMethodEnum.COINCIDES) {
            boolean noDuration;
            queryGraph.addStrictEquals(this.targetStreamNum, this.targetStartProp, targetStartExpr, this.parameterStreamNum, this.parameterStartProp, parameterStartExpr);
            boolean bl = noDuration = this.parameterEndProp.equals(this.parameterStartProp) && this.targetEndProp.equals(this.targetStartProp);
            if (!noDuration) {
                ExprIdentNode leftEndExpr = ExprNodeUtilityCore.getExprIdentNode(this.typesPerStream, this.targetStreamNum, this.targetEndProp);
                ExprIdentNode rightEndExpr = ExprNodeUtilityCore.getExprIdentNode(this.typesPerStream, this.parameterStreamNum, this.parameterEndProp);
                queryGraph.addStrictEquals(this.targetStreamNum, this.targetEndProp, leftEndExpr, this.parameterStreamNum, this.parameterEndProp, rightEndExpr);
            }
        } else if (this.currentMethod == DatetimeMethodEnum.DURING || this.currentMethod == DatetimeMethodEnum.INCLUDES) {
            RelationalOpEnum relop = this.currentMethod == DatetimeMethodEnum.DURING ? RelationalOpEnum.LT : RelationalOpEnum.GT;
            queryGraph.addRelationalOpStrict(this.parameterStreamNum, parameterStartExpr, this.targetStreamNum, targetStartExpr, relop);
            queryGraph.addRelationalOpStrict(this.targetStreamNum, targetEndExpr, this.parameterStreamNum, parameterEndExpr, relop);
        } else if (this.currentMethod == DatetimeMethodEnum.FINISHES || this.currentMethod == DatetimeMethodEnum.FINISHEDBY) {
            RelationalOpEnum relop = this.currentMethod == DatetimeMethodEnum.FINISHES ? RelationalOpEnum.LT : RelationalOpEnum.GT;
            queryGraph.addRelationalOpStrict(this.parameterStreamNum, parameterStartExpr, this.targetStreamNum, targetStartExpr, relop);
            queryGraph.addStrictEquals(this.targetStreamNum, this.targetEndProp, targetEndExpr, this.parameterStreamNum, this.parameterEndProp, parameterEndExpr);
        } else if (this.currentMethod == DatetimeMethodEnum.MEETS) {
            queryGraph.addStrictEquals(this.targetStreamNum, this.targetEndProp, targetEndExpr, this.parameterStreamNum, this.parameterStartProp, parameterStartExpr);
        } else if (this.currentMethod == DatetimeMethodEnum.METBY) {
            queryGraph.addStrictEquals(this.targetStreamNum, this.targetStartProp, targetStartExpr, this.parameterStreamNum, this.parameterEndProp, parameterEndExpr);
        } else if (this.currentMethod == DatetimeMethodEnum.OVERLAPS || this.currentMethod == DatetimeMethodEnum.OVERLAPPEDBY) {
            RelationalOpEnum relop = this.currentMethod == DatetimeMethodEnum.OVERLAPS ? RelationalOpEnum.LT : RelationalOpEnum.GT;
            queryGraph.addRelationalOpStrict(this.targetStreamNum, targetStartExpr, this.parameterStreamNum, parameterStartExpr, relop);
            queryGraph.addRelationalOpStrict(this.targetStreamNum, targetEndExpr, this.parameterStreamNum, parameterEndExpr, relop);
            if (this.currentMethod == DatetimeMethodEnum.OVERLAPS) {
                queryGraph.addRelationalOpStrict(this.parameterStreamNum, parameterStartExpr, this.targetStreamNum, targetEndExpr, RelationalOpEnum.LT);
            } else {
                queryGraph.addRelationalOpStrict(this.targetStreamNum, targetStartExpr, this.parameterStreamNum, parameterEndExpr, RelationalOpEnum.LT);
            }
        } else if (this.currentMethod == DatetimeMethodEnum.STARTS || this.currentMethod == DatetimeMethodEnum.STARTEDBY) {
            queryGraph.addStrictEquals(this.targetStreamNum, this.targetStartProp, targetStartExpr, this.parameterStreamNum, this.parameterStartProp, parameterStartExpr);
            RelationalOpEnum relop = this.currentMethod == DatetimeMethodEnum.STARTS ? RelationalOpEnum.LT : RelationalOpEnum.GT;
            queryGraph.addRelationalOpStrict(this.targetStreamNum, targetEndExpr, this.parameterStreamNum, parameterEndExpr, relop);
        }
    }
}

