/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.datetime.eval;

import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMember;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.epl.datetime.eval.DatetimeLongCoercer;
import java.time.LocalDateTime;
import java.util.TimeZone;

public class DatetimeLongCoercerLocalDateTime
implements DatetimeLongCoercer {
    private final TimeZone timeZone;

    public DatetimeLongCoercerLocalDateTime(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    @Override
    public long coerce(Object date) {
        return DatetimeLongCoercerLocalDateTime.coerceLDTToMilliWTimezone((LocalDateTime)date, this.timeZone);
    }

    public static long coerceLDTToMilliWTimezone(LocalDateTime ldt, TimeZone timeZone) {
        return ldt.atZone(timeZone.toZoneId()).toInstant().toEpochMilli();
    }

    @Override
    public CodegenExpression codegen(CodegenExpression value, Class valueType, CodegenClassScope codegenClassScope) {
        if (valueType != LocalDateTime.class) {
            throw new IllegalStateException("Expected a LocalDateTime type");
        }
        CodegenMember tz = codegenClassScope.makeAddMember(TimeZone.class, this.timeZone);
        return CodegenExpressionBuilder.exprDotMethodChain(value).add("atZone", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.member(tz.getMemberId()), "toZoneId", new CodegenExpression[0])).add("toInstant", new CodegenExpression[0]).add("toEpochMilli", new CodegenExpression[0]);
    }
}

