/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.datetime.dtlocal;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.codegen.base.CodegenBlock;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMember;
import com.espertech.esper.codegen.base.CodegenMethodNode;
import com.espertech.esper.codegen.base.CodegenMethodScope;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.codegen.model.expression.CodegenExpressionRef;
import com.espertech.esper.epl.datetime.calop.CalendarOp;
import com.espertech.esper.epl.datetime.dtlocal.DTLocalCalOpsIntervalEval;
import com.espertech.esper.epl.datetime.dtlocal.DTLocalEvaluatorCalOpsIntervalBase;
import com.espertech.esper.epl.datetime.dtlocal.DTLocalLocalDateTimeOpsIntervalForge;
import com.espertech.esper.epl.datetime.dtlocal.DTLocalUtil;
import com.espertech.esper.epl.datetime.eval.DatetimeLongCoercerLocalDateTime;
import com.espertech.esper.epl.datetime.interval.IntervalOp;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import java.time.LocalDateTime;
import java.util.List;
import java.util.TimeZone;

public class DTLocalLocalDateTimeOpsIntervalEval
extends DTLocalEvaluatorCalOpsIntervalBase {
    private final TimeZone timeZone;

    public DTLocalLocalDateTimeOpsIntervalEval(List<CalendarOp> calendarOps, IntervalOp intervalOp, TimeZone timeZone) {
        super(calendarOps, intervalOp);
        this.timeZone = timeZone;
    }

    @Override
    public Object evaluate(Object target, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        LocalDateTime ldt = (LocalDateTime)target;
        ldt = DTLocalUtil.evaluateCalOpsLDT(this.calendarOps, ldt, eventsPerStream, isNewData, exprEvaluatorContext);
        long time = DatetimeLongCoercerLocalDateTime.coerceLDTToMilliWTimezone(ldt, this.timeZone);
        return this.intervalOp.evaluate(time, time, eventsPerStream, isNewData, exprEvaluatorContext);
    }

    public static CodegenExpression codegen(DTLocalLocalDateTimeOpsIntervalForge forge, CodegenExpression inner, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenMember tz = codegenClassScope.makeAddMember(TimeZone.class, forge.timeZone);
        CodegenMethodNode methodNode = codegenMethodScope.makeChild(Boolean.class, DTLocalCalOpsIntervalEval.class, codegenClassScope).addParam(LocalDateTime.class, "target");
        CodegenBlock block = methodNode.getBlock();
        DTLocalUtil.evaluateCalOpsLDTCodegen(block, "target", forge.calendarForges, methodNode, exprSymbol, codegenClassScope);
        block.declareVar(Long.TYPE, "time", CodegenExpressionBuilder.staticMethod(DatetimeLongCoercerLocalDateTime.class, "coerceLDTToMilliWTimezone", CodegenExpressionBuilder.ref("target"), CodegenExpressionBuilder.member(tz.getMemberId())));
        block.methodReturn(forge.intervalForge.codegen(CodegenExpressionBuilder.ref("time"), CodegenExpressionBuilder.ref("time"), methodNode, exprSymbol, codegenClassScope));
        return CodegenExpressionBuilder.localMethod(methodNode, inner);
    }

    @Override
    public Object evaluate(Object startTimestamp, Object endTimestamp, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        LocalDateTime start = (LocalDateTime)startTimestamp;
        LocalDateTime end = (LocalDateTime)endTimestamp;
        long deltaMSec = DatetimeLongCoercerLocalDateTime.coerceLDTToMilliWTimezone(end, this.timeZone) - DatetimeLongCoercerLocalDateTime.coerceLDTToMilliWTimezone(start, this.timeZone);
        LocalDateTime result = DTLocalUtil.evaluateCalOpsLDT(this.calendarOps, start, eventsPerStream, isNewData, exprEvaluatorContext);
        long startLong = DatetimeLongCoercerLocalDateTime.coerceLDTToMilliWTimezone(result, this.timeZone);
        long endTime = startLong + deltaMSec;
        return this.intervalOp.evaluate(startLong, endTime, eventsPerStream, isNewData, exprEvaluatorContext);
    }

    public static CodegenExpression codegen(DTLocalLocalDateTimeOpsIntervalForge forge, CodegenExpressionRef start, CodegenExpressionRef end, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenMember tz = codegenClassScope.makeAddMember(TimeZone.class, forge.timeZone);
        CodegenMethodNode methodNode = codegenMethodScope.makeChild(Boolean.class, DTLocalCalOpsIntervalEval.class, codegenClassScope).addParam(LocalDateTime.class, "start").addParam(LocalDateTime.class, "end");
        CodegenBlock block = methodNode.getBlock().declareVar(Long.TYPE, "startMs", CodegenExpressionBuilder.staticMethod(DatetimeLongCoercerLocalDateTime.class, "coerceLDTToMilliWTimezone", CodegenExpressionBuilder.ref("start"), CodegenExpressionBuilder.member(tz.getMemberId()))).declareVar(Long.TYPE, "endMs", CodegenExpressionBuilder.staticMethod(DatetimeLongCoercerLocalDateTime.class, "coerceLDTToMilliWTimezone", CodegenExpressionBuilder.ref("end"), CodegenExpressionBuilder.member(tz.getMemberId()))).declareVar(Long.TYPE, "deltaMSec", CodegenExpressionBuilder.op(CodegenExpressionBuilder.ref("endMs"), "-", CodegenExpressionBuilder.ref("startMs"))).declareVar(LocalDateTime.class, "result", (CodegenExpression)start);
        DTLocalUtil.evaluateCalOpsLDTCodegen(block, "result", forge.calendarForges, methodNode, exprSymbol, codegenClassScope);
        block.declareVar(Long.TYPE, "startLong", CodegenExpressionBuilder.staticMethod(DatetimeLongCoercerLocalDateTime.class, "coerceLDTToMilliWTimezone", CodegenExpressionBuilder.ref("result"), CodegenExpressionBuilder.member(tz.getMemberId())));
        block.declareVar(Long.TYPE, "endTime", CodegenExpressionBuilder.op(CodegenExpressionBuilder.ref("startLong"), "+", CodegenExpressionBuilder.ref("deltaMSec")));
        block.methodReturn(forge.intervalForge.codegen(CodegenExpressionBuilder.ref("startLong"), CodegenExpressionBuilder.ref("endTime"), methodNode, exprSymbol, codegenClassScope));
        return CodegenExpressionBuilder.localMethod(methodNode, start, end);
    }
}

