/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.datetime.dtlocal;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.codegen.base.CodegenBlock;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMember;
import com.espertech.esper.codegen.base.CodegenMethodNode;
import com.espertech.esper.codegen.base.CodegenMethodScope;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.epl.datetime.calop.CalendarOp;
import com.espertech.esper.epl.datetime.dtlocal.DTLocalCalOpsLongForge;
import com.espertech.esper.epl.datetime.dtlocal.DTLocalEvaluator;
import com.espertech.esper.epl.datetime.dtlocal.DTLocalEvaluatorCalOpsCalBase;
import com.espertech.esper.epl.datetime.dtlocal.DTLocalUtil;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.time.TimeAbacus;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;

public class DTLocalCalOpsLongEval
extends DTLocalEvaluatorCalOpsCalBase
implements DTLocalEvaluator {
    private final TimeZone timeZone;
    private final TimeAbacus timeAbacus;

    public DTLocalCalOpsLongEval(List<CalendarOp> calendarOps, TimeZone timeZone, TimeAbacus timeAbacus) {
        super(calendarOps);
        this.timeZone = timeZone;
        this.timeAbacus = timeAbacus;
    }

    @Override
    public Object evaluate(Object target, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Long longValue = (Long)target;
        Calendar cal = Calendar.getInstance(this.timeZone);
        long remainder = this.timeAbacus.calendarSet(longValue, cal);
        DTLocalUtil.evaluateCalOpsCalendar(this.calendarOps, cal, eventsPerStream, isNewData, exprEvaluatorContext);
        return this.timeAbacus.calendarGet(cal, remainder);
    }

    public static CodegenExpression codegen(DTLocalCalOpsLongForge forge, CodegenExpression inner, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenMember tz = codegenClassScope.makeAddMember(TimeZone.class, forge.timeZone);
        CodegenMethodNode methodNode = codegenMethodScope.makeChild(Long.TYPE, DTLocalCalOpsLongEval.class, codegenClassScope).addParam(Long.TYPE, "target");
        CodegenBlock block = methodNode.getBlock().declareVar(Calendar.class, "cal", CodegenExpressionBuilder.staticMethod(Calendar.class, "getInstance", CodegenExpressionBuilder.member(tz.getMemberId()))).declareVar(Long.TYPE, "remainder", forge.timeAbacus.calendarSetCodegen(CodegenExpressionBuilder.ref("target"), CodegenExpressionBuilder.ref("cal"), methodNode, codegenClassScope));
        DTLocalUtil.evaluateCalOpsCalendarCodegen(block, forge.calendarForges, CodegenExpressionBuilder.ref("cal"), methodNode, exprSymbol, codegenClassScope);
        block.methodReturn(forge.timeAbacus.calendarGetCodegen(CodegenExpressionBuilder.ref("cal"), CodegenExpressionBuilder.ref("remainder"), codegenClassScope));
        return CodegenExpressionBuilder.localMethod(methodNode, inner);
    }
}

