/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.datetime.dtlocal;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.codegen.base.CodegenBlock;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMember;
import com.espertech.esper.codegen.base.CodegenMethodNode;
import com.espertech.esper.codegen.base.CodegenMethodScope;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.codegen.model.expression.CodegenExpressionRef;
import com.espertech.esper.epl.datetime.calop.CalendarOp;
import com.espertech.esper.epl.datetime.dtlocal.DTLocalCalOpsIntervalForge;
import com.espertech.esper.epl.datetime.dtlocal.DTLocalEvaluatorCalOpsIntervalBase;
import com.espertech.esper.epl.datetime.dtlocal.DTLocalUtil;
import com.espertech.esper.epl.datetime.interval.IntervalOp;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;

public class DTLocalCalOpsIntervalEval
extends DTLocalEvaluatorCalOpsIntervalBase {
    private final TimeZone timeZone;

    public DTLocalCalOpsIntervalEval(List<CalendarOp> calendarOps, IntervalOp intervalOp, TimeZone timeZone) {
        super(calendarOps, intervalOp);
        this.timeZone = timeZone;
    }

    @Override
    public Object evaluate(Object target, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Calendar cal = (Calendar)((Calendar)target).clone();
        DTLocalUtil.evaluateCalOpsCalendar(this.calendarOps, cal, eventsPerStream, isNewData, exprEvaluatorContext);
        long time = cal.getTimeInMillis();
        return this.intervalOp.evaluate(time, time, eventsPerStream, isNewData, exprEvaluatorContext);
    }

    public static CodegenExpression codegenPointInTime(DTLocalCalOpsIntervalForge forge, CodegenExpression inner, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenMethodNode methodNode = codegenMethodScope.makeChild(Boolean.class, DTLocalCalOpsIntervalEval.class, codegenClassScope).addParam(Calendar.class, "target");
        CodegenBlock block = methodNode.getBlock().declareVar(Calendar.class, "cal", CodegenExpressionBuilder.cast(Calendar.class, CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("target"), "clone", new CodegenExpression[0])));
        DTLocalUtil.evaluateCalOpsCalendarCodegen(block, forge.calendarForges, CodegenExpressionBuilder.ref("cal"), methodNode, exprSymbol, codegenClassScope);
        block.declareVar(Long.TYPE, "time", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("cal"), "getTimeInMillis", new CodegenExpression[0])).methodReturn(forge.intervalForge.codegen(CodegenExpressionBuilder.ref("time"), CodegenExpressionBuilder.ref("time"), methodNode, exprSymbol, codegenClassScope));
        return CodegenExpressionBuilder.localMethod(methodNode, inner);
    }

    @Override
    public Object evaluate(Object startTimestamp, Object endTimestamp, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        long startLong = ((Calendar)startTimestamp).getTimeInMillis();
        long endLong = ((Calendar)endTimestamp).getTimeInMillis();
        Calendar cal = Calendar.getInstance(this.timeZone);
        cal.setTimeInMillis(startLong);
        DTLocalUtil.evaluateCalOpsCalendar(this.calendarOps, cal, eventsPerStream, isNewData, exprEvaluatorContext);
        long startTime = cal.getTimeInMillis();
        long endTime = startTime + (endLong - startLong);
        return this.intervalOp.evaluate(startTime, endTime, eventsPerStream, isNewData, exprEvaluatorContext);
    }

    public static CodegenExpression codegenStartEnd(DTLocalCalOpsIntervalForge forge, CodegenExpressionRef start, CodegenExpressionRef end, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenMember tz = codegenClassScope.makeAddMember(TimeZone.class, forge.timeZone);
        CodegenMethodNode methodNode = codegenMethodScope.makeChild(Boolean.class, DTLocalCalOpsIntervalEval.class, codegenClassScope).addParam(Calendar.class, "startTimestamp").addParam(Calendar.class, "endTimestamp");
        CodegenBlock block = methodNode.getBlock().declareVar(Long.TYPE, "startLong", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("startTimestamp"), "getTimeInMillis", new CodegenExpression[0])).declareVar(Long.TYPE, "endLong", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("endTimestamp"), "getTimeInMillis", new CodegenExpression[0])).declareVar(Calendar.class, "cal", CodegenExpressionBuilder.staticMethod(Calendar.class, "getInstance", CodegenExpressionBuilder.member(tz.getMemberId()))).expression(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("cal"), "setTimeInMillis", CodegenExpressionBuilder.ref("startLong")));
        DTLocalUtil.evaluateCalOpsCalendarCodegen(block, forge.calendarForges, CodegenExpressionBuilder.ref("cal"), methodNode, exprSymbol, codegenClassScope);
        block.declareVar(Long.TYPE, "startTime", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("cal"), "getTimeInMillis", new CodegenExpression[0])).declareVar(Long.TYPE, "endTime", CodegenExpressionBuilder.op(CodegenExpressionBuilder.ref("startTime"), "+", CodegenExpressionBuilder.op(CodegenExpressionBuilder.ref("endLong"), "-", CodegenExpressionBuilder.ref("startLong")))).methodReturn(forge.intervalForge.codegen(CodegenExpressionBuilder.ref("startTime"), CodegenExpressionBuilder.ref("endTime"), methodNode, exprSymbol, codegenClassScope));
        return CodegenExpressionBuilder.localMethod(methodNode, start, end);
    }
}

