/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.datetime.calop;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.codegen.base.CodegenBlock;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMethodNode;
import com.espertech.esper.codegen.base.CodegenMethodScope;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.epl.datetime.calop.CalendarOp;
import com.espertech.esper.epl.datetime.calop.CalendarWithDateForge;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.util.SimpleNumberCoercerFactory;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Calendar;

public class CalendarWithDateForgeOp
implements CalendarOp {
    public static final String METHOD_ACTIONSETYMDCALENDAR = "actionSetYMDCalendar";
    private ExprEvaluator year;
    private ExprEvaluator month;
    private ExprEvaluator day;

    public CalendarWithDateForgeOp(ExprEvaluator year, ExprEvaluator month, ExprEvaluator day) {
        this.year = year;
        this.month = month;
        this.day = day;
    }

    @Override
    public void evaluate(Calendar cal, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        Integer yearNum = CalendarWithDateForgeOp.getInt(this.year, eventsPerStream, isNewData, context);
        Integer monthNum = CalendarWithDateForgeOp.getInt(this.month, eventsPerStream, isNewData, context);
        Integer dayNum = CalendarWithDateForgeOp.getInt(this.day, eventsPerStream, isNewData, context);
        CalendarWithDateForgeOp.actionSetYMDCalendar(cal, yearNum, monthNum, dayNum);
    }

    public static CodegenExpression codegenCalendar(CalendarWithDateForge forge, CodegenExpression cal, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenMethodNode methodNode = codegenMethodScope.makeChild(Void.TYPE, CalendarWithDateForgeOp.class, codegenClassScope).addParam(Calendar.class, "value");
        CodegenBlock block = methodNode.getBlock();
        CalendarWithDateForgeOp.codegenDeclareInts(block, forge, methodNode, exprSymbol, codegenClassScope);
        block.staticMethod(CalendarWithDateForgeOp.class, METHOD_ACTIONSETYMDCALENDAR, CodegenExpressionBuilder.ref("value"), CodegenExpressionBuilder.ref("year"), CodegenExpressionBuilder.ref("month"), CodegenExpressionBuilder.ref("day")).methodEnd();
        return CodegenExpressionBuilder.localMethod(methodNode, cal);
    }

    @Override
    public LocalDateTime evaluate(LocalDateTime ldt, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        Integer yearNum = CalendarWithDateForgeOp.getInt(this.year, eventsPerStream, isNewData, context);
        Integer monthNum = CalendarWithDateForgeOp.getInt(this.month, eventsPerStream, isNewData, context);
        Integer dayNum = CalendarWithDateForgeOp.getInt(this.day, eventsPerStream, isNewData, context);
        return CalendarWithDateForgeOp.actionSetYMDLocalDateTime(ldt, yearNum, monthNum, dayNum);
    }

    public static CodegenExpression codegenLDT(CalendarWithDateForge forge, CodegenExpression ldt, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenMethodNode methodNode = codegenMethodScope.makeChild(LocalDateTime.class, CalendarWithDateForgeOp.class, codegenClassScope).addParam(LocalDateTime.class, "value");
        CodegenBlock block = methodNode.getBlock();
        CalendarWithDateForgeOp.codegenDeclareInts(block, forge, methodNode, exprSymbol, codegenClassScope);
        block.methodReturn(CodegenExpressionBuilder.staticMethod(CalendarWithDateForgeOp.class, "actionSetYMDLocalDateTime", CodegenExpressionBuilder.ref("value"), CodegenExpressionBuilder.ref("year"), CodegenExpressionBuilder.ref("month"), CodegenExpressionBuilder.ref("day")));
        return CodegenExpressionBuilder.localMethod(methodNode, ldt);
    }

    @Override
    public ZonedDateTime evaluate(ZonedDateTime zdt, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        Integer yearNum = CalendarWithDateForgeOp.getInt(this.year, eventsPerStream, isNewData, context);
        Integer monthNum = CalendarWithDateForgeOp.getInt(this.month, eventsPerStream, isNewData, context);
        Integer dayNum = CalendarWithDateForgeOp.getInt(this.day, eventsPerStream, isNewData, context);
        return CalendarWithDateForgeOp.actionSetYMDZonedDateTime(zdt, yearNum, monthNum, dayNum);
    }

    public static CodegenExpression codegenZDT(CalendarWithDateForge forge, CodegenExpression zdt, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenMethodNode methodNode = codegenMethodScope.makeChild(ZonedDateTime.class, CalendarWithDateForgeOp.class, codegenClassScope).addParam(ZonedDateTime.class, "value");
        CodegenBlock block = methodNode.getBlock();
        CalendarWithDateForgeOp.codegenDeclareInts(block, forge, methodNode, exprSymbol, codegenClassScope);
        block.methodReturn(CodegenExpressionBuilder.staticMethod(CalendarWithDateForgeOp.class, "actionSetYMDZonedDateTime", CodegenExpressionBuilder.ref("value"), CodegenExpressionBuilder.ref("year"), CodegenExpressionBuilder.ref("month"), CodegenExpressionBuilder.ref("day")));
        return CodegenExpressionBuilder.localMethod(methodNode, zdt);
    }

    protected static Integer getInt(ExprEvaluator expr, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        Object result = expr.evaluate(eventsPerStream, isNewData, context);
        if (result == null) {
            return null;
        }
        return (Integer)result;
    }

    public static void actionSetYMDCalendar(Calendar cal, Integer year, Integer month, Integer day) {
        if (year != null) {
            cal.set(1, year);
        }
        if (month != null) {
            cal.set(2, month);
        }
        if (day != null) {
            cal.set(5, day);
        }
    }

    public static LocalDateTime actionSetYMDLocalDateTime(LocalDateTime ldt, Integer year, Integer month, Integer day) {
        if (year != null) {
            ldt = ldt.withYear(year);
        }
        if (month != null) {
            ldt = ldt.withMonth(month);
        }
        if (day != null) {
            ldt = ldt.withDayOfMonth(day);
        }
        return ldt;
    }

    public static ZonedDateTime actionSetYMDZonedDateTime(ZonedDateTime zdt, Integer year, Integer month, Integer day) {
        if (year != null) {
            zdt = zdt.withYear(year);
        }
        if (month != null) {
            zdt = zdt.withMonth(month);
        }
        if (day != null) {
            zdt = zdt.withDayOfMonth(day);
        }
        return zdt;
    }

    private static void codegenDeclareInts(CodegenBlock block, CalendarWithDateForge forge, CodegenMethodNode methodNode, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        Class yearType = forge.year.getEvaluationType();
        Class monthType = forge.month.getEvaluationType();
        Class dayType = forge.day.getEvaluationType();
        block.declareVar(Integer.class, "year", SimpleNumberCoercerFactory.SimpleNumberCoercerInt.coerceCodegenMayNull(forge.year.evaluateCodegen(yearType, methodNode, exprSymbol, codegenClassScope), yearType, methodNode, codegenClassScope)).declareVar(Integer.class, "month", SimpleNumberCoercerFactory.SimpleNumberCoercerInt.coerceCodegenMayNull(forge.month.evaluateCodegen(monthType, methodNode, exprSymbol, codegenClassScope), monthType, methodNode, codegenClassScope)).declareVar(Integer.class, "day", SimpleNumberCoercerFactory.SimpleNumberCoercerInt.coerceCodegenMayNull(forge.day.evaluateCodegen(dayType, methodNode, exprSymbol, codegenClassScope), dayType, methodNode, codegenClassScope));
    }
}

