/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.datetime.calop;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMethodScope;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.epl.datetime.calop.ApacheCommonsDateUtils;
import com.espertech.esper.epl.datetime.calop.CalendarFieldEnum;
import com.espertech.esper.epl.datetime.calop.CalendarForge;
import com.espertech.esper.epl.datetime.calop.CalendarOp;
import com.espertech.esper.epl.datetime.eval.DatetimeMethodEnum;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;

public class CalendarForgeRound
implements CalendarForge,
CalendarOp {
    private final CalendarFieldEnum fieldName;
    private final int code;

    public CalendarForgeRound(CalendarFieldEnum fieldName, DatetimeMethodEnum method) {
        this.fieldName = fieldName;
        if (method == DatetimeMethodEnum.ROUNDCEILING) {
            this.code = 2;
        } else if (method == DatetimeMethodEnum.ROUNDFLOOR) {
            this.code = 0;
        } else if (method == DatetimeMethodEnum.ROUNDHALF) {
            this.code = 1;
        } else {
            throw new IllegalArgumentException("Unrecognized method '" + (Object)((Object)method) + "'");
        }
    }

    @Override
    public CalendarOp getEvalOp() {
        return this;
    }

    @Override
    public CodegenExpression codegenCalendar(CodegenExpression cal, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.staticMethod(ApacheCommonsDateUtils.class, "modify", cal, CodegenExpressionBuilder.constant(this.fieldName.getCalendarField()), CodegenExpressionBuilder.constant(this.code));
    }

    @Override
    public void evaluate(Calendar cal, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        ApacheCommonsDateUtils.modify(cal, this.fieldName.getCalendarField(), this.code);
    }

    @Override
    public LocalDateTime evaluate(LocalDateTime ldt, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        if (this.code == 0) {
            return ldt.truncatedTo(this.fieldName.getChronoUnit());
        }
        if (this.code == 2) {
            return ldt.plus(1L, this.fieldName.getChronoUnit()).truncatedTo(this.fieldName.getChronoUnit());
        }
        throw new EPException("Round-half operation not supported for LocalDateTime");
    }

    @Override
    public CodegenExpression codegenLDT(CodegenExpression ldt, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return this.codegenLDTZDT(ldt, LocalDateTime.class);
    }

    @Override
    public ZonedDateTime evaluate(ZonedDateTime zdt, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        if (this.code == 0) {
            return zdt.truncatedTo(this.fieldName.getChronoUnit());
        }
        if (this.code == 2) {
            return zdt.plus(1L, this.fieldName.getChronoUnit()).truncatedTo(this.fieldName.getChronoUnit());
        }
        throw new EPException("Round-half operation not supported for ZonedDateTime");
    }

    @Override
    public CodegenExpression codegenZDT(CodegenExpression zdt, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return this.codegenLDTZDT(zdt, ZonedDateTime.class);
    }

    private CodegenExpression codegenLDTZDT(CodegenExpression val, Class type) {
        CodegenExpression chronoUnit = CodegenExpressionBuilder.enumValue(ChronoUnit.class, this.fieldName.getChronoUnit().name());
        if (this.code == 0) {
            return CodegenExpressionBuilder.exprDotMethod(val, "truncatedTo", chronoUnit);
        }
        if (this.code == 2) {
            return CodegenExpressionBuilder.exprDotMethodChain(val).add("plus", CodegenExpressionBuilder.constant(1), chronoUnit).add("truncatedTo", chronoUnit);
        }
        throw new EPException("Round-half operation not supported for " + type.getSimpleName());
    }
}

