/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core.select;

import com.espertech.esper.client.EventType;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMethodNode;
import com.espertech.esper.core.service.speccompiled.SelectClauseStreamCompiledSpec;
import com.espertech.esper.epl.core.engineimport.EngineImportService;
import com.espertech.esper.epl.core.select.BindProcessor;
import com.espertech.esper.epl.core.select.BindProcessorEvaluatorStreamTable;
import com.espertech.esper.epl.core.select.BindProcessorStream;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprForge;
import com.espertech.esper.epl.expression.core.ExprNodeUtilityCore;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.spec.SelectClauseElementCompiled;
import com.espertech.esper.epl.spec.SelectClauseElementWildcard;
import com.espertech.esper.epl.spec.SelectClauseExprCompiledSpec;
import com.espertech.esper.epl.table.mgmt.TableMetadata;
import com.espertech.esper.epl.table.mgmt.TableService;
import com.espertech.esper.epl.util.ExprNodeUtilityRich;
import java.util.ArrayList;

public class BindProcessorForge {
    private ExprForge[] expressionForges;
    private Class[] expressionTypes;
    private String[] columnNamesAssigned;

    public BindProcessorForge(SelectClauseElementCompiled[] selectionList, EventType[] typesPerStream, String[] streamNames, TableService tableService) throws ExprValidationException {
        ArrayList<ExprForge> expressions = new ArrayList<ExprForge>();
        ArrayList<Class> types = new ArrayList<Class>();
        ArrayList<String> columnNames = new ArrayList<String>();
        for (SelectClauseElementCompiled element : selectionList) {
            if (element instanceof SelectClauseElementWildcard) {
                for (int i = 0; i < typesPerStream.length; ++i) {
                    Class returnType = typesPerStream[i].getUnderlyingType();
                    TableMetadata tableMetadata = tableService.getTableMetadataFromEventType(typesPerStream[i]);
                    ExprForge forge = tableMetadata != null ? new BindProcessorEvaluatorStreamTable(i, returnType, tableMetadata) : new BindProcessorStream(i, returnType);
                    expressions.add(forge);
                    types.add(returnType);
                    columnNames.add(streamNames[i]);
                }
                continue;
            }
            if (element instanceof SelectClauseStreamCompiledSpec) {
                SelectClauseStreamCompiledSpec streamSpec = (SelectClauseStreamCompiledSpec)element;
                EventType type = typesPerStream[streamSpec.getStreamNumber()];
                Class returnType = type.getUnderlyingType();
                TableMetadata tableMetadata = tableService.getTableMetadataFromEventType(type);
                ExprForge forge = tableMetadata != null ? new BindProcessorEvaluatorStreamTable(streamSpec.getStreamNumber(), returnType, tableMetadata) : new BindProcessorStream(streamSpec.getStreamNumber(), returnType);
                expressions.add(forge);
                types.add(returnType);
                columnNames.add(streamNames[streamSpec.getStreamNumber()]);
                continue;
            }
            if (element instanceof SelectClauseExprCompiledSpec) {
                SelectClauseExprCompiledSpec expr = (SelectClauseExprCompiledSpec)element;
                ExprForge forge = expr.getSelectExpression().getForge();
                expressions.add(forge);
                types.add(forge.getEvaluationType());
                if (expr.getAssignedName() != null) {
                    columnNames.add(expr.getAssignedName());
                    continue;
                }
                columnNames.add(ExprNodeUtilityCore.toExpressionStringMinPrecedenceSafe(expr.getSelectExpression()));
                continue;
            }
            throw new IllegalStateException("Unrecognized select expression element of type " + element.getClass());
        }
        this.expressionForges = expressions.toArray(new ExprForge[expressions.size()]);
        this.expressionTypes = types.toArray(new Class[types.size()]);
        this.columnNamesAssigned = columnNames.toArray(new String[columnNames.size()]);
    }

    public BindProcessor getBindProcessor(EngineImportService engineImportService, boolean isFireAndForget, String statementName) {
        ExprEvaluator[] evaluators = ExprNodeUtilityRich.getEvaluatorsMayCompile(this.expressionForges, engineImportService, this.getClass(), isFireAndForget, statementName);
        return new BindProcessor(this, evaluators);
    }

    public CodegenMethodNode processCodegen(CodegenMethodNode methodNode, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return BindProcessor.processCodegen(this, methodNode, exprSymbol, codegenClassScope);
    }

    public Class[] getExpressionTypes() {
        return this.expressionTypes;
    }

    public String[] getColumnNamesAssigned() {
        return this.columnNamesAssigned;
    }

    public ExprForge[] getExpressionForges() {
        return this.expressionForges;
    }
}

