/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core.select;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMember;
import com.espertech.esper.codegen.base.CodegenMethodScope;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.codegen.model.expression.CodegenExpressionRef;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprForge;
import com.espertech.esper.epl.expression.core.ExprForgeComplexityEnum;
import com.espertech.esper.epl.expression.core.ExprNodeRenderable;
import com.espertech.esper.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.epl.table.mgmt.TableMetadata;
import com.espertech.esper.epl.table.mgmt.TableMetadataInternalEventToPublic;
import java.io.StringWriter;

public class BindProcessorEvaluatorStreamTable
implements ExprForge,
ExprEvaluator,
ExprNodeRenderable {
    private final int streamNum;
    private final Class returnType;
    private final TableMetadata tableMetadata;

    public BindProcessorEvaluatorStreamTable(int streamNum, Class returnType, TableMetadata tableMetadata) {
        this.streamNum = streamNum;
        this.returnType = returnType;
        this.tableMetadata = tableMetadata;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        return BindProcessorEvaluatorStreamTable.evaluateConvertTableEventToUnd(this.streamNum, this.tableMetadata.getEventToPublic(), eventsPerStream, isNewData, exprEvaluatorContext);
    }

    @Override
    public CodegenExpression evaluateCodegen(Class requiredType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenMember eventToPublic = codegenClassScope.makeAddMember(TableMetadataInternalEventToPublic.class, this.tableMetadata.getEventToPublic());
        CodegenExpressionRef refEPS = exprSymbol.getAddEPS(codegenMethodScope);
        CodegenExpression refIsNewData = exprSymbol.getAddIsNewData(codegenMethodScope);
        CodegenExpressionRef refExprEvalCtx = exprSymbol.getAddExprEvalCtx(codegenMethodScope);
        return CodegenExpressionBuilder.staticMethod(BindProcessorEvaluatorStreamTable.class, "evaluateConvertTableEventToUnd", CodegenExpressionBuilder.constant(this.streamNum), CodegenExpressionBuilder.member(eventToPublic.getMemberId()), refEPS, refIsNewData, refExprEvalCtx);
    }

    @Override
    public ExprForgeComplexityEnum getComplexity() {
        return ExprForgeComplexityEnum.SINGLE;
    }

    public static Object[] evaluateConvertTableEventToUnd(int streamNum, TableMetadataInternalEventToPublic eventToPublic, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        EventBean event = eventsPerStream[streamNum];
        if (event == null) {
            return null;
        }
        return eventToPublic.convertToUnd(event, eventsPerStream, isNewData, context);
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    @Override
    public Class getEvaluationType() {
        return this.returnType;
    }

    @Override
    public ExprNodeRenderable getForgeRenderable() {
        return this;
    }

    @Override
    public void toEPL(StringWriter writer, ExprPrecedenceEnum parentPrecedence) {
        writer.append(this.getClass().getSimpleName());
    }
}

