/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core.resultset.handthru;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.epl.agg.service.common.AggregationService;
import com.espertech.esper.epl.core.orderby.OrderByProcessor;
import com.espertech.esper.epl.core.resultset.core.ResultSetProcessor;
import com.espertech.esper.epl.core.resultset.core.ResultSetProcessorFactory;
import com.espertech.esper.epl.core.resultset.core.ResultSetProcessorHelperFactory;
import com.espertech.esper.epl.core.resultset.core.ResultSetProcessorOutputConditionType;
import com.espertech.esper.epl.core.resultset.handthru.ResultSetProcessorSimpleImpl;
import com.espertech.esper.epl.core.select.SelectExprProcessor;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.spec.OutputLimitLimitType;
import com.espertech.esper.epl.spec.OutputLimitSpec;

public class ResultSetProcessorSimpleFactory
implements ResultSetProcessorFactory {
    private final EventType resultEventType;
    private final boolean isSelectRStream;
    private final SelectExprProcessor selectExprProcessor;
    private final ExprEvaluator optionalHavingExpr;
    private final OutputLimitSpec outputLimitSpec;
    private final ResultSetProcessorOutputConditionType outputConditionType;
    private final ResultSetProcessorHelperFactory resultSetProcessorHelperFactory;
    private final int numStreams;

    public ResultSetProcessorSimpleFactory(EventType resultEventType, SelectExprProcessor selectExprProcessor, ExprEvaluator optionalHavingNode, boolean isSelectRStream, OutputLimitSpec outputLimitSpec, ResultSetProcessorOutputConditionType outputConditionType, ResultSetProcessorHelperFactory resultSetProcessorHelperFactory, int numStreams) {
        this.resultEventType = resultEventType;
        this.selectExprProcessor = selectExprProcessor;
        this.optionalHavingExpr = optionalHavingNode;
        this.isSelectRStream = isSelectRStream;
        this.outputLimitSpec = outputLimitSpec;
        this.outputConditionType = outputConditionType;
        this.resultSetProcessorHelperFactory = resultSetProcessorHelperFactory;
        this.numStreams = numStreams;
    }

    @Override
    public ResultSetProcessor instantiate(OrderByProcessor orderByProcessor, AggregationService aggregationService, AgentInstanceContext agentInstanceContext) {
        return new ResultSetProcessorSimpleImpl(this, this.selectExprProcessor, orderByProcessor, agentInstanceContext);
    }

    public EventType getResultEventType() {
        return this.resultEventType;
    }

    public boolean isSelectRStream() {
        return this.isSelectRStream;
    }

    public ExprEvaluator getOptionalHavingNode() {
        return this.optionalHavingExpr;
    }

    public boolean isOutputLast() {
        return this.outputLimitSpec != null && this.outputLimitSpec.getDisplayLimit() == OutputLimitLimitType.LAST;
    }

    public boolean isOutputAll() {
        return this.outputLimitSpec != null && this.outputLimitSpec.getDisplayLimit() == OutputLimitLimitType.ALL;
    }

    public ResultSetProcessorOutputConditionType getOutputConditionType() {
        return this.outputConditionType;
    }

    public ResultSetProcessorHelperFactory getResultSetProcessorHelperFactory() {
        return this.resultSetProcessorHelperFactory;
    }

    public int getNumStreams() {
        return this.numStreams;
    }
}

