/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core.resultset.core;

import com.espertech.esper.client.ConfigurationInformation;
import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.annotation.HookType;
import com.espertech.esper.client.annotation.IterableUnbound;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.core.context.util.ContextPropertyRegistry;
import com.espertech.esper.core.service.ExprEvaluatorContextStatement;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.core.service.speccompiled.SelectClauseStreamCompiledSpec;
import com.espertech.esper.core.service.speccompiled.StatementSpecCompiled;
import com.espertech.esper.epl.agg.rollup.GroupByRollupPerLevelForge;
import com.espertech.esper.epl.agg.rollup.GroupByRollupPlanDesc;
import com.espertech.esper.epl.agg.rollup.GroupByRollupPlanHook;
import com.espertech.esper.epl.agg.service.common.AggregationGroupByRollupDesc;
import com.espertech.esper.epl.agg.service.common.AggregationGroupByRollupLevel;
import com.espertech.esper.epl.agg.service.common.AggregationServiceFactoryFactory;
import com.espertech.esper.epl.agg.service.common.AggregationServiceForgeDesc;
import com.espertech.esper.epl.annotation.AnnotationUtil;
import com.espertech.esper.epl.core.engineimport.EngineImportUtil;
import com.espertech.esper.epl.core.orderby.OrderByElementForge;
import com.espertech.esper.epl.core.orderby.OrderByProcessorFactoryFactory;
import com.espertech.esper.epl.core.orderby.OrderByProcessorFactoryForge;
import com.espertech.esper.epl.core.resultset.agggrouped.ResultSetProcessorAggregateGroupedForge;
import com.espertech.esper.epl.core.resultset.codegen.ResultSetProcessorFactoryCompiler;
import com.espertech.esper.epl.core.resultset.core.ColumnNamedNodeSwapper;
import com.espertech.esper.epl.core.resultset.core.GroupByRollupInfo;
import com.espertech.esper.epl.core.resultset.core.ResultSetProcessorFactoryDesc;
import com.espertech.esper.epl.core.resultset.core.ResultSetProcessorFactoryForge;
import com.espertech.esper.epl.core.resultset.core.ResultSetProcessorHelperFactory;
import com.espertech.esper.epl.core.resultset.core.ResultSetProcessorOutputConditionType;
import com.espertech.esper.epl.core.resultset.core.ResultSetProcessorType;
import com.espertech.esper.epl.core.resultset.handthru.ResultSetProcessorHandThroughFactoryForge;
import com.espertech.esper.epl.core.resultset.handthru.ResultSetProcessorSimpleForge;
import com.espertech.esper.epl.core.resultset.rowforall.ResultSetProcessorRowForAllForge;
import com.espertech.esper.epl.core.resultset.rowperevent.ResultSetProcessorRowPerEventForge;
import com.espertech.esper.epl.core.resultset.rowpergroup.ResultSetProcessorRowPerGroupForge;
import com.espertech.esper.epl.core.resultset.rowpergrouprollup.ResultSetProcessorRowPerGroupRollupForge;
import com.espertech.esper.epl.core.select.SelectExprEventTypeRegistry;
import com.espertech.esper.epl.core.select.SelectExprProcessorDeliveryCallback;
import com.espertech.esper.epl.core.select.SelectExprProcessorFactory;
import com.espertech.esper.epl.core.select.SelectExprProcessorForge;
import com.espertech.esper.epl.core.streamtype.PropertyResolutionDescriptor;
import com.espertech.esper.epl.core.streamtype.StreamTypeService;
import com.espertech.esper.epl.core.streamtype.StreamTypeServiceImpl;
import com.espertech.esper.epl.core.streamtype.StreamTypesException;
import com.espertech.esper.epl.core.viewres.ViewResourceDelegateUnverified;
import com.espertech.esper.epl.declexpr.ExprDeclaredNode;
import com.espertech.esper.epl.expression.baseagg.ExprAggregateNode;
import com.espertech.esper.epl.expression.baseagg.ExprAggregateNodeUtil;
import com.espertech.esper.epl.expression.core.ExprConstantNodeImpl;
import com.espertech.esper.epl.expression.core.ExprForge;
import com.espertech.esper.epl.expression.core.ExprGroupingIdNode;
import com.espertech.esper.epl.expression.core.ExprGroupingNode;
import com.espertech.esper.epl.expression.core.ExprIdentNode;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeBase;
import com.espertech.esper.epl.expression.core.ExprNodeOrigin;
import com.espertech.esper.epl.expression.core.ExprNodePropOrStreamDesc;
import com.espertech.esper.epl.expression.core.ExprNodePropOrStreamExprDesc;
import com.espertech.esper.epl.expression.core.ExprNodePropOrStreamPropDesc;
import com.espertech.esper.epl.expression.core.ExprNodePropOrStreamSet;
import com.espertech.esper.epl.expression.core.ExprNodeUtilityCore;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.prev.ExprPreviousNode;
import com.espertech.esper.epl.expression.prior.ExprPriorNode;
import com.espertech.esper.epl.expression.time.ExprTimePeriod;
import com.espertech.esper.epl.expression.visitor.ExprNodeDeclaredVisitor;
import com.espertech.esper.epl.expression.visitor.ExprNodeGroupingVisitorWParent;
import com.espertech.esper.epl.expression.visitor.ExprNodeIdentifierAndStreamRefVisitor;
import com.espertech.esper.epl.expression.visitor.ExprNodeIdentifierCollectVisitorWContainer;
import com.espertech.esper.epl.expression.visitor.ExprNodeSubselectDeclaredDotVisitor;
import com.espertech.esper.epl.spec.DBStatementStreamSpec;
import com.espertech.esper.epl.spec.GroupByClauseExpressions;
import com.espertech.esper.epl.spec.InsertIntoDesc;
import com.espertech.esper.epl.spec.MethodStreamSpec;
import com.espertech.esper.epl.spec.OrderByItem;
import com.espertech.esper.epl.spec.OutputLimitLimitType;
import com.espertech.esper.epl.spec.OutputLimitSpec;
import com.espertech.esper.epl.spec.SelectClauseElementCompiled;
import com.espertech.esper.epl.spec.SelectClauseExprCompiledSpec;
import com.espertech.esper.epl.spec.SelectClauseSpecCompiled;
import com.espertech.esper.epl.spec.SelectClauseStreamSelectorEnum;
import com.espertech.esper.epl.spec.StreamSpecCompiled;
import com.espertech.esper.epl.spec.TableQueryStreamSpec;
import com.espertech.esper.epl.table.mgmt.TableMetadata;
import com.espertech.esper.epl.util.ExprNodeUtilityRich;
import com.espertech.esper.epl.view.OutputConditionPolledFactory;
import com.espertech.esper.epl.view.OutputConditionPolledFactoryFactory;
import com.espertech.esper.event.NativeEventType;
import com.espertech.esper.util.CollectionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultSetProcessorFactoryFactory {
    private static final Logger log = LoggerFactory.getLogger(ResultSetProcessorFactoryFactory.class);

    public static ResultSetProcessorFactoryDesc getProcessorPrototype(StatementSpecCompiled statementSpec, StatementContext stmtContext, StreamTypeService typeService, ViewResourceDelegateUnverified viewResourceDelegate, boolean[] isUnidirectionalStream, boolean allowAggregation, ContextPropertyRegistry contextPropertyRegistry, SelectExprProcessorDeliveryCallback selectExprProcessorCallback, ConfigurationInformation configurationInformation, ResultSetProcessorHelperFactory resultSetProcessorHelperFactory, boolean isFireAndForget, boolean isOnSelect) throws ExprValidationException {
        ExprNodePropOrStreamSet nonAggregatedPropsOrderBy;
        boolean allInSelect;
        String reasonMessage;
        boolean isFirst;
        boolean hasOutputLimit;
        boolean isSelectRStream;
        boolean isAggregated;
        GroupByRollupInfo groupByRollupInfo;
        int numStreams;
        StreamSpecCompiled spec;
        OrderByItem[] orderByListUnexpanded = statementSpec.getOrderByList();
        SelectClauseSpecCompiled selectClauseSpec = statementSpec.getSelectClauseSpec();
        InsertIntoDesc insertIntoDesc = statementSpec.getInsertIntoDesc();
        ExprNode optionalHavingNode = statementSpec.getHavingExprRootNode();
        OutputLimitSpec outputLimitSpec = statementSpec.getOutputLimitSpec();
        ArrayList<ExprDeclaredNode> declaredNodes = new ArrayList<ExprDeclaredNode>();
        ResultSetProcessorFactoryFactory.validateOutputLimit(outputLimitSpec, stmtContext);
        boolean isUnidirectional = false;
        for (int i = 0; i < isUnidirectionalStream.length; ++i) {
            isUnidirectional |= isUnidirectionalStream[i];
        }
        boolean isHistoricalOnly = false;
        if (statementSpec.getStreamSpecs().length == 1 && ((spec = statementSpec.getStreamSpecs()[0]) instanceof DBStatementStreamSpec || spec instanceof MethodStreamSpec || spec instanceof TableQueryStreamSpec)) {
            isHistoricalOnly = true;
        }
        boolean join = (numStreams = typeService.getEventTypes().length) > 1;
        List<OrderByItem> orderByList = ResultSetProcessorFactoryFactory.expandColumnNames(selectClauseSpec.getSelectExprList(), orderByListUnexpanded);
        LinkedList<SelectClauseExprCompiledSpec> namedSelectionList = new LinkedList<SelectClauseExprCompiledSpec>();
        ExprEvaluatorContextStatement evaluatorContextStmt = new ExprEvaluatorContextStatement(stmtContext, false);
        boolean allowRollup = statementSpec.getGroupByExpressions() != null && statementSpec.getGroupByExpressions().getGroupByRollupLevels() != null;
        boolean resettableAggs = isUnidirectional || statementSpec.getOnTriggerDesc() != null;
        String intoTableName = statementSpec.getIntoTableSpec() == null ? null : statementSpec.getIntoTableSpec().getName();
        ExprValidationContext validationContext = new ExprValidationContext(typeService, stmtContext.getEngineImportService(), stmtContext.getStatementExtensionServicesContext(), viewResourceDelegate, stmtContext.getSchedulingService(), stmtContext.getVariableService(), stmtContext.getTableService(), evaluatorContextStmt, stmtContext.getEventAdapterService(), stmtContext.getStatementName(), stmtContext.getStatementId(), stmtContext.getAnnotations(), stmtContext.getContextDescriptor(), false, allowRollup, true, resettableAggs, intoTableName, false);
        ResultSetProcessorFactoryFactory.validateSelectAssignColNames(selectClauseSpec, namedSelectionList, validationContext);
        if (statementSpec.getGroupByExpressions() != null && statementSpec.getGroupByExpressions().getSelectClausePerLevel() != null) {
            ExprNodeUtilityRich.getValidatedSubtree(ExprNodeOrigin.GROUPBY, statementSpec.getGroupByExpressions().getSelectClausePerLevel(), validationContext);
        }
        boolean isUsingWildcard = selectClauseSpec.isUsingWildcard();
        boolean isUsingStreamSelect = false;
        for (SelectClauseElementCompiled compiled : selectClauseSpec.getSelectExprList()) {
            if (!(compiled instanceof SelectClauseStreamCompiledSpec)) continue;
            SelectClauseStreamCompiledSpec streamSelectSpec = (SelectClauseStreamCompiledSpec)compiled;
            int streamNum = Integer.MIN_VALUE;
            boolean isFragmentEvent = false;
            boolean isProperty = false;
            Object propertyType = null;
            isUsingStreamSelect = true;
            for (int i = 0; i < typeService.getStreamNames().length; ++i) {
                String streamName = streamSelectSpec.getStreamName();
                if (typeService.getStreamNames()[i].equals(streamName)) {
                    streamNum = i;
                    break;
                }
                EventType candidateProviderOfFragments = typeService.getEventTypes()[i];
                if (candidateProviderOfFragments instanceof NativeEventType || candidateProviderOfFragments.getFragmentType(streamName) == null) continue;
                streamNum = i;
                isFragmentEvent = true;
                break;
            }
            if (streamNum == Integer.MIN_VALUE) {
                PropertyResolutionDescriptor desc = null;
                try {
                    desc = typeService.resolveByPropertyName(streamSelectSpec.getStreamName(), false);
                }
                catch (StreamTypesException streamName) {
                    // empty catch block
                }
                if (desc == null) {
                    throw new ExprValidationException("Stream selector '" + streamSelectSpec.getStreamName() + ".*' does not match any stream name in the from clause");
                }
                isProperty = true;
                propertyType = desc.getPropertyType();
                streamNum = desc.getStreamNum();
            }
            streamSelectSpec.setStreamNumber(streamNum);
            streamSelectSpec.setFragmentEvent(isFragmentEvent);
            streamSelectSpec.setProperty(isProperty, (Class)propertyType);
            if (streamNum < 0) continue;
            TableMetadata tableMetadata = stmtContext.getTableService().getTableMetadataFromEventType(typeService.getEventTypes()[streamNum]);
            streamSelectSpec.setTableMetadata(tableMetadata);
        }
        if (optionalHavingNode != null) {
            optionalHavingNode = ExprNodeUtilityRich.getValidatedSubtree(ExprNodeOrigin.HAVING, optionalHavingNode, validationContext);
            if (statementSpec.getGroupByExpressions() != null) {
                ExprNodeUtilityRich.getValidatedSubtree(ExprNodeOrigin.GROUPBY, statementSpec.getGroupByExpressions().getOptHavingNodePerLevel(), validationContext);
            }
        }
        for (int i = 0; i < orderByList.size(); ++i) {
            ExprNode orderByNode = orderByList.get(i).getExprNode();
            ExprNodeSubselectDeclaredDotVisitor visitor = new ExprNodeSubselectDeclaredDotVisitor();
            orderByNode.accept(visitor);
            if (visitor.getSubselects().size() > 0) {
                throw new ExprValidationException("Subselects not allowed within order-by clause");
            }
            Boolean isDescending = orderByList.get(i).isDescending();
            OrderByItem validatedOrderBy = new OrderByItem(ExprNodeUtilityRich.getValidatedSubtree(ExprNodeOrigin.ORDERBY, orderByNode, validationContext), isDescending);
            orderByList.set(i, validatedOrderBy);
            if (statementSpec.getGroupByExpressions() == null || statementSpec.getGroupByExpressions().getOptOrderByPerLevel() == null) continue;
            ExprNodeUtilityRich.getValidatedSubtree(ExprNodeOrigin.GROUPBY, statementSpec.getGroupByExpressions().getOptOrderByPerLevel(), validationContext);
        }
        ArrayList<ExprNode> selectNodes = new ArrayList<ExprNode>();
        for (SelectClauseExprCompiledSpec element : namedSelectionList) {
            selectNodes.add(element.getSelectExpression());
        }
        ArrayList<ExprNode> orderByNodes = new ArrayList<ExprNode>();
        for (OrderByItem element : orderByList) {
            orderByNodes.add(element.getExprNode());
        }
        LinkedList<ExprAggregateNode> selectAggregateExprNodes = new LinkedList<ExprAggregateNode>();
        HashMap<ExprNode, String> selectAggregationNodesNamed = new HashMap<ExprNode, String>();
        ExprNodeDeclaredVisitor declaredNodeVisitor = new ExprNodeDeclaredVisitor();
        for (SelectClauseExprCompiledSpec element : namedSelectionList) {
            ExprAggregateNodeUtil.getAggregatesBottomUp(element.getSelectExpression(), selectAggregateExprNodes);
            if (element.getProvidedName() != null) {
                selectAggregationNodesNamed.put(element.getSelectExpression(), element.getProvidedName());
            }
            element.getSelectExpression().accept(declaredNodeVisitor);
            declaredNodes.addAll(declaredNodeVisitor.getDeclaredExpressions());
            declaredNodeVisitor.clear();
        }
        if (statementSpec.getGroupByExpressions() != null) {
            ExprAggregateNodeUtil.getAggregatesBottomUp(statementSpec.getGroupByExpressions().getSelectClausePerLevel(), selectAggregateExprNodes);
        }
        if (!allowAggregation && !selectAggregateExprNodes.isEmpty()) {
            throw new ExprValidationException("Aggregation functions are not allowed in this context");
        }
        LinkedList<ExprAggregateNode> havingAggregateExprNodes = new LinkedList<ExprAggregateNode>();
        ExprNodePropOrStreamSet propertiesAggregatedHaving = new ExprNodePropOrStreamSet();
        if (optionalHavingNode != null) {
            ExprAggregateNodeUtil.getAggregatesBottomUp(optionalHavingNode, havingAggregateExprNodes);
            if (statementSpec.getGroupByExpressions() != null) {
                ExprAggregateNodeUtil.getAggregatesBottomUp(statementSpec.getGroupByExpressions().getOptHavingNodePerLevel(), havingAggregateExprNodes);
            }
            propertiesAggregatedHaving = ExprNodeUtilityRich.getAggregatedProperties(havingAggregateExprNodes);
        }
        if (!allowAggregation && !havingAggregateExprNodes.isEmpty()) {
            throw new ExprValidationException("Aggregation functions are not allowed in this context");
        }
        LinkedList<ExprAggregateNode> orderByAggregateExprNodes = new LinkedList<ExprAggregateNode>();
        if (orderByNodes != null && !orderByNodes.isEmpty()) {
            for (ExprNode orderByNode : orderByNodes) {
                ExprAggregateNodeUtil.getAggregatesBottomUp(orderByNode, orderByAggregateExprNodes);
            }
            if (statementSpec.getGroupByExpressions() != null) {
                ExprAggregateNodeUtil.getAggregatesBottomUp(statementSpec.getGroupByExpressions().getOptOrderByPerLevel(), orderByAggregateExprNodes);
            }
            if (!allowAggregation && !orderByAggregateExprNodes.isEmpty()) {
                throw new ExprValidationException("Aggregation functions are not allowed in this context");
            }
        }
        ExprNode[] groupByNodesValidated = (groupByRollupInfo = ResultSetProcessorFactoryFactory.analyzeValidateGroupBy(statementSpec.getGroupByExpressions(), validationContext)) == null ? ExprNodeUtilityCore.EMPTY_EXPR_ARRAY : groupByRollupInfo.getExprNodes();
        AggregationGroupByRollupDesc groupByRollupDesc = groupByRollupInfo == null ? null : groupByRollupInfo.getRollupDesc();
        boolean hasGroupBy = groupByNodesValidated.length > 0;
        AggregationServiceForgeDesc aggregationServiceForgeDesc = AggregationServiceFactoryFactory.getService(selectAggregateExprNodes, selectAggregationNodesNamed, declaredNodes, groupByNodesValidated, havingAggregateExprNodes, orderByAggregateExprNodes, Collections.emptyList(), hasGroupBy, statementSpec.getAnnotations(), stmtContext.getVariableService(), typeService.getEventTypes().length > 1, false, statementSpec.getFilterRootNode(), statementSpec.getHavingExprRootNode(), stmtContext.getAggregationServiceFactoryService(), typeService.getEventTypes(), groupByRollupDesc, statementSpec.getOptionalContextName(), statementSpec.getIntoTableSpec(), stmtContext.getTableService(), isUnidirectional, isFireAndForget, isOnSelect, stmtContext.getEngineImportService(), stmtContext.getStatementName(), stmtContext.getTimeAbacus());
        boolean localGroupByMatchesGroupBy = ResultSetProcessorFactoryFactory.analyzeLocalGroupBy(groupByNodesValidated, selectAggregateExprNodes, havingAggregateExprNodes, orderByAggregateExprNodes);
        boolean useCollatorSort = false;
        if (stmtContext.getConfigSnapshot() != null) {
            useCollatorSort = stmtContext.getConfigSnapshot().getEngineDefaults().getLanguage().isSortUsingCollator();
        }
        SelectExprEventTypeRegistry selectExprEventTypeRegistry = new SelectExprEventTypeRegistry(stmtContext.getStatementName(), stmtContext.getStatementEventTypeRef());
        SelectExprProcessorForge selectExprProcessorForge = SelectExprProcessorFactory.getProcessor(Collections.emptyList(), selectClauseSpec.getSelectExprList(), isUsingWildcard, insertIntoDesc, null, statementSpec.getForClauseSpec(), typeService, stmtContext.getEventAdapterService(), stmtContext.getStatementResultService(), stmtContext.getValueAddEventService(), selectExprEventTypeRegistry, stmtContext.getEngineImportService(), evaluatorContextStmt, stmtContext.getVariableService(), stmtContext.getTableService(), stmtContext.getTimeProvider(), stmtContext.getEngineURI(), stmtContext.getStatementId(), stmtContext.getStatementName(), stmtContext.getAnnotations(), stmtContext.getContextDescriptor(), stmtContext.getConfigSnapshot(), selectExprProcessorCallback, stmtContext.getNamedWindowMgmtService(), statementSpec.getIntoTableSpec(), groupByRollupInfo, stmtContext.getStatementExtensionServicesContext());
        EventType resultEventType = selectExprProcessorForge.getResultEventType();
        GroupByRollupPerLevelForge rollupPerLevelForges = null;
        if (groupByRollupDesc != null) {
            rollupPerLevelForges = ResultSetProcessorFactoryFactory.getRollUpPerLevelExpressions(statementSpec, groupByNodesValidated, groupByRollupDesc, stmtContext, selectExprEventTypeRegistry, evaluatorContextStmt, insertIntoDesc, typeService, validationContext, groupByRollupInfo);
        }
        OrderByProcessorFactoryForge orderByProcessorFactory = OrderByProcessorFactoryFactory.getProcessor(namedSelectionList, orderByList, statementSpec.getRowLimitSpec(), stmtContext.getVariableService(), useCollatorSort, statementSpec.getOptionalContextName(), rollupPerLevelForges == null ? (OrderByElementForge[][])null : rollupPerLevelForges.getOptionalOrderByElements());
        boolean hasOrderBy = orderByProcessorFactory != null;
        ExprNodePropOrStreamSet propertiesGroupBy = ExprNodeUtilityRich.getGroupByPropertiesValidateHasOne(groupByNodesValidated);
        ExprNodePropOrStreamSet nonAggregatedPropsSelect = ExprNodeUtilityRich.getNonAggregatedProps(typeService.getEventTypes(), selectNodes, contextPropertyRegistry);
        if (optionalHavingNode != null) {
            ExprNodeUtilityRich.addNonAggregatedProps(optionalHavingNode, nonAggregatedPropsSelect, typeService.getEventTypes(), contextPropertyRegistry);
        }
        boolean bl = isAggregated = !selectAggregateExprNodes.isEmpty() || !havingAggregateExprNodes.isEmpty() || !orderByAggregateExprNodes.isEmpty() || !propertiesAggregatedHaving.isEmpty();
        if (optionalHavingNode != null && isAggregated) {
            ResultSetProcessorFactoryFactory.validateHaving(propertiesGroupBy, optionalHavingNode);
        }
        boolean bl2 = isSelectRStream = statementSpec.getSelectStreamSelectorEnum() == SelectClauseStreamSelectorEnum.RSTREAM_ISTREAM_BOTH || statementSpec.getSelectStreamSelectorEnum() == SelectClauseStreamSelectorEnum.RSTREAM_ONLY;
        if (statementSpec.getInsertIntoDesc() != null && statementSpec.getInsertIntoDesc().getStreamSelector().isSelectsRStream()) {
            isSelectRStream = true;
        }
        ExprForge optionalHavingForge = optionalHavingNode == null ? null : optionalHavingNode.getForge();
        boolean hasOutputLimitOpt = ResultSetProcessorOutputConditionType.getOutputLimitOpt(statementSpec.getAnnotations(), configurationInformation, hasOrderBy);
        boolean hasOutputLimitSnapshot = outputLimitSpec != null && outputLimitSpec.getDisplayLimit() == OutputLimitLimitType.SNAPSHOT;
        boolean isGrouped = groupByNodesValidated.length > 0 || groupByRollupDesc != null;
        ResultSetProcessorOutputConditionType outputConditionType = outputLimitSpec != null ? ResultSetProcessorOutputConditionType.getConditionType(outputLimitSpec.getDisplayLimit(), isAggregated, hasOrderBy, hasOutputLimitOpt, isGrouped) : null;
        OutputConditionPolledFactory optionalOutputFirstConditionFactory = null;
        if (outputLimitSpec != null && outputLimitSpec.getDisplayLimit() == OutputLimitLimitType.FIRST) {
            optionalOutputFirstConditionFactory = OutputConditionPolledFactoryFactory.createConditionFactory(outputLimitSpec, stmtContext);
        }
        boolean bl3 = hasOutputLimit = outputLimitSpec != null;
        if (groupByNodesValidated.length == 0 && selectAggregateExprNodes.isEmpty() && havingAggregateExprNodes.isEmpty()) {
            boolean isOutputLimitingNoSnapshot;
            boolean bl4 = isOutputLimitingNoSnapshot = outputLimitSpec != null && outputLimitSpec.getDisplayLimit() != OutputLimitLimitType.SNAPSHOT;
            if (orderByNodes.isEmpty() && optionalHavingNode == null && !isOutputLimitingNoSnapshot && statementSpec.getRowLimitSpec() == null) {
                log.debug(".getProcessor Using no result processor");
                ResultSetProcessorHandThroughFactoryForge forge = new ResultSetProcessorHandThroughFactoryForge(resultEventType, selectExprProcessorForge, isSelectRStream);
                return ResultSetProcessorFactoryCompiler.allocate(forge, ResultSetProcessorType.HANDTHROUGH, resultEventType, stmtContext, isFireAndForget, join, hasOutputLimit, outputConditionType, hasOutputLimitSnapshot, new SelectExprProcessorForge[]{selectExprProcessorForge}, false, aggregationServiceForgeDesc, orderByProcessorFactory);
            }
            log.debug(".getProcessor Using ResultSetProcessorSimple");
            ResultSetProcessorSimpleForge forge = new ResultSetProcessorSimpleForge(resultEventType, selectExprProcessorForge, optionalHavingForge, isSelectRStream, outputLimitSpec, outputConditionType, resultSetProcessorHelperFactory, hasOrderBy, numStreams);
            return ResultSetProcessorFactoryCompiler.allocate(forge, ResultSetProcessorType.UNAGGREGATED_UNGROUPED, resultEventType, stmtContext, isFireAndForget, join, hasOutputLimit, outputConditionType, hasOutputLimitSnapshot, new SelectExprProcessorForge[]{selectExprProcessorForge}, false, aggregationServiceForgeDesc, orderByProcessorFactory);
        }
        boolean isLast = statementSpec.getOutputLimitSpec() != null && statementSpec.getOutputLimitSpec().getDisplayLimit() == OutputLimitLimitType.LAST;
        boolean bl5 = isFirst = statementSpec.getOutputLimitSpec() != null && statementSpec.getOutputLimitSpec().getDisplayLimit() == OutputLimitLimitType.FIRST;
        if (namedSelectionList.isEmpty() && propertiesAggregatedHaving.isEmpty() && havingAggregateExprNodes.isEmpty() && !isLast && !isFirst) {
            log.debug(".getProcessor Using ResultSetProcessorSimple");
            ResultSetProcessorSimpleForge forge = new ResultSetProcessorSimpleForge(resultEventType, selectExprProcessorForge, optionalHavingForge, isSelectRStream, outputLimitSpec, outputConditionType, resultSetProcessorHelperFactory, hasOrderBy, numStreams);
            return ResultSetProcessorFactoryCompiler.allocate(forge, ResultSetProcessorType.UNAGGREGATED_UNGROUPED, resultEventType, stmtContext, isFireAndForget, join, hasOutputLimit, outputConditionType, hasOutputLimitSnapshot, new SelectExprProcessorForge[]{selectExprProcessorForge}, false, aggregationServiceForgeDesc, orderByProcessorFactory);
        }
        if (groupByNodesValidated.length == 0 && isAggregated) {
            boolean hasStreamSelect = ExprNodeUtilityRich.hasStreamSelect(selectNodes);
            if (nonAggregatedPropsSelect.isEmpty() && !hasStreamSelect && !isUsingWildcard && !isUsingStreamSelect && localGroupByMatchesGroupBy && (viewResourceDelegate == null || viewResourceDelegate.getPreviousRequests().isEmpty())) {
                log.debug(".getProcessor Using ResultSetProcessorRowForAll");
                ResultSetProcessorRowForAllForge forge = new ResultSetProcessorRowForAllForge(resultEventType, selectExprProcessorForge, optionalHavingForge, isSelectRStream, isUnidirectional, isHistoricalOnly, outputLimitSpec, resultSetProcessorHelperFactory, hasOrderBy, outputConditionType);
                return ResultSetProcessorFactoryCompiler.allocate(forge, ResultSetProcessorType.FULLYAGGREGATED_UNGROUPED, resultEventType, stmtContext, isFireAndForget, join, hasOutputLimit, outputConditionType, hasOutputLimitSnapshot, new SelectExprProcessorForge[]{selectExprProcessorForge}, false, aggregationServiceForgeDesc, orderByProcessorFactory);
            }
            log.debug(".getProcessor Using ResultSetProcessorRowPerEventImpl");
            ResultSetProcessorRowPerEventForge forge = new ResultSetProcessorRowPerEventForge(selectExprProcessorForge.getResultEventType(), selectExprProcessorForge, optionalHavingForge, isSelectRStream, isUnidirectional, isHistoricalOnly, outputLimitSpec, outputConditionType, resultSetProcessorHelperFactory, hasOrderBy);
            return ResultSetProcessorFactoryCompiler.allocate(forge, ResultSetProcessorType.AGGREGATED_UNGROUPED, resultEventType, stmtContext, isFireAndForget, join, hasOutputLimit, outputConditionType, hasOutputLimitSnapshot, new SelectExprProcessorForge[]{selectExprProcessorForge}, false, aggregationServiceForgeDesc, orderByProcessorFactory);
        }
        if (groupByNodesValidated.length == 0) {
            throw new IllegalStateException("Unexpected empty group-by expression list");
        }
        boolean allInGroupBy = true;
        String notInGroupByReason = null;
        if (isUsingStreamSelect) {
            allInGroupBy = false;
            notInGroupByReason = "stream select";
        }
        if ((reasonMessage = propertiesGroupBy.notContainsAll(nonAggregatedPropsSelect)) != null) {
            notInGroupByReason = reasonMessage;
            allInGroupBy = false;
        }
        if (isUsingWildcard) {
            allInGroupBy = false;
            notInGroupByReason = "wildcard select";
        }
        boolean bl6 = allInSelect = (reasonMessage = nonAggregatedPropsSelect.notContainsAll(nonAggregatedPropsOrderBy = ExprNodeUtilityRich.getNonAggregatedProps(typeService.getEventTypes(), orderByNodes, contextPropertyRegistry))) == null;
        if (isUsingWildcard) {
            allInSelect = true;
        }
        if (allInGroupBy && allInSelect && localGroupByMatchesGroupBy) {
            boolean rollup;
            SelectExprProcessorForge[] selectExprProcessorForges;
            ResultSetProcessorType type;
            ResultSetProcessorFactoryForge forge;
            boolean noDataWindowSingleStream = typeService.getIStreamOnly()[0] && typeService.getEventTypes().length < 2;
            boolean iterableUnboundConfig = configurationInformation.getEngineDefaults().getViewResources().isIterableUnbound();
            boolean iterateUnbounded = noDataWindowSingleStream && (iterableUnboundConfig || AnnotationUtil.findAnnotation(statementSpec.getAnnotations(), IterableUnbound.class) != null);
            log.debug(".getProcessor Using ResultSetProcessorRowPerGroup");
            if (groupByRollupDesc != null) {
                GroupByRollupPerLevelForge perLevelForges = ResultSetProcessorFactoryFactory.getRollUpPerLevelExpressions(statementSpec, groupByNodesValidated, groupByRollupDesc, stmtContext, selectExprEventTypeRegistry, evaluatorContextStmt, insertIntoDesc, typeService, validationContext, groupByRollupInfo);
                forge = new ResultSetProcessorRowPerGroupRollupForge(resultEventType, perLevelForges, groupByNodesValidated, isSelectRStream, isUnidirectional, outputLimitSpec, orderByProcessorFactory != null, noDataWindowSingleStream, groupByRollupDesc, typeService.getEventTypes().length > 1, isHistoricalOnly, iterateUnbounded, optionalOutputFirstConditionFactory, resultSetProcessorHelperFactory, outputConditionType, numStreams);
                type = ResultSetProcessorType.FULLYAGGREGATED_GROUPED_ROLLUP;
                selectExprProcessorForges = perLevelForges.getSelectExprProcessorForges();
                rollup = true;
            } else {
                forge = new ResultSetProcessorRowPerGroupForge(resultEventType, selectExprProcessorForge, groupByNodesValidated, optionalHavingForge, isSelectRStream, isUnidirectional, outputLimitSpec, orderByProcessorFactory != null, noDataWindowSingleStream, isHistoricalOnly, iterateUnbounded, resultSetProcessorHelperFactory, outputConditionType, numStreams, optionalOutputFirstConditionFactory);
                type = ResultSetProcessorType.FULLYAGGREGATED_GROUPED;
                selectExprProcessorForges = new SelectExprProcessorForge[]{selectExprProcessorForge};
                rollup = false;
            }
            return ResultSetProcessorFactoryCompiler.allocate(forge, type, resultEventType, stmtContext, isFireAndForget, join, hasOutputLimit, outputConditionType, hasOutputLimitSnapshot, selectExprProcessorForges, rollup, aggregationServiceForgeDesc, orderByProcessorFactory);
        }
        if (groupByRollupDesc != null) {
            throw new ExprValidationException("Group-by with rollup requires a fully-aggregated query, the query is not full-aggregated because of " + notInGroupByReason);
        }
        log.debug(".getProcessor Using ResultSetProcessorAggregateGrouped");
        ResultSetProcessorAggregateGroupedForge forge = new ResultSetProcessorAggregateGroupedForge(resultEventType, selectExprProcessorForge, groupByNodesValidated, optionalHavingForge, isSelectRStream, isUnidirectional, outputLimitSpec, orderByProcessorFactory != null, isHistoricalOnly, resultSetProcessorHelperFactory, optionalOutputFirstConditionFactory, outputConditionType, numStreams);
        return ResultSetProcessorFactoryCompiler.allocate(forge, ResultSetProcessorType.AGGREGATED_GROUPED, resultEventType, stmtContext, isFireAndForget, join, hasOutputLimit, outputConditionType, hasOutputLimitSnapshot, new SelectExprProcessorForge[]{selectExprProcessorForge}, false, aggregationServiceForgeDesc, orderByProcessorFactory);
    }

    private static void validateOutputLimit(OutputLimitSpec outputLimitSpec, StatementContext statementContext) throws ExprValidationException {
        ExprTimePeriod timePeriodExpr;
        if (outputLimitSpec == null) {
            return;
        }
        ExprEvaluatorContextStatement evaluatorContextStmt = new ExprEvaluatorContextStatement(statementContext, false);
        ExprValidationContext validationContext = new ExprValidationContext(new StreamTypeServiceImpl(statementContext.getEngineURI(), false), statementContext.getEngineImportService(), statementContext.getStatementExtensionServicesContext(), null, statementContext.getTimeProvider(), statementContext.getVariableService(), statementContext.getTableService(), evaluatorContextStmt, statementContext.getEventAdapterService(), statementContext.getStatementName(), statementContext.getStatementId(), statementContext.getAnnotations(), statementContext.getContextDescriptor(), false, false, false, false, null, false);
        if (outputLimitSpec.getAfterTimePeriodExpr() != null) {
            timePeriodExpr = (ExprTimePeriod)ExprNodeUtilityRich.getValidatedSubtree(ExprNodeOrigin.OUTPUTLIMIT, outputLimitSpec.getAfterTimePeriodExpr(), validationContext);
            outputLimitSpec.setAfterTimePeriodExpr(timePeriodExpr);
        }
        if (outputLimitSpec.getTimePeriodExpr() != null) {
            timePeriodExpr = (ExprTimePeriod)ExprNodeUtilityRich.getValidatedSubtree(ExprNodeOrigin.OUTPUTLIMIT, outputLimitSpec.getTimePeriodExpr(), validationContext);
            outputLimitSpec.setTimePeriodExpr(timePeriodExpr);
            if (timePeriodExpr.isConstantResult()) {
                ExprEvaluatorContextStatement exprEvaluatorContextStatement = new ExprEvaluatorContextStatement(statementContext, false);
                if (timePeriodExpr.evaluateAsSeconds(null, true, exprEvaluatorContextStatement) <= 0.0) {
                    throw new ExprValidationException("Invalid time period expression returns a zero or negative time interval");
                }
            }
        }
    }

    private static boolean analyzeLocalGroupBy(ExprNode[] groupByNodesValidated, List<ExprAggregateNode> selectAggregateExprNodes, List<ExprAggregateNode> havingAggregateExprNodes, List<ExprAggregateNode> orderByAggregateExprNodes) {
        boolean localGroupByMatchesGroupBy = ResultSetProcessorFactoryFactory.analyzeLocalGroupBy(groupByNodesValidated, selectAggregateExprNodes);
        localGroupByMatchesGroupBy = localGroupByMatchesGroupBy && ResultSetProcessorFactoryFactory.analyzeLocalGroupBy(groupByNodesValidated, havingAggregateExprNodes);
        localGroupByMatchesGroupBy = localGroupByMatchesGroupBy && ResultSetProcessorFactoryFactory.analyzeLocalGroupBy(groupByNodesValidated, orderByAggregateExprNodes);
        return localGroupByMatchesGroupBy;
    }

    private static boolean analyzeLocalGroupBy(ExprNode[] groupByNodesValidated, List<ExprAggregateNode> aggNodes) {
        for (ExprAggregateNode agg : aggNodes) {
            if (agg.getOptionalLocalGroupBy() == null || ExprNodeUtilityCore.deepEqualsIsSubset(agg.getOptionalLocalGroupBy().getPartitionExpressions(), groupByNodesValidated)) continue;
            return false;
        }
        return true;
    }

    private static GroupByRollupInfo analyzeValidateGroupBy(GroupByClauseExpressions groupBy, ExprValidationContext validationContext) throws ExprValidationException {
        if (groupBy == null) {
            return null;
        }
        ExprNodeUtilityRich.validateNoSpecialsGroupByExpressions(groupBy.getGroupByNodes());
        ExprNode[] validated = new ExprNode[groupBy.getGroupByNodes().length];
        for (int i = 0; i < validated.length; ++i) {
            validated[i] = ExprNodeUtilityRich.getValidatedSubtree(ExprNodeOrigin.GROUPBY, groupBy.getGroupByNodes()[i], validationContext);
        }
        if (groupBy.getGroupByRollupLevels() == null) {
            return new GroupByRollupInfo(validated, null);
        }
        AggregationGroupByRollupDesc rollup = AggregationGroupByRollupDesc.make(groupBy.getGroupByRollupLevels());
        try {
            GroupByRollupPlanHook hook = (GroupByRollupPlanHook)EngineImportUtil.getAnnotationHook(validationContext.getAnnotations(), HookType.INTERNAL_GROUPROLLUP_PLAN, GroupByRollupPlanHook.class, validationContext.getEngineImportService());
            if (hook != null) {
                hook.query(new GroupByRollupPlanDesc(validated, rollup));
            }
        }
        catch (ExprValidationException e) {
            throw new EPException("Failed to obtain hook for " + (Object)((Object)HookType.INTERNAL_QUERY_PLAN));
        }
        return new GroupByRollupInfo(validated, rollup);
    }

    private static GroupByRollupPerLevelForge getRollUpPerLevelExpressions(StatementSpecCompiled statementSpec, ExprNode[] groupByNodesValidated, AggregationGroupByRollupDesc groupByRollupDesc, StatementContext stmtContext, SelectExprEventTypeRegistry selectExprEventTypeRegistry, ExprEvaluatorContextStatement evaluatorContextStmt, InsertIntoDesc insertIntoDesc, StreamTypeService typeService, ExprValidationContext validationContext, GroupByRollupInfo groupByRollupInfo) throws ExprValidationException {
        int i;
        int numLevels = groupByRollupDesc.getLevels().length;
        GroupByClauseExpressions groupByExpressions = statementSpec.getGroupByExpressions();
        SelectExprProcessorForge[] processors = new SelectExprProcessorForge[numLevels];
        ExprForge[] havingClauses = null;
        if (groupByExpressions.getOptHavingNodePerLevel() != null) {
            havingClauses = new ExprForge[numLevels];
        }
        OrderByElementForge[][] orderByElements = null;
        if (groupByExpressions.getOptOrderByPerLevel() != null) {
            orderByElements = new OrderByElementForge[numLevels][];
        }
        ExprNodePropOrStreamSet[] propsPerGroupByExpr = new ExprNodePropOrStreamSet[groupByNodesValidated.length];
        for (i = 0; i < groupByNodesValidated.length; ++i) {
            propsPerGroupByExpr[i] = ExprNodeUtilityRich.getGroupByPropertiesValidateHasOne(new ExprNode[]{groupByNodesValidated[i]});
        }
        for (i = 0; i < numLevels; ++i) {
            SelectExprProcessorForge forge;
            AggregationGroupByRollupLevel level = groupByRollupDesc.getLevels()[i];
            ExprNodePropOrStreamSet rolledupProps = ResultSetProcessorFactoryFactory.getRollupProperties(level, propsPerGroupByExpr);
            ExprNode[] selectClauseLevel = groupByExpressions.getSelectClausePerLevel()[i];
            SelectClauseElementCompiled[] selectClause = ResultSetProcessorFactoryFactory.getRollUpSelectClause(statementSpec.getSelectClauseSpec(), selectClauseLevel, level, rolledupProps, groupByNodesValidated, validationContext);
            processors[i] = forge = SelectExprProcessorFactory.getProcessor(Collections.emptyList(), selectClause, false, insertIntoDesc, null, statementSpec.getForClauseSpec(), typeService, stmtContext.getEventAdapterService(), stmtContext.getStatementResultService(), stmtContext.getValueAddEventService(), selectExprEventTypeRegistry, stmtContext.getEngineImportService(), evaluatorContextStmt, stmtContext.getVariableService(), stmtContext.getTableService(), stmtContext.getTimeProvider(), stmtContext.getEngineURI(), stmtContext.getStatementId(), stmtContext.getStatementName(), stmtContext.getAnnotations(), stmtContext.getContextDescriptor(), stmtContext.getConfigSnapshot(), null, stmtContext.getNamedWindowMgmtService(), statementSpec.getIntoTableSpec(), groupByRollupInfo, stmtContext.getStatementExtensionServicesContext());
            if (havingClauses != null) {
                ExprNode havingNode = ResultSetProcessorFactoryFactory.rewriteRollupValidateExpression(ExprNodeOrigin.HAVING, groupByExpressions.getOptHavingNodePerLevel()[i], validationContext, rolledupProps, groupByNodesValidated, level);
                havingClauses[i] = havingNode.getForge();
            }
            if (orderByElements == null) continue;
            orderByElements[i] = ResultSetProcessorFactoryFactory.rewriteRollupOrderBy(statementSpec.getOrderByList(), groupByExpressions.getOptOrderByPerLevel()[i], validationContext, rolledupProps, groupByNodesValidated, level);
        }
        return new GroupByRollupPerLevelForge(processors, havingClauses, orderByElements);
    }

    private static OrderByElementForge[] rewriteRollupOrderBy(OrderByItem[] items, ExprNode[] orderByList, ExprValidationContext validationContext, ExprNodePropOrStreamSet rolledupProps, ExprNode[] groupByNodes, AggregationGroupByRollupLevel level) throws ExprValidationException {
        OrderByElementForge[] elements = new OrderByElementForge[orderByList.length];
        for (int i = 0; i < orderByList.length; ++i) {
            ExprNode validated = ResultSetProcessorFactoryFactory.rewriteRollupValidateExpression(ExprNodeOrigin.ORDERBY, orderByList[i], validationContext, rolledupProps, groupByNodes, level);
            elements[i] = new OrderByElementForge(validated, items[i].isDescending());
        }
        return elements;
    }

    private static ExprNodePropOrStreamSet getRollupProperties(AggregationGroupByRollupLevel level, ExprNodePropOrStreamSet[] propsPerGroupByExpr) {
        ExprNodePropOrStreamSet rolledupProps = new ExprNodePropOrStreamSet();
        for (int i = 0; i < propsPerGroupByExpr.length; ++i) {
            if (level.isAggregationTop()) {
                rolledupProps.addAll(propsPerGroupByExpr[i]);
                continue;
            }
            boolean rollupContainsGroupExpr = false;
            for (int num : level.getRollupKeys()) {
                if (num != i) continue;
                rollupContainsGroupExpr = true;
                break;
            }
            if (rollupContainsGroupExpr) continue;
            rolledupProps.addAll(propsPerGroupByExpr[i]);
        }
        return rolledupProps;
    }

    private static SelectClauseElementCompiled[] getRollUpSelectClause(SelectClauseSpecCompiled selectClauseSpec, ExprNode[] selectClauseLevel, AggregationGroupByRollupLevel level, ExprNodePropOrStreamSet rolledupProps, ExprNode[] groupByNodesValidated, ExprValidationContext validationContext) throws ExprValidationException {
        SelectClauseElementCompiled[] rewritten = new SelectClauseElementCompiled[selectClauseSpec.getSelectExprList().length];
        for (int i = 0; i < rewritten.length; ++i) {
            SelectClauseElementCompiled spec = selectClauseSpec.getSelectExprList()[i];
            if (!(spec instanceof SelectClauseExprCompiledSpec)) {
                throw new ExprValidationException("Group-by clause with roll-up does not allow wildcard");
            }
            SelectClauseExprCompiledSpec exprSpec = (SelectClauseExprCompiledSpec)spec;
            ExprNode validated = ResultSetProcessorFactoryFactory.rewriteRollupValidateExpression(ExprNodeOrigin.SELECT, selectClauseLevel[i], validationContext, rolledupProps, groupByNodesValidated, level);
            rewritten[i] = new SelectClauseExprCompiledSpec(validated, exprSpec.getAssignedName(), exprSpec.getProvidedName(), exprSpec.isEvents());
        }
        return rewritten;
    }

    private static ExprNode rewriteRollupValidateExpression(ExprNodeOrigin exprNodeOrigin, ExprNode exprNode, ExprValidationContext validationContext, ExprNodePropOrStreamSet rolledupProps, ExprNode[] groupByNodes, AggregationGroupByRollupLevel level) throws ExprValidationException {
        int[] combination;
        ExprNodeGroupingVisitorWParent groupingVisitor = new ExprNodeGroupingVisitorWParent();
        exprNode.accept(groupingVisitor);
        for (Pair<ExprNode, ExprGroupingNode> pair : groupingVisitor.getGroupingNodes()) {
            int[] rollupIndexes;
            combination = ResultSetProcessorFactoryFactory.getGroupExprCombination(groupByNodes, pair.getSecond().getChildNodes());
            boolean found = false;
            for (int index : rollupIndexes = level.isAggregationTop() ? new int[]{} : level.getRollupKeys()) {
                if (index != combination[0]) continue;
                found = true;
                break;
            }
            int result = found ? 0 : 1;
            ExprConstantNodeImpl exprConstantNodeImpl = new ExprConstantNodeImpl(result, Integer.class);
            if (pair.getFirst() != null) {
                ExprNodeUtilityCore.replaceChildNode(pair.getFirst(), pair.getSecond(), exprConstantNodeImpl);
                continue;
            }
            exprNode = exprConstantNodeImpl;
        }
        for (Pair<ExprNode, ExprNodeBase> pair : groupingVisitor.getGroupingIdNodes()) {
            combination = ResultSetProcessorFactoryFactory.getGroupExprCombination(groupByNodes, ((ExprGroupingIdNode)pair.getSecond()).getChildNodes());
            int result = 0;
            for (int i = 0; i < combination.length; ++i) {
                int[] rollupIndexes;
                int index = combination[i];
                boolean bl = false;
                for (int rollupIndex : rollupIndexes = level.isAggregationTop() ? new int[]{} : level.getRollupKeys()) {
                    if (index != rollupIndex) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                result += ResultSetProcessorFactoryFactory.pow2(combination.length - i - 1);
            }
            ExprConstantNodeImpl constant = new ExprConstantNodeImpl(result, Integer.class);
            if (pair.getFirst() != null) {
                ExprNodeUtilityCore.replaceChildNode(pair.getFirst(), pair.getSecond(), constant);
                continue;
            }
            exprNode = constant;
        }
        ExprNodeIdentifierCollectVisitorWContainer identVisitor = new ExprNodeIdentifierCollectVisitorWContainer();
        exprNode.accept(identVisitor);
        for (Pair<ExprNode, ExprIdentNode> node : identVisitor.getExprProperties()) {
            boolean rewrite = false;
            ExprNodePropOrStreamExprDesc firstRollupNonPropExpr = rolledupProps.getFirstExpression();
            if (firstRollupNonPropExpr != null) {
                throw new ExprValidationException("Invalid rollup expression " + firstRollupNonPropExpr.getTextual());
            }
            for (ExprNodePropOrStreamDesc exprNodePropOrStreamDesc : rolledupProps.getProperties()) {
                ExprNodePropOrStreamPropDesc prop = (ExprNodePropOrStreamPropDesc)exprNodePropOrStreamDesc;
                if (exprNodePropOrStreamDesc.getStreamNum() != node.getSecond().getStreamId() || !prop.getPropertyName().equals(node.getSecond().getResolvedPropertyName())) continue;
                rewrite = true;
                break;
            }
            if (node.getFirst() != null && (node.getFirst() instanceof ExprPreviousNode || node.getFirst() instanceof ExprPriorNode)) {
                rewrite = false;
            }
            if (!rewrite) continue;
            ExprConstantNodeImpl constant = new ExprConstantNodeImpl(null, node.getSecond().getForge().getEvaluationType());
            if (node.getFirst() != null) {
                ExprNodeUtilityCore.replaceChildNode(node.getFirst(), node.getSecond(), constant);
                continue;
            }
            exprNode = constant;
        }
        return ExprNodeUtilityRich.getValidatedSubtree(exprNodeOrigin, exprNode, validationContext);
    }

    private static int[] getGroupExprCombination(ExprNode[] groupByNodes, ExprNode[] childNodes) throws ExprValidationException {
        TreeSet<Integer> indexes = new TreeSet<Integer>();
        for (ExprNode child : childNodes) {
            boolean found = false;
            for (int i = 0; i < groupByNodes.length; ++i) {
                if (!ExprNodeUtilityCore.deepEquals(child, groupByNodes[i], false)) continue;
                if (indexes.contains(i)) {
                    throw new ExprValidationException("Duplicate expression '" + ExprNodeUtilityCore.toExpressionStringMinPrecedenceSafe(child) + "' among grouping function parameters");
                }
                indexes.add(i);
                found = true;
            }
            if (found) continue;
            throw new ExprValidationException("Failed to find expression '" + ExprNodeUtilityCore.toExpressionStringMinPrecedenceSafe(child) + "' among group-by expressions");
        }
        return CollectionUtil.intArray(indexes);
    }

    private static void validateSelectAssignColNames(SelectClauseSpecCompiled selectClauseSpec, List<SelectClauseExprCompiledSpec> namedSelectionList, ExprValidationContext validationContext) throws ExprValidationException {
        for (int i = 0; i < selectClauseSpec.getSelectExprList().length; ++i) {
            SelectClauseElementCompiled element = selectClauseSpec.getSelectExprList()[i];
            if (!(element instanceof SelectClauseExprCompiledSpec)) continue;
            SelectClauseExprCompiledSpec expr = (SelectClauseExprCompiledSpec)element;
            ExprNode validatedExpression = ExprNodeUtilityRich.getValidatedSubtree(ExprNodeOrigin.SELECT, expr.getSelectExpression(), validationContext);
            String asName = expr.getAssignedName();
            if (asName == null) {
                asName = ExprNodeUtilityCore.toExpressionStringMinPrecedenceSafe(validatedExpression);
            }
            expr.setAssignedName(asName);
            expr.setSelectExpression(validatedExpression);
            namedSelectionList.add(expr);
        }
    }

    private static void validateHaving(ExprNodePropOrStreamSet propertiesGroupedBy, ExprNode havingNode) throws ExprValidationException {
        LinkedList<ExprAggregateNode> aggregateNodesHaving = new LinkedList<ExprAggregateNode>();
        ExprAggregateNodeUtil.getAggregatesBottomUp(havingNode, aggregateNodesHaving);
        if (!propertiesGroupedBy.isEmpty()) {
            ExprNodeIdentifierAndStreamRefVisitor visitor = new ExprNodeIdentifierAndStreamRefVisitor(true);
            havingNode.accept(visitor);
            List<ExprNodePropOrStreamDesc> allPropertiesHaving = visitor.getRefs();
            ExprNodePropOrStreamSet aggPropertiesHaving = ExprNodeUtilityRich.getAggregatedProperties(aggregateNodesHaving);
            aggPropertiesHaving.removeFromList(allPropertiesHaving);
            propertiesGroupedBy.removeFromList(allPropertiesHaving);
            if (!allPropertiesHaving.isEmpty()) {
                ExprNodePropOrStreamDesc desc = allPropertiesHaving.iterator().next();
                throw new ExprValidationException("Non-aggregated " + desc.getTextual() + " in the HAVING clause must occur in the group-by clause");
            }
        }
    }

    private static List<OrderByItem> expandColumnNames(SelectClauseElementCompiled[] selectionList, OrderByItem[] orderByUnexpanded) {
        if (orderByUnexpanded.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<OrderByItem> expanded = new ArrayList<OrderByItem>();
        for (OrderByItem item : orderByUnexpanded) {
            expanded.add(item.copy());
        }
        for (SelectClauseElementCompiled selectElement : selectionList) {
            SelectClauseExprCompiledSpec selectExpr;
            String name;
            if (!(selectElement instanceof SelectClauseExprCompiledSpec) || (name = (selectExpr = (SelectClauseExprCompiledSpec)selectElement).getAssignedName()) == null) continue;
            ExprNode fullExpr = selectExpr.getSelectExpression();
            ListIterator<OrderByItem> iterator = expanded.listIterator();
            while (iterator.hasNext()) {
                OrderByItem orderByElement = (OrderByItem)iterator.next();
                ExprNode swapped = ColumnNamedNodeSwapper.swap(orderByElement.getExprNode(), name, fullExpr);
                OrderByItem newOrderByElement = new OrderByItem(swapped, orderByElement.isDescending());
                iterator.set(newOrderByElement);
            }
        }
        return expanded;
    }

    private static int pow2(int exponent) {
        if (exponent == 0) {
            return 1;
        }
        int result = 2;
        for (int i = 0; i < exponent - 1; ++i) {
            result = 2 * result;
        }
        return result;
    }
}

