/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core.resultset.agggrouped;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.agg.service.common.AggregationService;
import com.espertech.esper.epl.core.resultset.agggrouped.ResultSetProcessorAggregateGrouped;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ResultSetProcessorAggregateGroupedIterator
implements Iterator<EventBean> {
    private final Iterator<EventBean> sourceIterator;
    private final ResultSetProcessorAggregateGrouped resultSetProcessor;
    private final AggregationService aggregationService;
    private EventBean nextResult;
    private final EventBean[] eventsPerStream;
    private final ExprEvaluatorContext exprEvaluatorContext;

    public ResultSetProcessorAggregateGroupedIterator(Iterator<EventBean> sourceIterator, ResultSetProcessorAggregateGrouped resultSetProcessor, AggregationService aggregationService, ExprEvaluatorContext exprEvaluatorContext) {
        this.sourceIterator = sourceIterator;
        this.resultSetProcessor = resultSetProcessor;
        this.aggregationService = aggregationService;
        this.eventsPerStream = new EventBean[1];
        this.exprEvaluatorContext = exprEvaluatorContext;
    }

    @Override
    public boolean hasNext() {
        if (this.nextResult != null) {
            return true;
        }
        this.findNext();
        return this.nextResult != null;
    }

    @Override
    public EventBean next() {
        if (this.nextResult != null) {
            EventBean result = this.nextResult;
            this.nextResult = null;
            return result;
        }
        this.findNext();
        if (this.nextResult != null) {
            EventBean result = this.nextResult;
            this.nextResult = null;
            return result;
        }
        throw new NoSuchElementException();
    }

    private void findNext() {
        while (this.sourceIterator.hasNext()) {
            boolean pass;
            EventBean candidate;
            this.eventsPerStream[0] = candidate = this.sourceIterator.next();
            Object groupKey = this.resultSetProcessor.generateGroupKeySingle(this.eventsPerStream, true);
            this.aggregationService.setCurrentAccess(groupKey, this.exprEvaluatorContext.getAgentInstanceId(), null);
            if (this.resultSetProcessor.hasHavingClause() && !(pass = this.resultSetProcessor.evaluateHavingClause(this.eventsPerStream, true, this.exprEvaluatorContext))) continue;
            this.nextResult = this.resultSetProcessor.getSelectExprProcessor().process(this.eventsPerStream, true, true, this.exprEvaluatorContext);
            break;
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

