/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core.orderby;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.codegen.base.CodegenBlock;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMember;
import com.espertech.esper.codegen.base.CodegenMethodNode;
import com.espertech.esper.codegen.core.CodegenNamedMethods;
import com.espertech.esper.codegen.core.CodegenNamedParam;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.codegen.model.expression.CodegenExpressionRelational;
import com.espertech.esper.collection.HashableMultiKey;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.epl.agg.rollup.GroupByRollupKey;
import com.espertech.esper.epl.agg.service.common.AggregationGroupByRollupLevel;
import com.espertech.esper.epl.agg.service.common.AggregationService;
import com.espertech.esper.epl.core.orderby.OrderByElementEval;
import com.espertech.esper.epl.core.orderby.OrderByElementForge;
import com.espertech.esper.epl.core.orderby.OrderByProcessor;
import com.espertech.esper.epl.core.orderby.OrderByProcessorCodegenNames;
import com.espertech.esper.epl.core.orderby.OrderByProcessorFactoryImpl;
import com.espertech.esper.epl.core.orderby.OrderByProcessorForgeImpl;
import com.espertech.esper.epl.core.orderby.OrderByProcessorUtil;
import com.espertech.esper.epl.core.resultset.codegen.ResultSetProcessorCodegenNames;
import com.espertech.esper.epl.core.resultset.core.ResultSetProcessorUtil;
import com.espertech.esper.epl.enummethod.codegen.EnumForgeCodegenNames;
import com.espertech.esper.epl.expression.codegen.CodegenLegoMethodExpression;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenNames;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;

public class OrderByProcessorImpl
implements OrderByProcessor {
    private final OrderByProcessorFactoryImpl factory;

    public OrderByProcessorImpl(OrderByProcessorFactoryImpl factory) {
        this.factory = factory;
    }

    @Override
    public Object getSortKey(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        return OrderByProcessorImpl.getSortKeyInternal(eventsPerStream, isNewData, exprEvaluatorContext, this.factory.getOrderBy());
    }

    public static void getSortKeyCodegen(OrderByProcessorForgeImpl forge, CodegenMethodNode method, CodegenClassScope classScope, CodegenNamedMethods namedMethods) {
        CodegenMethodNode getSortKey = OrderByProcessorImpl.generateOrderKeyCodegen("getSortKeyInternal", forge.getOrderBy(), classScope, namedMethods);
        method.getBlock().methodReturn(CodegenExpressionBuilder.localMethod(getSortKey, EnumForgeCodegenNames.REF_EPS, ResultSetProcessorCodegenNames.REF_ISNEWDATA, ExprForgeCodegenNames.REF_EXPREVALCONTEXT));
    }

    @Override
    public Object getSortKeyRollup(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext, AggregationGroupByRollupLevel level) {
        return OrderByProcessorImpl.getSortKeyInternal(eventsPerStream, isNewData, exprEvaluatorContext, this.factory.getOrderByRollup()[level.getLevelNumber()]);
    }

    public static void getSortKeyRollupCodegen(OrderByProcessorForgeImpl forge, CodegenMethodNode method, CodegenClassScope classScope, CodegenNamedMethods namedMethods) {
        method.getBlock().declareVar(Integer.TYPE, "num", CodegenExpressionBuilder.exprDotMethod(OrderByProcessorCodegenNames.REF_ORDERROLLUPLEVEL, "getLevelNumber", new CodegenExpression[0]));
        CodegenBlock[] blocks = method.getBlock().switchBlockOfLength("num", forge.getOrderByRollup().length, true);
        for (int i = 0; i < blocks.length; ++i) {
            CodegenMethodNode getSortKey = OrderByProcessorImpl.generateOrderKeyCodegen("getSortKeyInternal_" + i, forge.getOrderByRollup()[i], classScope, namedMethods);
            blocks[i].blockReturn(CodegenExpressionBuilder.localMethod(getSortKey, EnumForgeCodegenNames.REF_EPS, ResultSetProcessorCodegenNames.REF_ISNEWDATA, ExprForgeCodegenNames.REF_EXPREVALCONTEXT));
        }
    }

    private static Object getSortKeyInternal(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext, OrderByElementEval[] elements) {
        if (elements.length == 1) {
            return elements[0].getExpr().evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        }
        Object[] values = new Object[elements.length];
        int count = 0;
        for (OrderByElementEval sortPair : elements) {
            values[count++] = sortPair.getExpr().evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        }
        return new HashableMultiKey(values);
    }

    @Override
    public EventBean[] sortPlain(EventBean[] outgoingEvents, EventBean[][] generatingEvents, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext, AggregationService aggregationService) {
        if (outgoingEvents == null || outgoingEvents.length < 2) {
            return outgoingEvents;
        }
        return this.sortWGroupKeysInternal(outgoingEvents, generatingEvents, null, isNewData, exprEvaluatorContext, aggregationService);
    }

    @Override
    public EventBean[] sortRollup(EventBean[] outgoingEvents, List<GroupByRollupKey> currentGenerators, boolean newData, AgentInstanceContext agentInstanceContext, AggregationService aggregationService) {
        List<Object> sortValuesMultiKeys = this.createSortPropertiesWRollup(currentGenerators, this.factory.getOrderByRollup(), newData, agentInstanceContext, aggregationService);
        return OrderByProcessorUtil.sortGivenOutgoingAndSortKeys(outgoingEvents, sortValuesMultiKeys, this.factory.getComparator());
    }

    static void sortPlainCodegen(OrderByProcessorForgeImpl forge, CodegenMethodNode method, CodegenClassScope classScope, CodegenNamedMethods namedMethods) {
        CodegenMethodNode node = OrderByProcessorImpl.sortWGroupKeysInternalCodegen(forge, classScope, namedMethods);
        method.getBlock().ifCondition(CodegenExpressionBuilder.or(CodegenExpressionBuilder.equalsNull(OrderByProcessorCodegenNames.REF_OUTGOINGEVENTS), CodegenExpressionBuilder.relational(CodegenExpressionBuilder.arrayLength(OrderByProcessorCodegenNames.REF_OUTGOINGEVENTS), CodegenExpressionRelational.CodegenRelational.LT, CodegenExpressionBuilder.constant(2)), new CodegenExpression[0])).blockReturn(OrderByProcessorCodegenNames.REF_OUTGOINGEVENTS);
        method.getBlock().methodReturn(CodegenExpressionBuilder.localMethod(node, OrderByProcessorCodegenNames.REF_OUTGOINGEVENTS, OrderByProcessorCodegenNames.REF_GENERATINGEVENTS, CodegenExpressionBuilder.constantNull(), ResultSetProcessorCodegenNames.REF_ISNEWDATA, ExprForgeCodegenNames.REF_EXPREVALCONTEXT, ResultSetProcessorCodegenNames.REF_AGGREGATIONSVC));
    }

    static void sortRollupCodegen(OrderByProcessorForgeImpl forge, CodegenMethodNode method, CodegenClassScope classScope, CodegenNamedMethods namedMethods) {
        CodegenMethodNode createSortPropertiesWRollup = OrderByProcessorImpl.createSortPropertiesWRollupCodegen(forge, classScope, namedMethods);
        CodegenMember comparator = classScope.makeAddMember(Comparator.class, forge.getComparator());
        method.getBlock().declareVar(List.class, "sortValuesMultiKeys", (CodegenExpression)CodegenExpressionBuilder.localMethod(createSortPropertiesWRollup, OrderByProcessorCodegenNames.REF_ORDERCURRENTGENERATORS, ResultSetProcessorCodegenNames.REF_ISNEWDATA, ResultSetProcessorCodegenNames.REF_AGENTINSTANCECONTEXT, ResultSetProcessorCodegenNames.REF_AGGREGATIONSVC)).methodReturn(CodegenExpressionBuilder.staticMethod(OrderByProcessorUtil.class, "sortGivenOutgoingAndSortKeys", OrderByProcessorCodegenNames.REF_OUTGOINGEVENTS, CodegenExpressionBuilder.ref("sortValuesMultiKeys"), CodegenExpressionBuilder.member(comparator.getMemberId())));
    }

    @Override
    public EventBean[] sortWGroupKeys(EventBean[] outgoingEvents, EventBean[][] generatingEvents, Object[] groupByKeys, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext, AggregationService aggregationService) {
        if (outgoingEvents == null || outgoingEvents.length < 2) {
            return outgoingEvents;
        }
        return this.sortWGroupKeysInternal(outgoingEvents, generatingEvents, groupByKeys, isNewData, exprEvaluatorContext, aggregationService);
    }

    static void sortWGroupKeysCodegen(OrderByProcessorForgeImpl forge, CodegenMethodNode method, CodegenClassScope classScope, CodegenNamedMethods namedMethods) {
        CodegenMethodNode sortWGroupKeysInternal = OrderByProcessorImpl.sortWGroupKeysInternalCodegen(forge, classScope, namedMethods);
        method.getBlock().ifCondition(CodegenExpressionBuilder.or(CodegenExpressionBuilder.equalsNull(OrderByProcessorCodegenNames.REF_OUTGOINGEVENTS), CodegenExpressionBuilder.relational(CodegenExpressionBuilder.arrayLength(OrderByProcessorCodegenNames.REF_OUTGOINGEVENTS), CodegenExpressionRelational.CodegenRelational.LT, CodegenExpressionBuilder.constant(2)), new CodegenExpression[0])).blockReturn(OrderByProcessorCodegenNames.REF_OUTGOINGEVENTS).methodReturn(CodegenExpressionBuilder.localMethod(sortWGroupKeysInternal, OrderByProcessorCodegenNames.REF_OUTGOINGEVENTS, OrderByProcessorCodegenNames.REF_GENERATINGEVENTS, OrderByProcessorCodegenNames.REF_ORDERGROUPBYKEYS, ResultSetProcessorCodegenNames.REF_ISNEWDATA, ExprForgeCodegenNames.REF_EXPREVALCONTEXT, ResultSetProcessorCodegenNames.REF_AGGREGATIONSVC));
    }

    private EventBean[] sortWGroupKeysInternal(EventBean[] outgoingEvents, EventBean[][] generatingEvents, Object[] groupByKeys, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext, AggregationService aggregationService) {
        List<Object> sortValuesMultiKeys = this.createSortProperties(generatingEvents, groupByKeys, isNewData, exprEvaluatorContext, aggregationService);
        return OrderByProcessorUtil.sortGivenOutgoingAndSortKeys(outgoingEvents, sortValuesMultiKeys, this.factory.getComparator());
    }

    private static CodegenMethodNode sortWGroupKeysInternalCodegen(OrderByProcessorForgeImpl forge, CodegenClassScope classScope, CodegenNamedMethods namedMethods) {
        CodegenMethodNode createSortProperties = OrderByProcessorImpl.createSortPropertiesCodegen(forge, classScope, namedMethods);
        CodegenMember comparator = classScope.makeAddMember(Comparator.class, forge.getComparator());
        Consumer<CodegenMethodNode> code = method -> method.getBlock().declareVar(List.class, "sortValuesMultiKeys", (CodegenExpression)CodegenExpressionBuilder.localMethod(createSortProperties, OrderByProcessorCodegenNames.REF_GENERATINGEVENTS, CodegenExpressionBuilder.ref("groupByKeys"), ResultSetProcessorCodegenNames.REF_ISNEWDATA, ExprForgeCodegenNames.REF_EXPREVALCONTEXT, ResultSetProcessorCodegenNames.REF_AGGREGATIONSVC)).methodReturn(CodegenExpressionBuilder.staticMethod(OrderByProcessorUtil.class, "sortGivenOutgoingAndSortKeys", OrderByProcessorCodegenNames.REF_OUTGOINGEVENTS, CodegenExpressionBuilder.ref("sortValuesMultiKeys"), CodegenExpressionBuilder.member(comparator.getMemberId())));
        return namedMethods.addMethod(EventBean[].class, "sortWGroupKeysInternal", CodegenNamedParam.from(EventBean[].class, OrderByProcessorCodegenNames.REF_OUTGOINGEVENTS.getRef(), EventBean[][].class, OrderByProcessorCodegenNames.REF_GENERATINGEVENTS.getRef(), Object[].class, "groupByKeys", Boolean.TYPE, ResultSetProcessorCodegenNames.REF_ISNEWDATA.getRef(), ExprEvaluatorContext.class, ExprForgeCodegenNames.REF_EXPREVALCONTEXT.getRef(), AggregationService.class, ResultSetProcessorCodegenNames.REF_AGGREGATIONSVC.getRef()), OrderByProcessorImpl.class, classScope, code);
    }

    private List<Object> createSortProperties(EventBean[][] generatingEvents, Object[] groupByKeys, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext, AggregationService aggregationService) {
        Object[] sortProperties = new Object[generatingEvents.length];
        OrderByElementEval[] elements = this.factory.getOrderBy();
        if (elements.length == 1) {
            int count = 0;
            for (EventBean[] eventsPerStream : generatingEvents) {
                if (this.factory.isNeedsGroupByKeys()) {
                    aggregationService.setCurrentAccess(groupByKeys[count], exprEvaluatorContext.getAgentInstanceId(), null);
                }
                sortProperties[count] = elements[0].getExpr().evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
                ++count;
            }
        } else {
            int count = 0;
            for (EventBean[] eventsPerStream : generatingEvents) {
                if (this.factory.isNeedsGroupByKeys()) {
                    aggregationService.setCurrentAccess(groupByKeys[count], exprEvaluatorContext.getAgentInstanceId(), null);
                }
                Object[] values = new Object[this.factory.getOrderBy().length];
                int countTwo = 0;
                for (OrderByElementEval sortPair : this.factory.getOrderBy()) {
                    values[countTwo++] = sortPair.getExpr().evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
                }
                sortProperties[count] = new HashableMultiKey(values);
                ++count;
            }
        }
        return Arrays.asList(sortProperties);
    }

    private static CodegenMethodNode createSortPropertiesCodegen(OrderByProcessorForgeImpl forge, CodegenClassScope classScope, CodegenNamedMethods namedMethods) {
        Consumer<CodegenMethodNode> code = method -> {
            method.getBlock().declareVar(Object[].class, "sortProperties", CodegenExpressionBuilder.newArrayByLength(Object.class, CodegenExpressionBuilder.arrayLength(OrderByProcessorCodegenNames.REF_GENERATINGEVENTS)));
            OrderByElementForge[] elements = forge.getOrderBy();
            CodegenBlock forEach = method.getBlock().declareVar(Integer.TYPE, "count", CodegenExpressionBuilder.constant(0)).forEach(EventBean[].class, "eventsPerStream", OrderByProcessorCodegenNames.REF_GENERATINGEVENTS);
            if (forge.isNeedsGroupByKeys()) {
                forEach.exprDotMethod(ResultSetProcessorCodegenNames.REF_AGGREGATIONSVC, "setCurrentAccess", CodegenExpressionBuilder.arrayAtIndex(CodegenExpressionBuilder.ref("groupByKeys"), CodegenExpressionBuilder.ref("count")), CodegenExpressionBuilder.exprDotMethod(ExprForgeCodegenNames.REF_EXPREVALCONTEXT, "getAgentInstanceId", new CodegenExpression[0]), CodegenExpressionBuilder.constantNull());
            }
            if (elements.length == 1) {
                forEach.assignArrayElement("sortProperties", (CodegenExpression)CodegenExpressionBuilder.ref("count"), (CodegenExpression)CodegenExpressionBuilder.localMethod(CodegenLegoMethodExpression.codegenExpression(elements[0].getExprNode().getForge(), method, classScope), CodegenExpressionBuilder.ref("eventsPerStream"), ResultSetProcessorCodegenNames.REF_ISNEWDATA, ExprForgeCodegenNames.REF_EXPREVALCONTEXT));
            } else {
                forEach.declareVar(Object[].class, "values", CodegenExpressionBuilder.newArrayByLength(Object.class, CodegenExpressionBuilder.constant(forge.getOrderBy().length)));
                for (int i = 0; i < forge.getOrderBy().length; ++i) {
                    forEach.assignArrayElement("values", CodegenExpressionBuilder.constant(i), (CodegenExpression)CodegenExpressionBuilder.localMethod(CodegenLegoMethodExpression.codegenExpression(elements[i].getExprNode().getForge(), method, classScope), CodegenExpressionBuilder.ref("eventsPerStream"), ResultSetProcessorCodegenNames.REF_ISNEWDATA, ExprForgeCodegenNames.REF_EXPREVALCONTEXT));
                }
                forEach.assignArrayElement("sortProperties", (CodegenExpression)CodegenExpressionBuilder.ref("count"), CodegenExpressionBuilder.newInstance(HashableMultiKey.class, CodegenExpressionBuilder.ref("values")));
            }
            forEach.increment("count");
            method.getBlock().methodReturn(CodegenExpressionBuilder.staticMethod(Arrays.class, "asList", CodegenExpressionBuilder.ref("sortProperties")));
        };
        return namedMethods.addMethod(List.class, "createSortProperties", CodegenNamedParam.from(EventBean[][].class, OrderByProcessorCodegenNames.REF_GENERATINGEVENTS.getRef(), Object[].class, "groupByKeys", Boolean.TYPE, ResultSetProcessorCodegenNames.REF_ISNEWDATA.getRef(), ExprEvaluatorContext.class, ExprForgeCodegenNames.REF_EXPREVALCONTEXT.getRef(), AggregationService.class, ResultSetProcessorCodegenNames.REF_AGGREGATIONSVC.getRef()), OrderByProcessorImpl.class, classScope, code);
    }

    @Override
    public EventBean[] sortWOrderKeys(EventBean[] outgoingEvents, Object[] orderKeys, ExprEvaluatorContext exprEvaluatorContext) {
        return OrderByProcessorUtil.sortWOrderKeys(outgoingEvents, orderKeys, this.factory.getComparator());
    }

    static void sortWOrderKeysCodegen(OrderByProcessorForgeImpl forge, CodegenMethodNode method, CodegenClassScope classScope) {
        CodegenMember comparator = classScope.makeAddMember(Comparator.class, forge.getComparator());
        method.getBlock().methodReturn(CodegenExpressionBuilder.staticMethod(OrderByProcessorUtil.class, "sortWOrderKeys", OrderByProcessorCodegenNames.REF_OUTGOINGEVENTS, OrderByProcessorCodegenNames.REF_ORDERKEYS, CodegenExpressionBuilder.member(comparator.getMemberId())));
    }

    @Override
    public EventBean[] sortTwoKeys(EventBean first, Object sortKeyFirst, EventBean second, Object sortKeySecond) {
        if (this.factory.getComparator().compare(sortKeyFirst, sortKeySecond) <= 0) {
            return new EventBean[]{first, second};
        }
        return new EventBean[]{second, first};
    }

    static void sortTwoKeysCodegen(OrderByProcessorForgeImpl forge, CodegenMethodNode method, CodegenClassScope classScope, CodegenNamedMethods namedMethods) {
        CodegenMember comparator = classScope.makeAddMember(Comparator.class, forge.getComparator());
        CodegenExpression compare = CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.member(comparator.getMemberId()), "compare", OrderByProcessorCodegenNames.REF_ORDERFIRSTSORTKEY, OrderByProcessorCodegenNames.REF_ORDERSECONDSORTKEY);
        method.getBlock().ifCondition(CodegenExpressionBuilder.relational(compare, CodegenExpressionRelational.CodegenRelational.LE, CodegenExpressionBuilder.constant(0))).blockReturn(CodegenExpressionBuilder.newArrayWithInit(EventBean.class, OrderByProcessorCodegenNames.REF_ORDERFIRSTEVENT, OrderByProcessorCodegenNames.REF_ORDERSECONDEVENT)).methodReturn(CodegenExpressionBuilder.newArrayWithInit(EventBean.class, OrderByProcessorCodegenNames.REF_ORDERSECONDEVENT, OrderByProcessorCodegenNames.REF_ORDERFIRSTEVENT));
    }

    private List<Object> createSortPropertiesWRollup(List<GroupByRollupKey> currentGenerators, OrderByElementEval[][] elementsPerLevel, boolean isNewData, AgentInstanceContext exprEvaluatorContext, AggregationService aggregationService) {
        Object[] sortProperties = new Object[currentGenerators.size()];
        OrderByElementEval[] elements = this.factory.getOrderBy();
        if (elements.length == 1) {
            int count = 0;
            for (GroupByRollupKey rollup : currentGenerators) {
                if (this.factory.isNeedsGroupByKeys()) {
                    aggregationService.setCurrentAccess(rollup.getGroupKey(), exprEvaluatorContext.getAgentInstanceId(), rollup.getLevel());
                }
                sortProperties[count] = elementsPerLevel[rollup.getLevel().getLevelNumber()][0].getExpr().evaluate(rollup.getGenerator(), isNewData, exprEvaluatorContext);
                ++count;
            }
        } else {
            int count = 0;
            for (GroupByRollupKey rollup : currentGenerators) {
                if (this.factory.isNeedsGroupByKeys()) {
                    aggregationService.setCurrentAccess(rollup.getGroupKey(), exprEvaluatorContext.getAgentInstanceId(), rollup.getLevel());
                }
                Object[] values = new Object[this.factory.getOrderBy().length];
                int countTwo = 0;
                for (OrderByElementEval sortPair : elementsPerLevel[rollup.getLevel().getLevelNumber()]) {
                    values[countTwo++] = sortPair.getExpr().evaluate(rollup.getGenerator(), isNewData, exprEvaluatorContext);
                }
                sortProperties[count] = new HashableMultiKey(values);
                ++count;
            }
        }
        return Arrays.asList(sortProperties);
    }

    private static CodegenMethodNode createSortPropertiesWRollupCodegen(OrderByProcessorForgeImpl forge, CodegenClassScope classScope, CodegenNamedMethods namedMethods) {
        Consumer<CodegenMethodNode> code = method -> {
            method.getBlock().declareVar(Object[].class, "sortProperties", CodegenExpressionBuilder.newArrayByLength(Object.class, CodegenExpressionBuilder.exprDotMethod(OrderByProcessorCodegenNames.REF_ORDERCURRENTGENERATORS, "size", new CodegenExpression[0]))).declareVar(Integer.TYPE, "count", CodegenExpressionBuilder.constant(0));
            CodegenBlock forEach = method.getBlock().forEach(GroupByRollupKey.class, "rollup", OrderByProcessorCodegenNames.REF_ORDERCURRENTGENERATORS);
            if (forge.isNeedsGroupByKeys()) {
                forEach.exprDotMethod(ResultSetProcessorCodegenNames.REF_AGGREGATIONSVC, "setCurrentAccess", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("rollup"), "getGroupKey", new CodegenExpression[0]), CodegenExpressionBuilder.exprDotMethod(ExprForgeCodegenNames.REF_EXPREVALCONTEXT, "getAgentInstanceId", new CodegenExpression[0]), CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("rollup"), "getLevel", new CodegenExpression[0]));
            }
            forEach.declareVar(Integer.TYPE, "num", (CodegenExpression)CodegenExpressionBuilder.exprDotMethodChain(CodegenExpressionBuilder.ref("rollup")).add("getLevel", new CodegenExpression[0]).add("getLevelNumber", new CodegenExpression[0]));
            CodegenBlock[] blocks = forEach.switchBlockOfLength("num", forge.getOrderByRollup().length, false);
            for (int i = 0; i < blocks.length; ++i) {
                CodegenMethodNode getSortKey = OrderByProcessorImpl.generateOrderKeyCodegen("getSortKeyInternal_" + i, forge.getOrderByRollup()[i], classScope, namedMethods);
                blocks[i].assignArrayElement("sortProperties", (CodegenExpression)CodegenExpressionBuilder.ref("count"), (CodegenExpression)CodegenExpressionBuilder.localMethod(getSortKey, CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("rollup"), "getGenerator", new CodegenExpression[0]), ResultSetProcessorCodegenNames.REF_ISNEWDATA, ExprForgeCodegenNames.REF_EXPREVALCONTEXT));
            }
            forEach.increment("count");
            method.getBlock().methodReturn(CodegenExpressionBuilder.staticMethod(Arrays.class, "asList", CodegenExpressionBuilder.ref("sortProperties")));
        };
        return namedMethods.addMethod(List.class, "createSortPropertiesWRollup", CodegenNamedParam.from(List.class, OrderByProcessorCodegenNames.REF_ORDERCURRENTGENERATORS.getRef(), Boolean.TYPE, ResultSetProcessorCodegenNames.REF_ISNEWDATA.getRef(), ExprEvaluatorContext.class, ExprForgeCodegenNames.REF_EXPREVALCONTEXT.getRef(), AggregationService.class, ResultSetProcessorCodegenNames.REF_AGGREGATIONSVC.getRef()), OrderByProcessorImpl.class, classScope, code);
    }

    public EventBean determineLocalMinMax(EventBean[] outgoingEvents, EventBean[][] generatingEvents, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext, AggregationService aggregationService) {
        OrderByElementEval[] elements = this.factory.getOrderBy();
        Object localMinMax = null;
        EventBean outgoingMinMaxBean = null;
        if (elements.length == 1) {
            int count = 0;
            for (EventBean[] eventsPerStream : generatingEvents) {
                boolean newMinMax;
                Object sortKey = elements[0].getExpr().evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
                boolean bl = newMinMax = localMinMax == null || this.factory.getComparator().compare(localMinMax, sortKey) > 0;
                if (newMinMax) {
                    localMinMax = sortKey;
                    outgoingMinMaxBean = outgoingEvents[count];
                }
                ++count;
            }
        } else {
            int count = 0;
            Object[] values = new Object[this.factory.getOrderBy().length];
            HashableMultiKey valuesMk = new HashableMultiKey(values);
            for (EventBean[] eventsPerStream : generatingEvents) {
                boolean newMinMax;
                int countTwo = 0;
                for (OrderByElementEval sortPair : this.factory.getOrderBy()) {
                    values[countTwo++] = sortPair.getExpr().evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
                }
                boolean bl = newMinMax = localMinMax == null || this.factory.getComparator().compare(localMinMax, valuesMk) > 0;
                if (newMinMax) {
                    localMinMax = valuesMk;
                    values = new Object[this.factory.getOrderBy().length];
                    valuesMk = new HashableMultiKey(values);
                    outgoingMinMaxBean = outgoingEvents[count];
                }
                ++count;
            }
        }
        return outgoingMinMaxBean;
    }

    public static CodegenMethodNode determineLocalMinMaxCodegen(OrderByProcessorForgeImpl forge, CodegenClassScope classScope, CodegenNamedMethods namedMethods) {
        OrderByElementForge[] elements = forge.getOrderBy();
        CodegenMember comparator = classScope.makeAddMember(Comparator.class, forge.getComparator());
        Consumer<CodegenMethodNode> code = method -> {
            method.getBlock().declareVar(Object.class, "localMinMax", CodegenExpressionBuilder.constantNull()).declareVar(EventBean.class, "outgoingMinMaxBean", CodegenExpressionBuilder.constantNull()).declareVar(Integer.TYPE, "count", CodegenExpressionBuilder.constant(0));
            if (elements.length == 1) {
                CodegenBlock forEach = method.getBlock().forEach(EventBean[].class, "eventsPerStream", OrderByProcessorCodegenNames.REF_GENERATINGEVENTS);
                forEach.declareVar(Object.class, "sortKey", (CodegenExpression)CodegenExpressionBuilder.localMethod(CodegenLegoMethodExpression.codegenExpression(elements[0].getExprNode().getForge(), method, classScope), CodegenExpressionBuilder.ref("eventsPerStream"), ResultSetProcessorCodegenNames.REF_ISNEWDATA, ExprForgeCodegenNames.REF_EXPREVALCONTEXT)).ifCondition(CodegenExpressionBuilder.or(CodegenExpressionBuilder.equalsNull(CodegenExpressionBuilder.ref("localMinMax")), CodegenExpressionBuilder.relational(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.member(comparator.getMemberId()), "compare", CodegenExpressionBuilder.ref("localMinMax"), CodegenExpressionBuilder.ref("sortKey")), CodegenExpressionRelational.CodegenRelational.GT, CodegenExpressionBuilder.constant(0)), new CodegenExpression[0])).assignRef("localMinMax", (CodegenExpression)CodegenExpressionBuilder.ref("sortKey")).assignRef("outgoingMinMaxBean", CodegenExpressionBuilder.arrayAtIndex(OrderByProcessorCodegenNames.REF_OUTGOINGEVENTS, CodegenExpressionBuilder.ref("count"))).blockEnd().increment("count");
            } else {
                method.getBlock().declareVar(Object[].class, "values", CodegenExpressionBuilder.newArrayByLength(Object.class, CodegenExpressionBuilder.constant(elements.length))).declareVar(HashableMultiKey.class, "valuesMk", CodegenExpressionBuilder.newInstance(HashableMultiKey.class, CodegenExpressionBuilder.ref("values")));
                CodegenBlock forEach = method.getBlock().forEach(EventBean[].class, "eventsPerStream", OrderByProcessorCodegenNames.REF_GENERATINGEVENTS);
                if (forge.isNeedsGroupByKeys()) {
                    forEach.exprDotMethod(ResultSetProcessorCodegenNames.REF_AGGREGATIONSVC, "setCurrentAccess", CodegenExpressionBuilder.arrayAtIndex(CodegenExpressionBuilder.ref("groupByKeys"), CodegenExpressionBuilder.ref("count")), CodegenExpressionBuilder.exprDotMethod(ExprForgeCodegenNames.REF_EXPREVALCONTEXT, "getAgentInstanceId", CodegenExpressionBuilder.constantNull()));
                }
                for (int i = 0; i < elements.length; ++i) {
                    forEach.assignArrayElement("values", CodegenExpressionBuilder.constant(i), (CodegenExpression)CodegenExpressionBuilder.localMethod(CodegenLegoMethodExpression.codegenExpression(elements[i].getExprNode().getForge(), method, classScope), CodegenExpressionBuilder.ref("eventsPerStream"), ResultSetProcessorCodegenNames.REF_ISNEWDATA, ExprForgeCodegenNames.REF_EXPREVALCONTEXT));
                }
                forEach.ifCondition(CodegenExpressionBuilder.or(CodegenExpressionBuilder.equalsNull(CodegenExpressionBuilder.ref("localMinMax")), CodegenExpressionBuilder.relational(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.member(comparator.getMemberId()), "compare", CodegenExpressionBuilder.ref("localMinMax"), CodegenExpressionBuilder.ref("valuesMk")), CodegenExpressionRelational.CodegenRelational.GT, CodegenExpressionBuilder.constant(0)), new CodegenExpression[0])).assignRef("localMinMax", (CodegenExpression)CodegenExpressionBuilder.ref("valuesMk")).assignRef("values", CodegenExpressionBuilder.newArrayByLength(Object.class, CodegenExpressionBuilder.constant(elements.length))).assignRef("valuesMk", CodegenExpressionBuilder.newInstance(HashableMultiKey.class, CodegenExpressionBuilder.ref("values"))).assignRef("outgoingMinMaxBean", CodegenExpressionBuilder.arrayAtIndex(OrderByProcessorCodegenNames.REF_OUTGOINGEVENTS, CodegenExpressionBuilder.ref("count"))).blockEnd().increment("count");
            }
            method.getBlock().methodReturn(CodegenExpressionBuilder.ref("outgoingMinMaxBean"));
        };
        return namedMethods.addMethod(EventBean.class, "determineLocalMinMax", CodegenNamedParam.from(EventBean[].class, OrderByProcessorCodegenNames.REF_OUTGOINGEVENTS.getRef(), EventBean[][].class, OrderByProcessorCodegenNames.REF_GENERATINGEVENTS.getRef(), Boolean.TYPE, "isNewData", ExprEvaluatorContext.class, "exprEvalCtx", AggregationService.class, ResultSetProcessorCodegenNames.REF_AGGREGATIONSVC.getRef()), OrderByProcessorImpl.class, classScope, code);
    }

    static CodegenMethodNode generateOrderKeyCodegen(String methodName, OrderByElementForge[] orderBy, CodegenClassScope classScope, CodegenNamedMethods namedMethods) {
        Consumer<CodegenMethodNode> code = methodNode -> {
            if (orderBy.length == 1) {
                CodegenMethodNode expression = CodegenLegoMethodExpression.codegenExpression(orderBy[0].getExprNode().getForge(), methodNode, classScope);
                methodNode.getBlock().methodReturn(CodegenExpressionBuilder.localMethod(expression, EnumForgeCodegenNames.REF_EPS, ResultSetProcessorCodegenNames.REF_ISNEWDATA, ExprForgeCodegenNames.REF_EXPREVALCONTEXT));
                return;
            }
            methodNode.getBlock().declareVar(Object[].class, "keys", CodegenExpressionBuilder.newArrayByLength(Object.class, CodegenExpressionBuilder.constant(orderBy.length)));
            for (int i = 0; i < orderBy.length; ++i) {
                CodegenMethodNode expression = CodegenLegoMethodExpression.codegenExpression(orderBy[i].getExprNode().getForge(), methodNode, classScope);
                methodNode.getBlock().assignArrayElement("keys", CodegenExpressionBuilder.constant(i), (CodegenExpression)CodegenExpressionBuilder.localMethod(expression, EnumForgeCodegenNames.REF_EPS, ResultSetProcessorCodegenNames.REF_ISNEWDATA, ExprForgeCodegenNames.REF_EXPREVALCONTEXT));
            }
            methodNode.getBlock().methodReturn(CodegenExpressionBuilder.newInstance(HashableMultiKey.class, CodegenExpressionBuilder.ref("keys")));
        };
        return namedMethods.addMethod(Object.class, methodName, CodegenNamedParam.from(EventBean[].class, "eventsPerStream", Boolean.TYPE, "isNewData", ExprEvaluatorContext.class, "exprEvalCtx"), ResultSetProcessorUtil.class, classScope, code);
    }

    public Comparator<Object> getComparator() {
        return this.factory.getComparator();
    }
}

