/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core.engineimport;

import com.espertech.esper.client.annotation.Hook;
import com.espertech.esper.client.annotation.HookType;
import com.espertech.esper.epl.core.engineimport.EngineImportException;
import com.espertech.esper.epl.core.engineimport.EngineImportService;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.util.JavaClassHelper;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class EngineImportUtil {
    public static Object resolveIdentAsEnumConst(String constant, EngineImportService engineImportService, boolean isAnnotation) throws ExprValidationException {
        Field field;
        Class clazz;
        int lastDotIndex = constant.lastIndexOf(46);
        if (lastDotIndex == -1) {
            return null;
        }
        String className = constant.substring(0, lastDotIndex);
        String constName = constant.substring(lastDotIndex + 1);
        className = EngineImportUtil.unescape(className);
        constName = EngineImportUtil.unescape(constName);
        try {
            clazz = engineImportService.resolveClass(className, isAnnotation);
        }
        catch (EngineImportException e) {
            return null;
        }
        try {
            field = clazz.getField(constName);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        int modifiers = field.getModifiers();
        if (Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers)) {
            try {
                return field.get(null);
            }
            catch (IllegalAccessException e) {
                throw new ExprValidationException("Exception accessing field '" + field.getName() + "': " + e.getMessage(), e);
            }
        }
        return null;
    }

    public static Object getAnnotationHook(Annotation[] annotations, HookType hookType, Class interfaceExpected, EngineImportService engineImportService) throws ExprValidationException {
        Class clazz;
        Hook hook;
        if (annotations == null) {
            return null;
        }
        String hookClass = null;
        for (int i = 0; i < annotations.length; ++i) {
            if (!(annotations[i] instanceof Hook) || (hook = (Hook)annotations[i]).type() != hookType) continue;
            hookClass = hook.hook();
        }
        if (hookClass == null) {
            return null;
        }
        try {
            clazz = engineImportService.resolveClass(hookClass, false);
        }
        catch (Exception e) {
            throw new ExprValidationException("Failed to resolve hook provider of hook type '" + (Object)((Object)hookType) + "' import '" + hookClass + "' :" + e.getMessage());
        }
        if (!JavaClassHelper.isImplementsInterface(clazz, interfaceExpected)) {
            throw new ExprValidationException("Hook provider for hook type '" + (Object)((Object)hookType) + "' class '" + clazz.getName() + "' does not implement the required '" + interfaceExpected.getSimpleName() + "' interface");
        }
        try {
            hook = clazz.newInstance();
        }
        catch (Exception e) {
            throw new ExprValidationException("Failed to instantiate hook provider of hook type '" + (Object)((Object)hookType) + "' class '" + clazz.getName() + "' :" + e.getMessage());
        }
        return hook;
    }

    private static String unescape(String name) {
        if (name.startsWith("`") && name.endsWith("`")) {
            return name.substring(1, name.length() - 1);
        }
        return name;
    }
}

