/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg.util;

import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.agg.access.AggregationAccessorSlotPair;
import com.espertech.esper.epl.agg.service.common.AggregationStateFactory;
import com.espertech.esper.epl.agg.service.common.AggregatorUtil;
import com.espertech.esper.epl.agg.service.groupbylocal.AggSvcLocalGroupByForge;
import com.espertech.esper.epl.agg.util.AggregationLocalGroupByColumn;
import com.espertech.esper.epl.agg.util.AggregationLocalGroupByColumnForge;
import com.espertech.esper.epl.agg.util.AggregationLocalGroupByLevel;
import com.espertech.esper.epl.agg.util.AggregationLocalGroupByLevelForge;
import com.espertech.esper.epl.agg.util.AggregationLocalGroupByPlan;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprNodeUtilityCore;
import com.espertech.esper.epl.util.ExprNodeUtilityRich;

public class AggregationLocalGroupByPlanForge {
    private final int numMethods;
    private final int numAccess;
    private final AggregationLocalGroupByColumnForge[] columnsForges;
    private final AggregationLocalGroupByLevelForge optionalLevelTopForge;
    private final AggregationLocalGroupByLevelForge[] allLevelsForges;

    public AggregationLocalGroupByPlanForge(int numMethods, int numAccess, AggregationLocalGroupByColumnForge[] columns, AggregationLocalGroupByLevelForge optionalLevelTop, AggregationLocalGroupByLevelForge[] allLevels) {
        this.numMethods = numMethods;
        this.numAccess = numAccess;
        this.columnsForges = columns;
        this.optionalLevelTopForge = optionalLevelTop;
        this.allLevelsForges = allLevels;
    }

    public AggregationLocalGroupByColumnForge[] getColumnsForges() {
        return this.columnsForges;
    }

    public AggregationLocalGroupByLevelForge getOptionalLevelTopForge() {
        return this.optionalLevelTopForge;
    }

    public AggregationLocalGroupByLevelForge[] getAllLevelsForges() {
        return this.allLevelsForges;
    }

    public int getNumMethods() {
        return this.numMethods;
    }

    public int getNumAccess() {
        return this.numAccess;
    }

    public AggregationLocalGroupByPlan toEvaluators(StatementContext stmtContext, boolean isFireAndForget) {
        AggregationLocalGroupByColumn[] columns = new AggregationLocalGroupByColumn[this.columnsForges.length];
        for (int i = 0; i < columns.length; ++i) {
            AggregationLocalGroupByColumnForge forge = this.columnsForges[i];
            ExprEvaluator[] evaluators = ExprNodeUtilityRich.getEvaluatorsMayCompile(forge.getPartitionForges(), stmtContext.getEngineImportService(), AggSvcLocalGroupByForge.class, isFireAndForget, stmtContext.getStatementName());
            AggregationAccessorSlotPair pair = forge.getPair() == null ? null : AggregatorUtil.getAccessorForForge(forge.getPair(), stmtContext.getEngineImportService(), isFireAndForget, stmtContext.getStatementName());
            columns[i] = new AggregationLocalGroupByColumn(forge.isDefaultGroupLevel(), evaluators, forge.getMethodOffset(), forge.isMethodAgg(), pair, forge.getLevelNum());
        }
        AggregationLocalGroupByLevel optionalLevelTop = this.optionalLevelTopForge == null ? null : this.makeLevel(this.optionalLevelTopForge, stmtContext, isFireAndForget);
        AggregationLocalGroupByLevel[] allLevels = new AggregationLocalGroupByLevel[this.allLevelsForges.length];
        for (int i = 0; i < allLevels.length; ++i) {
            allLevels[i] = this.makeLevel(this.allLevelsForges[i], stmtContext, isFireAndForget);
        }
        return new AggregationLocalGroupByPlan(this.numMethods, this.numAccess, columns, optionalLevelTop, allLevels);
    }

    private AggregationLocalGroupByLevel makeLevel(AggregationLocalGroupByLevelForge forge, StatementContext stmtContext, boolean isFireAndForget) {
        ExprEvaluator[] methodEvaluators = ExprNodeUtilityRich.getEvaluatorsMayCompileWMultiValue(forge.getMethodForges(), stmtContext.getEngineImportService(), this.getClass(), isFireAndForget, stmtContext.getStatementName());
        AggregationStateFactory[] stateFactories = AggregatorUtil.getAccesssFactoriesFromForges(forge.getAccessStateForges(), stmtContext, isFireAndForget);
        ExprEvaluator[] partitionEvaluators = ExprNodeUtilityRich.getEvaluatorsMayCompile(forge.getPartitionForges(), stmtContext.getEngineImportService(), this.getClass(), isFireAndForget, stmtContext.getStatementName());
        Class[] partitionEvaluatorsTypes = ExprNodeUtilityCore.getExprResultTypes(forge.getPartitionForges());
        return new AggregationLocalGroupByLevel(methodEvaluators, forge.getMethodFactories(), stateFactories, partitionEvaluators, partitionEvaluatorsTypes, forge.isDefaultLevel());
    }
}

