/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg.service.table;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMember;
import com.espertech.esper.codegen.base.CodegenMethodNode;
import com.espertech.esper.codegen.base.CodegenMethodScope;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.codegen.model.expression.CodegenExpressionRelational;
import com.espertech.esper.epl.agg.access.AggregationAccessorSlotPair;
import com.espertech.esper.epl.agg.access.AggregationAgent;
import com.espertech.esper.epl.agg.access.AggregationAgentCodegenSymbols;
import com.espertech.esper.epl.agg.access.AggregationAgentForge;
import com.espertech.esper.epl.agg.access.AggregationState;
import com.espertech.esper.epl.agg.aggregator.AggregationMethod;
import com.espertech.esper.epl.agg.codegen.AggregationServiceCodegenNames;
import com.espertech.esper.epl.agg.service.common.AggregationGroupByRollupLevel;
import com.espertech.esper.epl.agg.service.common.AggregationRowPair;
import com.espertech.esper.epl.agg.service.common.AggregationRowRemovedCallback;
import com.espertech.esper.epl.agg.service.common.AggregationService;
import com.espertech.esper.epl.agg.service.common.AggregationServiceVisitor;
import com.espertech.esper.epl.agg.service.common.AggregationServiceVisitorWGroupDetail;
import com.espertech.esper.epl.agg.service.table.AggSvcGroupByWTableCodegenUtil;
import com.espertech.esper.epl.agg.service.table.AggSvcGroupByWTableUtil;
import com.espertech.esper.epl.agg.service.table.AggSvcTableGetterType;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenNames;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.table.mgmt.TableColumnMethodPair;
import com.espertech.esper.epl.table.mgmt.TableStateInstanceUngrouped;
import com.espertech.esper.epl.table.strategy.ExprTableEvalLockUtil;
import com.espertech.esper.epl.table.strategy.ExprTableEvalStrategyUtil;
import com.espertech.esper.event.ObjectArrayBackedEventBean;
import java.util.Collection;
import java.util.concurrent.locks.Lock;

public class AggSvcGroupAllWTableImpl
implements AggregationService {
    private final TableStateInstanceUngrouped tableStateInstance;
    private final TableColumnMethodPair[] methodPairs;
    private final AggregationAccessorSlotPair[] accessors;
    private final int[] targetStates;
    private final ExprNode[] accessStateExpr;
    private final AggregationAgent[] agents;

    public AggSvcGroupAllWTableImpl(TableStateInstanceUngrouped tableStateInstance, TableColumnMethodPair[] methodPairs, AggregationAccessorSlotPair[] accessors, int[] targetStates, ExprNode[] accessStateExpr, AggregationAgent[] agents) {
        this.tableStateInstance = tableStateInstance;
        this.methodPairs = methodPairs;
        this.accessors = accessors;
        this.targetStates = targetStates;
        this.accessStateExpr = accessStateExpr;
        this.agents = agents;
    }

    @Override
    public void applyEnter(EventBean[] eventsPerStream, Object optionalGroupKeyPerRow, ExprEvaluatorContext exprEvaluatorContext) {
        int i;
        ExprTableEvalLockUtil.obtainLockUnless((Lock)this.tableStateInstance.getTableLevelRWLock().writeLock(), exprEvaluatorContext);
        ObjectArrayBackedEventBean event = this.tableStateInstance.getCreateRowIntoTable(null, exprEvaluatorContext);
        AggregationRowPair row = ExprTableEvalStrategyUtil.getRow(event);
        for (i = 0; i < this.methodPairs.length; ++i) {
            TableColumnMethodPair methodPair = this.methodPairs[i];
            AggregationMethod method = row.getMethods()[methodPair.getTargetIndex()];
            Object columnResult = methodPair.getEvaluator().evaluate(eventsPerStream, true, exprEvaluatorContext);
            method.enter(columnResult);
        }
        for (i = 0; i < this.targetStates.length; ++i) {
            AggregationState state = row.getStates()[this.targetStates[i]];
            this.agents[i].applyEnter(eventsPerStream, exprEvaluatorContext, state);
        }
        this.tableStateInstance.handleRowUpdated(event);
    }

    @Override
    public void applyLeave(EventBean[] eventsPerStream, Object optionalGroupKeyPerRow, ExprEvaluatorContext exprEvaluatorContext) {
        int i;
        ExprTableEvalLockUtil.obtainLockUnless((Lock)this.tableStateInstance.getTableLevelRWLock().writeLock(), exprEvaluatorContext);
        ObjectArrayBackedEventBean event = this.tableStateInstance.getCreateRowIntoTable(null, exprEvaluatorContext);
        AggregationRowPair row = ExprTableEvalStrategyUtil.getRow(event);
        for (i = 0; i < this.methodPairs.length; ++i) {
            TableColumnMethodPair methodPair = this.methodPairs[i];
            AggregationMethod method = row.getMethods()[methodPair.getTargetIndex()];
            Object columnResult = methodPair.getEvaluator().evaluate(eventsPerStream, false, exprEvaluatorContext);
            method.leave(columnResult);
        }
        for (i = 0; i < this.targetStates.length; ++i) {
            AggregationState state = row.getStates()[this.targetStates[i]];
            this.agents[i].applyLeave(eventsPerStream, exprEvaluatorContext, state);
        }
        this.tableStateInstance.handleRowUpdated(event);
    }

    public static CodegenMethodNode applyCodegen(boolean enter, CodegenMethodScope parent, CodegenClassScope classScope, TableColumnMethodPair[] methodPairs, AggregationAgentForge[] agentForges, AggregationAgent[] agents, int[] targetStates) {
        int i;
        AggregationAgentCodegenSymbols symbols = new AggregationAgentCodegenSymbols(true, true);
        CodegenMethodNode method = parent.makeChildWithScope(Void.TYPE, AggSvcGroupAllWTableImpl.class, symbols, classScope).addParam(EventBean[].class, "eventsPerStream").addParam(ExprEvaluatorContext.class, "exprEvalCtx");
        method.getBlock().declareVar(ObjectArrayBackedEventBean.class, "event", CodegenExpressionBuilder.exprDotMethod(AggSvcGroupByWTableCodegenUtil.REF_TABLESTATEINSTANCE, "getCreateRowIntoTable", CodegenExpressionBuilder.constantNull(), ExprForgeCodegenNames.REF_EXPREVALCONTEXT)).declareVar(AggregationRowPair.class, "row", CodegenExpressionBuilder.staticMethod(ExprTableEvalStrategyUtil.class, "getRow", CodegenExpressionBuilder.ref("event"))).declareVarNoInit(Object.class, "columnResult").declareVarNoInit(AggregationMethod.class, "method").declareVarNoInit(AggregationState.class, "state");
        CodegenExpression[] methodEnterLeave = AggSvcGroupByWTableUtil.getMethodEnterLeave(methodPairs, method, symbols, classScope);
        CodegenExpression[] accessEnterLeave = AggSvcGroupByWTableUtil.getAccessEnterLeave(enter, agentForges, agents, method, symbols, classScope);
        symbols.derivedSymbolsCodegen(method, method.getBlock(), classScope);
        for (i = 0; i < methodPairs.length; ++i) {
            TableColumnMethodPair methodPair = methodPairs[i];
            method.getBlock().assignRef("method", CodegenExpressionBuilder.arrayAtIndex(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("row"), "getMethods", new CodegenExpression[0]), CodegenExpressionBuilder.constant(methodPair.getTargetIndex()))).assignRef("columnResult", methodEnterLeave[i]).exprDotMethod(CodegenExpressionBuilder.ref("method"), enter ? "enter" : "leave", CodegenExpressionBuilder.ref("columnResult"));
        }
        for (i = 0; i < agentForges.length; ++i) {
            method.getBlock().assignRef("state", CodegenExpressionBuilder.arrayAtIndex(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("row"), "getStates", new CodegenExpression[0]), CodegenExpressionBuilder.constant(targetStates[i]))).expression(accessEnterLeave[i]);
        }
        method.getBlock().exprDotMethod(AggSvcGroupByWTableCodegenUtil.REF_TABLESTATEINSTANCE, "handleRowUpdated", CodegenExpressionBuilder.ref("event"));
        return method;
    }

    @Override
    public void setCurrentAccess(Object groupKey, int agentInstanceId, AggregationGroupByRollupLevel rollupLevel) {
    }

    @Override
    public Object getValue(int column, int agentInstanceId, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        ExprTableEvalLockUtil.obtainLockUnless((Lock)this.tableStateInstance.getTableLevelRWLock().writeLock(), exprEvaluatorContext);
        ObjectArrayBackedEventBean event = this.tableStateInstance.getEventUngrouped();
        if (event == null) {
            return null;
        }
        AggregationRowPair row = ExprTableEvalStrategyUtil.getRow(event);
        AggregationMethod[] aggregators = row.getMethods();
        if (column < aggregators.length) {
            return aggregators[column].getValue();
        }
        AggregationAccessorSlotPair pair = this.accessors[column - aggregators.length];
        return pair.getAccessor().getValue(row.getStates()[pair.getSlot()], eventsPerStream, isNewData, exprEvaluatorContext);
    }

    public static void getGroupAllValueCodegen(AggSvcTableGetterType getterType, CodegenMethodNode method, CodegenClassScope classScope, AggregationAccessorSlotPair[] accessors) {
        CodegenMember accessorMember = classScope.makeAddMember(AggregationAccessorSlotPair[].class, accessors);
        method.getBlock().declareVar(ObjectArrayBackedEventBean.class, "event", CodegenExpressionBuilder.exprDotMethod(AggSvcGroupByWTableCodegenUtil.REF_TABLESTATEINSTANCE, "getEventUngrouped", new CodegenExpression[0])).ifRefNullReturnNull("event").declareVar(AggregationRowPair.class, "row", CodegenExpressionBuilder.staticMethod(ExprTableEvalStrategyUtil.class, "getRow", CodegenExpressionBuilder.ref("event"))).declareVar(AggregationMethod[].class, "aggregators", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("row"), "getMethods", new CodegenExpression[0])).ifCondition(CodegenExpressionBuilder.relational(AggregationServiceCodegenNames.REF_COLUMN, CodegenExpressionRelational.CodegenRelational.LT, CodegenExpressionBuilder.arrayLength(CodegenExpressionBuilder.ref("aggregators")))).blockReturn(getterType == AggSvcTableGetterType.GETVALUE ? CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.arrayAtIndex(CodegenExpressionBuilder.ref("aggregators"), AggregationServiceCodegenNames.REF_COLUMN), "getValue", new CodegenExpression[0]) : CodegenExpressionBuilder.constantNull()).declareVar(AggregationAccessorSlotPair.class, "pair", CodegenExpressionBuilder.arrayAtIndex(CodegenExpressionBuilder.member(accessorMember.getMemberId()), CodegenExpressionBuilder.op(AggregationServiceCodegenNames.REF_COLUMN, "-", CodegenExpressionBuilder.arrayLength(CodegenExpressionBuilder.ref("aggregators"))))).methodReturn(CodegenExpressionBuilder.exprDotMethodChain(CodegenExpressionBuilder.ref("pair")).add("getAccessor", new CodegenExpression[0]).add(getterType.getAccessorMethod(), CodegenExpressionBuilder.arrayAtIndex(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("row"), "getStates", new CodegenExpression[0]), CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("pair"), "getSlot", new CodegenExpression[0])), ExprForgeCodegenNames.REF_EPS, ExprForgeCodegenNames.REF_ISNEWDATA, ExprForgeCodegenNames.REF_EXPREVALCONTEXT));
    }

    @Override
    public Collection<EventBean> getCollectionOfEvents(int column, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        ExprTableEvalLockUtil.obtainLockUnless((Lock)this.tableStateInstance.getTableLevelRWLock().writeLock(), context);
        ObjectArrayBackedEventBean event = this.tableStateInstance.getEventUngrouped();
        if (event == null) {
            return null;
        }
        AggregationRowPair row = ExprTableEvalStrategyUtil.getRow(event);
        AggregationMethod[] aggregators = row.getMethods();
        if (column < aggregators.length) {
            return null;
        }
        AggregationAccessorSlotPair pair = this.accessors[column - aggregators.length];
        return pair.getAccessor().getEnumerableEvents(row.getStates()[pair.getSlot()], eventsPerStream, isNewData, context);
    }

    @Override
    public Collection<Object> getCollectionScalar(int column, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        ExprTableEvalLockUtil.obtainLockUnless((Lock)this.tableStateInstance.getTableLevelRWLock().writeLock(), context);
        ObjectArrayBackedEventBean event = this.tableStateInstance.getEventUngrouped();
        if (event == null) {
            return null;
        }
        AggregationRowPair row = ExprTableEvalStrategyUtil.getRow(event);
        AggregationMethod[] aggregators = row.getMethods();
        if (column < aggregators.length) {
            return null;
        }
        AggregationAccessorSlotPair pair = this.accessors[column - aggregators.length];
        return pair.getAccessor().getEnumerableScalar(row.getStates()[pair.getSlot()], eventsPerStream, isNewData, context);
    }

    @Override
    public EventBean getEventBean(int column, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        ExprTableEvalLockUtil.obtainLockUnless((Lock)this.tableStateInstance.getTableLevelRWLock().writeLock(), context);
        ObjectArrayBackedEventBean event = this.tableStateInstance.getEventUngrouped();
        if (event == null) {
            return null;
        }
        AggregationRowPair row = ExprTableEvalStrategyUtil.getRow(event);
        AggregationMethod[] aggregators = row.getMethods();
        if (column < aggregators.length) {
            return null;
        }
        AggregationAccessorSlotPair pair = this.accessors[column - aggregators.length];
        return pair.getAccessor().getEnumerableEvent(row.getStates()[pair.getSlot()], eventsPerStream, isNewData, context);
    }

    @Override
    public void clearResults(ExprEvaluatorContext exprEvaluatorContext) {
    }

    @Override
    public void setRemovedCallback(AggregationRowRemovedCallback callback) {
    }

    @Override
    public void accept(AggregationServiceVisitor visitor) {
    }

    @Override
    public void acceptGroupDetail(AggregationServiceVisitorWGroupDetail visitor) {
    }

    @Override
    public boolean isGrouped() {
        return false;
    }

    @Override
    public Object getGroupKey(int agentInstanceId) {
        return null;
    }

    @Override
    public Collection<Object> getGroupKeys(ExprEvaluatorContext exprEvaluatorContext) {
        return null;
    }

    @Override
    public void stop() {
    }

    @Override
    public AggregationService getContextPartitionAggregationService(int agentInstanceId) {
        return this;
    }
}

