/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg.service.groupbylocal;

import com.espertech.esper.codegen.base.CodegenBlock;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMethodNode;
import com.espertech.esper.codegen.base.CodegenMethodScope;
import com.espertech.esper.codegen.core.CodegenCtor;
import com.espertech.esper.codegen.core.CodegenNamedMethods;
import com.espertech.esper.codegen.core.CodegenTypedParam;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.codegen.model.expression.CodegenExpressionRef;
import com.espertech.esper.codegen.model.expression.CodegenExpressionRelational;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.agg.access.AggregationAccessorSlotPairForge;
import com.espertech.esper.epl.agg.codegen.AggregationCodegenRowDetailDesc;
import com.espertech.esper.epl.agg.codegen.AggregationCodegenRowDetailStateDesc;
import com.espertech.esper.epl.agg.codegen.AggregationCodegenRowLevelDesc;
import com.espertech.esper.epl.agg.codegen.AggregationRowCodegenUtil;
import com.espertech.esper.epl.agg.codegen.AggregationRowGenerated;
import com.espertech.esper.epl.agg.codegen.AggregationServiceCodegenNames;
import com.espertech.esper.epl.agg.service.common.AggregationServiceCodegenUtil;
import com.espertech.esper.epl.agg.service.common.AggregationServiceFactory;
import com.espertech.esper.epl.agg.service.common.AggregationServiceFactoryForge;
import com.espertech.esper.epl.agg.service.groupby.AggSvcGroupByForge;
import com.espertech.esper.epl.agg.service.groupbylocal.AggSvcGroupAllLocalGroupByFactory;
import com.espertech.esper.epl.agg.service.groupbylocal.AggSvcGroupByLocalGroupByFactory;
import com.espertech.esper.epl.agg.service.groupbylocal.AggSvcLocalGroupLevelKeyPair;
import com.espertech.esper.epl.agg.service.table.AggSvcGroupAllWTableImpl;
import com.espertech.esper.epl.agg.util.AggregationLocalGroupByColumnForge;
import com.espertech.esper.epl.agg.util.AggregationLocalGroupByLevelForge;
import com.espertech.esper.epl.agg.util.AggregationLocalGroupByPlan;
import com.espertech.esper.epl.agg.util.AggregationLocalGroupByPlanForge;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenNames;
import com.espertech.esper.epl.expression.core.ExprForge;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AggSvcLocalGroupByForge
implements AggregationServiceFactoryForge {
    private static final CodegenExpressionRef REF_CURRENTROW = new CodegenExpressionRef("currentRow");
    private static final CodegenExpressionRef REF_AGGREGATORSTOPLEVEL = new CodegenExpressionRef("aggregatorsTopLevel");
    private static final CodegenExpressionRef REF_AGGREGATORSPERLEVELANDGROUP = new CodegenExpressionRef("aggregatorsPerLevelAndGroup");
    private static final CodegenExpressionRef REF_REMOVEDKEYS = CodegenExpressionBuilder.ref("removedKeys");
    protected final boolean hasGroupBy;
    protected final boolean join;
    protected final AggregationLocalGroupByPlanForge localGroupByPlan;

    public AggSvcLocalGroupByForge(boolean hasGroupBy, boolean join, AggregationLocalGroupByPlanForge localGroupByPlan) {
        this.hasGroupBy = hasGroupBy;
        this.join = join;
        this.localGroupByPlan = localGroupByPlan;
    }

    @Override
    public AggregationServiceFactory getAggregationServiceFactory(StatementContext stmtContext, boolean isFireAndForget) {
        AggregationLocalGroupByPlan plan = this.localGroupByPlan.toEvaluators(stmtContext, isFireAndForget);
        if (!this.hasGroupBy) {
            return new AggSvcGroupAllLocalGroupByFactory(this.join, plan);
        }
        return new AggSvcGroupByLocalGroupByFactory(this.join, plan);
    }

    @Override
    public AggregationCodegenRowLevelDesc getRowLevelDesc() {
        AggregationCodegenRowDetailDesc top = null;
        if (this.localGroupByPlan.getOptionalLevelTopForge() != null) {
            top = this.mapDesc(true, -1, this.localGroupByPlan.getColumnsForges(), this.localGroupByPlan.getOptionalLevelTopForge());
        }
        AggregationCodegenRowDetailDesc[] additional = null;
        if (this.localGroupByPlan.getAllLevelsForges() != null) {
            additional = new AggregationCodegenRowDetailDesc[this.localGroupByPlan.getAllLevelsForges().length];
            for (int i = 0; i < this.localGroupByPlan.getAllLevelsForges().length; ++i) {
                additional[i] = this.mapDesc(false, i, this.localGroupByPlan.getColumnsForges(), this.localGroupByPlan.getAllLevelsForges()[i]);
            }
        }
        return new AggregationCodegenRowLevelDesc(top, additional);
    }

    @Override
    public void rowCtorCodegen(CodegenClassScope classScope, CodegenCtor rowCtor, List<CodegenTypedParam> rowMembers, CodegenNamedMethods namedMethods) {
        AggregationServiceCodegenUtil.generateRefCount(true, namedMethods, rowCtor, rowMembers, classScope);
    }

    @Override
    public void makeServiceCodegen(CodegenMethodNode method, CodegenClassScope classScope) {
        method.getBlock().methodReturn(CodegenExpressionBuilder.newInstanceInnerClass("AggSvc", CodegenExpressionBuilder.ref("o")));
    }

    @Override
    public void ctorCodegen(CodegenCtor ctor, List<CodegenTypedParam> explicitMembers, CodegenClassScope classScope) {
        explicitMembers.add(new CodegenTypedParam(Map[].class, REF_AGGREGATORSPERLEVELANDGROUP.getRef()));
        ctor.getBlock().assignRef(REF_AGGREGATORSPERLEVELANDGROUP, CodegenExpressionBuilder.newArrayByLength(Map.class, CodegenExpressionBuilder.constant(this.localGroupByPlan.getAllLevelsForges().length)));
        for (int i = 0; i < this.localGroupByPlan.getAllLevelsForges().length; ++i) {
            ctor.getBlock().assignArrayElement(REF_AGGREGATORSPERLEVELANDGROUP, CodegenExpressionBuilder.constant(i), CodegenExpressionBuilder.newInstance(HashMap.class, new CodegenExpression[0]));
        }
        explicitMembers.add(new CodegenTypedParam(AggregationRowGenerated.class, REF_AGGREGATORSTOPLEVEL.getRef()));
        if (this.hasGroupBy) {
            explicitMembers.add(new CodegenTypedParam(AggregationRowGenerated.class, REF_CURRENTROW.getRef()));
        }
        explicitMembers.add(new CodegenTypedParam(List.class, REF_REMOVEDKEYS.getRef()));
        ctor.getBlock().assignRef(REF_REMOVEDKEYS, CodegenExpressionBuilder.newInstance(ArrayList.class, new CodegenExpression[0]));
    }

    @Override
    public void getValueCodegen(CodegenMethodNode method, CodegenClassScope classScope, CodegenNamedMethods namedMethods) {
        this.getterCodegen("getValue", method, classScope, namedMethods);
    }

    @Override
    public void getCollectionOfEventsCodegen(CodegenMethodNode method, CodegenClassScope classScope, CodegenNamedMethods namedMethods) {
        this.getterCodegen("getCollectionOfEvents", method, classScope, namedMethods);
    }

    @Override
    public void getEventBeanCodegen(CodegenMethodNode method, CodegenClassScope classScope, CodegenNamedMethods namedMethods) {
        this.getterCodegen("getEventBean", method, classScope, namedMethods);
    }

    @Override
    public void getCollectionScalarCodegen(CodegenMethodNode method, CodegenClassScope classScope, CodegenNamedMethods namedMethods) {
        this.getterCodegen("getCollectionScalar", method, classScope, namedMethods);
    }

    @Override
    public void applyEnterCodegen(CodegenMethodNode method, CodegenClassScope classScope, CodegenNamedMethods namedMethods) {
        this.applyCodegen(true, method, classScope, namedMethods);
    }

    @Override
    public void applyLeaveCodegen(CodegenMethodNode method, CodegenClassScope classScope, CodegenNamedMethods namedMethods) {
        this.applyCodegen(false, method, classScope, namedMethods);
    }

    @Override
    public void stopMethodCodegen(AggregationServiceFactoryForge forge, CodegenMethodNode method) {
    }

    @Override
    public void setRemovedCallbackCodegen(CodegenMethodNode method) {
    }

    @Override
    public void setCurrentAccessCodegen(CodegenMethodNode method, CodegenClassScope classScope) {
        if (this.hasGroupBy) {
            if (!this.localGroupByPlan.getAllLevelsForges()[0].isDefaultLevel()) {
                return;
            }
            int indexDefault = -1;
            for (int i = 0; i < this.localGroupByPlan.getAllLevelsForges().length; ++i) {
                if (!this.localGroupByPlan.getAllLevelsForges()[i].isDefaultLevel()) continue;
                indexDefault = i;
            }
            method.getBlock().assignRef(REF_CURRENTROW, CodegenExpressionBuilder.cast(AggregationRowGenerated.class, CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.arrayAtIndex(REF_AGGREGATORSPERLEVELANDGROUP, CodegenExpressionBuilder.constant(0)), "get", AggregationServiceCodegenNames.REF_GROUPKEY))).ifCondition(CodegenExpressionBuilder.equalsNull(REF_CURRENTROW)).assignRef(REF_CURRENTROW, CodegenExpressionBuilder.newInstanceInnerClass(AggregationRowCodegenUtil.classnameForLevel(indexDefault), CodegenExpressionBuilder.ref("o")));
        }
    }

    @Override
    public void clearResultsCodegen(CodegenMethodNode method, CodegenClassScope classScope) {
        method.getBlock().ifCondition(CodegenExpressionBuilder.notEqualsNull(REF_AGGREGATORSTOPLEVEL)).exprDotMethod(REF_AGGREGATORSTOPLEVEL, "clear", new CodegenExpression[0]);
        for (int i = 0; i < this.localGroupByPlan.getAllLevelsForges().length; ++i) {
            method.getBlock().exprDotMethod(CodegenExpressionBuilder.arrayAtIndex(REF_AGGREGATORSPERLEVELANDGROUP, CodegenExpressionBuilder.constant(i)), "clear", new CodegenExpression[0]);
        }
    }

    @Override
    public void acceptCodegen(CodegenMethodNode method, CodegenClassScope classScope) {
        method.getBlock().exprDotMethod(AggregationServiceCodegenNames.REF_AGGVISITOR, "visitAggregations", this.getNumGroupsCodegen(method, classScope), REF_AGGREGATORSTOPLEVEL, REF_AGGREGATORSPERLEVELANDGROUP);
    }

    @Override
    public void getGroupKeysCodegen(CodegenMethodNode method, CodegenClassScope classScope) {
        method.getBlock().methodThrowUnsupported();
    }

    @Override
    public void getGroupKeyCodegen(CodegenMethodNode method, CodegenClassScope classScope) {
        method.getBlock().methodReturn(CodegenExpressionBuilder.constantNull());
    }

    @Override
    public void acceptGroupDetailCodegen(CodegenMethodNode method, CodegenClassScope classScope) {
        method.getBlock().exprDotMethod(AggregationServiceCodegenNames.REF_AGGVISITOR, "visitGrouped", this.getNumGroupsCodegen(method, classScope)).ifCondition(CodegenExpressionBuilder.notEqualsNull(REF_AGGREGATORSTOPLEVEL)).exprDotMethod(AggregationServiceCodegenNames.REF_AGGVISITOR, "visitGroup", CodegenExpressionBuilder.constantNull(), REF_AGGREGATORSTOPLEVEL);
        for (int i = 0; i < this.localGroupByPlan.getAllLevelsForges().length; ++i) {
            method.getBlock().forEach(Map.Entry.class, "entry", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.arrayAtIndex(REF_AGGREGATORSPERLEVELANDGROUP, CodegenExpressionBuilder.constant(i)), "entrySet", new CodegenExpression[0])).exprDotMethod(AggregationServiceCodegenNames.REF_AGGVISITOR, "visitGroup", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("entry"), "getKey", new CodegenExpression[0]), CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("entry"), "getValue", new CodegenExpression[0]));
        }
    }

    @Override
    public void isGroupedCodegen(CodegenMethodNode method, CodegenClassScope classScope) {
        method.getBlock().methodReturn(CodegenExpressionBuilder.constantTrue());
    }

    private CodegenExpression getNumGroupsCodegen(CodegenMethodScope parent, CodegenClassScope classScope) {
        CodegenMethodNode method = parent.makeChild(Integer.TYPE, AggSvcGroupAllWTableImpl.class, classScope);
        method.getBlock().declareVar(Integer.TYPE, "size", CodegenExpressionBuilder.constant(0)).ifCondition(CodegenExpressionBuilder.notEqualsNull(REF_AGGREGATORSTOPLEVEL)).increment("size").blockEnd();
        for (int i = 0; i < this.localGroupByPlan.getAllLevelsForges().length; ++i) {
            method.getBlock().assignCompound("size", "+", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.arrayAtIndex(REF_AGGREGATORSPERLEVELANDGROUP, CodegenExpressionBuilder.constant(i)), "size", new CodegenExpression[0]));
        }
        method.getBlock().methodReturn(CodegenExpressionBuilder.ref("size"));
        return CodegenExpressionBuilder.localMethod(method, new CodegenExpression[0]);
    }

    private void applyCodegen(boolean enter, CodegenMethodNode method, CodegenClassScope classScope, CodegenNamedMethods namedMethods) {
        if (enter) {
            method.getBlock().localMethod(this.handleRemovedKeysCodegen(method, classScope), new CodegenExpression[0]);
        }
        if (this.localGroupByPlan.getOptionalLevelTopForge() != null) {
            method.getBlock().ifCondition(CodegenExpressionBuilder.equalsNull(REF_AGGREGATORSTOPLEVEL)).assignRef(REF_AGGREGATORSTOPLEVEL, CodegenExpressionBuilder.newInstanceInnerClass("AggRowTop", CodegenExpressionBuilder.ref("o"))).blockEnd().exprDotMethod(REF_AGGREGATORSTOPLEVEL, enter ? "applyEnter" : "applyLeave", ExprForgeCodegenNames.REF_EPS, ExprForgeCodegenNames.REF_EXPREVALCONTEXT);
        }
        for (int levelNum = 0; levelNum < this.localGroupByPlan.getAllLevelsForges().length; ++levelNum) {
            AggregationLocalGroupByLevelForge level = this.localGroupByPlan.getAllLevelsForges()[levelNum];
            ExprForge[] partitionForges = level.getPartitionForges();
            String groupKeyName = "groupKeyLvl_" + levelNum;
            String rowName = "row_" + levelNum;
            CodegenExpressionRef groupKeyExp = this.hasGroupBy && level.isDefaultLevel() ? AggregationServiceCodegenNames.REF_GROUPKEY : CodegenExpressionBuilder.localMethod(AggregationServiceCodegenUtil.computeMultiKeyCodegen(levelNum, partitionForges, classScope, namedMethods), ExprForgeCodegenNames.REF_EPS, CodegenExpressionBuilder.constantTrue(), ExprForgeCodegenNames.REF_EXPREVALCONTEXT);
            method.getBlock().declareVar(Object.class, groupKeyName, (CodegenExpression)groupKeyExp).declareVar(AggregationRowGenerated.class, rowName, CodegenExpressionBuilder.cast(AggregationRowGenerated.class, CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.arrayAtIndex(REF_AGGREGATORSPERLEVELANDGROUP, CodegenExpressionBuilder.constant(levelNum)), "get", CodegenExpressionBuilder.ref(groupKeyName)))).ifCondition(CodegenExpressionBuilder.equalsNull(CodegenExpressionBuilder.ref(rowName))).assignRef(rowName, CodegenExpressionBuilder.newInstanceInnerClass(AggregationRowCodegenUtil.classnameForLevel(levelNum), CodegenExpressionBuilder.ref("o"))).exprDotMethod(CodegenExpressionBuilder.arrayAtIndex(REF_AGGREGATORSPERLEVELANDGROUP, CodegenExpressionBuilder.constant(levelNum)), "put", CodegenExpressionBuilder.ref(groupKeyName), CodegenExpressionBuilder.ref(rowName)).ifElse().exprDotMethod(CodegenExpressionBuilder.ref(rowName), enter ? "increaseRefcount" : "decreaseRefcount", new CodegenExpression[0]).blockEnd().exprDotMethod(CodegenExpressionBuilder.ref(rowName), enter ? "applyEnter" : "applyLeave", ExprForgeCodegenNames.REF_EPS, ExprForgeCodegenNames.REF_EXPREVALCONTEXT);
            if (enter) continue;
            method.getBlock().ifCondition(CodegenExpressionBuilder.relational(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref(rowName), "getRefcount", new CodegenExpression[0]), CodegenExpressionRelational.CodegenRelational.LE, CodegenExpressionBuilder.constant(0))).exprDotMethod(REF_REMOVEDKEYS, "add", CodegenExpressionBuilder.newInstance(AggSvcLocalGroupLevelKeyPair.class, CodegenExpressionBuilder.constant(levelNum), CodegenExpressionBuilder.ref(groupKeyName)));
        }
    }

    private AggregationCodegenRowDetailDesc mapDesc(boolean top, int levelNum, AggregationLocalGroupByColumnForge[] columns, AggregationLocalGroupByLevelForge level) {
        ArrayList<AggregationAccessorSlotPairForge> accessAccessors = new ArrayList<AggregationAccessorSlotPairForge>(4);
        for (int i = 0; i < columns.length; ++i) {
            AggregationLocalGroupByColumnForge column = columns[i];
            if (column.getPair() == null) continue;
            if (top && column.isDefaultGroupLevel()) {
                accessAccessors.add(column.getPair());
                continue;
            }
            if (column.getLevelNum() != levelNum) continue;
            accessAccessors.add(column.getPair());
        }
        AggregationAccessorSlotPairForge[] pairs = accessAccessors.toArray(new AggregationAccessorSlotPairForge[accessAccessors.size()]);
        return new AggregationCodegenRowDetailDesc(new AggregationCodegenRowDetailStateDesc(level.getMethodForges(), level.getMethodFactories(), level.getAccessStateForges()), pairs);
    }

    private int accessorIndex(AggregationAccessorSlotPairForge[] accessAccessors, AggregationAccessorSlotPairForge pair) {
        for (int i = 0; i < accessAccessors.length; ++i) {
            if (accessAccessors[i] != pair) continue;
            return i;
        }
        throw new IllegalStateException();
    }

    private void getterCodegen(String methodName, CodegenMethodNode method, CodegenClassScope classScope, CodegenNamedMethods namedMethods) {
        AggregationCodegenRowLevelDesc rowLevelDesc = this.getRowLevelDesc();
        CodegenBlock[] blocks = method.getBlock().switchBlockOfLength("column", this.localGroupByPlan.getColumnsForges().length, true);
        for (int i = 0; i < blocks.length; ++i) {
            int num;
            AggregationCodegenRowDetailDesc levelDesc;
            AggregationLocalGroupByColumnForge col = this.localGroupByPlan.getColumnsForges()[i];
            if (this.hasGroupBy && col.isDefaultGroupLevel()) {
                levelDesc = rowLevelDesc.getOptionalAdditionalRows()[col.getLevelNum()];
                num = col.isMethodAgg() ? col.getMethodOffset() : levelDesc.getStateDesc().getMethodFactories().length + this.accessorIndex(levelDesc.getAccessAccessors(), col.getPair());
                blocks[i].blockReturn(CodegenExpressionBuilder.exprDotMethod(REF_CURRENTROW, methodName, CodegenExpressionBuilder.constant(num), ExprForgeCodegenNames.REF_EPS, ExprForgeCodegenNames.REF_ISNEWDATA, ExprForgeCodegenNames.REF_EXPREVALCONTEXT));
                continue;
            }
            if (col.getLevelNum() == -1) {
                levelDesc = rowLevelDesc.getOptionalTopRow();
                num = col.isMethodAgg() ? col.getMethodOffset() : levelDesc.getStateDesc().getMethodFactories().length + this.accessorIndex(levelDesc.getAccessAccessors(), col.getPair());
                blocks[i].blockReturn(CodegenExpressionBuilder.exprDotMethod(REF_AGGREGATORSTOPLEVEL, methodName, CodegenExpressionBuilder.constant(num), ExprForgeCodegenNames.REF_EPS, ExprForgeCodegenNames.REF_ISNEWDATA, ExprForgeCodegenNames.REF_EXPREVALCONTEXT));
                continue;
            }
            levelDesc = rowLevelDesc.getOptionalAdditionalRows()[col.getLevelNum()];
            num = col.isMethodAgg() ? col.getMethodOffset() : levelDesc.getStateDesc().getMethodFactories().length + this.accessorIndex(levelDesc.getAccessAccessors(), col.getPair());
            blocks[i].declareVar(Object.class, "groupByKey", (CodegenExpression)CodegenExpressionBuilder.localMethod(AggregationServiceCodegenUtil.computeMultiKeyCodegen(col.getLevelNum(), col.getPartitionForges(), classScope, namedMethods), ExprForgeCodegenNames.REF_EPS, ExprForgeCodegenNames.REF_ISNEWDATA, ExprForgeCodegenNames.REF_EXPREVALCONTEXT)).declareVar(AggregationRowGenerated.class, "row", CodegenExpressionBuilder.cast(AggregationRowGenerated.class, CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.arrayAtIndex(REF_AGGREGATORSPERLEVELANDGROUP, CodegenExpressionBuilder.constant(col.getLevelNum())), "get", CodegenExpressionBuilder.ref("groupByKey")))).blockReturn(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("row"), methodName, CodegenExpressionBuilder.constant(num), ExprForgeCodegenNames.REF_EPS, ExprForgeCodegenNames.REF_ISNEWDATA, ExprForgeCodegenNames.REF_EXPREVALCONTEXT));
        }
    }

    private CodegenMethodNode handleRemovedKeysCodegen(CodegenMethodNode scope, CodegenClassScope classScope) {
        CodegenMethodNode method = scope.makeChild(Void.TYPE, AggSvcGroupByForge.class, classScope);
        method.getBlock().ifCondition(CodegenExpressionBuilder.not(CodegenExpressionBuilder.exprDotMethod(REF_REMOVEDKEYS, "isEmpty", new CodegenExpression[0]))).forEach(AggSvcLocalGroupLevelKeyPair.class, "removedKey", REF_REMOVEDKEYS).exprDotMethod(CodegenExpressionBuilder.arrayAtIndex(REF_AGGREGATORSPERLEVELANDGROUP, CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("removedKey"), "getLevel", new CodegenExpression[0])), "remove", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("removedKey"), "getKey", new CodegenExpression[0])).blockEnd().exprDotMethod(REF_REMOVEDKEYS, "clear", new CodegenExpression[0]);
        return method;
    }
}

