/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg.service.groupby;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMember;
import com.espertech.esper.codegen.base.CodegenMethodNode;
import com.espertech.esper.codegen.base.CodegenMethodScope;
import com.espertech.esper.codegen.core.CodegenCtor;
import com.espertech.esper.codegen.core.CodegenNamedMethods;
import com.espertech.esper.codegen.core.CodegenNamedParam;
import com.espertech.esper.codegen.core.CodegenTypedParam;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.codegen.model.expression.CodegenExpressionRef;
import com.espertech.esper.codegen.model.expression.CodegenExpressionRelational;
import com.espertech.esper.epl.agg.access.AggregationAccessorSlotPair;
import com.espertech.esper.epl.agg.access.AggregationState;
import com.espertech.esper.epl.agg.aggregator.AggregationMethod;
import com.espertech.esper.epl.agg.service.common.AggSvcGroupByUtil;
import com.espertech.esper.epl.agg.service.common.AggregationGroupByRollupLevel;
import com.espertech.esper.epl.agg.service.common.AggregationMethodFactory;
import com.espertech.esper.epl.agg.service.common.AggregationMethodRowAged;
import com.espertech.esper.epl.agg.service.common.AggregationRowRemovedCallback;
import com.espertech.esper.epl.agg.service.common.AggregationServiceBaseGrouped;
import com.espertech.esper.epl.agg.service.common.AggregationServiceVisitor;
import com.espertech.esper.epl.agg.service.common.AggregationServiceVisitorWGroupDetail;
import com.espertech.esper.epl.agg.service.common.AggregationStateFactory;
import com.espertech.esper.epl.agg.service.groupby.AggSvcGroupByForge;
import com.espertech.esper.epl.agg.service.groupby.AggSvcGroupByReclaimAgedEvalFunc;
import com.espertech.esper.epl.agg.service.groupby.AggSvcGroupByReclaimAgedEvalFuncFactory;
import com.espertech.esper.epl.core.resultset.codegen.ResultSetProcessorCodegenNames;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenNames;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.time.TimeAbacus;
import com.espertech.esper.util.ExecutionPathDebugLog;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggSvcGroupByReclaimAgedImpl
extends AggregationServiceBaseGrouped {
    private static final Logger log = LoggerFactory.getLogger(AggSvcGroupByReclaimAgedImpl.class);
    private static final CodegenExpressionRef REF_NEXTSWEEPTIME = CodegenExpressionBuilder.ref("nextSweepTime");
    private static final CodegenExpressionRef REF_REMOVEDCALLBACK = CodegenExpressionBuilder.ref("removedCallback");
    private static final CodegenExpressionRef REF_CURRENTMAXAGE = CodegenExpressionBuilder.ref("currentMaxAge");
    private static final CodegenExpressionRef REF_CURRENTRECLAIMFREQUENCY = CodegenExpressionBuilder.ref("currentReclaimFrequency");
    private static final CodegenExpressionRef REF_EVALUATORFUNCTIONMAXAGE = CodegenExpressionBuilder.ref("evaluationFunctionMaxAge");
    private static final CodegenExpressionRef REF_EVALUATIONFUNCTIONFREQUENCY = CodegenExpressionBuilder.ref("evaluationFunctionFrequency");
    public static final long DEFAULT_MAX_AGE_MSEC = 60000L;
    private final AggregationAccessorSlotPair[] accessors;
    protected final AggregationStateFactory[] accessAggregations;
    protected final boolean isJoin;
    private final TimeAbacus timeAbacus;
    private final AggSvcGroupByReclaimAgedEvalFunc evaluationFunctionMaxAge;
    private final AggSvcGroupByReclaimAgedEvalFunc evaluationFunctionFrequency;
    protected Map<Object, AggregationMethodRowAged> aggregatorsPerGroup;
    private AggregationMethod[] currentAggregatorMethods;
    private AggregationState[] currentAggregatorStates;
    private Object currentGroupKey;
    private List<Object> removedKeys;
    private Long nextSweepTime = null;
    private AggregationRowRemovedCallback removedCallback;
    private volatile long currentMaxAge = 60000L;
    private volatile long currentReclaimFrequency = 60000L;

    public AggSvcGroupByReclaimAgedImpl(ExprEvaluator[] evaluators, AggregationMethodFactory[] aggregators, AggregationAccessorSlotPair[] accessors, AggregationStateFactory[] accessAggregations, boolean join, AggSvcGroupByReclaimAgedEvalFunc evaluationFunctionMaxAge, AggSvcGroupByReclaimAgedEvalFunc evaluationFunctionFrequency, TimeAbacus timeAbacus) {
        super(evaluators, aggregators);
        this.accessors = accessors;
        this.accessAggregations = accessAggregations;
        this.isJoin = join;
        this.evaluationFunctionMaxAge = evaluationFunctionMaxAge;
        this.evaluationFunctionFrequency = evaluationFunctionFrequency;
        this.aggregatorsPerGroup = new HashMap<Object, AggregationMethodRowAged>();
        this.timeAbacus = timeAbacus;
        this.removedKeys = new ArrayList<Object>();
    }

    public static void rowCtorCodegen(CodegenNamedMethods namedMethods, CodegenClassScope classScope, List<CodegenTypedParam> rowMembers) {
        rowMembers.add(new CodegenTypedParam(Long.TYPE, "lastUpdateTime"));
        namedMethods.addMethod(Void.TYPE, "setLastUpdateTime", CodegenNamedParam.from(Long.TYPE, "time"), AggSvcGroupByReclaimAgedImpl.class, classScope, method -> method.getBlock().assignRef("lastUpdateTime", (CodegenExpression)CodegenExpressionBuilder.ref("time")));
        namedMethods.addMethod(Long.TYPE, "getLastUpdateTime", Collections.emptyList(), AggSvcGroupByReclaimAgedImpl.class, classScope, method -> method.getBlock().methodReturn(CodegenExpressionBuilder.ref("lastUpdateTime")));
    }

    public static void ctorCodegenReclaim(CodegenCtor ctor, List<CodegenTypedParam> explicitMembers, CodegenClassScope classScope, AggSvcGroupByReclaimAgedEvalFuncFactory maxAgeFactory, AggSvcGroupByReclaimAgedEvalFuncFactory frequencyFactory) {
        CodegenMember memberMaxAgeFactory = classScope.makeAddMember(AggSvcGroupByReclaimAgedEvalFuncFactory.class, maxAgeFactory);
        CodegenMember memberFrequencyFactory = classScope.makeAddMember(AggSvcGroupByReclaimAgedEvalFuncFactory.class, frequencyFactory);
        explicitMembers.add(new CodegenTypedParam(Long.class, REF_NEXTSWEEPTIME.getRef()));
        explicitMembers.add(new CodegenTypedParam(AggregationRowRemovedCallback.class, REF_REMOVEDCALLBACK.getRef()));
        explicitMembers.add(new CodegenTypedParam(Long.TYPE, REF_CURRENTMAXAGE.getRef()));
        explicitMembers.add(new CodegenTypedParam(Long.TYPE, REF_CURRENTRECLAIMFREQUENCY.getRef()));
        explicitMembers.add(new CodegenTypedParam(AggSvcGroupByReclaimAgedEvalFunc.class, REF_EVALUATORFUNCTIONMAXAGE.getRef()));
        explicitMembers.add(new CodegenTypedParam(AggSvcGroupByReclaimAgedEvalFunc.class, REF_EVALUATIONFUNCTIONFREQUENCY.getRef()));
        ctor.getBlock().assignRef(REF_CURRENTMAXAGE, CodegenExpressionBuilder.constant(60000L)).assignRef(REF_CURRENTRECLAIMFREQUENCY, CodegenExpressionBuilder.constant(60000L)).assignRef(REF_EVALUATORFUNCTIONMAXAGE, CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.member(memberMaxAgeFactory.getMemberId()), "make", ResultSetProcessorCodegenNames.REF_AGENTINSTANCECONTEXT)).assignRef(REF_EVALUATIONFUNCTIONFREQUENCY, CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.member(memberFrequencyFactory.getMemberId()), "make", ResultSetProcessorCodegenNames.REF_AGENTINSTANCECONTEXT));
    }

    @Override
    public void applyEnter(EventBean[] eventsPerStream, Object groupByKey, ExprEvaluatorContext exprEvaluatorContext) {
        int i;
        AggregationState[] groupStates;
        AggregationMethod[] groupAggregators;
        long currentTime = exprEvaluatorContext.getTimeProvider().getTime();
        if (this.nextSweepTime == null || this.nextSweepTime <= currentTime) {
            this.currentMaxAge = AggSvcGroupByReclaimAgedImpl.computeTimeReclaimAgeFreq(this.currentMaxAge, this.evaluationFunctionMaxAge, this.timeAbacus);
            this.currentReclaimFrequency = AggSvcGroupByReclaimAgedImpl.computeTimeReclaimAgeFreq(this.currentReclaimFrequency, this.evaluationFunctionFrequency, this.timeAbacus);
            if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
                log.debug("Reclaiming groups older then " + this.currentMaxAge + " msec and every " + this.currentReclaimFrequency + "msec in frequency");
            }
            this.nextSweepTime = currentTime + this.currentReclaimFrequency;
            this.sweep(currentTime, this.currentMaxAge);
        }
        this.handleRemovedKeys();
        AggregationMethodRowAged row = this.aggregatorsPerGroup.get(groupByKey);
        if (row == null) {
            groupAggregators = AggSvcGroupByUtil.newAggregators(this.aggregators);
            groupStates = AggSvcGroupByUtil.newAccesses(exprEvaluatorContext.getAgentInstanceId(), this.isJoin, this.accessAggregations, groupByKey, null);
            row = new AggregationMethodRowAged(1L, currentTime, groupAggregators, groupStates);
            this.aggregatorsPerGroup.put(groupByKey, row);
        } else {
            groupAggregators = row.getMethods();
            groupStates = row.getStates();
            row.increaseRefcount();
            row.setLastUpdateTime(currentTime);
        }
        this.currentAggregatorMethods = groupAggregators;
        this.currentAggregatorStates = groupStates;
        for (i = 0; i < this.evaluators.length; ++i) {
            Object columnResult = this.evaluators[i].evaluate(eventsPerStream, true, exprEvaluatorContext);
            groupAggregators[i].enter(columnResult);
        }
        for (i = 0; i < this.currentAggregatorStates.length; ++i) {
            this.currentAggregatorStates[i].applyEnter(eventsPerStream, exprEvaluatorContext);
        }
        this.internalHandleUpdated(groupByKey, row);
    }

    public static void applyEnterCodegenSweep(CodegenMethodNode method, CodegenClassScope classScope, TimeAbacus timeAbacus) {
        CodegenMember timeAbacusMember = classScope.makeAddMember(TimeAbacus.class, timeAbacus);
        method.getBlock().declareVar(Long.TYPE, "currentTime", (CodegenExpression)CodegenExpressionBuilder.exprDotMethodChain(ExprForgeCodegenNames.REF_EXPREVALCONTEXT).add("getTimeProvider", new CodegenExpression[0]).add("getTime", new CodegenExpression[0])).ifCondition(CodegenExpressionBuilder.or(CodegenExpressionBuilder.equalsNull(REF_NEXTSWEEPTIME), CodegenExpressionBuilder.relational(REF_NEXTSWEEPTIME, CodegenExpressionRelational.CodegenRelational.LE, CodegenExpressionBuilder.ref("currentTime")), new CodegenExpression[0])).assignRef(REF_CURRENTMAXAGE, CodegenExpressionBuilder.staticMethod(AggSvcGroupByReclaimAgedImpl.class, "computeTimeReclaimAgeFreq", REF_CURRENTMAXAGE, REF_EVALUATORFUNCTIONMAXAGE, CodegenExpressionBuilder.member(timeAbacusMember.getMemberId()))).assignRef(REF_CURRENTRECLAIMFREQUENCY, CodegenExpressionBuilder.staticMethod(AggSvcGroupByReclaimAgedImpl.class, "computeTimeReclaimAgeFreq", REF_CURRENTRECLAIMFREQUENCY, REF_EVALUATIONFUNCTIONFREQUENCY, CodegenExpressionBuilder.member(timeAbacusMember.getMemberId()))).assignRef(REF_NEXTSWEEPTIME, CodegenExpressionBuilder.op(CodegenExpressionBuilder.ref("currentTime"), "+", REF_CURRENTRECLAIMFREQUENCY)).localMethod(AggSvcGroupByReclaimAgedImpl.sweepCodegen(method, classScope), CodegenExpressionBuilder.ref("currentTime"), REF_CURRENTMAXAGE);
    }

    @Override
    public void applyLeave(EventBean[] eventsPerStream, Object groupByKey, ExprEvaluatorContext exprEvaluatorContext) {
        int i;
        AggregationState[] groupStates;
        AggregationMethod[] groupAggregators;
        AggregationMethodRowAged row = this.aggregatorsPerGroup.get(groupByKey);
        long currentTime = exprEvaluatorContext.getTimeProvider().getTime();
        if (row != null) {
            groupAggregators = row.getMethods();
            groupStates = row.getStates();
        } else {
            groupAggregators = AggSvcGroupByUtil.newAggregators(this.aggregators);
            groupStates = AggSvcGroupByUtil.newAccesses(exprEvaluatorContext.getAgentInstanceId(), this.isJoin, this.accessAggregations, groupByKey, null);
            row = new AggregationMethodRowAged(1L, currentTime, groupAggregators, groupStates);
            this.aggregatorsPerGroup.put(groupByKey, row);
        }
        this.currentAggregatorMethods = groupAggregators;
        this.currentAggregatorStates = groupStates;
        for (i = 0; i < this.evaluators.length; ++i) {
            Object columnResult = this.evaluators[i].evaluate(eventsPerStream, false, exprEvaluatorContext);
            groupAggregators[i].leave(columnResult);
        }
        for (i = 0; i < this.currentAggregatorStates.length; ++i) {
            this.currentAggregatorStates[i].applyLeave(eventsPerStream, exprEvaluatorContext);
        }
        row.decreaseRefcount();
        row.setLastUpdateTime(currentTime);
        if (row.getRefcount() <= 0L) {
            this.removedKeys.add(groupByKey);
        }
        this.internalHandleUpdated(groupByKey, row);
    }

    @Override
    public void clearResults(ExprEvaluatorContext exprEvaluatorContext) {
        this.aggregatorsPerGroup.clear();
    }

    @Override
    public void setCurrentAccess(Object groupByKey, int agentInstanceId, AggregationGroupByRollupLevel rollupLevel) {
        AggregationMethodRowAged row = this.aggregatorsPerGroup.get(groupByKey);
        if (row != null) {
            this.currentAggregatorMethods = row.getMethods();
            this.currentAggregatorStates = row.getStates();
        } else {
            this.currentAggregatorMethods = null;
        }
        if (this.currentAggregatorMethods == null) {
            this.currentAggregatorMethods = AggSvcGroupByUtil.newAggregators(this.aggregators);
            this.currentAggregatorStates = AggSvcGroupByUtil.newAccesses(agentInstanceId, this.isJoin, this.accessAggregations, groupByKey, null);
        }
        this.currentGroupKey = groupByKey;
    }

    @Override
    public Object getValue(int column, int agentInstanceId, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        if (column < this.aggregators.length) {
            return this.currentAggregatorMethods[column].getValue();
        }
        AggregationAccessorSlotPair pair = this.accessors[column - this.aggregators.length];
        return pair.getAccessor().getValue(this.currentAggregatorStates[pair.getSlot()], eventsPerStream, isNewData, exprEvaluatorContext);
    }

    @Override
    public Collection<EventBean> getCollectionOfEvents(int column, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        if (column < this.aggregators.length) {
            return null;
        }
        AggregationAccessorSlotPair pair = this.accessors[column - this.aggregators.length];
        return pair.getAccessor().getEnumerableEvents(this.currentAggregatorStates[pair.getSlot()], eventsPerStream, isNewData, context);
    }

    @Override
    public Collection<Object> getCollectionScalar(int column, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        if (column < this.aggregators.length) {
            return null;
        }
        AggregationAccessorSlotPair pair = this.accessors[column - this.aggregators.length];
        return pair.getAccessor().getEnumerableScalar(this.currentAggregatorStates[pair.getSlot()], eventsPerStream, isNewData, context);
    }

    @Override
    public EventBean getEventBean(int column, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        if (column < this.aggregators.length) {
            return null;
        }
        AggregationAccessorSlotPair pair = this.accessors[column - this.aggregators.length];
        return pair.getAccessor().getEnumerableEvent(this.currentAggregatorStates[pair.getSlot()], eventsPerStream, isNewData, context);
    }

    @Override
    public void setRemovedCallback(AggregationRowRemovedCallback callback) {
        this.removedCallback = callback;
    }

    public void internalHandleUpdated(Object groupByKey, AggregationMethodRowAged row) {
    }

    public void internalHandleRemoved(Object key) {
    }

    @Override
    public void accept(AggregationServiceVisitor visitor) {
        visitor.visitAggregations(this.aggregatorsPerGroup.size(), this.aggregatorsPerGroup);
    }

    @Override
    public void acceptGroupDetail(AggregationServiceVisitorWGroupDetail visitor) {
        visitor.visitGrouped(this.aggregatorsPerGroup.size());
        for (Map.Entry<Object, AggregationMethodRowAged> entry : this.aggregatorsPerGroup.entrySet()) {
            visitor.visitGroup(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean isGrouped() {
        return true;
    }

    protected void handleRemovedKeys() {
        if (!this.removedKeys.isEmpty()) {
            for (Object removedKey : this.removedKeys) {
                this.aggregatorsPerGroup.remove(removedKey);
                this.internalHandleRemoved(removedKey);
            }
            this.removedKeys.clear();
        }
    }

    @Override
    public Object getGroupKey(int agentInstanceId) {
        return this.currentGroupKey;
    }

    @Override
    public Collection<Object> getGroupKeys(ExprEvaluatorContext exprEvaluatorContext) {
        return this.aggregatorsPerGroup.keySet();
    }

    public static long computeTimeReclaimAgeFreq(long current, AggSvcGroupByReclaimAgedEvalFunc func, TimeAbacus timeAbacus) {
        Double maxAge = func.getLongValue();
        if (maxAge == null || maxAge <= 0.0) {
            return current;
        }
        return timeAbacus.deltaForSecondsDouble(maxAge);
    }

    private void sweep(long currentTime, long currentMaxAge) {
        ArrayDeque<Object> removed = new ArrayDeque<Object>();
        for (Map.Entry<Object, AggregationMethodRowAged> entry : this.aggregatorsPerGroup.entrySet()) {
            long age = currentTime - entry.getValue().getLastUpdateTime();
            if (age <= currentMaxAge) continue;
            removed.add(entry.getKey());
        }
        for (Map.Entry<Object, AggregationMethodRowAged> entry : removed) {
            this.aggregatorsPerGroup.remove(entry);
            this.internalHandleRemoved(entry);
            this.removedCallback.removedAggregationGroupKey(entry);
        }
    }

    private static CodegenMethodNode sweepCodegen(CodegenMethodScope parent, CodegenClassScope classScope) {
        CodegenMethodNode method = parent.makeChild(Void.TYPE, AggSvcGroupByReclaimAgedImpl.class, classScope).addParam(Long.TYPE, "currentTime").addParam(Long.TYPE, REF_CURRENTMAXAGE.getRef());
        method.getBlock().declareVar(ArrayDeque.class, "removed", CodegenExpressionBuilder.newInstance(ArrayDeque.class, new CodegenExpression[0])).forEach(Map.Entry.class, "entry", CodegenExpressionBuilder.exprDotMethod(AggSvcGroupByForge.REF_AGGREGATORSPERGROUP, "entrySet", new CodegenExpression[0])).declareVar(Long.TYPE, "age", CodegenExpressionBuilder.op(CodegenExpressionBuilder.ref("currentTime"), "-", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.cast("AggRowTop", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("entry"), "getValue", new CodegenExpression[0])), "getLastUpdateTime", new CodegenExpression[0]))).ifCondition(CodegenExpressionBuilder.relational(CodegenExpressionBuilder.ref("age"), CodegenExpressionRelational.CodegenRelational.GT, REF_CURRENTMAXAGE)).exprDotMethod(CodegenExpressionBuilder.ref("removed"), "add", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("entry"), "getKey", new CodegenExpression[0])).blockEnd().blockEnd().forEach(Object.class, "key", CodegenExpressionBuilder.ref("removed")).exprDotMethod(AggSvcGroupByForge.REF_AGGREGATORSPERGROUP, "remove", CodegenExpressionBuilder.ref("key")).exprDotMethod(REF_REMOVEDCALLBACK, "removedAggregationGroupKey", CodegenExpressionBuilder.ref("key"));
        return method;
    }
}

