/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg.aggregator;

import com.espertech.esper.codegen.base.CodegenBlock;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMembersColumnized;
import com.espertech.esper.codegen.base.CodegenMethodNode;
import com.espertech.esper.codegen.core.CodegenCtor;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.codegen.model.expression.CodegenExpressionRefWCol;
import com.espertech.esper.codegen.model.expression.CodegenExpressionRelational;
import com.espertech.esper.collection.RefCountedSet;
import com.espertech.esper.epl.agg.aggregator.AggregationMethod;
import com.espertech.esper.epl.agg.aggregator.AggregatorCodegenUtil;
import com.espertech.esper.epl.agg.factory.AggregationMethodFactoryNth;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.epl.expression.core.ExprForge;
import java.util.function.Consumer;

public class AggregatorNth
implements AggregationMethod {
    protected final int sizeBuf;
    protected Object[] circularBuffer;
    protected int currentBufferElementPointer;
    protected long numDataPoints;

    public AggregatorNth(int sizeBuf) {
        this.sizeBuf = sizeBuf;
    }

    public static void rowMemberCodegen(AggregationMethodFactoryNth forge, int column, CodegenCtor ctor, CodegenMembersColumnized membersColumnized) {
        membersColumnized.addMember(column, Object[].class, "circularBuffer");
        membersColumnized.addMember(column, Integer.TYPE, "currentBufferElementPointer");
        membersColumnized.addMember(column, Long.TYPE, "numDataPoints");
        if (forge.getParent().isDistinct()) {
            membersColumnized.addMember(column, RefCountedSet.class, "distinctSet");
            ctor.getBlock().assignRef(CodegenExpressionBuilder.refCol("distinctSet", column), CodegenExpressionBuilder.newInstance(RefCountedSet.class, new CodegenExpression[0]));
        }
    }

    @Override
    public void enter(Object value) {
        Object[] arr = (Object[])value;
        this.enterValues(arr);
    }

    public static void applyEnterCodegen(AggregationMethodFactoryNth forge, int column, CodegenMethodNode method, ExprForgeCodegenSymbol symbols, ExprForge[] forges, CodegenClassScope classScope) {
        if (forge.getParent().getOptionalFilter() != null) {
            AggregatorCodegenUtil.prefixWithFilterCheck(forge.getParent().getOptionalFilter().getForge(), method, symbols, classScope);
        }
        CodegenExpressionRefWCol numDataPoints = CodegenExpressionBuilder.refCol("numDataPoints", column);
        CodegenExpressionRefWCol circularBuffer = CodegenExpressionBuilder.refCol("circularBuffer", column);
        CodegenExpressionRefWCol currentBufferElementPointer = CodegenExpressionBuilder.refCol("currentBufferElementPointer", column);
        Class type = forges[0].getEvaluationType();
        CodegenExpression expr = forges[0].evaluateCodegen(Long.TYPE, method, symbols, classScope);
        method.getBlock().declareVar(type, "value", expr);
        if (forge.getParent().isDistinct()) {
            method.getBlock().ifCondition(CodegenExpressionBuilder.not(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.refCol("distinctSet", column), "add", CodegenExpressionBuilder.ref("value")))).blockReturnNoValue();
        }
        method.getBlock().increment(numDataPoints).ifCondition(CodegenExpressionBuilder.equalsNull(circularBuffer)).apply(AggregatorNth.clearCode(forge, column)).blockEnd().assignArrayElement(circularBuffer, (CodegenExpression)currentBufferElementPointer, (CodegenExpression)CodegenExpressionBuilder.ref("value")).assignRef(currentBufferElementPointer, CodegenExpressionBuilder.op(CodegenExpressionBuilder.op(currentBufferElementPointer, "+", CodegenExpressionBuilder.constant(1)), "%", CodegenExpressionBuilder.constant(forge.getSizeOfBuf())));
    }

    @Override
    public void leave(Object value) {
        if ((long)this.sizeBuf > this.numDataPoints) {
            int diff = this.sizeBuf - (int)this.numDataPoints;
            int index = (this.currentBufferElementPointer + diff - 1) % this.sizeBuf;
            this.circularBuffer[index] = null;
        }
        --this.numDataPoints;
    }

    public static void applyLeaveCodegen(AggregationMethodFactoryNth forge, int column, CodegenMethodNode method, ExprForgeCodegenSymbol symbols, ExprForge[] forges, CodegenClassScope classScope) {
        if (forge.getParent().getOptionalFilter() != null) {
            AggregatorCodegenUtil.prefixWithFilterCheck(forge.getParent().getOptionalFilter().getForge(), method, symbols, classScope);
        }
        CodegenExpressionRefWCol numDataPoints = CodegenExpressionBuilder.refCol("numDataPoints", column);
        CodegenExpressionRefWCol circularBuffer = CodegenExpressionBuilder.refCol("circularBuffer", column);
        CodegenExpressionRefWCol currentBufferElementPointer = CodegenExpressionBuilder.refCol("currentBufferElementPointer", column);
        if (forge.getParent().isDistinct()) {
            Class type = forges[0].getEvaluationType();
            CodegenExpression expr = forges[0].evaluateCodegen(Long.TYPE, method, symbols, classScope);
            method.getBlock().declareVar(type, "value", expr);
            method.getBlock().ifCondition(CodegenExpressionBuilder.not(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.refCol("distinctSet", column), "add", CodegenExpressionBuilder.ref("value")))).blockReturnNoValue();
        }
        method.getBlock().ifCondition(CodegenExpressionBuilder.relational(CodegenExpressionBuilder.constant(forge.getSizeOfBuf()), CodegenExpressionRelational.CodegenRelational.GT, numDataPoints)).declareVar(Integer.TYPE, "diff", CodegenExpressionBuilder.op(CodegenExpressionBuilder.constant(forge.getSizeOfBuf()), "-", CodegenExpressionBuilder.cast(Integer.TYPE, (CodegenExpression)numDataPoints))).declareVar(Integer.TYPE, "index", CodegenExpressionBuilder.op(CodegenExpressionBuilder.op(CodegenExpressionBuilder.op(currentBufferElementPointer, "+", CodegenExpressionBuilder.ref("diff")), "-", CodegenExpressionBuilder.constant(1)), "%", CodegenExpressionBuilder.constant(forge.getSizeOfBuf()))).assignArrayElement(circularBuffer, (CodegenExpression)CodegenExpressionBuilder.ref("index"), CodegenExpressionBuilder.constantNull()).blockEnd().decrement(numDataPoints);
    }

    @Override
    public void clear() {
        this.circularBuffer = new Object[this.sizeBuf];
        this.numDataPoints = 0L;
        this.currentBufferElementPointer = 0;
    }

    public static void clearCodegen(AggregationMethodFactoryNth forge, int column, CodegenMethodNode method) {
        method.getBlock().apply(AggregatorNth.clearCode(forge, column)).applyConditional(forge.getParent().isDistinct(), block -> block.exprDotMethod(CodegenExpressionBuilder.refCol("distinctSet", column), "clear", new CodegenExpression[0]));
    }

    @Override
    public Object getValue() {
        if (this.circularBuffer == null) {
            return null;
        }
        return this.circularBuffer[(this.currentBufferElementPointer + this.sizeBuf) % this.sizeBuf];
    }

    public static void getValueCodegen(AggregationMethodFactoryNth forge, int column, CodegenMethodNode method) {
        CodegenExpressionRefWCol circularBuffer = CodegenExpressionBuilder.refCol("circularBuffer", column);
        CodegenExpressionRefWCol currentBufferElementPointer = CodegenExpressionBuilder.refCol("currentBufferElementPointer", column);
        CodegenExpression sizeBuf = CodegenExpressionBuilder.constant(forge.getSizeOfBuf());
        method.getBlock().ifRefNullReturnNull(circularBuffer).declareVar(Integer.TYPE, "index", CodegenExpressionBuilder.op(CodegenExpressionBuilder.op(currentBufferElementPointer, "+", sizeBuf), "%", sizeBuf)).methodReturn(CodegenExpressionBuilder.arrayAtIndex(circularBuffer, CodegenExpressionBuilder.ref("index")));
    }

    protected void enterValues(Object[] arr) {
        ++this.numDataPoints;
        if (this.circularBuffer == null) {
            this.clear();
        }
        this.circularBuffer[this.currentBufferElementPointer] = arr[0];
        this.currentBufferElementPointer = (this.currentBufferElementPointer + 1) % this.sizeBuf;
    }

    public int getSizeBuf() {
        return this.sizeBuf;
    }

    public Object[] getCircularBuffer() {
        return this.circularBuffer;
    }

    public void setCircularBuffer(Object[] circularBuffer) {
        this.circularBuffer = circularBuffer;
    }

    public int getCurrentBufferElementPointer() {
        return this.currentBufferElementPointer;
    }

    public void setCurrentBufferElementPointer(int currentBufferElementPointer) {
        this.currentBufferElementPointer = currentBufferElementPointer;
    }

    public long getNumDataPoints() {
        return this.numDataPoints;
    }

    public void setNumDataPoints(long numDataPoints) {
        this.numDataPoints = numDataPoints;
    }

    private static Consumer<CodegenBlock> clearCode(AggregationMethodFactoryNth forge, int column) {
        return block -> block.assignRef(CodegenExpressionBuilder.refCol("circularBuffer", column), CodegenExpressionBuilder.newArrayByLength(Object.class, CodegenExpressionBuilder.constant(forge.getSizeOfBuf()))).assignRef(CodegenExpressionBuilder.refCol("numDataPoints", column), CodegenExpressionBuilder.constant(0)).assignRef(CodegenExpressionBuilder.refCol("currentBufferElementPointer", column), CodegenExpressionBuilder.constant(0));
    }
}

