/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg.aggregator;

import com.espertech.esper.codegen.base.CodegenBlock;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMember;
import com.espertech.esper.codegen.base.CodegenMembersColumnized;
import com.espertech.esper.codegen.base.CodegenMethodNode;
import com.espertech.esper.codegen.core.CodegenCtor;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.codegen.model.expression.CodegenExpressionRef;
import com.espertech.esper.codegen.model.expression.CodegenExpressionRelational;
import com.espertech.esper.codegen.model.expression.CodegenExpressionTypePair;
import com.espertech.esper.collection.RefCountedSet;
import com.espertech.esper.epl.agg.aggregator.AggregationMethod;
import com.espertech.esper.epl.agg.aggregator.AggregatorCodegenUtil;
import com.espertech.esper.epl.agg.factory.AggregationMethodFactoryAvg;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.epl.expression.core.ExprForge;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregatorAvgBigDecimal
implements AggregationMethod {
    private static final Logger log = LoggerFactory.getLogger(AggregatorAvgBigDecimal.class);
    protected BigDecimal sum = new BigDecimal(0.0);
    protected long cnt;
    protected MathContext optionalMathContext;

    public AggregatorAvgBigDecimal(MathContext optionalMathContext) {
        this.optionalMathContext = optionalMathContext;
    }

    public static void rowMemberCodegen(boolean distinct, int column, CodegenCtor ctor, CodegenMembersColumnized membersColumnized) {
        membersColumnized.addMember(column, BigDecimal.class, "sum");
        membersColumnized.addMember(column, Long.TYPE, "cnt");
        ctor.getBlock().assignRef(CodegenExpressionBuilder.refCol("sum", column), CodegenExpressionBuilder.newInstance(BigDecimal.class, CodegenExpressionBuilder.constant(0.0)));
        if (distinct) {
            membersColumnized.addMember(column, RefCountedSet.class, "distinctSet");
            ctor.getBlock().assignRef(CodegenExpressionBuilder.refCol("distinctSet", column), CodegenExpressionBuilder.newInstance(RefCountedSet.class, new CodegenExpression[0]));
        }
    }

    @Override
    public void enter(Object object) {
        if (object == null) {
            return;
        }
        ++this.cnt;
        if (object instanceof BigInteger) {
            this.sum = this.sum.add(new BigDecimal((BigInteger)object));
            return;
        }
        this.sum = this.sum.add((BigDecimal)object);
    }

    public static void applyEnterCodegen(boolean distinct, boolean hasFilter, int column, CodegenMethodNode method, ExprForgeCodegenSymbol symbols, ExprForge[] forges, CodegenClassScope classScope) {
        CodegenExpressionTypePair value = AggregatorCodegenUtil.prefixWithFilterNullDistinctChecks(true, distinct, hasFilter, forges, column, method, symbols, classScope);
        CodegenExpressionRef sum = AggregatorCodegenUtil.sumRefCol(column);
        CodegenExpressionRef cnt = AggregatorCodegenUtil.cntRefCol(column);
        if (value.getType() == BigInteger.class) {
            method.getBlock().assignRef(sum, CodegenExpressionBuilder.exprDotMethod(sum, "add", CodegenExpressionBuilder.newInstance(BigDecimal.class, value.getExpression())));
        } else {
            method.getBlock().assignRef(sum, CodegenExpressionBuilder.exprDotMethod(sum, "add", value.getType() == BigDecimal.class ? value.getExpression() : CodegenExpressionBuilder.cast(BigDecimal.class, value.getExpression())));
        }
        method.getBlock().increment(cnt);
    }

    @Override
    public void leave(Object object) {
        if (object == null) {
            return;
        }
        if (this.cnt <= 1L) {
            this.clear();
        } else {
            --this.cnt;
            this.sum = object instanceof BigInteger ? this.sum.subtract(new BigDecimal((BigInteger)object)) : this.sum.subtract((BigDecimal)object);
        }
    }

    public static void applyLeaveCodegen(boolean distinct, boolean hasFilter, int column, CodegenMethodNode method, ExprForgeCodegenSymbol symbols, ExprForge[] forges, CodegenClassScope classScope) {
        CodegenExpressionTypePair value = AggregatorCodegenUtil.prefixWithFilterNullDistinctChecks(false, distinct, hasFilter, forges, column, method, symbols, classScope);
        CodegenExpressionRef sum = AggregatorCodegenUtil.sumRefCol(column);
        CodegenExpressionRef cnt = AggregatorCodegenUtil.cntRefCol(column);
        method.getBlock().ifCondition(CodegenExpressionBuilder.relational(cnt, CodegenExpressionRelational.CodegenRelational.LE, CodegenExpressionBuilder.constant(1))).apply(AggregatorAvgBigDecimal.clearCode(column)).ifElse().decrement(cnt).apply(block -> {
            if (value.getType() == BigInteger.class) {
                block.assignRef(sum, CodegenExpressionBuilder.exprDotMethod(sum, "subtract", CodegenExpressionBuilder.newInstance(BigDecimal.class, value.getExpression())));
            } else {
                block.assignRef(sum, CodegenExpressionBuilder.exprDotMethod(sum, "subtract", value.getType() == BigDecimal.class ? value.getExpression() : CodegenExpressionBuilder.cast(BigDecimal.class, value.getExpression())));
            }
        });
    }

    @Override
    public void clear() {
        this.sum = new BigDecimal(0.0);
        this.cnt = 0L;
    }

    public static void clearCodegen(boolean distinct, int column, CodegenMethodNode method) {
        method.getBlock().apply(AggregatorAvgBigDecimal.clearCode(column));
        if (distinct) {
            method.getBlock().exprDotMethod(CodegenExpressionBuilder.refCol("distinctSet", column), "clear", new CodegenExpression[0]);
        }
    }

    @Override
    public BigDecimal getValue() {
        return AggregatorAvgBigDecimal.getValueBigDecimalDivide(this.cnt, this.optionalMathContext, this.sum);
    }

    public static void getValueCodegen(AggregationMethodFactoryAvg forge, int column, CodegenMethodNode method, CodegenClassScope classScope) {
        CodegenMember mathContext = classScope.makeAddMember(MathContext.class, forge.getOptionalMathContext());
        method.getBlock().methodReturn(CodegenExpressionBuilder.staticMethod(AggregatorAvgBigDecimal.class, "getValueBigDecimalDivide", CodegenExpressionBuilder.refCol("cnt", column), CodegenExpressionBuilder.member(mathContext.getMemberId()), CodegenExpressionBuilder.refCol("sum", column)));
    }

    public static BigDecimal getValueBigDecimalDivide(long cnt, MathContext optionalMathContext, BigDecimal sum) {
        if (cnt == 0L) {
            return null;
        }
        try {
            if (optionalMathContext == null) {
                return sum.divide(new BigDecimal(cnt));
            }
            return sum.divide(new BigDecimal(cnt), optionalMathContext);
        }
        catch (ArithmeticException ex) {
            log.error("Error computing avg aggregation result: " + ex.getMessage(), (Throwable)ex);
            return new BigDecimal(0);
        }
    }

    private static Consumer<CodegenBlock> clearCode(int stateNumber) {
        return block -> block.assignRef(CodegenExpressionBuilder.refCol("sum", stateNumber), CodegenExpressionBuilder.newInstance(BigDecimal.class, CodegenExpressionBuilder.constant(0.0))).assignRef(CodegenExpressionBuilder.refCol("cnt", stateNumber), CodegenExpressionBuilder.constant(0));
    }
}

