/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg.aggregator;

import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMembersColumnized;
import com.espertech.esper.codegen.base.CodegenMethodNode;
import com.espertech.esper.codegen.core.CodegenCtor;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.codegen.model.expression.CodegenExpressionRefWCol;
import com.espertech.esper.codegen.model.expression.CodegenExpressionTypePair;
import com.espertech.esper.collection.RefCountedSet;
import com.espertech.esper.epl.agg.aggregator.AggregationMethod;
import com.espertech.esper.epl.agg.aggregator.AggregatorCodegenUtil;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.epl.expression.core.ExprForge;
import com.espertech.esper.util.SimpleNumberCoercerFactory;
import java.util.Iterator;
import java.util.Map;

public class AggregatorAvedev
implements AggregationMethod {
    private RefCountedSet<Double> valueSet = new RefCountedSet();
    private double sum;

    public static void rowMemberCodegen(boolean distinct, int column, CodegenCtor ctor, CodegenMembersColumnized membersColumnized) {
        membersColumnized.addMember(column, RefCountedSet.class, "valueSet");
        membersColumnized.addMember(column, Double.TYPE, "sum");
        ctor.getBlock().assignRef(CodegenExpressionBuilder.refCol("valueSet", column), CodegenExpressionBuilder.newInstance(RefCountedSet.class, new CodegenExpression[0]));
        if (distinct) {
            membersColumnized.addMember(column, RefCountedSet.class, "distinctSet");
            ctor.getBlock().assignRef(CodegenExpressionBuilder.refCol("distinctSet", column), CodegenExpressionBuilder.newInstance(RefCountedSet.class, new CodegenExpression[0]));
        }
    }

    @Override
    public void enter(Object object) {
        if (object == null) {
            return;
        }
        double value = ((Number)object).doubleValue();
        this.valueSet.add(value);
        this.sum += value;
    }

    public static void applyEnterCodegen(boolean distinct, boolean hasFilter, int column, CodegenMethodNode method, ExprForgeCodegenSymbol symbols, ExprForge[] forges, CodegenClassScope classScope) {
        AggregatorAvedev.applyCodegen(true, distinct, hasFilter, column, method, symbols, forges, classScope);
    }

    @Override
    public void leave(Object object) {
        if (object == null) {
            return;
        }
        double value = ((Number)object).doubleValue();
        this.valueSet.remove(value);
        this.sum -= value;
    }

    public static void applyLeaveCodegen(boolean distinct, boolean hasFilter, int column, CodegenMethodNode method, ExprForgeCodegenSymbol symbols, ExprForge[] forges, CodegenClassScope classScope) {
        AggregatorAvedev.applyCodegen(false, distinct, hasFilter, column, method, symbols, forges, classScope);
    }

    @Override
    public void clear() {
        this.sum = 0.0;
        this.valueSet.clear();
    }

    public static void clearCodegen(boolean distinct, int column, CodegenMethodNode method) {
        method.getBlock().assignRef(CodegenExpressionBuilder.refCol("sum", column), CodegenExpressionBuilder.constant(0)).exprDotMethod(CodegenExpressionBuilder.refCol("valueSet", column), "clear", new CodegenExpression[0]);
        if (distinct) {
            method.getBlock().exprDotMethod(CodegenExpressionBuilder.refCol("distinctSet", column), "clear", new CodegenExpression[0]);
        }
    }

    @Override
    public Object getValue() {
        return AggregatorAvedev.computeAvedev(this.valueSet, this.sum);
    }

    public static void getValueCodegen(int column, CodegenMethodNode method) {
        method.getBlock().methodReturn(CodegenExpressionBuilder.staticMethod(AggregatorAvedev.class, "computeAvedev", CodegenExpressionBuilder.refCol("valueSet", column), CodegenExpressionBuilder.refCol("sum", column)));
    }

    public RefCountedSet<Double> getValueSet() {
        return this.valueSet;
    }

    public void setValueSet(RefCountedSet<Double> valueSet) {
        this.valueSet = valueSet;
    }

    public double getSum() {
        return this.sum;
    }

    public void setSum(double sum) {
        this.sum = sum;
    }

    private static void applyCodegen(boolean enter, boolean distinct, boolean hasFilter, int column, CodegenMethodNode method, ExprForgeCodegenSymbol symbols, ExprForge[] forges, CodegenClassScope classScope) {
        CodegenExpressionTypePair value = AggregatorCodegenUtil.prefixWithFilterNullDistinctChecks(enter, distinct, hasFilter, forges, column, method, symbols, classScope);
        CodegenExpressionRefWCol sum = CodegenExpressionBuilder.refCol("sum", column);
        CodegenExpressionRefWCol valueSet = CodegenExpressionBuilder.refCol("valueSet", column);
        method.getBlock().declareVar(Double.TYPE, "val", SimpleNumberCoercerFactory.SimpleNumberCoercerDouble.codegenDouble(value.getExpression(), value.getType())).exprDotMethod(valueSet, enter ? "add" : "remove", CodegenExpressionBuilder.ref("val")).assignCompound(sum, enter ? "+" : "-", (CodegenExpression)CodegenExpressionBuilder.ref("val"));
    }

    public static Object computeAvedev(RefCountedSet<Double> valueSet, double sum) {
        int datapoints = valueSet.size();
        if (datapoints == 0) {
            return null;
        }
        double total = 0.0;
        double avg = sum / (double)datapoints;
        Iterator<Map.Entry<Double, Integer>> it = valueSet.entryIterator();
        while (it.hasNext()) {
            Map.Entry<Double, Integer> entry = it.next();
            total += (double)entry.getValue().intValue() * Math.abs(entry.getKey() - avg);
        }
        return total / (double)datapoints;
    }
}

