/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.thread;

import com.espertech.esper.core.context.util.EPStatementAgentInstanceHandle;
import com.espertech.esper.core.service.EPRuntimeImpl;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.core.thread.TimerUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerUnitMultiple
implements TimerUnit {
    private static final Logger log = LoggerFactory.getLogger(TimerUnitMultiple.class);
    private final EPServicesContext services;
    private final EPRuntimeImpl runtime;
    private final Object callbackObject;
    private final EPStatementAgentInstanceHandle handle;

    public TimerUnitMultiple(EPServicesContext services, EPRuntimeImpl runtime, EPStatementAgentInstanceHandle handle, Object callbackObject) {
        this.services = services;
        this.handle = handle;
        this.runtime = runtime;
        this.callbackObject = callbackObject;
    }

    @Override
    public void run() {
        try {
            EPRuntimeImpl.processStatementScheduleMultiple(this.handle, this.callbackObject, this.services);
            this.runtime.dispatch();
            this.runtime.processThreadWorkQueue();
        }
        catch (RuntimeException e) {
            log.error("Unexpected error processing multiple timer execution: " + e.getMessage(), (Throwable)e);
        }
    }
}

