/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.start;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.start.EPPreparedExecuteIUDSingleStreamExecDelete;
import com.espertech.esper.core.start.EPPreparedExecuteIUDSingleStreamExecInsert;
import com.espertech.esper.core.start.EPPreparedExecuteIUDSingleStreamExecUpdate;
import com.espertech.esper.core.start.EPPreparedExecuteMethodQuery;
import com.espertech.esper.core.start.FireAndForgetInstance;
import com.espertech.esper.epl.agg.service.common.AggregationRowPair;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeUtilityCore;
import com.espertech.esper.epl.fafquery.FireAndForgetQueryExec;
import com.espertech.esper.epl.join.plan.QueryGraph;
import com.espertech.esper.epl.table.mgmt.TableServiceImpl;
import com.espertech.esper.epl.table.mgmt.TableStateInstance;
import com.espertech.esper.epl.table.strategy.ExprTableEvalLockUtil;
import com.espertech.esper.epl.virtualdw.VirtualDWView;
import com.espertech.esper.util.CollectionUtil;
import com.espertech.esper.view.Viewable;
import java.lang.annotation.Annotation;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;

public class FireAndForgetInstanceTable
extends FireAndForgetInstance {
    private final TableStateInstance instance;

    public FireAndForgetInstanceTable(TableStateInstance instance) {
        this.instance = instance;
    }

    @Override
    public EventBean[] processInsert(EPPreparedExecuteIUDSingleStreamExecInsert insert) {
        ExprTableEvalLockUtil.obtainLockUnless((Lock)this.instance.getTableLevelRWLock().writeLock(), insert.getServices().getTableService().getTableExprEvaluatorContext());
        EventBean theEvent = insert.getInsertHelper().process(new EventBean[0], true, true, insert.getExprEvaluatorContext());
        AggregationRowPair aggs = this.instance.getTableMetadata().getRowFactory().makeAggs(insert.getExprEvaluatorContext().getAgentInstanceId(), null, null, this.instance.getAggregationServicePassThru());
        ((Object[])theEvent.getUnderlying())[0] = aggs;
        this.instance.addEvent(theEvent);
        return CollectionUtil.EVENTBEANARRAY_EMPTY;
    }

    @Override
    public EventBean[] processDelete(EPPreparedExecuteIUDSingleStreamExecDelete delete) {
        ExprTableEvalLockUtil.obtainLockUnless((Lock)this.instance.getTableLevelRWLock().writeLock(), delete.getServices().getTableService().getTableExprEvaluatorContext());
        if (delete.getOptionalWhereClause() == null) {
            this.instance.clearInstance();
            return CollectionUtil.EVENTBEANARRAY_EMPTY;
        }
        Collection<EventBean> found = this.snapshotAndApplyFilter(delete.getQueryGraph(), delete.getAnnotations(), delete.getOptionalWhereClause(), this.instance.getAgentInstanceContext());
        for (EventBean event : found) {
            this.instance.deleteEvent(event);
        }
        return CollectionUtil.EVENTBEANARRAY_EMPTY;
    }

    @Override
    public EventBean[] processUpdate(EPPreparedExecuteIUDSingleStreamExecUpdate update) {
        ExprTableEvalLockUtil.obtainLockUnless((Lock)this.instance.getTableLevelRWLock().writeLock(), update.getServices().getTableService().getTableExprEvaluatorContext());
        Collection<EventBean> events = this.snapshotAndApplyFilter(update.getQueryGraph(), update.getAnnotations(), update.getOptionalWhereClause(), this.instance.getAgentInstanceContext());
        if (events != null && events.isEmpty()) {
            return CollectionUtil.EVENTBEANARRAY_EMPTY;
        }
        EventBean[] eventsPerStream = new EventBean[3];
        if (events == null) {
            update.getTableUpdateStrategy().updateTable(this.instance.getEventCollection(), this.instance, eventsPerStream, this.instance.getAgentInstanceContext());
        } else {
            update.getTableUpdateStrategy().updateTable(events, this.instance, eventsPerStream, this.instance.getAgentInstanceContext());
        }
        return CollectionUtil.EVENTBEANARRAY_EMPTY;
    }

    @Override
    public Collection<EventBean> snapshotBestEffort(EPPreparedExecuteMethodQuery query, QueryGraph queryGraph, Annotation[] annotations) {
        ExprTableEvalLockUtil.obtainLockUnless((Lock)this.instance.getTableLevelRWLock().readLock(), query.getAgentInstanceContext());
        Collection<EventBean> events = this.snapshotNullWhenNoIndex(queryGraph, annotations, null, null);
        if (events != null) {
            return events;
        }
        return this.instance.getEventCollection();
    }

    private Collection<EventBean> snapshotAndApplyFilter(QueryGraph queryGraph, Annotation[] annotations, ExprNode filterExpr, AgentInstanceContext agentInstanceContext) {
        Collection<EventBean> indexedResult = this.snapshotNullWhenNoIndex(queryGraph, annotations, null, null);
        if (indexedResult != null) {
            if (indexedResult.isEmpty() || filterExpr == null) {
                return indexedResult;
            }
            ArrayDeque<EventBean> deque = new ArrayDeque<EventBean>(Math.min(indexedResult.size(), 16));
            ExprNodeUtilityCore.applyFilterExpressionIterable(indexedResult.iterator(), filterExpr.getForge().getExprEvaluator(), agentInstanceContext, deque);
            return deque;
        }
        Collection<EventBean> sourceCollection = this.instance.getEventCollection();
        Iterator<EventBean> it = sourceCollection.iterator();
        if (!it.hasNext()) {
            return Collections.EMPTY_LIST;
        }
        ArrayDeque<EventBean> deque = new ArrayDeque<EventBean>(sourceCollection.size());
        if (filterExpr != null) {
            ExprNodeUtilityCore.applyFilterExpressionIterable(sourceCollection.iterator(), filterExpr.getForge().getExprEvaluator(), agentInstanceContext, deque);
        } else {
            while (it.hasNext()) {
                deque.add(it.next());
            }
        }
        return deque;
    }

    private Collection<EventBean> snapshotNullWhenNoIndex(QueryGraph queryGraph, Annotation[] annotations, ExprNode optionalWhereClause, AgentInstanceContext agentInstanceContext) {
        return FireAndForgetQueryExec.snapshot(queryGraph, annotations, null, this.instance.getIndexRepository(), this.instance.getTableMetadata().isQueryPlanLogging(), TableServiceImpl.getQueryPlanLog(), this.instance.getTableMetadata().getTableName(), this.instance.getAgentInstanceContext());
    }

    @Override
    public AgentInstanceContext getAgentInstanceContext() {
        return this.instance.getAgentInstanceContext();
    }

    @Override
    public Viewable getTailViewInstance() {
        return null;
    }

    @Override
    public VirtualDWView getVirtualDataWindow() {
        return null;
    }
}

