/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.start;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.service.StatementAgentInstanceLock;
import com.espertech.esper.core.start.EPPreparedExecuteIUDSingleStreamExecDelete;
import com.espertech.esper.core.start.EPPreparedExecuteIUDSingleStreamExecInsert;
import com.espertech.esper.core.start.EPPreparedExecuteIUDSingleStreamExecUpdate;
import com.espertech.esper.core.start.EPPreparedExecuteMethodQuery;
import com.espertech.esper.core.start.EPPreparedExecuteTableHelper;
import com.espertech.esper.core.start.FireAndForgetInstance;
import com.espertech.esper.epl.join.plan.QueryGraph;
import com.espertech.esper.epl.named.NamedWindowProcessorInstance;
import com.espertech.esper.epl.virtualdw.VirtualDWView;
import com.espertech.esper.view.Viewable;
import java.lang.annotation.Annotation;
import java.util.Collection;

public class FireAndForgetInstanceNamedWindow
extends FireAndForgetInstance {
    private final NamedWindowProcessorInstance processorInstance;

    public FireAndForgetInstanceNamedWindow(NamedWindowProcessorInstance processorInstance) {
        this.processorInstance = processorInstance;
    }

    public NamedWindowProcessorInstance getProcessorInstance() {
        return this.processorInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EventBean[] processInsert(EPPreparedExecuteIUDSingleStreamExecInsert insert) {
        EPPreparedExecuteTableHelper.assignTableAccessStrategies(insert.getServices(), insert.getOptionalTableNodes(), this.processorInstance.getTailViewInstance().getAgentInstanceContext());
        try {
            EventBean event = insert.getInsertHelper().process(new EventBean[0], true, true, insert.getExprEvaluatorContext());
            EventBean[] inserted = new EventBean[]{event};
            AgentInstanceContext ctx = this.processorInstance.getTailViewInstance().getAgentInstanceContext();
            StatementAgentInstanceLock ailock = ctx.getAgentInstanceLock();
            ailock.acquireWriteLock();
            try {
                this.processorInstance.getRootViewInstance().update(inserted, null);
            }
            catch (EPException ex) {
                this.processorInstance.getRootViewInstance().update(null, inserted);
            }
            finally {
                ailock.releaseWriteLock();
            }
            EventBean[] eventBeanArray = inserted;
            return eventBeanArray;
        }
        finally {
            insert.getServices().getTableService().getTableExprEvaluatorContext().releaseAcquiredLocks();
        }
    }

    @Override
    public EventBean[] processDelete(EPPreparedExecuteIUDSingleStreamExecDelete delete) {
        EPPreparedExecuteTableHelper.assignTableAccessStrategies(delete.getServices(), delete.getOptionalTableNodes(), this.processorInstance.getTailViewInstance().getAgentInstanceContext());
        return this.processorInstance.getTailViewInstance().snapshotDelete(delete.getQueryGraph(), delete.getOptionalWhereClause(), delete.getAnnotations());
    }

    @Override
    public EventBean[] processUpdate(EPPreparedExecuteIUDSingleStreamExecUpdate update) {
        EPPreparedExecuteTableHelper.assignTableAccessStrategies(update.getServices(), update.getOptionalTableNodes(), this.processorInstance.getTailViewInstance().getAgentInstanceContext());
        return this.processorInstance.getTailViewInstance().snapshotUpdate(update.getQueryGraph(), update.getOptionalWhereClause(), update.getUpdateHelper(), update.getAnnotations());
    }

    @Override
    public Collection<EventBean> snapshotBestEffort(EPPreparedExecuteMethodQuery query, QueryGraph queryGraph, Annotation[] annotations) {
        EPPreparedExecuteTableHelper.assignTableAccessStrategies(query.getServices(), query.getTableNodes(), this.processorInstance.getTailViewInstance().getAgentInstanceContext());
        return this.processorInstance.getTailViewInstance().snapshot(queryGraph, annotations);
    }

    @Override
    public AgentInstanceContext getAgentInstanceContext() {
        return this.processorInstance.getTailViewInstance().getAgentInstanceContext();
    }

    @Override
    public Viewable getTailViewInstance() {
        return this.processorInstance.getTailViewInstance();
    }

    @Override
    public VirtualDWView getVirtualDataWindow() {
        return this.processorInstance.getRootViewInstance().getVirtualDataWindow();
    }
}

