/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.start;

import com.espertech.esper.client.EPException;
import com.espertech.esper.collection.ViewUpdatedCollection;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.core.viewres.ViewResourceDelegateVerified;
import com.espertech.esper.epl.expression.core.ExprConstantNodeImpl;
import com.espertech.esper.epl.expression.prior.ExprPriorEvalStrategy;
import com.espertech.esper.epl.expression.prior.ExprPriorEvalStrategyBase;
import com.espertech.esper.epl.expression.prior.ExprPriorEvalStrategyRandomAccess;
import com.espertech.esper.epl.expression.prior.ExprPriorEvalStrategyRelativeAccess;
import com.espertech.esper.epl.expression.prior.ExprPriorNode;
import com.espertech.esper.view.ViewEnum;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewFactoryContext;
import com.espertech.esper.view.ViewParameterException;
import com.espertech.esper.view.ViewProcessingException;
import com.espertech.esper.view.internal.PriorEventViewFactory;
import com.espertech.esper.view.internal.PriorEventViewRelAccess;
import com.espertech.esper.view.window.RandomAccessByIndex;
import com.espertech.esper.view.window.RelativeAccessByEventNIndex;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EPStatementStartMethodHelperPrior {
    private static final Logger log = LoggerFactory.getLogger(EPStatementStartMethodHelperPrior.class);

    public static PriorEventViewFactory findPriorViewFactory(List<ViewFactory> factories) {
        ViewFactory factoryFound = null;
        for (ViewFactory factory : factories) {
            if (!(factory instanceof PriorEventViewFactory)) continue;
            factoryFound = factory;
            break;
        }
        if (factoryFound == null) {
            throw new RuntimeException("Failed to find 'prior'-handling view factory");
        }
        return (PriorEventViewFactory)factoryFound;
    }

    public static PriorEventViewFactory getPriorEventViewFactory(StatementContext statementContext, int streamNum, boolean unboundStream, boolean isSubquery, int subqueryNumber) {
        try {
            String namespace = ViewEnum.PRIOR_EVENT_VIEW.getNamespace();
            String name = ViewEnum.PRIOR_EVENT_VIEW.getName();
            ViewFactory factory = statementContext.getViewResolutionService().create(namespace, name);
            ViewFactoryContext context = new ViewFactoryContext(statementContext, streamNum, namespace, name, isSubquery, subqueryNumber, false);
            factory.setViewParameters(context, Arrays.asList(new ExprConstantNodeImpl(unboundStream)));
            return (PriorEventViewFactory)factory;
        }
        catch (ViewProcessingException ex) {
            String text = "Exception creating prior event view factory";
            throw new EPException(text, ex);
        }
        catch (ViewParameterException ex) {
            String text = "Exception creating prior event view factory";
            throw new EPException(text, ex);
        }
    }

    public static Map<ExprPriorNode, ExprPriorEvalStrategy> compilePriorNodeStrategies(ViewResourceDelegateVerified viewResourceDelegate, AgentInstanceViewFactoryChainContext[] viewFactoryChainContexts) {
        if (!viewResourceDelegate.isHasPrior()) {
            return Collections.emptyMap();
        }
        HashMap<ExprPriorNode, ExprPriorEvalStrategy> strategies = new HashMap<ExprPriorNode, ExprPriorEvalStrategy>();
        for (int streamNum = 0; streamNum < viewResourceDelegate.getPerStream().length; ++streamNum) {
            ViewUpdatedCollection viewUpdatedCollection = viewFactoryChainContexts[streamNum].getPriorViewUpdatedCollection();
            SortedMap<Integer, List<ExprPriorNode>> callbacksPerIndex = viewResourceDelegate.getPerStream()[streamNum].getPriorRequests();
            EPStatementStartMethodHelperPrior.handlePrior(viewUpdatedCollection, callbacksPerIndex, strategies);
        }
        return strategies;
    }

    private static void handlePrior(ViewUpdatedCollection viewUpdatedCollection, SortedMap<Integer, List<ExprPriorNode>> callbacksPerIndex, Map<ExprPriorNode, ExprPriorEvalStrategy> strategies) {
        int relativeIndex = 0;
        for (int reqIndex : callbacksPerIndex.keySet()) {
            List priorNodes = (List)callbacksPerIndex.get(reqIndex);
            for (ExprPriorNode callback : priorNodes) {
                ExprPriorEvalStrategyBase strategy;
                if (viewUpdatedCollection instanceof RelativeAccessByEventNIndex) {
                    RelativeAccessByEventNIndex relativeAccess = (RelativeAccessByEventNIndex)((Object)viewUpdatedCollection);
                    PriorEventViewRelAccess impl = new PriorEventViewRelAccess(relativeAccess, relativeIndex);
                    strategy = new ExprPriorEvalStrategyRelativeAccess(impl);
                } else {
                    strategy = viewUpdatedCollection instanceof RandomAccessByIndex ? new ExprPriorEvalStrategyRandomAccess((RandomAccessByIndex)((Object)viewUpdatedCollection)) : new ExprPriorEvalStrategyRelativeAccess((RelativeAccessByEventNIndex)((Object)viewUpdatedCollection));
                }
                strategies.put(callback, strategy);
            }
            ++relativeIndex;
        }
    }
}

